# myls.py
# Import the argparse library
import argparse

import os
import sys
from numerous_api_client.client import open_admin_client
import json
import logging
logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger('numerous-scheduler.main')






if __name__ == '__main__':

    # Create the parser
    my_parser = argparse.ArgumentParser(description='Do things')

    # Add the arguments
    my_parser.add_argument('command',
                           metavar='command',
                           type=str,
                           help='command')

    # Add the arguments
    my_parser.add_argument('project',
                           metavar='project',
                           type=str,
                           help='project')

    # Add the arguments
    my_parser.add_argument('scenario',
                           metavar='scenario',
                           type=str,
                           help='scenario')

    # Add the arguments
    my_parser.add_argument('job',
                           metavar='job',
                           type=str,
                           help='job')

    # Execute the parse_args() method
    args = my_parser.parse_args()



    with open_admin_client() as client:
        if args.command == 'terminate_job':
            client.terminate_job(args.project, args.scenario, args.job)
        elif args.command == 'launch_job':
            client.launch_job(args.project, args.scenario, args.job)
