from ..client.numerous_api_client.client.common import RepeatedFunction
from time import sleep


def test_repeated_function_run_initially():
    state = { "count": 0 }
    def increase_count():
        state["count"] += 1
    assert state["count"] == 0, "The repeated function should not run yet"
    RepeatedFunction(0.1, increase_count, run_initially=True)
    assert state["count"] == 1, "The repeated function should run initially"


def test_repeated_function_start_stop():
    state = { "count": 0 }
    def increase_count():
        state["count"] += 1
    
    repeated_function = RepeatedFunction(0.01, increase_count)
    repeated_function.start()
    sleep(0.1)
    repeated_function.stop()

    sleep(0.1)
    count_after = state["count"]
    assert count_after > 0, "The repeated function must have run"
    assert count_after <= 10, "The repeated function must not have run more than 10 times"

    sleep(0.1)
    assert count_after == state["count"], "The repeated function should not have changed the state"
