from setuptools import setup, find_packages

from src.numerous.cli import __version__


setup(
    name="numerous_cli",
    entry_points={ "console_scripts": ["numerous=numerous.cli.run:main"], },
    version=__version__,
    include_package_data=True,
    description="Command-line tool for the numerous platform.",
    url="www.numerous.com",
    author="/".join([
        "Lasse Thomsen",
        "Kristian Bonde",
        "Jens Feodor Nielsen"
    ]),
    author_email="/".join([
        "lasse.thomsen@numerous.com",
        "kristian.bonde@numerous.com",
        "jens.nielsen@numerous.com"
    ]),
    license="Standard 2-clause BSD",
    install_requires=["dirtools_numerous", "numerous_api_client >= 0.4.9a",
                      "prettytable", "colorama", "requests"],
    package_dir={"": "src"},
    packages=find_packages(where="src")
)