from setuptools import find_packages, setup

from src.numerous.cli import __version__

setup(
    name="numerous_cli",
    version=__version__,
    include_package_data=True,
    description="Command-line tool for the numerous platform.",
    classifiers=[
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3.9',
    ],
    entry_points={"console_scripts": ["numerous=numerous.cli.run:main"]},
    license="Standard 2-clause BSD",
    install_requires=["dirtools", "numerous_api_client >= 0.5",
                      "prettytable", "colorama", "requests"],
    package_dir={'': 'src'},
    packages=find_packages(where='src'),
)
