from logging import Logger
from pathlib import Path

from ..repository import NumerousRepository
from ..utils import bold, green, red


def command_init(log: Logger, path: Path):
    path = path or Path.cwd()

    if (path / NumerousRepository.FILE_NAME).exists():
        try:
            repo = NumerousRepository(path).load()
            print(red(f'Cannot init: Folder already a repository for {bold(repo.remote.name)}'))
        except Exception:
            print(red('Cannot init: Folder already exists, but repository configuration is invalid'))
        finally:
            return

    path.mkdir(parents=True, exist_ok=True)

    if not (path / '.exclude').exists():
        src = Path(__file__).parent.parent / '.exclude'
        dst = path / '.exclude'
        dst.write_text(src.read_text())

    repo = NumerousRepository(path).save()

    print(green(f"New repository {bold(path.name)}"))
    print(f" - Connect a remote with {bold('numbuild config --remote <REMOTE URL>')}")
    print(f" - Checkout a scenario with {bold('numbuild checkout --scenario <SCENARIO ID>')}")
