from logging import Logger
from pathlib import Path

from ..auth import AuthenticationError, login
from ..repository import NumerousRepository
from ..utils import bold, green, red


def command_login(log: Logger, path: Path, admin: bool):
    path = path or Path.cwd()

    try:
        repo = NumerousRepository(path).load()
    except Exception as excp:
        log.debug(f"Exception {type(excp)} {excp}")
        print(red(f"Cannot login: {bold(str(path))} is not a repository."))
        return

    if repo.remote is None:
        print(red('Cannot login: No remote is configured for the repository.'))
        print(f"Use the command {bold('numbuild config --remote <REMOTE_URL>')} to configure a remote for the "
              "repository.")
        return

    if repo.scenario is None:
        print(red("Cannot re-login: A scenario must be checked out."))
        print(f"- Check out a scenario with {bold('numbuild checkout <SCENARIO ID>')}")
        return

    repo.token = None
    try:
        login(repo, admin=admin)
        print(green("Login succeeded."))
    except AuthenticationError:
        print(red("Login failed."))
        return
