from setuptools import find_namespace_packages, setup

from src.numerous.cli import __version__

setup(
    name="numerous_cli",
    version=__version__,
    include_package_data=True,
    description="Command-line tool for the numerous platform.",
    classifiers=[
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3.9',
    ],
    entry_points={"console_scripts": ["numerous=numerous.cli.run:main"]},
    license="Standard 2-clause BSD",
    install_requires=["dirtools-numerous==0.2.1", "numerous_api_client>=0.5", "colorama==0.4.4", "prettytable==2.4.0",
                      "requests==2.26.0", "api_grpc>=0.2"],
    package_dir={'': 'src'},
    packages=find_namespace_packages(where='src'),
)
