import json
import os
import datetime

def get_component_item_classes(scenario_data):

    components_ids = [x['id'] for x in scenario_data['simComponents']]


    component_data = {x['name']: x['item_class'] for x in scenario_data['simComponents']}
    return component_data

def get_model_component(sim_comp, component_id):
    for sc in sim_comp:
        if sc['id'] == component_id or ('containerID' in sc and sc['containerID'] == component_id):
            return sc
    return None
    #raise ValueError(component_id + ' not found')

def get_model_file_from_id(model, file_id):
    return model['Files'][file_id]

def item_key_value(item_list, key, value):
    for i in item_list:
        if key in i and i[key]==value:
            return i


def check_items_found(item_list, key, values):
    missing_vals = []
    for v in values:
        if item_key_value(item_list, key, v) is None:
            missing_vals.append(v)

    if len(missing_vals)>0:

        raise KeyError('Missing values for: ',missing_vals)

def format_job_spec(job_id, scenario_data, model):
    run_settings = scenario_data['jobs'][job_id]['runSettings']
    print('Run settings: ', run_settings)

    complete_job_spec = {}

    # Data for the time aspect of simulation
    parameters = scenario_data['jobs'][job_id]['image']['parameters']

    def get_val(param):
            return item_key_value(parameters, 'id', param)['value']['value']

    time_scale_div = 3.154 * 10**7

    check_items_found(parameters, 'id', ['first_month', 'duration', 'result_resolution', 'solver_resolution'])

    # Define sim specification and imports
    sim_specification = {
        "model_spec": {
            "input_stream": {
                "stream_ix": get_val('duration')/time_scale_div,  # 3.154 * 10**7
                "solve_all": True
            },
        },
        "sim_spec": {
            "dt": get_val('result_resolution'),
            "t_0": 0,#get_val('first_month'),
            "t_end": run_settings['endTimeVal']['value'],
            "dt_internal": get_val('solver_resolution'),


            "persistent_tags": {
                "no_tmp": True,
                "level": 3
            },
            "n_dt_update": -1,
            "start": datetime.datetime.fromisoformat(run_settings['startDate']),
            "stop_tag": "stop"
        }
    }

    #if not component['disabled'] and component['isMainComponent']:

    # Format kwargs
    for c in scenario_data['simComponents']:
        if "subcomponents" in c:
            for sc in c["subcomponents"]:
                for sc_ in scenario_data['simComponents']:
                    if sc['uuid'] == sc_['uuid']:
                        sc_['isSubcomponent'] = True

    components_list = [c for c in scenario_data['simComponents'] if not c['disabled'] and (c['isMainComponent'] or ("isSubcomponent" in c and c['isSubcomponent']))]
    sim_components_item_classes = get_component_item_classes(scenario_data)

    sys_def = []
    reference_names = []
    comp_names = []
    for i, component in enumerate(components_list):
        tmp_dict = {}
        name_ = component['name']
        name = name_
        if name in comp_names:
            raise ValueError(f'Item tag/name must be unique found multiple {name}')
        #   name = name_ + "_" + str(count)
        #    count +=1

        # Check if parameterers are specified and add them if so
        if 'parameters' in component.keys():
            for dicts in component['parameters']:

                # Check if the type is a reference, and make sure that it is added as such
                # Basically gets the name of the components which is referenced and adds a '@' sign
                if dicts['type'] == 'reference':

                    reference_data = get_model_component(scenario_data['simComponents'], dicts['value'])
                    if reference_data is None:
                        #raise ValueError(dicts['value'])
                        tmp_dict[dicts['id']] = None
                    #    tmp_dict[dicts['id']] = None
                    else:
                        tmp_dict[dicts['id']] = '@' + reference_data['name']
                        reference_names.append(reference_data['name'])

                # If type is file, substitute value for name of file
                elif dicts['type'] == 'file':
                    if type(dicts['value']) == dict and 'name' in dicts['value'].keys():
                        tmp_dict[dicts['id']] = dicts['value']['name']
                    else:
                        tmp_dict[dicts['id']] = str(os.getcwd()) + '/' + \
                                                get_model_file_from_id(model, dicts['value'])['name']

                # If not, just treat it normally
                else:
                    tmp_dict[dicts['id']] = dicts['value']

        tmp_dict['__disabled'] = component['disabled']
        sys_def.append({
            "name": name,
            "class_search_name": name_,
            "id": component['id'],
            "_id": i + 1,
            "item_type": "Simple_Components " + component['type'],
            "type": component['type'],
            "item": tmp_dict,
            "order": component['order'],
        })
        comp_names.append(name)

    kwargs_items = [{
        "py/tuple": [
            x['name'],
            {
                **x['item'],
                **{'item_class': sim_components_item_classes[x['name']]}
            }
        ],
        "order": x['order'],
    }
        for x in sys_def
    ]

    kwargs_items = sorted(kwargs_items, key=lambda k: k['order'])
    kwargs = {
        "label": "test",
        "specification": {
            "items": {
                "py/reduce": [
                    {
                        "py/type": "collections.OrderedDict"
                    },
                    {
                        "py/tuple": []
                    },
                    None,
                    None,
                    {
                        "py/tuple": kwargs_items
                    }
                ]
            }
        }
    }
    recipe = json.dumps({'sys_def': sys_def})
    print('r:')
    print(recipe)
    sim_specification['model_spec']['kwargs'] = json.dumps(kwargs)
    complete_job_spec['sim_specification'] = sim_specification




    return complete_job_spec, run_settings

