from numerous_api_client.client import open_client
from numerous_engine_0.dependencies.simulation import simulate_model
import logging
logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger('numerous0.main')
log.setLevel(logging.DEBUG)
import traceback

def run(job_id=None, project=None, scenario=None, code_path=None):

    #Open the numerous client
    with open_client(job_id=job_id, project=project, scenario=scenario) as client:
        try:

            scenario, model_definition, files = client.get_scenario()


            with client.open_writer() as output:
                log.debug('Writer opened!')

                simulate_model(scenario=scenario, model_definition=model_definition, output=output, client=client, code_path=code_path, timeout=120)
                log.debug('Simulation completed')

        except (KeyboardInterrupt):
            client.set_scenario_progress('Simulation terminated', 'terminated', force=True)

        except Exception:
            tb = traceback.format_exc()
            log.error(tb)
            client.set_scenario_progress('Simulation failed', 'failed', force=True)

