import os
import ipywidgets as widgets
import math
from scipy import interpolate
from plotly import __version__
from plotly.offline import download_plotlyjs,init_notebook_mode, plot, iplot
import plotly.graph_objs as go
import json
import pandas
import numpy as np
import base64
from IPython.display import HTML

date_fmt = '%Y-%m-%d %H:%M:%S %z UTC'
style = {'description_width': 'initial'}

def save_json(data, file):
    with open(file, 'w') as outfile:
        json.dump(data, outfile)
def load_json(file):        
    with open(file) as json_file:
        data = json.load(json_file)
        return data

def create_download_link( df, title = "Download CSV file", filename = "data.csv"):
    csv = df.to_csv(sep=';',decimal=',')
    b64 = base64.b64encode(csv.encode())
    payload = b64.decode()
    html = '<a download="{filename}" href="data:text/csv;base64,{payload}" target="_blank">{title}</a>'
    html = html.format(payload=payload,title=title,filename=filename)
    return HTML(html)


def agg(df, atype='mean',freq='D',tags=None, df_to_update=None):
    #print(type(df_to_update))
    if df_to_update is None:
        #print('kkk')
        df_to_update=df
    #else:
        #print('kk2')
    if tags is not None:
        if  len(tags)>0:
        
            df_to_update[tags]=agg_(df[tags], atype,freq)
           
    else:
        return agg_(df, atype,freq)
    return df_to_update

def agg_(df, atype='mean',freq='D'):
    if freq=='M':
        if atype=='mean':
            return df.groupby([(df.index.year),(df.index.month)]).mean()
        elif atype=='stddev':
            return df.groupby([(df.index.year),(df.index.month)]).stddev()
        elif atype=='sum':
            return df.groupby([(df.index.year),(df.index.month)]).sum()
        elif atype=='min':
            return df.groupby([(df.index.year),(df.index.month)]).min()
        elif atype=='max':
            return df.groupby([(df.index.year),(df.index.month)]).max()

        else:
            raise ValidationError('Unsupported aggregator!')
    else:
        if atype=='mean':
            return df.groupby(pandas.Grouper(freq=freq)).mean()
        elif atype=='stddev':
            return df.groupby([(df.index.year),(df.index.month)]).stddev()
        elif atype=='sum':
            return df.groupby(pandas.Grouper(freq=freq)).sum()
        if atype=='min':
            return df.groupby(pandas.Grouper(freq=freq)).min()
        elif atype=='max':
            return df.groupby(pandas.Grouper(freq=freq)).max()

        else:
            raise ValidationError('Unsupported aggregator!')
            


def makeplot(layo,y,range_slider=False, fill=None, captions=[], y2=None, show_iplot=True):
        data=[]
        for i, s in enumerate(y):
            #print(s[3:])
            vis = s[4] if len(s)>4 else True
            yaxis = s[5] if len(s)>5 else None
            #print(yaxis)
            #print(vis)
            if fill:
                if i>0:
                    d=go.Scatter(x=s[0],
                       y=s[1], name=s[2], fill=fill[i], visible=vis, yaxis=yaxis)
                else:
                    d=go.Scatter(x=s[0],
                       y=s[1], name=s[2], fill=fill[i], visible=vis, yaxis=yaxis)
            else:
                d= go.Scatter(x=s[0],
                   y=s[1], name=s[2], visible=vis, yaxis=yaxis)
            data.append(d)
            
        
 
        if range_slider:
            layout = dict(
                title=layo[0],
                yaxis=dict(
                    title=layo[2],
                    rangemode = 'tozero',
                ),
                xaxis=dict(
                    title=layo[1],
                    rangeselector=dict(
                        buttons=list([
                            dict(count=1,
                                 label='1m',
                                 step='month',
                                 stepmode='backward'),
                            dict(count=6,
                                 label='6m',
                                 step='month',
                                 stepmode='backward'),
                            dict(count=1,
                                label='YTD',
                                step='year',
                                stepmode='todate'),
                            dict(count=1,
                                label='1y',
                                step='year',
                                stepmode='backward'),
                            dict(step='all')
                        ])
                    ),
                    rangeslider=dict(),
                    type='date'
                )
            )
        else:
            y2_def = dict(
                    title=layo[3],
                    rangemode = 'tozero',
                    #titlefont=dict(
                    #    color='rgb(0,0,0)'
                    #),
                    #tickfont=dict(
                    #    color='rgb(0,0,0)'
                    #),
                    overlaying='y',
                    side='right'
                ) if y2 else None
            #print(y2_def)
            layout = dict(
                title=layo[0],
                xaxis=dict(
                    title=layo[1],
                    ),
                yaxis=dict(
                    title=layo[2],
                    rangemode = 'tozero',
      
                    ),
                yaxis2 = y2_def
            )
            
                        
 
            
                
        #print(data)
        fig = dict(data=data, layout=layout)
        if show_iplot:
            iplot(fig)
            
        return fig
     
        #if len(captions)>0:
            
            #display(HTML(figure_number))
            #figure_number += 1

        
            #display(HTML(num_fig(captions)))
        
        
def makebar(layo,y,stack=False, captions=[], y2=None, show_iplot=True):
        data=[]
        for s in y:
            vis = s[4] if len(s)>4 else True
            yaxis = s[5] if len(s)>5 else None
            data+=[go.Bar(x=s[0],
                   y=s[1], name=s[2],visible=vis, yaxis=yaxis)]
        
        y2_def = dict(
                    title=layo[3],
                    titlefont=dict(
                        color='rgb(148, 103, 189)'
                    ),
                    tickfont=dict(
                        color='rgb(148, 103, 189)'
                    ),
                    overlaying='y',
                    side='right'
                ) if y2 else None
        
        layout = dict(
            title=layo[0],
            xaxis=dict(
                title=layo[1],
                ),
            yaxis=dict(
                title=layo[2],

                ),
            yaxis2 = y2_def
        )
        if stack:
            layout['barmode']='stack'
        fig = dict(data=data, layout=layout)
        
        if show_iplot:
            iplot(fig)
            
        return fig
        
        #if len(captions)>0:
                    
           # display(HTML(num_fig(captions)))
        
# df: the dataframe storing the values to be plotted
# plot_defs: the different type of plots, like: temperatures over a year, average power changes over a year
# overwrite: force changing the title etc. of the pre-defined axis titles and so on of the "plot_defs"

def make_graphs(df, plot_defs,plot=True, overwrite=None, stack=False, y2=None, show_iplot=True):
    
    # If overwrite is not None -> it has VALUES and presumably a person wants to change the titles etc.
    # of the pre-defined graphs. 
    # "overwrite" is a list in itself, capable of changing multiple attributes of the graph to be made 
    # overwrite=[no_of_graph_to_be_altered,('')]
    
    # If overwrite is not None...
    if not overwrite:
        select = [(pd, None,1) for pd in plot_defs]
    else:
        select = []
    for o in overwrite:
        #print(type(o)
        # The 'overwrite' list members are getting added to the "select" list here? Why exactly?
        if isinstance(o,int):
            select.append((plot_defs[o], None, 1))
        else:
            #print(len(o))
            select.append((plot_defs[o[0]], o[1], 1 if len(o[1])<3 else o[1][2]))
    
    figures=[]
    for o in select:
        pd=o[0]
        xy=o[1]
        
        
        # xy is still getting values from the overwrite part, this is bassically what is in the () within the overwrite values
        # If xy is not None ->
        if not xy:
            #Shall be able to change the title of the 2nd Y_AXIS. DOES NOT HAPPEN THOUGH
            xy=(pd.x_title,pd.y_title, pd.y_title2 if hasattr(pd, 'y_title2') else '')
            
        captions = [pd.caption if hasattr(pd, 'caption') else '', pd.note if hasattr(pd, 'note') else '']
        #print(o)
        if len(xy)>3:
            captions[1] = xy[3]
        
        if len(xy)>4:
            captions[0] = xy[4]
            
        if len(xy)< 3:
            xy=(xy[0], xy[1], '')
        
        if plot:
            figures.append(makeplot((pd.title,xy[0],xy[1], xy[2]),[(df.index,df[y[0]]*y[2]*o[2],y[1], y[2], y[3] if len(y)>3 else True, y[4] if len(y)>4 else None) for y in pd.y_values], y2=y2, captions=captions, show_iplot=show_iplot))
        else:
            figures.append(makebar((pd.title,xy[0],xy[1], xy[2]),[(df.index,df[y[0]]*y[2]*o[2],y[1], y[2], y[3] if len(y)>3 else True, y[4] if len(y)>4 else None) for y in pd.y_values], stack=stack, y2=y2, captions=captions, show_iplot=show_iplot))
         
        return figures
            
def make_tables(df, plot_defs, overwrite=None):
    
    if not overwrite:
        select = [(pd, None,1) for pd in plot_defs]
    else:
        select = []
        for o in overwrite:
            #print(type(o))
            if isinstance(o,int):
                select.append((plot_defs[o], None, 1))
            else:
                #print(len(o))
                select.append((plot_defs[o[0]], o[1], 1 if len(o[1])<3 else o[1][2]))
    
    
    for o in select:
        pd=o[0]
        xy=o[1]
       
        
       
        this_df = pandas.DataFrame()
        for y in pd.y_values:
            this_df[y[1]] = df[y[0]]*y[2]*o[2]
        
        #this_df['Month']=this_df.index.month_name()
        #this_df.set_index('Month', inplace=True)
        #pandas.set_option('decimal', 2)    
        pandas.options.display.float_format = '{:,.2f}'.format
        this_qgrid = qgrid.QgridWidget(df=this_df, precision=2, show_toolbar=False)
        #this_qgrid.observe(observe_qgrid)
        
        display(create_download_link(this_df,title=pd.title, filename=base_job_alias+'_'+pd.title+'.csv'))
        display(this_df)
        
        


class dot_dict():
    def __init__(self, dictionary: dict):
        for k,v in dictionary.items():
            setattr(self,k,v)
            
def chunkIt(seq, num):
    avg = len(seq) / float(num)
    out = []
    last = 0.0

    while last < len(seq):
        out.append(seq[int(last):int(last + avg)])
        last += avg

    return out

def diff_tags(df, tags, difftags, scale=1):
    for t, tdiff in zip(tags, difftags):
        df[tdiff] = list(df[t].diff().values*scale)
    return df

def calc_flow(P, dT):
    return np.array([P_/4.189/dT_ if dT_>0 else 0 for dT_, P_ in zip(dT, P)])

from scipy.interpolate import interp1d
#Power price
def power_signature_cost(T, P, T_ref, 
          price_structure=[
              {'P': 51, 'offset': 1200/10.74, 'scale': 931/10.74},
              {'P': 251, 'offset': 4800/10.74, 'scale': 856/10.74},
              {'P': 1001, 'offset': 21400/10.74, 'scale': 789/10.74},
              {'P': np.inf, 'offset': 119050/10.74, 'scale': 692/10.74},
                          ]
       ):
    #print(min(T))
    #Here the min(T) is somehow can be lower than the Tref, which is just not good.
    P_ref = float(interp1d(T,P, fill_value="extrapolate", bounds_error=False)(T_ref))
    #print(P_ref)
    for ps in price_structure:
        if P_ref < ps['P']:
            #print(ps['offset'] + ps['scale'] * P_ref)
            #print(ps['offset'] )
            return ps['offset'] + ps['scale'] * P_ref, P_ref
        
    return price_structure[-1]['offset'] + price_structure[-1]['scale'] * P_ref, P_ref

#Flow cost made zero in the summer based on setting cost_m3 = 0
#This only fixes the flow cost for the BH charging period, not really for the DHW that we use in the summer I think.
    
def calc_DH_cost(df_in,
                #Energy Pricing
                prices_energy=[(0.403, [12,1,2]), (0.272, [3,4,10,11]) ,(0.0785, [5,6,7,8,9])],  #kr/kWh dec-feb
                power_sig_price_structure=[
              {'P': 51, 'offset': 1200/10.74, 'scale': 931/10.74},
              {'P': 251, 'offset': 4800/10.74, 'scale': 856/10.74},
              {'P': 1001, 'offset': 21400/10.74, 'scale': 789/10.74},
              {'P': np.inf, 'offset': 119050/10.74, 'scale': 692/10.74},
                          ],
                #prices_flow=[(0.036, [12,1,2]), (0.036, [3,4,10,11]) ,(0, [5,6,7,8,9])], #kr/m3
                flow_free_months=[5,6,7,8,9],
                
                #DH_flow_cost_cubicm_SEK = 'Stub.DH.cost_flow_m3_SEK',
                DH_cost_kWh_SEK = 'Stub.DH.cost_kWh_SEK',
                Elec_cost_kWh = 'Stub.Elec.cost',
                P_Peak = ['Stub.VV.P_Peak', 'Stub.VS.P_Peak'],
                T_Peak = ['Stub.VV.T', 'Stub.VS.T'],
                DH_cost_E = 'Stub.DH.cost_E',
                DH_cost_P_sign = 'Stub.DH.cost_P_sign',
                DH_cost_Flow = 'Stub.DH.cost_Flow',
                T_DH_avg_return = 'Stub.DH.T_avg_return',
                T_Ambient = 'T Ambient (C)',
                 DH_cost_total = 'Stub.DH.cost_Total',
                 HP_elec_consumption = 'Stub.EP.P_Usage',
                 HP_elec_cost = 'Stub.Elec.cost_EP',
                Peak_elec_cost = 'Stub.Elec.cost_Peak',
                 T_ref=-17.6, T_DH = 70, cost_m3 = 3.6, cost_elec_kWh = 0.61,
                 #ref=-17.6, T_DH = 70, cost_elec_kWh = 0.61,
                 tot_DH_cost="Total cost of DH",
                 tot_EP_cost="Total cost of EP usage",
                 tot_Peak_cost="Total cost of E based peak producer",
                 
                 
                
                ):
    d_time = max(df_in.index) - min(df_in.index);
    d_years = d_time.days/365;
    #print(max(df_in.index) - min(df_in.index))
    
    #Printing the overall amount of years that the simulation is looking at    
    ##print(d_years)
    
    #A new column is created in the dataframe, that stores the cost defined in the inputs as default,
    #but can be overwritten if needed.
    df_in[Elec_cost_kWh] =cost_elec_kWh;
   
    #Creating a column named after the pre-specified name to store the total DH cost, initialize it as 0
    df_in[DH_cost_kWh_SEK] = 0;
    
    #Filling the DH_cost_kWh_SEK with the price value that is belonging to the month that the given time step
    #is located at.
    for pl in prices_energy:
        df_in.loc[df_in.index.month.isin(pl[1]) , DH_cost_kWh_SEK] = pl[0];
    
    #Getting the overall heat amount that the peak producer provides
    #(or generally what we set as the producer connected to the DH, it can be the KB, 
    #which can act as the BH charger circuit)
  
    sum_peaks_kW = df_in[P_Peak].sum(axis=1);
    #print(sum_peaks_kW.describe())
    
    #Calculating the DH total heat/"thermal energy" cost of the peak production for every time step
    df_in[DH_cost_E] = sum_peaks_kW*df_in[DH_cost_kWh_SEK];
    
    ##print('cost E: ',df_in[DH_cost_E].sum()/d_years)
    
    #I think there might be a problem here. 
    #The peak power for the calculation of the peak signature part of the cost is always calculated bassed on -17.9  C
    #So in a way if the actual temperature throughout a year is below that then the user is winning. Else - so basically always -
    #the poor user is losing and overpaying as they will never ever use the power peak that is forecasted for the year.
    #Basically the DH provider just extrapolates from actual measured points on the heat signature curve and 
    #gets the value about what the heat rate would be if the temperature would be -17.9
    
    #So the max function is not good as then Tref can be closer to zero than -17.9, which is not really true
    #T_ref_signature = max(df_in[T_Ambient].min(),T_ref)
    #Fixed
    T_ref_signature = T_ref;
    
    
    #So here we call the function that calculates the cost of power signature.
    #This gives us the power signature cost per time-step, so hourly power signature cost
    df_in[DH_cost_P_sign] = power_signature_cost(df_in[T_Ambient], sum_peaks_kW, T_ref_signature, price_structure=power_sig_price_structure)[0]/365/24;
    
    ##print('cost P sig: ',df_in[DH_cost_P_sign].sum()/d_years)
    
    df_in[T_DH_avg_return]= sum([df_in[P_tag]*df_in[T_tag] for P_tag, T_tag in zip(P_Peak, T_Peak)])/sum_peaks_kW/1000;
    
    #print(df_in[T_DH_avg_return].describe())
    
    #An adjustment here might be necessary, so that summer months DHW heating by DH is not charged flow cost-wise
    #The flow calc funstion needs a power value and a temperature value
    
    df_in[DH_cost_Flow] = calc_flow(sum_peaks_kW/1000*3600, T_DH - df_in[T_DH_avg_return])*cost_m3*(sum_peaks_kW>0);
    
    #Zeroing out flow costs in months when there is no flow cost charged
    df_in.loc[df_in.index.month.isin(flow_free_months) , DH_cost_Flow] = 0;
    
    ####This fix method raised another issue. trying a different one now.
    
    #So creating a column for the actual flow costs. Zero in summer months
    #df_in[DH_flow_cost_cubicm_SEK] = 0
    
    #for pl in prices_flow:
    #    df_in.loc[df_in.index.month.isin(pl[1]) , DH_flow_cost_cubicm_SEK] = pl[0]
    
    #df_in[DH_cost_Flow] = calc_flow(sum_peaks_kW/1000*3600, T_DH - df_in[T_DH_avg_return])*DH_flow_cost_cubicm_SEK*(sum_peaks_kW>0)
    
    #####
   
    ##print('cost Flow: ', df_in[DH_cost_Flow].sum()/d_years)
    
    df_in[DH_cost_total] = df_in[DH_cost_E] + df_in[DH_cost_P_sign] + df_in[DH_cost_Flow];
    #df_in[DH_cost_total] = df_in[DH_cost_E].sum() + df_in[DH_cost_P_sign].sum() + df_in[DH_cost_Flow].sum()
    
    ##print('Total DH cost: ', df_in[DH_cost_total].sum()/d_years)#/1000)
    df_in[tot_DH_cost]=df_in[DH_cost_total].sum()/d_years;
    
    df_in[HP_elec_cost] = df_in[HP_elec_consumption] *df_in[Elec_cost_kWh]/d_years;
    df_in[Peak_elec_cost] = sum_peaks_kW *df_in[Elec_cost_kWh]/d_years;
    df_in['Stub.Elec.Peak_Cost'] = sum_peaks_kW *df_in[Elec_cost_kWh];
    
    ##print('Total EP Elec cost: ', df_in[HP_elec_cost].sum())#/1000)
    df_in[tot_EP_cost]=df_in[HP_elec_cost].sum();
    
    ##print('Total Peak Elec cost: ', df_in[Peak_elec_cost].sum())#/1000)
    df_in[tot_Peak_cost]=df_in[Peak_elec_cost].sum();
    
        
    return df_in;

def payback_of_investment(investment, cashflows):
    """The payback period refers to the length of time required 
       for an investment to have its initial cost recovered.
       
       >>> payback_of_investment(200.0, [60.0, 60.0, 70.0, 90.0])
       3.1111111111111112
    """
    total, years, cumulative = 0.0, 0, []
    if not cashflows or (sum(cashflows) < investment):
        #print(cashflows)
        #print(sum(cashflows))
        #print(investment)
        #raise Exception("insufficient cashflows")
        return np.inf
    for cashflow in cashflows:
        total += cashflow
        if total < investment:
            years += 1
        cumulative.append(total)
    A = years
    B = investment - cumulative[years-1]
    C = cumulative[years] - cumulative[years-1]
    return A + (B/C)

def payback(cashflows):
    """The payback period refers to the length of time required
       for an investment to have its initial cost recovered.
       
       (This version accepts a list of cashflows)
       
       >>> payback([-200.0, 60.0, 60.0, 70.0, 90.0])
       3.1111111111111112
    """
    investment, cashflows = cashflows[0], cashflows[1:]
    if investment < 0 : investment = -investment
    return payback_of_investment(investment, cashflows)


def check_null(value):
    if value == 0:
        return 0
    else:
        return 1
    """
def check_nan_value(value):
    if math.isnan(value)==True:
        return 0
    else:
        a = value
        return a
    

def sum_positive(A):
    B = 0
    for i in A:
        if i > 0:
            B += i
    return B


def sum_negative(x):
    y = 0
    for i in x:
        if i < 0:
            y += abs(i)
    return y
"""