class BaseValidationError(Exception):
    def __init__(self, msg: str):
        self.msg = msg


class DecodeTokenError(BaseValidationError):
    def __init__(self, exception: Exception):
        super().__init__(f"Could not decode the token: {exception}")


class InvalidTokenTypeError(BaseValidationError):
    def __init__(self, msg: str):
        super().__init__(msg)


class ExpiredTokenError(BaseValidationError):
    def __init__(self, msg: str = "Token expired"):
        super().__init__(msg)


class ValidationFailedError(BaseValidationError):
    def __init__(self, msg: str = "Token validation failed"):
        super().__init__(msg)


class MissingTokenError(BaseValidationError):
    def __init__(self, msg: str = "Token was missing from the request"):
        super().__init__(msg)
