from typing import Optional

from pydantic import BaseModel

from .common import AccessLevel


class BaseClaims(BaseModel):
    prefix: Optional[str] = None
    admin: bool = False
    user_id: Optional[str] = None
    organization_id: Optional[str] = None
    agent: Optional[str] = None
    purpose: Optional[str] = None
    access_level: AccessLevel = AccessLevel.READ


DataPortClaims = BaseClaims


class ApiClaims(BaseClaims):
    project_id: Optional[str] = None
    scenario_id: Optional[str] = None
    execution_id: Optional[str] = None
    job_id: Optional[str] = None
