import time
from abc import ABC, abstractmethod
from functools import wraps

from .common import decode_token_no_verify

EXPIRATION_SAFE_MARGIN = 30.0


class TokenRefreshable(ABC):
    @abstractmethod
    def _refresh_access_token(self):
        pass


def refresh_access_token(func):
    @wraps(func)
    def wrapper(self: TokenRefreshable, *args, **kwargs):
        self._refresh_access_token()
        return func(self, *args, **kwargs)

    return wrapper


def is_expired(token: str, safe_margin: float = EXPIRATION_SAFE_MARGIN) -> bool:
    claims = decode_token_no_verify(token)
    return bool(claims['exp'] < time.time() + safe_margin)
