if __name__ == '__main__':
    from google.cloud import datastore

    from g_func_utilities import Gfunc_Store

    ss = Gfunc_Store()

    client = datastore.Client(project='simtool-208411')


    query = client.query(kind='sim_G_func')


    results = query.fetch()



    for r in results:
        #print(r)

        model_params = {
            'B/H': r['B/H'],
            'rb/H': r['rb/H'],
            'D/H': r['D/H'],
            'geometry': r['geometry'],
        }

        id_ = '-'.join([str(i) for i in model_params.values()])
        print(id_)

        c = {'Name':id_ + '_model_params', 'Description': 'G-function', 'Tags': ['G-func'],
             'Comment': '', 'Configuration':
                 r
            }


        if ss.store_Config(c, True) == 0:
            print(str(id_) + ' stored successfully.')
        else:
            raise ValueError('Not saved')



        G_fit_key = client.key('sim_G_func_fit',id_)

        G_fit_ent = client.get(G_fit_key)
        if G_fit_ent:
            print('!!!!!')
            G_dict = dict(G_fit_ent)

            c = {'Name': id_ + '_fit_params', 'Description': 'G-function-fit', 'Tags': ['G-func'],
                 'Comment': '', 'Configuration':
                     G_dict
                 }

            if ss.store_Config(c, True) == 0:
                print(id_ + 'fit_params' + ' stored successfully.')
            else:
                raise ValueError('Not saved')

