import csv
import numpy as np
from scipy import interpolate

def import_CSV_Data(filename):
    csv.register_dialect('a', delimiter=';', quoting=csv.QUOTE_NONE)
    #print(filename)
    with open(filename, mode='r') as infile:
        #print(infile)
        reader = csv.reader(infile,'a')
        
        data = [rows for rows in reader]
        
    infile.close()
    
    data_dict={key.strip():[] for key in data[0]}
   
    data_keys=[key.strip() for key in data[0]]
    #print(data_keys)
    
    for i in range(2,len(data)):
        for j,v in enumerate(data[i]):
            if v !='':
                data_dict[data_keys[j]]+=[float(v)]
                
    #print(data_dict)
    return data_dict
   
def make_2DMap(data,XYZ):
    
    #p2D=PolyFitting.Poly2D('test')
    #p2D.fitPoly3(np.array(data[XYZ[0]]),np.array(data[XYZ[1]]),np.array(data[XYZ[2]]))
    #print(np.array(data[XYZ[2]]))
    p2D=interpolate.SmoothBivariateSpline(np.array(data[XYZ[0]]),np.array(data[XYZ[1]]),np.array(data[XYZ[2]]))
    
    return p2D

def make_Grid(p2D,data,XYZ,Nx,Ny, minx,maxx,miny,maxy):
    x=np.linspace(minx,maxx,Nx)
    y=np.linspace(miny,maxy,Ny)
    
    z=np.zeros((Nx,Ny),dtype=np.float32)
    
    for i in range(Nx):
        for j in range(Ny):
            z[i,j]=p2D(x[i],y[j])
            
    return x, y, z

def make_interpolation_grid(data, XYZ, Nx, Ny, minx,maxx,miny,maxy):
    p2D=make_2DMap(data,XYZ)
    x,y,z=make_Grid(p2D,data,XYZ,Nx,Ny, minx,maxx,miny,maxy)
    maparray=np.concatenate([[Nx, Ny, minx, maxx, miny, maxy], x, y, np.ndarray.flatten(np.transpose(z))])
    #print(maparray)
    #adsads=asdads
    return maparray
    
def make_interpolation_grid_RGI(data, XYZ, Nx, Ny, minx,maxx,miny,maxy):
    p2D=interpolate.LinearNDInterpolator(np.array(data[XYZ[0]]),np.array(data[XYZ[1]]),np.array(data[XYZ[2]]))
    x,y,z=make_Grid(p2D,data,XYZ,Nx,Ny, minx,maxx,miny,maxy)
    maparray=np.concatenate([[Nx, Ny, minx, maxx, miny, maxy], x, y, np.ndarray.flatten(np.transpose(z))])
    #print(maparray)
    #adsads=asdads
    return maparray

if __name__ == '__main__':
    data=import_CSV_Data('Grundfos NBE_65_125-127.CSV')
    
    XYZ=['Q','H','DC']
    QH_DC=make_interpolation_grid(data, XYZ, 5, 3, 0, max(data[XYZ[0]]),0,max(data[XYZ[1]]))
    
    print(QH_DC)
    
    
    data=import_CSV_Data('Grundfos_Magma3_125-100.CSV')
    spl=make_2DMap(data,['Q','P','DC'])
    spl2=make_2DMap(data,['Q','H','DC'])
    
    print(spl(0,1000))
   