import logging

class LoggerBaseClass:
    def __init__(self, firestore_job=None):
        pass
        #self.firestore_job = firestore_job

    def set_firestore_job(self, firestore_job):
        #self.firestore_job = firestore_job
        #self.firestore_job.push_log('', initializing=True)
        pass

    def __call__(self, msg, *args, sep=" ", status=None, progress=None):
        # Make sure firestore job is set
        #if self.firestore_job is None:
        #    raise ValueError("Firestore job is not set, so custom logging will not work!")

        status_update = {}
        if progress is not None:
            status_update.update({"progress": progress})

        if status is not None:
            status_update.update({'status': status})

        # Format message
        args = [str(element) for element in args]
        msg = str(msg) + sep + sep.join(args) if len(args) >= 1 else str(msg)

        # Print and send message
        #print(msg)
        logging.info(msg)
        #self.firestore_job.push_log(msg)

    def status(self, progress=None, status=None):
        # Make sure firestore job is set
        #if self.firestore_job is None:
        #    raise ValueError("Firestore job is not set, so custom logging will not work!")

        # Only add progress/status if they are not None
        status_update = {k: v for (k, v) in {'progress': progress, 'status': status}.items() if v is not None}

        # Update status
        if status_update:
             pass
        #    self.firestore_job.submit_progress(**status_update)

        # Log message, if both progress and status are None
        else:
            self.__call__("Neither status nor progress were set when attempting to update status. Doing nothing.")


class LoggerSingleton(type):
    _instances = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super(LoggerSingleton, cls).__call__(*args, **kwargs)
        return cls._instances[cls]


class Logger(LoggerBaseClass, metaclass=LoggerSingleton):
    pass
