# EMA
import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF, \
    sim_components.thermodynamics.LF_Pump_with_Map_P as LF_Pump_with_Map

import sim_components.thermodynamics.Heat_Exchanger_Nodes_Mean_p as MHX


class KVP(BC.Subsystem):
    def construct_Subsystem(self, CW_Evap=None, CW_Cond=None, T_Evap_ini=10, T_Cond_ini=50, VS_conn=False, **c):
        self.VS_conn = VS_conn
        #T_Evap_ini = -10
        #T_Cond_ini = 70
        kV=1
        self.dual_circuit = False
        self.subcooler = False
        self.cond1_VS = False
        # Evaporators1
        q_RF_Evap_ini = 1

        RF = self.add(c['Refrigerant'], FF.Fluid_Props, Config=c['Refrigerant'])
        self.RF = RF

        self.Evaporator1 = self.add('Evaporator1', MHX.Heat_Exchanger, 6, c['Plates_Evap'], RF, CW_Evap, T_Evap_ini,
                                    --1, q_RF_Evap_ini, dual='single', Config=c['Conf_Evap'])

        q_RF_Cond_ini = 0.0

        self.SuctionGas = self.add('SuctionGas', MHX.Heat_Exchanger, 4, c['Plates_Suc'], RF, RF, 60,
                                   -1, q=q_RF_Evap_ini, q2=q_RF_Cond_ini, dual='single', Config=c['Conf_Suc'])

        # Condenser


        self.Condenser1 = self.add('Condenser1', MHX.Heat_Exchanger, 8, c['Plates_Cond']/3 if VS_conn else c['Plates_Cond'], RF, CW_Cond, T_Cond_ini,
                                   60, q_RF_Cond_ini, dual='single', Config=c['Conf_Cond'])

        if VS_conn:

            self.Condenser_VS = self.add('Condenser_VS', MHX.Heat_Exchanger, 8, c['Plates_Cond']/3, RF, CW_Cond, T_Cond_ini,
                                   60, q_RF_Cond_ini, dual='single', Config=c['Conf_Cond'])

            self.Condenser_Low = self.add('Condenser_Low', MHX.Heat_Exchanger, 8, c['Plates_Cond']/3, RF, CW_Cond, T_Cond_ini,
                                   60, q_RF_Cond_ini, dual='single', Config=c['Conf_Cond'])

            self.add('pipe_cond_1_VS', FF.Pipe, .5,
                     side1=self.Condenser1.ports['F1A_Out'],
                     side2=self.Condenser_VS.ports['F1A_In']
                     )
            self.add('pipe_cond_VS_Low', FF.Pipe, .5,
                     side1=self.Condenser_VS.ports['F1A_Out'],
                     side2=self.Condenser_Low.ports['F1A_In']
                     )

            self.add('pipe_cond_low_1', FF.Pipe, 5,
                     side1=self.Condenser_Low.ports['F2_Out'],
                     side2=self.Condenser1.ports['F2_In'])


        self.add('pipe_suc_suction', FF.Pipe, .5,
                 side1=self.Condenser_Low.ports['F1A_Out'] if VS_conn else self.Condenser1.ports['F1A_Out'],
                 side2=self.SuctionGas.ports['F2_In']
                 )

        self.add('pipe_evap_suction', FF.Pipe, .5,
                 side1=self.Evaporator1.ports['F1A_Out'],
                 side2=self.SuctionGas.ports['F1A_In']
                 )

        # Circuit 1
        # RF Circuit
        self.var_nozzle1 = self.add('VarNozzle1', FF.Var_Nozzle,
                                    side1=self.SuctionGas.ports['F2_Out'],
                                    side2=self.Evaporator1.ports['F1A_In']
                                    )

        self.Compressor1 = self.add('Compressor1', FF.Transcritical_Compressor, RF,c['Compressors_Circuit'], 0,
                                    Config=c['Conf_Compressor'],
                                    evap=self.Evaporator1.ports['F1A_In'],
                                    inlet=self.SuctionGas.ports['F1A_In'],
                                    outlet=self.Condenser1.ports['F1A_In'],
                                    # outlet=self.comp_outlet1,
                                    nozzle=self.var_nozzle1
                                    )


        # 'Grundfos_Magma3_50-150'
        c_pump = {'Pump_Type': c['Pump_Evap1'], 'Set_Speed': c['Pump_Evap1_Speed'], 'kP': 0.0003}

        # c_pump={'Pump_Type':'Grundfos NBE_65_125-127', 'Set_Speed':.66, 'kP': 0.001}

        self.LCW_Evap1_in = self.add('Pump_CW_In_Evap1', LF_Pump_with_Map.Pump_with_Map, simple=True,
                                     inlet=c['In_Evaporator1'],  # c['In_Evaporator1'],#self.evap1_Inlet_Vol,
                                     outlet=self.Evaporator1.ports['F2_In'],
                                     **c_pump)

        self.add('pipe_evap1_Out', FF.Pipe_Check, 1,
                 inlet=self.Evaporator1.ports['F2_Out'],
                 outlet=c['Out_Evaporator1'])

        # CW Connections Condenser1

        self.add('pipe_cond1_In', FF.Pipe_Check, 1,
                 inlet=c['In_Condenser1'],
                 #outlet=self.Condenser_Low.ports['F2_In'] if VS_conn else self.Condenser1.ports['F2_In'])
                 outlet=self.Condenser1.ports['F2_In'])

        self.add('pipe_cond_Low_In', FF.Pipe_Check, 1,
                 inlet=c['In_Condenser_Low'],
                 # outlet=self.Condenser_Low.ports['F2_In'] if VS_conn else self.Condenser1.ports['F2_In'])
                 outlet=self.Condenser_Low.ports['F2_In'])
        #self.add('pipe_cond2_In', FF.Pipe, 1,
        #         side1=c['In_Condenser2'],
        #         side2=self.Condenser2.ports['F2_In'])

        #self.add('pipe_cond3_In', FF.Pipe_Check, 5,
        #         inlet=c['In_Condenser3'],
         #        outlet=self.Condenser3.ports['F2_In'])

        #self.Cond1_Outlet_Vol = self.add('Cond1_Outlet_Vol', FF.Volume, CW_Cond, .1, 0, T_Cond_ini)

        # 'Grundfos_Magma3_50-150'
        c_pump = {'Pump_Type': c['Pump_Cond1'], 'Set_Speed': c['Pump_Cond1_Speed'], 'kP': 0.0003}

        self.LCW_Cond1_out = self.add('Pump_CW_Out_Cond1', LF_Pump_with_Map.Pump_with_Map, simple=True,
                                      inlet=self.Condenser1.ports['F2_Out'],
                                      outlet=c['Out_Condenser1'],
                                      **c_pump)



        self.LCW_Cond_Low_out = self.add('LCW_Cond_Low_out', LF_Pump_with_Map.Pump_with_Map, simple=True,
                                      inlet=self.Condenser_Low.ports['F2_Out'],
                                      outlet=c['Out_Condenser_Low'],
                                      **c_pump)

        if VS_conn:
            c_pump = {'Pump_Type': c['Pump_Cond1'], 'Set_Speed': c['Pump_Cond1_Speed'], 'kP': 0.0003}

            self.LCW_Cond_VS_out = self.add('LCW_Cond_VS_out', LF_Pump_with_Map.Pump_with_Map, simple=False,
                                          inlet=self.Condenser_VS.ports['F2_Out'],
                                          outlet=c['Out_Condenser_VS'],
                                          **c_pump)

            self.add('pipe_cond_VS_In', FF.Pipe_Check, 5,
                     inlet=c['In_Condenser_VS'],
                     outlet=self.Condenser_VS.ports['F2_In'])

        #self.LCW_Cond2_out = self.add('Pump_CW_Out_Cond2', LF_Pump_with_Map.Pump_with_Map, simple=True,
        #                              inlet=self.Condenser2.ports['F2_Out'],
        #                              outlet=c['Out_Condenser2'],
        #                              **c_pump)

        #self.LCW_Cond3_out = self.add('Pump_CW_Out_Cond3', LF_Pump_with_Map.Pump_with_Map, simple=False,
        #                              inlet=self.Condenser3.ports['F2_Out'],
        #                              outlet=c['Out_Condenser3'],
        #                              **c_pump)

        #self.add('pipe_cond1_Out1', FF.Pipe_Check, kV=kV,
        #         inlet=self.Cond1_Outlet_Vol,
        #         outlet=c['Out_Condenser1_1'])

        #self.add('pipe_cond1_Out2', FF.Pipe_Check, kV=kV,
        #         inlet=self.Cond1_Outlet_Vol,
        #         outlet=c['Out_Condenser1_2'])



    #def pipe_flow(self):
     #   pipe_cond1_Out2 = cond1_Bypass.pipe_B.m_dot

    def output_(self, sys_dict):
        sys_dict[self.gp('Power_Usage')] = (
                sys_dict[self.Compressor1.gp('P_ewma')]
                + sys_dict[self.LCW_Evap1_in.gp('P_ewma')]
                + sys_dict[self.LCW_Cond1_out.gp('P_ewma')]
                + sys_dict[self.LCW_Cond_VS_out.gp('P_ewma')] if self.VS_conn else 0
                #+ sys_dict[self.LCW_Cond3_out.gp('P_ewma')]
                #+ sys_dict[self.LCW_Sub_in.gp('P_ewma')]
        )

        sys_dict[self.gp('Power_Usage_Compressors')] = (
                sys_dict[self.Compressor1.gp('P_ewma')]
        )

        sys_dict[self.gp('Energy_Usage')] = (
                sys_dict[self.Compressor1.gp('Energy')]
                + sys_dict[self.LCW_Evap1_in.gp('Energy')]

                + sys_dict[self.LCW_Cond1_out.gp('Energy')]
                + sys_dict[self.LCW_Cond_VS_out.gp('Energy')] if self.VS_conn else 0
               # + sys_dict[self.LCW_Cond3_out.gp('Energy')]

                #+ sys_dict[self.LCW_Sub_in.gp('Energy')]
        )

        sys_dict[self.gp('Energy_Usage_Compressor')] = (
                sys_dict[self.Compressor1.gp('Energy')]

        )

        #sys_dict[self.path + '.Q_Subcool_1A'] = (sys_dict[self.Subcooler.ports['F1A_Out'].gp('h')] - sys_dict[
        #    self.Condenser1.ports['F1A_Out'].gp('h')]) * sys_dict[self.gp('pipe1.m_dot')] / 1000

        sys_dict[self.gp('Power_Cooling')] = -sys_dict[self.Evaporator1.gp('Q_ewma')]
        #if self.dual_circuit:
        sys_dict[self.gp('Power_Heating')] = sys_dict[self.Condenser1.gp('Q_ewma')] #+ sys_dict[self.Condenser2.gp('Q_ewma')] #+sys_dict[self.Subcooler.gp('Q_ewma')]
        #else:
        #    sys_dict[self.gp('Power_Heating')] = sys_dict[self.Condenser1.gp('Q_ewma')] + sys_dict[self.Subcooler.gp('Q_ewma')]

        #sys_dict[self.path + '.Q_Subcool_2'] = (sys_dict[self.Subcooler.ports['F2_Out'].gp('h')] - sys_dict[
        #    self.LCW_Sub_in.inlet.gp('h')]) * sys_dict[self.gp('pipe_Sub_Out.m_dot')] / 1000

        if self.dual_circuit:
            sys_dict[self.gp('Power_Usage')] += (
                    sys_dict[self.Compressor2.gp('P_ewma')]
                    + sys_dict[self.LCW_Evap2_in.gp('P_ewma')]
                    + sys_dict[self.LCW_Cond2_out.gp('P_ewma')]
            )

            sys_dict[self.gp('Power_Usage_Compressors')] += (
                    sys_dict[self.Compressor2.gp('P_ewma')]

            )

            sys_dict[self.gp('Energy_Usage_Compressor')] += (
                sys_dict[self.Compressor2.gp('Energy')]

            )

            sys_dict[self.gp('Energy_Usage')] += (
                    sys_dict[self.Compressor2.gp('Energy')]
                    + sys_dict[self.LCW_Evap2_in.gp('Energy')]
                    + sys_dict[self.LCW_Cond2_out.gp('Energy')]
                    )

            #sys_dict[self.path + '.Q_Subcool_1B'] = (sys_dict[self.Subcooler.ports['F1B_Out'].gp('h')] - sys_dict[
            #    self.Condenser2.ports['F1A_Out'].gp('h')]) * sys_dict[self.gp('pipe2.m_dot')] / 1000

            sys_dict[self.gp('Power_Cooling')] += -sys_dict[self.Evaporator2.gp('Q_ewma')]
            sys_dict[self.gp('Power_Heating')] += sys_dict[self.Condenser2.gp('Q_ewma')]

        #sys_dict[self.gp('COP')] = sys_dict[self.gp('Power_Heating')] / (
        #            sys_dict[self.gp('Power_Usage')] + (sys_dict[self.gp('Power_Usage')] == 0)) * (
        #                                       sys_dict[self.gp('Power_Usage')] != 0)
        #sys_dict[self.gp('COP_Heating')] = sys_dict[self.gp('Power_Heating')] / (
        #        sys_dict[self.gp('Power_Usage')] + (sys_dict[self.gp('Power_Usage')] == 0)) * (
         #                                          sys_dict[self.gp('Power_Usage')] != 0)

        sys_dict[self.gp('Power_Evaporator1')] = sys_dict[self.Evaporator1.gp('Q_ewma')]
        sys_dict[self.gp('Power_Condenser1')] = sys_dict[self.Condenser1.gp('Q_ewma')]
        sys_dict[self.gp('Power_Condenser_Low')] = sys_dict[self.Condenser_Low.gp('Q_ewma')] if self.VS_conn else 0
        sys_dict[self.gp('Power_Condenser_VS')] = sys_dict[self.Condenser_VS.gp('Q_ewma')] if self.VS_conn else 0
        sys_dict[self.gp('Power_HW')] = sys_dict[self.Condenser1.gp('Q_ewma')] + sys_dict[self.Condenser_Low.gp('Q_ewma')] if self.VS_conn else 0
        #sys_dict[self.gp('Power_Condenser3')] = sys_dict[self.Condenser3.gp('Q_ewma')]
        #sys_dict[self.gp('Power_Subcooler1')] = sys_dict[self.Subcooler.gp('Q_A_ewma')]

        #sys_dict[self.gp('COP_Heat_1')] = (sys_dict[self.Condenser1.gp('Q_A_ewma')] + sys_dict[
        #    self.Subcooler.gp('Q_A_ewma')]) / (
        #                                          sys_dict[self.Compressor1.gp('P_ewma')] + 1) * (
        #                                          sys_dict[self.Compressor1.gp('state')] > 0)

        #sys_dict[self.gp('COP_Cool_1')] = (sys_dict[self.Evaporator1.gp('Q_A_ewma')]) / (
        #        sys_dict[self.Compressor1.gp('P_ewma')] + 1) * (sys_dict[self.Compressor1.gp('state')] > 0)

        #sys_dict[self.gp('Power_Subcooler')] = sys_dict[self.Subcooler.gp('Q_ewma')]

        if self.dual_circuit:
            sys_dict[self.gp('Power_Evaporator2')] = sys_dict[self.Evaporator2.gp('Q_ewma')]
            sys_dict[self.gp('Power_Condenser2')] = sys_dict[self.Condenser2.gp('Q_ewma')]
            sys_dict[self.gp('Power_Subcooler2')] = sys_dict[self.Subcooler.gp('Q_B_ewma')]

            sys_dict[self.gp('COP_Heat_2')] = (sys_dict[self.Condenser2.gp('Q_A_ewma')] + sys_dict[
                self.Subcooler.gp('Q_B_ewma')]) / (
                                                  sys_dict[self.Compressor2.gp('P_ewma')] + 1) * (
                                                      sys_dict[self.Compressor2.gp('state')] > 0)

            sys_dict[self.gp('COP_Cool_2')] = (sys_dict[self.Evaporator2.gp('Q_A_ewma')]) / (
                    sys_dict[self.Compressor2.gp('P_ewma')] + 1) * (sys_dict[self.Compressor2.gp('state')] > 0)

    def print_output(self, t, sys_dict):

        #print('COP: ' + str(sys_dict[self.gp('COP')]))
        ##print('Power Usage: ' + str(sys_dict[self.gp('Power_Usage')]) + ' kW')
        #print('Power Cooling: ' + str(sys_dict[self.gp('Power_Cooling')]) + ' kW')
        #print('Power Heating: ' + str(sys_dict[self.gp('Power_Heating')]) + ' kW')
        print('')


