import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
#import Liquid
import sim_components.machines.EMA_v2 as EMA
import sim_components.machines.EMB_single_no_sub_v2 as EMB
#import sim_tool_EM.RefpropFluid as Fluid
import sim_components.machines.accumulator_tanks as AT



#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class EM_System(BC.Subsystem):
    def construct_Subsystem(self, CW_CS, CW_HS, CW_DW, T_CS_ini, T_HS_ini, **inputs):

        
        #Generic flow resistance - might need optim!
        kV=3
        h=1e4
        Acu_nodes=3
        #Construct Accumulator1
        self.Acu1 = self.add('Acu1', AT.AccumulatorTank, Acu_nodes,
                             [{'Volume': inputs['Acu_Tank_Sizes'][0], 'kV': kV, 'Fluid': CW_HS, 'T_ini': T_HS_ini, 'Counter': False}])

        #Construct Acuumulator2
        self.Acu2 = self.add('Acu2', AT.AccumulatorTank, Acu_nodes,
                             [
                                 {'Volume': inputs['Acu_Tank_Sizes'][1], 'kV': kV, 'Fluid': CW_HS, 'T_ini': T_HS_ini, 'Counter': False},
                                 {'Volume': .1, 'kV':kV, 'Fluid': CW_DW, 'T_ini': T_HS_ini, 'Counter': True}
                             ],
                             [
                                 {'h': h, 'strings': [0, 1]}
                             ]
                             )

        # Construct Acuumulator3
        self.Acu3 = self.add('Acu3', AT.AccumulatorTank, Acu_nodes,
                             [
                                 {'Volume': inputs['Acu_Tank_Sizes'][2], 'kV': kV, 'Fluid': CW_HS, 'T_ini': T_HS_ini, 'Counter': False},
                                 {'Volume': .1, 'kV': kV, 'Fluid': CW_DW, 'T_ini': T_HS_ini, 'Counter': True}
                             ],
                             [
                                 {'h': h, 'strings': [0, 1]}
                             ]
                             )

        # Construct Acuumulator4
        self.Acu4 = self.add('Acu4', AT.AccumulatorTank, Acu_nodes,
                             [
                                 {'Volume': inputs['Acu_Tank_Sizes'][3], 'kV': kV, 'Fluid': CW_HS, 'T_ini': T_HS_ini, 'Counter': False},
                                 {'Volume': .1, 'kV': kV, 'Fluid': CW_DW, 'T_ini': T_HS_ini, 'Counter': True}
                             ],
                             [
                                 {'h': h, 'strings': [0, 1]}
                             ]
                             )

        # Create pipes ports EM1
        VoCW_HS_in = self.add('VoCW_HS_in', FF.Volume, CW_HS, 0.1, T0=T_HS_ini)


        self.Pipe_Cold_Water_in_Acu2_Bottom_1 = self.add('Pipe_Cold_Water_in_Acu2_Bottom_1', FF.Pipe, kV,
                                            side1=inputs['VV_Cold'],
                                            side2=self.Acu2.Bottom[1])

        self.Pipe_Acu3_Top_1_DHW = self.add('Pipe_Acu3_Top_1_DHW', FF.Pipe, kV,
                                                         side1 =  self.Acu3.Top[1],
                                                         side2 = inputs['VV_Supply'])

        self.Pipe_DHW_Return_Acu3_Bottom_1 = self.add('Pipe_DHW_Return_Acu3_Bottom_1', FF.Pipe_Fixed_Massflow, 0.5,
                                            side1=inputs['VV_Return'],
                                            side2=self.Acu3.Bottom[1])

        self.Pipe_VoCW_HS_in_Acu4_Bottom_0 = self.add('Pipe_VoCW_HS_in_Acu4_Bottom_0', FF.Valve_Regulated,  kV, S_set_in=0, kP=0.1,
                                               side1=VoCW_HS_in,
                                               side2=self.Acu4.Bottom[0])

        #self.Pipe_VoCW_HS_in_Acu4_Bottom_0 = self.add('Pipe_VoCW_HS_in_Acu4_Bottom_0', FF.Pipe, kV,

         #                                             side1=VoCW_HS_in,
          #                                            side2=self.Acu4.Bottom[0])

        self.Pipe_VS_return_VoCW_HS_in = self.add('Pipe_VS_return_VoCW_HS_in', FF.Pipe, kV,
                                                      side1=inputs['VS_Return'],
                                                      side2=VoCW_HS_in)

        self.Pipe_Acu4_Top_0_HS_out = self.add('Pipe_Acu4_Top_0_HS_out', FF.Pipe, kV,
                                                   side1=self.Acu4.Top[0],
                                                   side2=inputs['VS_Supply'])

        if 'VS_Dump_Supply' in inputs and 'VS_Dump_Return' in inputs:
            self.Pipe_VS_Dump_return_VoCW_HS_in = self.add('Pipe_VS_Dump_return_VoCW_HS_in', FF.Pipe, kV,
                                                      side1=inputs['VS_Dump_Return'],
                                                      side2=VoCW_HS_in)

            self.Pipe_Dump_Acu4_Top_0_HS_out = self.add('Pipe_Dump_Acu4_Top_0_HS_out', FF.Pipe, kV,
                                                   side1=self.Acu4.Top[0],
                                                   side2=inputs['VS_Dump_Supply'])


        self.Pipe_Acu2_Bottom_0_Acu1_Top_0 = self.add('Pipe_Acu2_Bottom_0_Acu1_Top_0', FF.Pipe, kV,
                                                         side1=self.Acu2.Bottom[0],
                                                         side2=self.Acu1.Top[0])

        self.Pipe_Acu2_Top_0_Acu4_Bottom_0 = self.add('Pipe_Acu2_Top_0_Acu4_Bottom_0', FF.Pipe, kV*0,
                                                      side1=self.Acu2.Top[1],
                                                      side2=self.Acu4.Bottom[1])

        self.Pipe_Acu4_Top_0_Acu3_Bottom_0 = self.add('Pipe_Acu4_Top_0_Acu3_Bottom_0', FF.Pipe, kV*0,
                                                      side1=self.Acu4.Top[1],
                                                      side2=self.Acu3.Bottom[1])

        #self.Pipe_direct_return_kb = self.add('Pipe_direct_return_kb', FF.Pipe_Check, kV,
        #                                             inlet=inputs['KB_Supply'],
        #                                             outlet=inputs['KB_Return'])

        #Construct EM1AB
        EMAB_conf = {'Config': inputs['Conf_EMAB'],
            'A1': inputs['KB_Supply'],
            'A2': inputs['KB_Return'],
            'B1': self.Acu4.Top[0],
            'B2': VoCW_HS_in,
            'C11': self.Acu1.Bottom[0],
            'C12': self.Acu1.Top[0],
            'C21': self.Acu2.Bottom[0],
            'C22': self.Acu2.Top[0],
            'D1': self.Acu3.Top[0],
            'D2': self.Acu3.Bottom[0],
            'E1': self.Acu2.Top[0],
            'E2': self.Acu1.Bottom[0],
        }
        self.EMAB = self.add('EMAB',EMAB, CW_CS, CW_HS, T_CS_ini, T_HS_ini,host=self, **EMAB_conf)

    def output_(self, sys_dict):


        Power_space_heating = sys_dict[self.EMA.gp('Power_Heating')]
        EMA_Comp_Power = sys_dict[self.EMA.gp('Power_Usage')]
        Cooling_Power = -sys_dict[self.EMA.gp('Power_Evaporator')]
        #Energy_Consumption = sys_dict[self.EMA.gp('Energy_Usage')]
        #Energy_Consumption_Compressors = sys_dict[self.EMA.gp('Energy_Usage_Compressor')]


        Power_space_heating = sys_dict[self.EMB.gp('Power_Heating')]
        EMB_Comp_Power = sys_dict[self.EMB.gp('Power_Usage')]
        Energy_Consumption = sys_dict[self.EMB.gp('Energy_Usage')] + sys_dict[self.EMA.gp('Energy_Usage')]
        Energy_Consumption_Compressors = sys_dict[self.EMB.gp('Energy_Usage_Compressor')] + sys_dict[self.EMA.gp('Energy_Usage_Compressor')]


        sys_dict[self.gp('EMA_Comp_Power')] = EMA_Comp_Power
        sys_dict[self.gp('EMB_Comp_Power')] = EMB_Comp_Power
        sys_dict[self.gp('Space_Heating_Power')] = Power_space_heating
        sys_dict[self.gp('Cooling_Power')] = Cooling_Power
        # 'Power Consumption':
        sys_dict[self.gp('Power_Consumption')] = EMA_Comp_Power + EMB_Comp_Power

        sys_dict[self.gp('Energy_Consumption')] = Energy_Consumption/3600
        sys_dict[self.gp('Energy_Consumption_Compressors')] = Energy_Consumption_Compressors/3600
        sys_dict[self.gp('Energy_Consumption_Evap_Pumps')] = sys_dict[self.EMA.gp('Energy_Usage_Evap_Pump')] / 3600



        #'Total COP':
        sys_dict[self.gp('Total_COP')] = (Power_space_heating + Cooling_Power)/ (EMB_Comp_Power+ EMA_Comp_Power)

class EMAB(BC.Subsystem):

    def construct_Subsystem(self,CW_CS, CW_HS,T_CS_ini,T_HS_ini,host=None,**inputs):
        if not host:
            host = self
        self.host = host

        #print('inputs: ',inputs)

        kV=3
        # Create volume for EMB evaporator outlet
        VoCW_EMB_Evap_out = host.add('VoCW_EMB_Evap_out', FF.Volume, CW_HS, 0.1, T0=T_HS_ini)
        VoCW_EMB_Evap_in = host.add('VoCW_EMB_Evap_in', FF.Volume, CW_HS, 0.1, T0=T_HS_ini)

        # Create volumes for EMB condenser in/outlet
        VoCW_EMB_Cond_in = host.add('VoCW_EMB_Cond_in', FF.Volume, CW_HS, 0.1, T0=T_HS_ini)
        VoCW_EMB_Cond_out = host.add('VoCW_EMB_Cond_out', FF.Volume, CW_HS, 0.1, T0=T_HS_ini)

        # Create volumes for EMB subcooler in/outlet
        VoCW_EMB_Sub_in = host.add('VoCW_EMB_Sub_in', FF.Volume, CW_HS, 0.1, T0=T_HS_ini)
        VoCW_EMB_Sub_out = host.add('VoCW_EMB_Sub_out', FF.Volume, CW_HS, 0.1, T0=T_HS_ini)

        VoCW_EMB_Sub_in_kb = host.add('VoCW_EMB_Sub_in_kb', FF.Volume, CW_CS, 0.1, T0=T_HS_ini)
        VoCW_EMB_Sub_out_kb = host.add('VoCW_EMB_Sub_out_kb', FF.Volume, CW_CS, 0.1, T0=T_HS_ini)

        #Create pipes internal EM1AB
        Pipe_EMB_Sub_in_out = host.add('Pipe_EMB_Sub_in_out', FF.Pipe, kV,
                 side1=VoCW_EMB_Sub_in,
                 side2=VoCW_EMB_Sub_out)

        Pipe_EMB_Cond_in_out = host.add('Pipe_EMB_Cond_in_out', FF.Pipe, kV,
                                            side1=VoCW_EMB_Cond_in,
                                            side2=VoCW_EMB_Cond_out)

        Pipe_C21_EMB_Evap_out = host.add('Pipe_C21_EMB_Evap_out', FF.Pipe, kV,
                                             side1=VoCW_EMB_Evap_out,
                                             side2=inputs['C21'])

        Pipe_C11_EMB_Evap_out = host.add('Pipe_C11_EMB_Evap_out', FF.Pipe, kV,
                                              side1=VoCW_EMB_Evap_out,
                                              side2=inputs['C11'])

        Pipe_B2_EMB_Sub_in = host.add('Pipe_B2_EMB_Sub_in', FF.Pipe, kV,
                                              side1=inputs['B2'],
                                              side2=VoCW_EMB_Sub_in)

        Pipe_B1_EMB_Cond_out = host.add('Pipe_B1_EMB_Cond_out', FF.Pipe, kV,
                                           side1=VoCW_EMB_Cond_out,
                                           side2=inputs['B1'])



        # Create EMA
        EMA_conf = {'Config': inputs['EMA']}
        EMA_conf.update({
            'Compressor_states': [0, 0, 0, 0],
            'Pump_Evap_Speed': 0,
            'Pump_Cond_Speed': 0,
            'Pump_Sub_Speed': 0,
            '3W_Subcooler_Bypass': 0,
            'In_Evaporator': inputs['A2'],
            'Out_Evaporator': inputs['A1'],
            'In_Condenser': VoCW_EMB_Sub_out,
            'Out_Condenser': VoCW_EMB_Cond_in,
            'In_Subcooler': inputs['E2'],
            'Out_Subcooler': inputs['E1']
        })

        #host.add('EMA', EMA.EMA, CW_CS, CW_HS, CW_HS, T_CS_ini, T_HS_ini, T_HS_ini, **EMA_conf)
        host.add('EMA', EMA.EMA, CW_CS, CW_HS, CW_HS, **EMA_conf)

        #Create EMB

        EMB_Evap_Bypass = host.add('EMB_Evap_Bypass', FF.ThreeWayValve_Regulated, CW_HS, kV, .1, T_HS_ini, 1,
                                 A=inputs['C22'],
                                 B=inputs['C12'],
                                 C=VoCW_EMB_Evap_in)

        EMB_conf = {'Config': inputs['EMB']}
        EMB_conf.update({
            'Fix_Pump_Flow': False,
            'Compressor_states': [0, 0],
            'Pump_Evap1_Speed': 1,
            'Pump_Cond1_Speed': 1,
            'Pump_Evap2_Speed': 1,
            'Pump_Cond2_Speed': 1,
            'Pump_Sub_Speed': 1,
            '3W_Space_Hot': 0,
            'In_Evaporator1': VoCW_EMB_Evap_in,
            'Out_Evaporator1': VoCW_EMB_Evap_out,
            #'Out_Evaporator1_2': inputs['C12'],
            'In_Condenser1_1': inputs['D2'],
            'Out_Condenser1_1': inputs['D1'],
            'In_Condenser1_2': VoCW_EMB_Cond_in,
            'Out_Condenser1_2': VoCW_EMB_Cond_out,
            'In_Subcooler': VoCW_EMB_Sub_in,
            'Out_Subcooler': VoCW_EMB_Sub_out
        })

        host.add('EMB', EMB.EMB, CW_HS, CW_HS, CW_HS, T_HS_ini, T_HS_ini, T_HS_ini, **EMB_conf)

