# EMA
import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF, \
    sim_components.thermodynamics.LF_Pump_with_Map_P as LF_Pump_with_Map

import sim_components.thermodynamics.Heat_Exchanger_Nodes_Mean_p as MHX


class EMB(BC.Subsystem):
    def construct_Subsystem(self, CW_Evap, CW_Cond, CW_Sub, T_Evap_ini, T_Cond_ini, T_Sub_ini, **c):
        self.dual_circuit = c['Dual_Circuit']

        # TODO Solve issue with Evap three way, sometimes expose two ports!
        T_Evap_ini = T_Cond_ini = T_Sub_ini = 60
        # Evaporators1
        q_RF_Evap_ini = 0.9

        RF = self.add(c['Refrigerant'], FF.Fluid_Props, Config=c['Refrigerant'] + '_333_6_No_NaN')
        self.RF = RF

        self.Evaporator1 = self.add('Evaporator1', MHX.Heat_Exchanger, 4, c['Plates_Evap'], RF, CW_Evap, T_Evap_ini,
                                    T_Evap_ini, q_RF_Evap_ini, dual='single', Config=c['Conf_Evap'])

        if c['Dual_Circuit']:
            self.Evaporator2 = self.add('Evaporator2', MHX.Heat_Exchanger, 4, c['Plates_Evap'], RF, CW_Evap, T_Evap_ini,
                                        T_Evap_ini, q_RF_Evap_ini, dual='single', Config=c['Conf_Evap'])

        q = 0.05
        # Condenser
        q_RF_Cond_ini = q

        self.Condenser1 = self.add('Condenser1', MHX.Heat_Exchanger, 4, c['Plates_Cond'], RF, CW_Cond, T_Cond_ini,
                                   T_Cond_ini, q_RF_Cond_ini, dual='single', Config=c['Conf_Cond'])
        if c['Dual_Circuit']:
            self.Condenser2 = self.add('Condenser2', MHX.Heat_Exchanger, 4, c['Plates_Cond'], RF, CW_Cond, T_Cond_ini,
                                       T_Cond_ini, q_RF_Cond_ini, dual='single', Config=c['Conf_Cond'])
        # Subcooler
        q_RF_Sub_ini = q
        if c['Dual_Circuit']:
            dual_str='dual'
        else:
            dual_str = 'single'

        self.Subcooler = self.add('Subcooler', MHX.Heat_Exchanger, 4, c['Plates_Sub'], RF, CW_Sub, T_Sub_ini, T_Sub_ini,
                                  q_RF_Cond_ini, dual=dual_str, Config=c['Conf_Sub'])

        # self.comp_outlet1 = self.add('comp_outlet1', FF.Volume, RF, 0.1, q_RF_Cond_ini, T_Cond_ini)

        # Circuit 1
        # RF Circuit
        self.var_nozzle1 = self.add('VarNozzle1', FF.Var_Nozzle,
                                    side1=self.Subcooler.ports['F1A_Out'],
                                    side2=self.Evaporator1.ports['F1A_In']
                                    )

        self.Compressor1 = self.add('Compressor1', FF.Dual_Compressor, RF,c['Compressors_Circuit'], c['Compressor_states'][0], 0,
                                    Config=c['Conf_Compressor'],
                                    inlet=self.Evaporator1.ports['F1A_Out'],
                                    outlet=self.Condenser1.ports['F1A_In'],
                                    # outlet=self.comp_outlet1,
                                    nozzle=self.var_nozzle1
                                    )

        # self.add('pipe_comp', FF.Pipe, .05,
        #         side1=self.comp_outlet1,
        #         side2=self.Condenser1.ports['F1A_In']
        #         )

        # self.add('pipe1',FF.Pipe_Liquid_Only,RF,.5,
        self.add('pipe1', FF.Pipe, .5,
                 side1=self.Condenser1.ports['F1A_Out'],
                 side2=self.Subcooler.ports['F1A_In']
                 )

        # CW Connections Evaporator1
        self.evap1_Inlet_Vol = self.add('Evap1_Inlet_Vol', FF.Volume, CW_Evap, .1, 0, T_Evap_ini)

        # self.bp_evap1=self.add('Evap1_Bypass',FF.ThreeWayValve,5,
        #     A=self.Evaporator1.ports['F2_Out'],
        #     B=c['In_Evaporator1'],
        #     C=self.evap1_Inlet_Vol)

        self.bp_evap1 = self.add('Evap1_Bypass', FF.ThreeWayValve_Regulated, CW_Evap, 3, .1, T_Evap_ini, 1,
                                 A=c['In_Evaporator1'],
                                 B=self.Evaporator1.ports['F2_Out'],
                                 C=self.evap1_Inlet_Vol)

        # 'Grundfos_Magma3_50-150'
        c_pump = {'Pump_Type': c['Pump_Evap1'], 'Set_Speed': c['Pump_Evap1_Speed'], 'kP': 0.0003}

        # c_pump={'Pump_Type':'Grundfos NBE_65_125-127', 'Set_Speed':.66, 'kP': 0.001}

        self.LCW_Evap1_in = self.add('Pump_CW_In_Evap1', LF_Pump_with_Map.Pump_with_Map, c['Fix_Pump_Flow'],
                                     inlet=self.evap1_Inlet_Vol,  # c['In_Evaporator1'],#self.evap1_Inlet_Vol,
                                     outlet=self.Evaporator1.ports['F2_In'],
                                     **c_pump)

        self.add('pipe_evap1_Out', FF.Pipe_Check, 1,
                 inlet=self.Evaporator1.ports['F2_Out'],
                 outlet=c['Out_Evaporator1'])

        # CW Connections Condenser1

        self.bp_cond1 = self.add('cond1_Bypass', FF.ThreeWayValve_Regulated, CW_Evap, 5, .1, T_Evap_ini,
                                 c['3W_Space_Hot'],
                                 A=c['In_Condenser1_1'],
                                 B=c['In_Condenser1_2'],
                                 C=self.Condenser1.ports['F2_In'])

        self.Cond1_Outlet_Vol = self.add('Cond1_Outlet_Vol', FF.Volume, CW_Cond, .1, 0, T_Cond_ini)

        # 'Grundfos_Magma3_50-150'
        c_pump = {'Pump_Type': c['Pump_Cond1'], 'Set_Speed': c['Pump_Cond1_Speed'], 'kP': 0.0003}
        self.LCW_Cond1_out = self.add('Pump_CW_Out_Cond1', LF_Pump_with_Map.Pump_with_Map, c['Fix_Pump_Flow'],
                                      inlet=self.Condenser1.ports['F2_Out'],
                                      outlet=self.Cond1_Outlet_Vol,
                                      **c_pump)

        self.add('pipe_cond1_Out1', FF.Pipe_Check, 1,
                 inlet=self.Cond1_Outlet_Vol,
                 outlet=c['Out_Condenser1_1'])

        self.add('pipe_cond1_Out2', FF.Pipe_Check, 1,
                 inlet=self.Cond1_Outlet_Vol,
                 outlet=c['Out_Condenser1_2'])

        # #Circuit 2
        if c['Dual_Circuit']:
            self.var_nozzle2 = self.add('VarNozzle2', FF.Var_Nozzle,
                                        side1=self.Subcooler.ports['F1B_Out'],
                                        side2=self.Evaporator2.ports['F1A_In']
                                        )
            self.Compressor2 = self.add('Compressor2', FF.Dual_Compressor, RF, c['Compressors_Circuit'], c['Compressor_states'][1], 0,
                                        Config=c['Conf_Compressor'],
                                        inlet=self.Evaporator2.ports['F1A_Out'],
                                        outlet=self.Condenser2.ports['F1A_In'],
                                        nozzle=self.var_nozzle2)
            # self.add('pipe2',FF.Pipe_Liquid_Only,RF,.5,
            self.add('pipe2', FF.Pipe, .5,
                     side1=self.Condenser2.ports['F1A_Out'],
                     side2=self.Subcooler.ports['F1B_In']
                     )

            # CW Connections Evaporator2
            self.evap2_Inlet_Vol = self.add('Evap2_Inlet_Vol', FF.Volume, CW_Evap, .1, 0, T_Evap_ini)

            # self.bp_evap2=self.add('Evap2_Bypass',FF.ThreeWayValve,5,
            #     A=self.Evaporator2.ports['F2_Out'],
            #     B=c['In_Evaporator2'],
            #     C=self.evap2_Inlet_Vol)

            self.bp_evap2 = self.add('Evap2_Bypass', FF.ThreeWayValve_Regulated, CW_Evap, 3, .1, T_Evap_ini, 1,
                                     A=c['In_Evaporator2'],
                                     B=self.Evaporator2.ports['F2_Out'],
                                     C=self.evap2_Inlet_Vol)

            # 'Grundfos_Magma3_50-60'
            c_pump = {'Pump_Type': c['Pump_Evap2'], 'Set_Speed': c['Pump_Evap2_Speed'], 'kP': 0.0003}
            # c_pump={'Pump_Type':'Grundfos NBE_65_125-127', 'Set_Speed':.66, 'kP': 0.001}
            self.LCW_Evap2_in = self.add('Pump_CW_In_Evap2', LF_Pump_with_Map.Pump_with_Map, c['Fix_Pump_Flow'],
                                         inlet=self.evap2_Inlet_Vol,  # c['In_Evaporator2'],#self.evap2_Inlet_Vol,
                                         outlet=self.Evaporator2.ports['F2_In'],
                                         **c_pump)

            self.add('pipe_evap2_Out', FF.Pipe_Check, 1,
                     inlet=self.Evaporator2.ports['F2_Out'],
                     outlet=c['Out_Evaporator2'])

            # CW Connections Condenser2
            # 'Grundfos_Magma3_50-60'
            c_pump = {'Pump_Type': c['Pump_Cond2'], 'Set_Speed': c['Pump_Cond2_Speed'], 'kP': 0.0003}
            self.LCW_Cond2_out = self.add('Pump_CW_Out_Cond2', LF_Pump_with_Map.Pump_with_Map, c['Fix_Pump_Flow'],
                                          inlet=self.Condenser2.ports['F2_Out'],
                                          outlet=c['Out_Condenser2'],
                                          **c_pump)

            self.add('pipe_cond2_In', FF.Pipe, 1,
                     side1=c['In_Condenser2'],
                     side2=self.Condenser2.ports['F2_In'])

        # Subcooler CW Circuit
        # 'Grundfos Magma3_32-120'
        c_pump = {'Pump_Type': c['Pump_Sub'], 'Set_Speed': c['Pump_Sub_Speed'], 'kP': 0.0001}

        self.LCW_Sub_in = self.add('Pump_CW_In_Sub', LF_Pump_with_Map.Pump_with_Map, c['Fix_Pump_Flow'],
                                   inlet=c['In_Subcooler'],
                                   outlet=self.Subcooler.ports['F2_In'],
                                   **c_pump)

        self.add('pipe_Sub_Out', FF.Pipe, .2,
                 side1=c['Out_Subcooler'],
                 side2=self.Subcooler.ports['F2_Out'])

    def output_(self, sys_dict):
        sys_dict[self.gp('Power_Usage')] = (
                sys_dict[self.Compressor1.gp('P_ewma')]
                #+ sys_dict[self.LCW_Evap1_in.gp('P_ewma')]
                #+ sys_dict[self.LCW_Cond1_out.gp('P_ewma')]
                #+ sys_dict[self.LCW_Sub_in.gp('P_ewma')]
        )

        sys_dict[self.gp('Energy_Usage')] = (
                sys_dict[self.Compressor1.gp('Energy')]
                #+ sys_dict[self.LCW_Evap1_in.gp('Energy')]

                #+ sys_dict[self.LCW_Cond1_out.gp('Energy')]

                #+ sys_dict[self.LCW_Sub_in.gp('Energy')]
        )

        sys_dict[self.path + '.Q_Subcool_1A'] = (sys_dict[self.Subcooler.ports['F1A_Out'].gp('h')] - sys_dict[
            self.Condenser1.ports['F1A_Out'].gp('h')]) * sys_dict[self.gp('pipe1.m_dot')] / 1000

        sys_dict[self.gp('Power_Cooling')] = -sys_dict[self.Evaporator1.gp('Q_ewma')]
        sys_dict[self.gp('Power_Heating')] = sys_dict[self.Condenser1.gp('Q_ewma')] + sys_dict[self.Condenser2.gp('Q_ewma')] +sys_dict[self.Subcooler.gp('Q_ewma')]

        sys_dict[self.path + '.Q_Subcool_2'] = (sys_dict[self.Subcooler.ports['F2_Out'].gp('h')] - sys_dict[
            self.LCW_Sub_in.inlet.gp('h')]) * sys_dict[self.gp('pipe_Sub_Out.m_dot')] / 1000

        if self.dual_circuit:
            sys_dict[self.gp('Power_Usage')] += (
                    sys_dict[self.Compressor2.gp('P_ewma')]
                    + sys_dict[self.LCW_Evap2_in.gp('P_ewma')]
                    + sys_dict[self.LCW_Cond2_out.gp('P_ewma')]
            )

            sys_dict[self.gp('Energy_Usage')] += (
                    sys_dict[self.Compressor2.gp('Energy')]
                    + sys_dict[self.LCW_Evap2_in.gp('Energy')]
                    + sys_dict[self.LCW_Cond2_out.gp('Energy')]
                    )

            sys_dict[self.path + '.Q_Subcool_1B'] = (sys_dict[self.Subcooler.ports['F1B_Out'].gp('h')] - sys_dict[
                self.Condenser2.ports['F1A_Out'].gp('h')]) * sys_dict[self.gp('pipe2.m_dot')] / 1000

            sys_dict[self.gp('Power_Cooling')] += -sys_dict[self.Evaporator2.gp('Q_ewma')]
            sys_dict[self.gp('Power_Heating')] += sys_dict[self.Condenser2.gp('Q_ewma')]

        sys_dict[self.gp('COP')] = sys_dict[self.gp('Power_Heating')] / (
                    sys_dict[self.gp('Power_Usage')] + (sys_dict[self.gp('Power_Usage')] == 0)) * (
                                               sys_dict[self.gp('Power_Usage')] != 0)
        sys_dict[self.gp('COP_Heating')] = sys_dict[self.gp('Power_Heating')] / (
                sys_dict[self.gp('Power_Usage')] + (sys_dict[self.gp('Power_Usage')] == 0)) * (
                                                   sys_dict[self.gp('Power_Usage')] != 0)

        sys_dict[self.gp('Power_Evaporator1')] = sys_dict[self.Evaporator1.gp('Q_ewma')]
        sys_dict[self.gp('Power_Condenser1')] = sys_dict[self.Condenser1.gp('Q_ewma')]
        sys_dict[self.gp('Power_Subcooler1')] = sys_dict[self.Subcooler.gp('Q_A_ewma')]

        sys_dict[self.gp('COP_Heat_1')] = (sys_dict[self.Condenser1.gp('Q_A_ewma')] + sys_dict[
            self.Subcooler.gp('Q_A_ewma')]) / (
                                                  sys_dict[self.Compressor1.gp('P_ewma')] + 1) * (
                                                  sys_dict[self.Compressor1.gp('state')] > 0)

        sys_dict[self.gp('COP_Cool_1')] = (sys_dict[self.Evaporator1.gp('Q_A_ewma')]) / (
                sys_dict[self.Compressor1.gp('P_ewma')] + 1) * (sys_dict[self.Compressor1.gp('state')] > 0)

        sys_dict[self.gp('Power_Subcooler')] = sys_dict[self.Subcooler.gp('Q_ewma')]

        if self.dual_circuit:
            sys_dict[self.gp('Power_Evaporator2')] = sys_dict[self.Evaporator2.gp('Q_ewma')]
            sys_dict[self.gp('Power_Condenser2')] = sys_dict[self.Condenser2.gp('Q_ewma')]
            sys_dict[self.gp('Power_Subcooler2')] = sys_dict[self.Subcooler.gp('Q_B_ewma')]

            sys_dict[self.gp('COP_Heat_2')] = (sys_dict[self.Condenser2.gp('Q_A_ewma')] + sys_dict[
                self.Subcooler.gp('Q_B_ewma')]) / (
                                                  sys_dict[self.Compressor2.gp('P_ewma')] + 1) * (
                                                      sys_dict[self.Compressor2.gp('state')] > 0)

            sys_dict[self.gp('COP_Cool_2')] = (sys_dict[self.Evaporator2.gp('Q_A_ewma')]) / (
                    sys_dict[self.Compressor2.gp('P_ewma')] + 1) * (sys_dict[self.Compressor2.gp('state')] > 0)

    def print_output(self, t, sys_dict):

        print('COP: ' + str(sys_dict[self.gp('COP')]))
        print('Power Usage: ' + str(sys_dict[self.gp('Power_Usage')]) + ' kW')
        print('Power Cooling: ' + str(sys_dict[self.gp('Power_Cooling')]) + ' kW')
        print('Power Heating: ' + str(sys_dict[self.gp('Power_Heating')]) + ' kW')
        print('')


