import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
#import Liquid
import sim_components.machines.SCC as SCC
import sim_components.machines.EMHW as EMHW
import sim_components.machines.EMA as EMA
import sim_components.machines.EMB as EMB
#import sim_tool_EM.RefpropFluid as Fluid
import sim_components.thermodynamics.ST as ST


#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class EM_System(BC.Subsystem):
    def construct_Subsystem(self, **inputs):

        CW=inputs['CW']


        #SCC
        SCC_conf = {'CW': CW, 'L_Pipe': 1, 'D_Pipe': 0.05}  # SCC
        self.SCC=self.add('SCC', SCC.SCC, **SCC_conf)
        
        #VV ST
        VV_ST_Conf={'V_CW': 9,'h': 10000,'N_nodes': 3,'L_Pipe':1,'D_Pipe':0.07}
        self.VV_ST=self.add('VV_ST', ST.ST, 60, **VV_ST_Conf)

        EMHW_conf ={'Config': inputs['Conf_EMHW']}
        EMHW_conf.update({'F1': CW, 'F2': CW, 'T_F1': 15, 'T_F2': 30, 'q': 0, 'kpipe': 10, 'L_Pipe': 1,
             'D_Pipe': 0.05, 'Pump_Step1_Speed': 0, 'Pump_Step2_Speed': 0, 'Pump_Step3_Speed': 0,
             'Hot_Water_Return': inputs['Hot_Water_Return'],
             'Step1_Prim_Out': self.SCC.ports['In_ST3_Sec'],
             'Step2_Prim_Out': self.SCC.ports['In_ST1_Sec'],
             'Step3_Prim_In': self.VV_ST.ports['CW_Out_2']}) # EMHW

        # EMHW
        self.EMHW = self.add('EMHW', EMHW.EMHW, **EMHW_conf)

        #####VS Connections/Volumes
        CW_Evap=CW_Cond=CW_Sub=CW
        T_Evap_ini, T_Cond_ini, T_Sub_ini =20, 20, 20#oC


        self.VoCW_Cond2_EMB_out=self.add('VoCW_Cond2_EMB_out',FF.Volume,CW_Cond,0.1, T0 = 40)
        self.VoCW_Cond1_EMB_in=self.add('VoCW_Cond1_EMB_in',FF.Volume,CW_Cond,0.1)
        self.VoCW_Cond1_EMB_out=self.add('VoCW_Cond1_EMB_out',FF.Volume,CW_Cond,0.1, T0 = 40)

        self.VoCW_EMB_In_Sub=self.add('VoCW_EMB_In_Sub',FF.Volume,CW_Cond,0.1)
        self.VoCW_EMB_Out_Sub=self.add('VoCW_EMB_Out_Sub',FF.Volume,CW_Cond,0.1, T0 = 40)

        self.VoCW_HS_In = self.add('VoCW_HS_In', FF.Volume, CW_Cond, 1)
        self.VoCW_HS_Out = self.add('VoCW_HS_Out', FF.Volume, CW_Cond, 10, T0 = 40)
        #self.ReCW_Evap=self.add('CW_Out_Evap',FF.Reservoir,CW_Evap,T_Evap_ini)


        kV=5

        EMA_VoCW = [self.VoCW_EMB_Out_Sub]

        self.EMAs=[]
        for i in range(1,inputs['N_EMA']+1):
            if i > 1:
                EMA_VoCW += [self.add('VoCW_Cond_EMA'+str(i), FF.Volume, CW_Cond, 0.1)]
            else:
                EMA_VoCW += [self.add('VoCW_Cond_EMA', FF.Volume, CW_Cond, 0.1)]
            if i>1:
                self.add('Pipe_EMA_'+str(i), FF.Pipe_Check, kV,
                     inlet=EMA_VoCW[i-1],
                     outlet=EMA_VoCW[i])
            #Create EMA
            EMA_conf= {'Config': inputs['Conf_EMA']}
            EMA_conf.update({
                'Compressor_states': [0, 0, 0, 0],
                'Pump_Evap_Speed': 1,
                'Pump_Cond_Speed': 1,
                'Pump_Sub_Speed': 1,
                '3W_Subcooler_Bypass': 0,
                'In_Evaporator': inputs['Chilled_Water_Inlet'],
                'Out_Evaporator': inputs['Chilled_Water_Outlet'],
                'In_Condenser': EMA_VoCW[i-1],
                'Out_Condenser': EMA_VoCW[i],
                'In_Subcooler': self.SCC.ports['Out_ST3_Prim'],
                'Out_Subcooler': self.SCC.ports['In_ST1_Prim']
            })
            if i>1:
                EMA_name = 'EMA'+str(i)
            else:
                EMA_name = 'EMA'

            self.EMAs +=[self.add(EMA_name, EMA.EMA, CW_Evap, CW_Cond, CW_Sub, T_Evap_ini, T_Cond_ini, T_Sub_ini, **EMA_conf)]

        ### VS Return
        self.add('Pipe_ReCW_Sub_in', FF.Pipe, kV,
                 side1=self.VoCW_HS_In,
                 side2=self.VoCW_EMB_In_Sub)

        self.add('Pipe_EMB_sub_in_out', FF.Pipe, kV,
                 side1=self.VoCW_EMB_In_Sub,
                 side2=self.VoCW_EMB_Out_Sub)

        ### VS Flow
        self.add('Pipe_EMB_cond2_in_out', FF.Pipe, kV,
                 side1=EMA_VoCW[-1],
                 side2=self.VoCW_Cond2_EMB_out)

        self.add('Pipe_EMB_cond1_cond2', FF.Pipe, kV,
                 side1=self.VoCW_Cond2_EMB_out,
                 side2=self.VoCW_Cond1_EMB_in)

        self.add('Pipe_EMB_cond1_in_out', FF.Pipe, kV,
                 side1=self.VoCW_Cond1_EMB_in,
                 side2=self.VoCW_Cond1_EMB_out)

        self.add('Pipe_Cond1_EMB_out_HS_Out', FF.Pipe, kV,
                 side1=self.VoCW_Cond1_EMB_out,
                 side2=self.VoCW_HS_Out)

        self.add('Pipe_HS_In_HS_Out', FF.Pipe, kV,
                 side1=self.VoCW_HS_In,
                 side2=self.VoCW_HS_Out)

        self.Pipe_HS_In = self.add('Pipe_HS_In', FF.Pipe_Fixed_Massflow, m_dot=10,
                                   side1=inputs['Heating_System_Inlet'], side2=self.VoCW_HS_In)

        self.Pipe_HS_Out = self.add('Pipe_HS_Out', FF.Pipe_Fixed_Massflow, m_dot=10,
                                    side1=self.VoCW_HS_Out, side2=inputs['Heating_System_Outlet'])
        
        #EMB

        
        # T_Evap_ini, T_Cond_ini, T_Sub_ini =30 +273.15, 30 +273.15, 30 +273.15#oC
        EMB_conf = {'Config': inputs['Conf_EMB']}
        EMB_conf.update({
            'Fix_Pump_Flow': False,
            'Compressor_states': [0, 0],
            'Pump_Evap1_Speed': 1,
            'Pump_Cond1_Speed': 1,
            'Pump_Evap2_Speed': 1,
            'Pump_Cond2_Speed': 1,
            'Pump_Sub_Speed': 1,
            '3W_Space_Hot': 0,
            'In_Evaporator1': self.SCC.ports['Out_ST2_Sec'],
            'Out_Evaporator1': self.SCC.ports['In_ST2_Sec'],
            'In_Condenser1_1': self.VV_ST.ports['CW_Out_1'],
            'Out_Condenser1_1': self.VoCW_Cond1_EMB_out,
            'In_Condenser1_2': self.VoCW_Cond1_EMB_in,
            'Out_Condenser1_2': self.VV_ST.ports['CW_In_1'],
            'In_Evaporator2': self.SCC.ports['Out_ST3_Sec'],
            'Out_Evaporator2': self.SCC.ports['In_ST3_Sec'],
            'In_Condenser2': EMA_VoCW[-1],
            'Out_Condenser2': self.VoCW_Cond2_EMB_out,
            'In_Subcooler': self.VoCW_EMB_In_Sub,
            'Out_Subcooler': self.VoCW_EMB_Out_Sub
        })
        
        self.EMB=self.add('EMB', EMB.EMB, CW_Evap, CW_Cond, CW_Sub, T_Evap_ini, T_Cond_ini, T_Sub_ini, **EMB_conf)

        #Connections SCC - EMHW
        
        self.Pipe_2 = self.add('Pipe_2',FF.Pipe,kV=1,side1=self.SCC.ports['Out_ST1_Sec'],side2=self.EMHW.ports['Step2_Prim_In'])

        #self.Pipe_3 = self.add('Pipe_3',FF.Pipe_Dim,CW,L=c['L_Pipe'], D=c['D_Pipe'],side1=self.SCC.ports['In_ST1_Sec'],side2=self.EMHW.ports['Step2_Prim_Out'])
        
        self.Pipe_4 = self.add('Pipe_4',FF.Pipe,kV=1,side1=self.SCC.ports['Out_ST3_Sec'],side2=self.EMHW.ports['Step1_Prim_In'])

        #self.Pipe_5 = self.add('Pipe_5',FF.Pipe_Dim,CW,L=c['L_Pipe'], D=c['D_Pipe'],side1=self.SCC.ports['In_ST3_Sec'],side2=self.EMHW.ports['Step1_Prim_Out'])
        
        #Connections EMHW Prim
        
        #self.Pipe_6 = self.add('Pipe_6',FF.Pipe_Dim,CW,L=c['L_Pipe'], D=c['D_Pipe'],side1=self.EMHW.ports['Step3_Prim_In'],side2=self.VV_ST.ports['CW_Out_2'])
        
        
        self.Pipe_7 = self.add('Pipe_7',FF.Pipe,kV=3,side1=self.EMHW.ports['Step3_Prim_Out'],side2=self.VV_ST.ports['CW_In_2'])
        
        #Connection EMHW Sec
        #self.Drain_5 = self.add('Drain_5',FF.Reservoir,CW,inputs['Hot_Water_Outlet'])
        self.Pipe_8 = self.add('Pipe_8',FF.Pipe,kV=.5,side1=self.EMHW.ports['Step3_Sec_Out'],side2=inputs['Hot_Water_Outlet'])

        #self.Pipe_8 = self.add('Pipe_8',FF.Pipe_Fixed_Massflow,m_dot=.01,side1=self.EMHW.ports['Step3_Sec_Out'],side2=self.Drain_5)

        #self.Water_Source_Sec = self.add('Water_Source_Sec',FF.Reservoir,CW,inputs['Hot_Water_Inlet'],T0=10+273.15)
        self.Cold_Water_Pipe = self.add('Cold_Water_Pipe',FF.Pipe_Fixed_Massflow,m_dot=0,side1=inputs['Cold_Water_Inlet'],side2=self.EMHW.ports['Step1_Sec_In'])
        
        ## Återv ICA
        #self.ICA_Res_In = self.add('ICA_Res_In',FF.Reservoir,c['CW'])
        #self.ICA_Inlet_Pipe = self.add('ICA_Pipe', FF.Pipe_Fixed_Massflow, m_dot=0,
        #                               side1=self.ICA_Res_In, side2=self.SCC.ports['In_ST1_Prim'])
        #self.ICA_Return_Pipe = self.add('ICA_Return_Pipe',FF.Pipe_Fixed_Massflow, m_dot=0,side1=self.SCC.ports['Out_ST3_Prim'],side2=self.ICA_Res_In)
        #self.ICA = self.add('ICA_EM', FF.EnergyMeter, inlet=self.SCC.ports['Out_ST3_Prim'], outlet=self.ICA_Res_In, pipe=self.ICA_Inlet_Pipe)
        #self.HW_Initial_EM = self.add('HW_Initial_EM', FF.EnergyMeter, inlet=inputs['Cold_Water_Inlet'], outlet=self.EMHW.HX2.ports['F2_Out'], pipe=self.Cold_Water_Pipe)
        #self.HS_EM = self.add('HS_EM', FF.EnergyMeter, inlet=inputs['Heating_System_Inlet'], outlet=self.VoCW_HS_Out, pipe=self.Pipe_HS_In)
        
        
    def output_(self, sys_dict):
        import numpy as np
        sys_dict[self.gp('EMA_Comp_Power')]=np.sum([sys_dict[EMA.gp('Power_Usage')] for EMA in self.EMAs])
        sys_dict[self.gp('EMB_Comp_Power')]=sys_dict[self.EMB.gp('Power_Usage')]
        
        sys_dict[self.gp('T_ST1_top')]=sys_dict[self.SCC.gp('T_ST1_top')]
        sys_dict[self.gp('T_ST1_mid')]=sys_dict[self.SCC.gp('T_ST1_mid')]
        sys_dict[self.gp('T_ST1_bot')]=sys_dict[self.SCC.gp('T_ST1_bot')]
        
        sys_dict[self.gp('T_ST2_top')]=sys_dict[self.SCC.gp('T_ST2_top')]
        sys_dict[self.gp('T_ST2_mid')]=sys_dict[self.SCC.gp('T_ST2_mid')]
        sys_dict[self.gp('T_ST2_bot')]=sys_dict[self.SCC.gp('T_ST2_bot')]
        
        sys_dict[self.gp('T_ST3_top')]=sys_dict[self.SCC.gp('T_ST3_top')]
        sys_dict[self.gp('T_ST3_mid')]=sys_dict[self.SCC.gp('T_ST3_mid')]
        sys_dict[self.gp('T_ST3_bot')]=sys_dict[self.SCC.gp('T_ST3_bot')]
        
        # sys_dict[self.gp('EMHW_Step_1_Prim_T_In')]=sys_dict[self.EMHW.gp('T_In_Prim_Step_1')]-273.15
        sys_dict[self.gp('EMHW_Step_1_Prim_T_Out')]=sys_dict[self.EMHW.gp('T_Out_Prim_Step_1')]

        # sys_dict[self.gp('EMHW_Step_2_Prim_T_In')]=sys_dict[self.EMHW.gp('T_In_Prim_Step_2')]-273.15
        sys_dict[self.gp('EMHW_Step_2_Prim_T_Out')]=sys_dict[self.EMHW.gp('T_Out_Prim_Step_2')]
        
        
        sys_dict[self.gp('EMHW_Step_3_Prim_T_Out')]=sys_dict[self.EMHW.gp('T_Out_Prim_Step_3')]

        # 'Space Heating Power':
        sys_dict[self.gp('Space_Heating_Power')] = sys_dict[self.EMA.gp('Power_Condenser')] + sys_dict[
            self.EMB.gp('Power_Heating')]

        if hasattr(self,'EMA2'):
            sys_dict[self.gp('Heating_Power')] = sys_dict[self.EMA.gp('Power_Heating')] + sys_dict[self.EMA2.gp('Power_Heating')] + sys_dict[
                self.EMB.gp('Power_Heating')]
        else:
            sys_dict[self.gp('Heating_Power')] = sys_dict[self.EMA.gp('Power_Heating')] + sys_dict[
                                                     self.EMB.gp('Power_Heating')]

        # 'Cooling Power':
        sys_dict[self.gp('Cooling_Power')] = -np.sum([sys_dict[EMA.gp('Power_Evaporator')] for EMA in self.EMAs])
        # 'Power Consumption':
        sys_dict[self.gp('Power_Consumption')] = np.sum([sys_dict[EMA.gp('Power_Usage')] for EMA in self.EMAs]) + sys_dict[
            self.EMB.gp('Power_Usage')]

        sys_dict[self.gp('Energy_Consumption')] = np.sum([sys_dict[EMA.gp('Energy_Usage')] for EMA in self.EMAs]) + sys_dict[
            self.EMB.gp('Energy_Usage')]

        #'Total COP':
        sys_dict[self.gp('Total_COP')] = (sys_dict[self.gp('Space_Heating_Power')] + sys_dict[self.gp('Cooling_Power')])/sys_dict[self.gp('Power_Consumption')]
        #'Space Heating COP':
        #sys_dict[self.gp('Space_Heating_COP')] = (sys_dict[self.HS_EM.gp('P_ewma')])/sys_dict[self.gp('Power_Consumption')]

        
        
        
    
    def print_output(self,t, sys_dict):
        pass
        #self.Rosendal.print_output(t, sys_dict)

