# EMA
import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF, \
    sim_components.thermodynamics.LF_Pump_with_Map_P as LF_Pump_with_Map
import sim_components.thermodynamics.Heat_Exchanger_Nodes_Mean_p as MHX


# from String_Dual_Heat_Exchanger import String_Dual_Heat_Exchanger

class EMA(BC.Subsystem):
    def construct_Subsystem(self, CW_Evap, CW_Cond, CW_Sub, T_Evap_ini, T_Cond_ini, T_Sub_ini, **c):
        self.dual_circuit = c['Dual_Circuit']
        # Evaporator
        q_RF_Evap_ini = 0.9
        # T_Evap_ini = T_Cond_ini = T_Sub_ini = 40

        RF = self.add(c['Refrigerant'], FF.Fluid_Props, Config=c['Refrigerant'] + '_333_6_No_NaN')
        self.RF = RF

        if c['Dual_Circuit']:
            dual_str='dual'
        else:
            dual_str = 'single'

        self.Evaporator = self.add('Evaporator', MHX.Heat_Exchanger, 8, c['Plates_Evap'], RF, CW_Evap, T_Evap_ini,
                                   T_Evap_ini, q_RF_Evap_ini, Config=c['Conf_Evap'], dual=dual_str)

        q = 0.05
        # Condenser
        q_RF_Cond_ini = q
        self.Condenser = self.add('Condenser', MHX.Heat_Exchanger, 8, c['Plates_Cond'], RF, CW_Cond, T_Cond_ini,
                                  T_Cond_ini, q_RF_Cond_ini, Config=c['Conf_Cond'], dual=dual_str)

        if c['Subcooler']:
            q_RF_Sub_ini = q
            self.Subcooler = self.add('Subcooler', MHX.Heat_Exchanger, 8, c['Plates_Sub'], RF, CW_Sub, T_Sub_ini, T_Sub_ini,
                                      q_RF_Cond_ini, Config=c['Conf_Sub'], dual=dual_str)

        # Circuit 1


        self.Compressor1 = self.add('Compressor1', FF.Dual_Compressor, RF, c['Compressors_Circuit'], c['Compressor_states'][0],
                                    c['Compressor_states'][1], Config=c['Conf_Compressor'],

                                    inlet=self.Evaporator.ports['F1A_Out'],
                                    outlet=self.Condenser.ports['F1A_In'],
                                    nozzle=self.var_nozzle1
                                    )
        # self.add('pipe1',FF.Pipe_Liquid_Only,RF,1,

        if c['Subcooler']:
            self.add('pipe1', FF.Pipe, .5,
                     side1=self.Condenser.ports['F1A_Out'],
                     side2=self.Subcooler.ports['F1A_In']
                     )
            self.var_nozzle1 = self.add('VarNozzle1', FF.Var_Nozzle,
                                        side1=self.Subcooler.ports['F1A_Out'],
                                        side2=self.Evaporator.ports['F1A_In']
                                        )

        else:
            self.var_nozzle1 = self.add('VarNozzle1', FF.Var_Nozzle,
                                        side1=self.Condenser.ports['F1A_Out'],
                                        side2=self.Evaporator.ports['F1A_In']
                                        )

        if c['Dual_Circuit']:
            # #Circuit 2


            self.Compressor2 = self.add('Compressor2', FF.Dual_Compressor, RF, c['Compressors_Circuit'],c['Compressor_states'][2],
                                        c['Compressor_states'][3], Config=c['Conf_Compressor'],

                                        inlet=self.Evaporator.ports['F1B_Out'],
                                        outlet=self.Condenser.ports['F1B_In'],
                                        nozzle=self.var_nozzle2)
            # self.add('pipe2',FF.Pipe_Liquid_Only,RF,1,
            if c['Subcooler']:
                self.var_nozzle2 = self.add('VarNozzle2', FF.Var_Nozzle,
                                            side1=self.Subcooler.ports['F1B_Out'],
                                            side2=self.Evaporator.ports['F1B_In']
                                            )

                self.add('pipe2', FF.Pipe, .5,
                         side1=self.Condenser.ports['F1B_Out'],
                         side2=self.Subcooler.ports['F1B_In']
                         )
            else:
                self.var_nozzle2 = self.add('VarNozzle2', FF.Var_Nozzle,
                                            side1=self.Condenser.ports['F1B_Out'],
                                            side2=self.Evaporator.ports['F1B_In']
                                            )

        # kV=1
        kV_Sub = .2

        self.add('pipe_evap_out', FF.Pipe, kV=3.3,
                 side1=c['Out_Evaporator'],
                 side2=self.Evaporator.ports['F2_Out'])

        self.add('pipe_cond_out', FF.Pipe, kV=8,
                 side1=c['Out_Condenser'],
                 side2=self.Condenser.ports['F2_Out'])

        Pre_Cond = self.add('Pre_Cond', FF.Volume, CW_Sub, .1, 0, T_Sub_ini)

        if c['Subcooler']:
            self.pipe_in = self.add('pipe_sub_in', FF.Pipe, kV_Sub,
                                    side1=c['In_Subcooler'],
                                    side2=self.Subcooler.ports['F2_In'])

            self.Sub_middle = self.add('Sub_middle', FF.Volume, CW_Sub, .1, 0, T_Sub_ini)


            self.bp_sub = self.add('Subcool_Bypass', FF.ThreeWayValve_Regulated, CW_Sub, kV_Sub, 0.1, T_Sub_ini,
                                   c['3W_Subcooler_Bypass'],
                                   A=self.Condenser.ports['F2_Out'],
                                   B=self.Subcooler.ports['F2_Out'],
                                   C=self.Sub_middle)

            self.add('pipe_Sub_Out_Pre_Cond', FF.Pipe_Check, kV=kV_Sub,
                     inlet=self.Subcooler.ports['F2_Out'],
                     outlet=Pre_Cond)

            # 'Grundfos_Magma3_125-100'
            c_pump = {'Pump_Type': c['Pump_Sub'], 'Set_Speed': c['Pump_Sub_Speed'], 'kP': 0.0001}
            self.LCW_Sub_in = self.add('Pump_CW_In_Sub', LF_Pump_with_Map.Pump_with_Map,
                                       inlet=self.Sub_middle, simple=False,
                                       outlet=c['Out_Subcooler'],
                                       **c_pump)

        self.add('pipe_cond_in', FF.Pipe, kV=8,
                 side1=c['In_Condenser'],
                 side2=Pre_Cond)

        simple_on = False
        # 'Grundfos NBE_65_125-127'
        c_pump = {'Pump_Type': c['Pump_Evap'], 'Set_Speed': c['Pump_Evap_Speed'], 'kP': 0.0001}
        # c_pump = {'Pump_Type': c['Pump_Evap'], 'Set_Speed': 30, 'kP': 0.0001}

        self.LCW_Evap_in = self.add('Pump_CW_In_Evap', LF_Pump_with_Map.Pump_with_Map,
                                    inlet=c['In_Evaporator'],
                                    outlet=self.Evaporator.ports['F2_In'], simple=simple_on,
                                    **c_pump)

        # 'Grundfos NBE_65_125-127'
        c_pump = {'Pump_Type': c['Pump_Cond'], 'Set_Speed': c['Pump_Cond_Speed'], 'kP': 0.0001}
        # c_pump = {'Pump_Type': c['Pump_Cond'], 'Set_Speed': 26, 'kP': 0.0001}

        self.LCW_Cond_in = self.add('Pump_CW_In_Cond', LF_Pump_with_Map.Pump_with_Map,
                                    inlet=Pre_Cond,
                                    outlet=self.Condenser.ports['F2_In'], simple=simple_on,
                                    **c_pump)



        self.Variables = [
            {'name': 'COP_ewma', 'unit': '', 'type': 'calc', 'val': 0}, ]

    def output_(self, sys_dict):
        sys_dict[self.gp('Power_Usage')] = (
                sys_dict[self.Compressor1.gp('P_ewma')]

                + sys_dict[self.LCW_Evap_in.gp('P_ewma')]
                + sys_dict[self.LCW_Cond_in.gp('P_ewma')]
                + sys_dict[self.LCW_Sub_in.gp('P_ewma')]
        )

        sys_dict[self.gp('Energy_Usage')] = (
                sys_dict[self.Compressor1.gp('Energy')]

                + sys_dict[self.LCW_Evap_in.gp('Energy')]
                + sys_dict[self.LCW_Cond_in.gp('Energy')]
                + sys_dict[self.LCW_Sub_in.gp('Energy')]
        )

        if self.dual_circuit:
            sys_dict[self.gp('Power_Usage')] += (

                sys_dict[self.Compressor2.gp('P_ewma')]
            )

            sys_dict[self.gp('Energy_Usage')] += (
                sys_dict[self.Compressor2.gp('Energy')]
            )

        sys_dict[self.gp('Power_Cooling')] = sys_dict[self.Evaporator.gp('Q_ewma')]
        sys_dict[self.gp('Power_Heating')] = (
                    sys_dict[self.Condenser.gp('Q_ewma')] + sys_dict[self.Subcooler.gp('Q_ewma')])
        sys_dict[self.gp('Power_Evaporator')] = (sys_dict[self.Evaporator.gp('Q_ewma')])
        sys_dict[self.gp('Power_Condenser')] = (sys_dict[self.Condenser.gp('Q_ewma')])
        sys_dict[self.gp('Power_Subcooler')] = (sys_dict[self.Subcooler.gp('Q_ewma')])
        sys_dict[self.gp('RF_flow')] = sys_dict[self.Compressor1.gp('m_dot')]
        sys_dict[self.gp('Cond_Temp')] = sys_dict[self.Compressor1.gp('T_Cond')]
        sys_dict[self.gp('Evap_Temp')] = sys_dict[self.Compressor1.gp('T_Evap')]
        sys_dict[self.gp('Sub_cool1')] = sys_dict[self.Compressor1.gp('T_Cond')] - sys_dict[
            self.Subcooler.gp('T_F1A_Out')]

        sys_dict[self.gp('COP')] = sys_dict[self.gp('Power_Heating')] / (
                sys_dict[self.gp('Power_Usage')] + (sys_dict[self.gp('Power_Usage')] == 0)) * (
                                           sys_dict[self.gp('Power_Usage')] != 0)
        sys_dict[self.gp('COP_Cool')] = sys_dict[self.gp('Power_Cooling')] / (
                sys_dict[self.gp('Power_Usage')] + (sys_dict[self.gp('Power_Usage')] == 0)) * (
                                                sys_dict[self.gp('Power_Usage')] != 0)

        sys_dict[self.gp('COP_Heat')] = (sys_dict[self.gp('Power_Condenser')] + sys_dict[
            self.gp('Power_Subcooler')]) / (
                                                sys_dict[self.gp('Power_Usage')] + (
                                                sys_dict[self.gp('Power_Usage')] == 0)) * (
                                                sys_dict[self.gp('Power_Usage')] != 0)

        sys_dict[self.gp('COP_Cool_1')] = sys_dict[self.Evaporator.gp('Q_A_ewma')] / (
                sys_dict[self.Compressor1.gp('P_ewma')] + 1)

        sys_dict[self.gp('COP_Heat_1')] = (sys_dict[self.Condenser.gp('Q_A_ewma')] + sys_dict[
            self.Subcooler.gp('Q_A_ewma')]) / (
                                                  sys_dict[self.Compressor1.gp('P_ewma')] + 1)

        # sys_dict[self.gp('COP')]=(sys_dict[self.Condenser.gp('Q')]+sys_dict[self.Subcooler.gp('Q')])/(sys_dict[self.Compressor1.gp('Power')]+sys_dict[self.Compressor2.gp('Power')])
        sys_dict[self.gp('COP_ewma')] = (sys_dict[self.Condenser.gp('Q_ewma')] + sys_dict[
            self.Subcooler.gp('Q_ewma')]) / sys_dict[self.gp('Power_Usage')]

        if self.dual_circuit:
            sys_dict[self.gp('RF_flow')] += sys_dict[self.Compressor2.gp('m_dot')]

            sys_dict[self.gp('Sub_cool2')] = sys_dict[self.Compressor2.gp('T_Cond')] - sys_dict[
                self.Subcooler.gp('T_F1B_Out')]
            sys_dict[self.gp('COP_Cool_2')] = sys_dict[self.Evaporator.gp('Q_B_ewma')] / (
                    sys_dict[self.Compressor2.gp('P_ewma')] + 1)
            sys_dict[self.gp('COP_Heat_2')] = (sys_dict[self.Condenser.gp('Q_B_ewma')] + sys_dict[
                self.Subcooler.gp('Q_B_ewma')]) / (
                                                      sys_dict[self.Compressor2.gp('P_ewma')] + 1)



    def print_output(self, t, sys_dict):
        print('COP: ' + str(sys_dict[self.gp('COP')]))
        print('Power Usage: ' + str(sys_dict[self.gp('Power_Usage')]) + ' kW')
        print('Power Cooling: ' + str(sys_dict[self.gp('Power_Cooling')]) + ' kW')
        print('Power Heating: ' + str(sys_dict[self.gp('Power_Heating')]) + ' kW')
        print('Evaporator Power: {} kW'.format(str(sys_dict[self.gp('Power_Evaporator')])))
        print('Condenser Power: {} kW'.format(str(sys_dict[self.gp('Power_Condenser')])))
        print('Subcooler Power: {} kW'.format(str(sys_dict[self.gp('Power_Subcooler')])))
        print('Condensation Temp: {} oC, Evaporation Temp: {} oC'.format(str(sys_dict[self.gp('Cond_Temp')]),
                                                                         str(sys_dict[self.gp('Evap_Temp')])))
        print('RF Flow: {} kg/hr'.format(str(sys_dict[self.gp('RF_flow')] * 3600)))
        print('')
        print('q evap in: {} '.format(str(sys_dict[self.gp('q_evap_in')])))
        print('q evap out: {} '.format(str(sys_dict[self.gp('q_evap_out')])))
        print('q cond in: {} '.format(str(sys_dict[self.gp('q_cond_in')])))
        print('q cond out: {} '.format(str(sys_dict[self.gp('q_cond_out')])))
        print('q sub in: {} '.format(str(sys_dict[self.gp('q_sub_in')])))
        print('q sub out: {} '.format(str(sys_dict[self.gp('q_sub_out')])))