
import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
import sim_components.thermodynamics.ST as ST


#from String_Dual_Heat_Exchanger import String_Dual_Heat_Exchanger
#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K 

class SCC(BC.Subsystem):
    def construct_Subsystem(self, **c):
        d={'V_CW': 2,'h': 10000,'N_nodes': 3,'L_Pipe':1,'D_Pipe':0.07}
        CW=self.add('Water',FF.Liquid_Props,Config='Water_4')
        T_CW=25
        
        #Storage tank 1
        
        self.ST1=self.add('ST1', ST.ST, 30, **d)
        
        #Storage tank 2
        
        self.ST2=self.add('ST2', ST.ST, 25, **d)
        
        #Storage tank 3
        
        self.ST3=self.add('ST3', ST.ST, 20, **d)
        
        #Prim side
        
        self.addPort('In_ST1_Prim',self.ST1.ports['CW_In_1'])
        
        Pipe_1 = self.add('Pipe_1',FF.Pipe_Dim,CW, L=c['L_Pipe'], D=c['D_Pipe'],side1=self.ST1.ports['CW_Out_1'],side2=self.ST2.ports['CW_In_1'])
        
        Pipe_2 = self.add('Pipe_2',FF.Pipe_Dim,CW, L=c['L_Pipe'], D=c['D_Pipe'],side1=self.ST2.ports['CW_Out_1'],side2=self.ST3.ports['CW_In_1'])
        
        self.addPort('Out_ST3_Prim',self.ST3.ports['CW_Out_1'])
        
        #Sec side
        
        self.addPort('In_ST1_Sec',self.ST1.ports['CW_In_2'])
        self.addPort('Out_ST1_Sec',self.ST1.ports['CW_Out_2'])
        
        self.addPort('In_ST2_Sec',self.ST2.ports['CW_In_2'])
        self.addPort('Out_ST2_Sec',self.ST2.ports['CW_Out_2'])
        
        self.addPort('In_ST3_Sec',self.ST3.ports['CW_In_2'])
        self.addPort('Out_ST3_Sec',self.ST3.ports['CW_Out_2'])
        
        
    def output_(self, sys_dict):
        #Prim
        sys_dict[self.gp('T_ST1_top')]=sys_dict[self.ST1.gp('T_CW_Node_0')]
        sys_dict[self.gp('T_ST1_mid')]=sys_dict[self.ST1.gp('T_CW_Node_1')]
        sys_dict[self.gp('T_ST1_bot')]=sys_dict[self.ST1.gp('T_CW_Node_2')]
        
        sys_dict[self.gp('T_ST2_top')]=sys_dict[self.ST2.gp('T_CW_Node_0')]
        sys_dict[self.gp('T_ST2_mid')]=sys_dict[self.ST2.gp('T_CW_Node_1')]
        sys_dict[self.gp('T_ST2_bot')]=sys_dict[self.ST2.gp('T_CW_Node_2')]
        
        sys_dict[self.gp('T_ST3_top')]=sys_dict[self.ST3.gp('T_CW_Node_0')]
        sys_dict[self.gp('T_ST3_mid')]=sys_dict[self.ST3.gp('T_CW_Node_1')]
        sys_dict[self.gp('T_ST3_bot')]=sys_dict[self.ST3.gp('T_CW_Node_2')]
        
        
        
    def print_output(self, t, sys_dict):
        pass