
import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
import sim_components.thermodynamics.ST_v2 as ST


#from String_Dual_Heat_Exchanger import String_Dual_Heat_Exchanger
#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K 

class SCC(BC.Subsystem):
    def construct_Subsystem(self, CW=None, V=2, N=3, T0=(35,30,25)):
        kV=3
        last_ST=None
        for i in range(N):
            STc = self.add('ST'+str(i+1), ST.ST, CW=CW, T0=T0[i], V=V)

            if i>0:
                self.add('Pipe_'+str(i+1), FF.Pipe, CW=CW, kV=kV, side1=last_ST.Bottom,
                         side2=STc.Top)

            last_ST = STc
