import sim_components.generic.items as B
import sim_components.regulators.Read_TrendExport_File as RTF
import numpy as np

class Data_Regulator(B.Item):        
    def construct_Item(self, filename, tags): 
        data_raw=RTF.import_TrendExport(filename)
        self.tags=tags
        for tag, data_tag in self.tags.items():
            if 'Scale' not in data_tag:
                data_tag['Scale']=1
                
            if 'Offset' not in data_tag:
                data_tag['Offset']=0
                
            self.tags[tag]=data_tag    
        #print(self.tags) 
        self.data={} 
        #{'source': 'Pipe_diff_f', 'line': 72, 'target': 'HX_stub.pipe_F1B_Out.tmp_81_0_1', 'func': 'sign', 'args': ['HX_stub.pipe_F1B_Out.dp']}
        
        self.ops=[]
        
        for tag, data_tag in self.tags.items():
            d=data_raw[data_tag['Tag']]
            t=data_raw['t']
            print(max(t))
            print(min(t))
            #scaled_data=np.concatenate([[len(t), min(t)-1,max(t)-1], np.array(t),np.array(np.array(d)*data_tag['Scale'])+np.array(data_tag['Offset'])])

            op={'path':'abs','source': 'Data_Regulator', 'line': 0, 'target': tag, 'func': 'interp_lin', 'args': [scaled_data,'t']}
            
            self.ops+=[op]

        for tag, d in data_raw.items():
            #print(tag)
            if not tag == 'Time':
                t = data_raw['t']
                # print(t)
                scaled_data = np.concatenate([[len(t), min(t) - 1, max(t) - 1], np.array(t),
                                              np.array(d)])

                #print(self.gp(tag))

                op = {'path': 'abs', 'source': 'Data_Regulator', 'line': 0, 'target': self.gp(tag), 'func': 'interp_lin',
                      'args': [scaled_data, 't']}

                self.ops += [op]

if __name__ == '__main__':
    import Model_Tools_Encoded as MT
    import Simulation_Store_MongoDB
    import Liquid_Flow as LF
    import Liquid
    
    class Test(B.Subsystem):
        def construct_Subsystem(self):
            
            CW_Cond=Liquid.Simple_Liquid('Water',4177,992)
            
            F2_In=self.add('F2_In',LF.Volume,CW_Cond,1,300)
            self.DataRegulator = self.add('Data',Data_Regulator,'TrendExport_26092017_NUS',
                    {'T_set':{'Tag':'KVP1_KB200_GT4A_PV','Offset':273.15}})
            
           
    item_fact=Simulation_Store_MongoDB.Item_Factory('')
    Test_Data_regulator=item_fact.get_Item('test','',Test)
    
        
    
    sys_hist=MT.solve_Model(Test_Data_regulator,1,10,'EMA',False,[],True)