import sim_components.generic.items as BC


class EM_Regulator(BC.Subsystem):
    def construct_Subsystem(self, mode=0, dT_VV_buffer=5, min_VS_set=30, T_emb_comp1_on=25, T_sub_max=100, **conf):

        self.EM = conf['EM']
        self.VV = conf['VV']
        self.VS = conf['VS']
        self.KB = conf['KB']
        self.UK = conf['UK'] if 'UK' in conf else None

        N_Comp_EMB = 1
        step_EMB = 1/ self.EM.N_EMB / N_Comp_EMB if self.EM.N_EMB > 0 else 0


        #make EMB regulators
        for i, EMB in enumerate(self.EM.EMBs):
            if self.EM.KVP_HW_type == 'EMB':
                comp1_offset = (i+1)*step_EMB
                comp2_offset = (i+1)*step_EMB
                comp1_step = step_EMB
                comp2_step = step_EMB

                self.add('EMB_Regulator_'+str(i+1), EMB_regulator, self, EMB, T_emb_comp1_on=T_emb_comp1_on, VS=self.VS, cond1_VS= EMB.cond1_VS)

            else:
                self.add('EMB_Regulator_' + str(i + 1), CO2_regulator, self, EMB)

        #Make EMA regulators
        N_Comp_EMA = 4
        step_VS = N_Comp_EMA / 32
        step_KB = N_Comp_EMA / 2  #comp/degree
        if self.EM.parallel:
            cond_dT = 5
        else:
            cond_dT = 5 / self.EM.N_EMA

        for i, EMA in enumerate(self.EM.EMAs):
            KB_offset = i*step_KB/self.EM.N_EMA
            if i<4:
                offset = step_VS*(i+1)/3+0.001

                self.add('EMA_Regulator_' + str(i + 1), EMA_regulator, EMA, source=self,
                         VS_EMA_num=self.EM.N_EMA if self.EM.parallel else i+1,
                         KB=self.KB, KB_offset=KB_offset, KB_step=step_KB,
                         UK = self, UK_offset=offset, UK_step=step_VS*4, cond_dT=cond_dT)
            else:

                self.add('EMA_Regulator_' + str(i + 1), EMA_regulator, EMA, source=self, KB=self.KB, KB_offset=KB_offset, KB_step=step_KB)




        #Make EMHW regulators

        for i, EMHW in enumerate(self.EM.EMHWs):
            if self.EM.KVP_HW_type == 'EMB':
                self.add('EMHW_Regulator_'+str(i+1), EMHW_regulator,  EMHW, self.EM)
            else:
                self.add('EMHW_Regulator_' + str(i + 1), EMHW_CO2_regulator, EMHW, self.EM)



        self.Variables = [
            {'name': 'switch_HW_on', 'unit': '1', 'type': 'param', 'val': 1},
            {'name': 'T_emb_comp1_on', 'unit': 'C', 'type': 'param', 'val': T_emb_comp1_on},
            #{'name': 'T_emb_comp1_off', 'unit': 'C', 'type': 'param', 'val': 25},
            #{'name': 'T_emb_comp2_on', 'unit': 'C', 'type': 'param', 'val': 25},
            #{'name': 'T_emb_comp2_off', 'unit': 'C', 'type': 'param', 'val': 20},
            {'name': 'kP_VV', 'unit': '1/C', 'type': 'param', 'val': 1},
            {'name': 'kP_VS', 'unit': '1/C', 'type': 'param', 'val': 1},
            {'name': 'kP_emb_comp2_VS', 'unit': '1/C', 'type': 'param', 'val': 1},
            {'name': 'kP_KB', 'unit': '1/C', 'type': 'param', 'val': 1},
            {'name': 'kP_sub', 'unit': '1/C', 'type': 'param', 'val': 0.2},
            {'name': 'kI_sub', 'unit': '1/C', 'type': 'param', 'val': 0.00001 * 10},
            {'name': 'VS_mode', 'unit': '1', 'type': 'param', 'val': 1},
            {'name': 'Sub_int_err', 'unit': 'C*s', 'type': 'state', 'val': 0},
            {'name': 'T_sub_min', 'unit': 'C', 'type': 'param', 'val': 0},
            {'name': 'T_off', 'unit': 'C', 'type': 'param', 'val': 0},#self.EM.N_EMA*1},
            {'name': 'T_scale', 'unit': 'C', 'type': 'param', 'val': 0.1+4*self.EM.N_EMA},
            {'name': 'int_err_VS', 'unit': 'C*s', 'type': 'state', 'val': 0},
            {'name': 'int_err_KB', 'unit': 'C*s', 'type': 'state', 'val': 0},
            {'name': 'VS_ext_err_int', 'unit': 'C*s', 'type': 'state', 'val': 0},
            {'name': 'VS_dump_start', 'unit': 'C*s', 'type': 'state', 'val': 30},
            {'name': 'VS_dump_keep', 'unit': 'C*s', 'type': 'state', 'val': 25},
            {'name': 'kI_VS_Cool', 'unit': 'C*s', 'type': 'state', 'val': 0.00001},
            {'name': 'mode', 'unit': 'C*s', 'type': 'state', 'val': mode},
            {'name': 'N_EMA_heat', 'unit': '1', 'type': 'param', 'val': self.EM.N_EMA},
            {'name': 'unit', 'unit': '1', 'type': 'param', 'val': 1},
            {'name': 'N_EMA_cool', 'unit': '1', 'type': 'param', 'val': self.EM.N_EMA_sec},
            {'name': 'dT_VV_buffer', 'unit': '1', 'type': 'param', 'val': dT_VV_buffer},
            {'name': 'min_VS_set', 'unit': '1', 'type': 'param', 'val': min_VS_set},
            {'name': 'T_condenser_dump_start', 'unit': '1', 'type': 'param', 'val': 35},
            {'name': 'T_sub_max', 'unit': '1', 'type': 'param', 'val': T_sub_max},

            {'name': 'VS_Cool_Err_int', 'unit': '1', 'type': 'state', 'val': 0},

        ]
        self.calc_funcs = [self.regulate]

        if self.EM.has_subcooling:
            if hasattr(self.EM, 'has_scc'):
                if not self.EM.has_scc:
                    self.calc_funcs.append(self.regulate_subcooling_consumer)
                    self.calc_funcs.append(self.regulate_no_subcooling)
                else:
                    self.calc_funcs.append(self.regulate_subcooling)

            else:
                self.calc_funcs.append(self.regulate_subcooling)


        else:
            self.calc_funcs.append(self.regulate_no_subcooling)

        if self.EM.Condenser_Dump:
            self.calc_funcs.append(self.regulate_VS_dump)

        if self.EM.KVP_HW_type == 'EMB' and self.EM.N_EMB>0:
            self.calc_funcs.append(self.regulate_VV_buffer)

    def regulate_subcooling_consumer(self):

        Err_T_Sub = UK.Err
        UK.T_set = max(EM.EMA.Compressor1.T_Cond,EM.EMA.Compressor2.T_Cond,0) - 8


        T_Sub_Set = UK.T_set


    def regulate_subcooling(self):

        Err_T_Sub = (17 - EM.SCC.ST2.Top.T)
        # *(Err_T_VV_buffer - 1 > 0)

        EM.ST1_Top_T = EM.SCC.ST1.Top.T
        EM.ST1_Bottom_T = EM.SCC.ST1.Bottom.T
        EM.ST2_Top_T = EM.SCC.ST2.Top.T
        EM.ST2_Bottom_T = EM.SCC.ST2.Bottom.T
        EM.ST3_Top_T = EM.SCC.ST3.Top.T
        EM.ST3_Bottom_T = EM.SCC.ST3.Bottom.T

        T_Sub_Set = min(EM.SCC.ST3.Bottom.T, T_sub_max, 100)
        T_sub1 = EM.SCC.ST2.CW_0.T
        T_sub2 = EM.SCC.ST3.CW_0.T

        VS_Cool_start = (max(T_condenser_dump_start, VS_T_set + 3, 0) < EM.VS_Pri_in.T)

    def regulate_no_subcooling(self):
        VS_Cool_start = (max(T_condenser_dump_start, VS_T_set + 3, 0) < EM.VS_Pri_in.T)

    def regulate_VS_dump(self):
        VS_Cool_Err = EM.VS_Pri_in.T - max(25, VS_T_set + 1 ,0) * 0.25

        VS_Cool_Err_int_dot = (VS_Cool_Err - VS_Cool_Err_int)/10

        VS_Cool_keep = (VS_Cool > 0) * (VS_T_set < EM.VS_Pri_in.T)
        VS_Cool = (VS_Cool_start>0) + (VS_Cool_keep>0)

        EM.VS_secondary_bypass.Reg.S_set = (VS_Cool_keep > 0) * VS_Cool_Err_int

    def regulate_VV_buffer(self):
        Err_T_VV_buffer = (VV.T_set + dT_VV_buffer - EM.VV_ST.CW_0.T) * switch_HW_on

    def regulate(self):

        #Define errors



        #EMB regulation
        # Regulation of EMB Compressors

        VS_T_set = max(VS.T_set + T_off, min_VS_set, 0)
        #VS_Err = VS.T_set - EM.VS_supply.T
        VS_Err = VS.T_set - VS.Supply.T

        VS_ext_err = VS.T_set - VS.Supply.T
        VS_ext_err_int_dot = (VS_ext_err * 0.0001)*((VS_ext_err_int<1)*(VS_ext_err>0) + (VS_ext_err_int>0)*(VS_ext_err<0))

        #KB.Err = KB.T_set - KB.Supply.T
        #N_on_KB = (-source.KB_Err / KB_step - KB_offset) * (source.mode >= 0.5)
        #VS_offset =min(EM.VS_return.T, VS.Return.T, VS.T_set)
        VS_offset = min(EM.VS_return.T,1000, VS.T_set)
        VS_scale = (VS_T_set - VS_offset)/N_EMA_heat
        VS_scale = VS_scale*(VS_scale>1)+ (VS_scale<=1)


        #err_VS = EM.VS_supply.T - VS.T_set
        bias = -1

        err_VS = -(VS_Err + bias)
        err_VS = -VS_Err
        kI = 0.00001

        #int_err_VS_dot = err_VS
        int_err_VS_dot = err_VS * ((err_VS > 0) * ((int_err_VS * kI) <= 1) + (err_VS < 0) * (int_err_VS > 0))

        #EM.Bypass_VS1.Reg.S_set = (err_VS * 1 + int_err_VS * kI)*(VS.active_flow<=0)+(VS.active_flow>0)*VS.active_flow
        #EM.Bypass_VS1.Reg.S_set = unit #(err_VS * .1 + int_err_VS * kI) * (VS.active_flow <= 0) + (VS.active_flow > 0) * VS.active_flow



        EM.Bypass_VS1.Reg.S_set = (int_err_VS * kI)*0 +1
                                  #+  0.25 * err_VS

        #err_KB = KB.T_set - EM.KB_supply.T + KB.Return.T - EM.KB_return.T

        #int_err_KB_dot = err_KB*((err_KB>0)*((int_err_KB*kI)<=1) + (err_KB<0)*(int_err_KB>0))
        #EM.Bypass_KB1.Reg.S_set = max(err_KB * .1 + int_err_KB * kI, KB.active_flow, 0)
        #EM.Bypass_KB1.Reg.S_set = err_KB * 1 + int_err_KB * kI
        #EM.Bypass_KB1.Reg.S_set = unit #int_err_KB * kI + 0.25*err_KB

        #err_KB = (KB_Err - bias)
        KB_Err = KB.Err
        #int_err_KB_dot = KB.Err * ((KB.Err > 0) * ((int_err_KB * kI) <= 1) + (KB.Err < 0) * (int_err_KB > 0))

        #EM.Bypass_KB1.Reg.S_set = KB.Err - bias
        EM.Bypass_KB1.Reg.S_set = (int_err_KB * kI)*0 +1
                                  #+ err_KB * 0.25







class EM1_Regulator(BC.Subsystem):
    def construct_Subsystem(self, mode=0, **conf):

        self.EM = conf['EM']
        self.VV = conf['VV']
        self.VS = conf['VS']
        self.KB = conf['KB']

        #self.add('EMB_Regulator', EMB_regulator, self, self.EM.EMB, comp1_offset=0, comp2_offset=0, comp1_step=1, comp2_step=1)
        self.add('EMB_Regulator', EMB_regulator, self, self.EM.EMB, T_emb_comp1_on=25, VS=self.VS,
                 cond1_VS=False)
        #Make EMA regulators
        N_Comp_EMA = 2





        self.add('EMA_Regulator', EMA_regulator, self.EM.EMA, source=self,
                 VS_EMA_num=1,
                 KB=self.KB, KB_offset=0, KB_step=1,
                 UK = self, UK_offset=0, UK_step=4, VS_far=True)

        #Make EMHW regulators

        #self.add('EMHW_Regulator_'+str(i+1), EMHW_regulator,  EMHW, self.EM)

        self.Variables = [
            {'name': 'switch_HW_on', 'unit': '1', 'type': 'param', 'val': 1},
            {'name': 'T_emb_comp1_on', 'unit': 'C', 'type': 'param', 'val': 30},
            {'name': 'VS_mode', 'unit': '1', 'type': 'param', 'val': 1},
            {'name': 'mode', 'unit': 'C*s', 'type': 'state', 'val': mode},
            {'name': 'T_sub_min', 'unit': 'C', 'type': 'param', 'val': 0},
            {'name': 'N_EMA_heat', 'unit': '1', 'type': 'param', 'val': 1},
            {'name': 'T_scale', 'unit': 'C', 'type': 'param', 'val': 0.1 + 2},
            {'name': 'kV', 'unit': 'C', 'type': 'param', 'val':0},

        ]
        self.calc_funcs = [self.regulate]

    def regulate(self):
        KB_Err = KB.Err

        VS_Err = VS.T_set - VS.Supply.T

        #Define errors
        Err_T_VV_buffer = (VV.T_set + 5 - EM.Acu3.VolumeString.F0_0.T) * switch_HW_on

        Err_T_Sub = (T_emb_comp1_on - EM.Acu2.VolumeString.F0_0.T)*(Err_T_VV_buffer-1>0)

        #EMB regulation
        # Regulation of EMB Compressors

        T_Sub_Set = EM.Acu2.VolumeString.F0_0.T
        T_sub1 = EM.Acu2.VolumeString.F0_0.T
        T_sub2 = EM.Acu1.VolumeString.F0_0.T
        VS_T_set = VS.T_set + 2
        VS_offset = VS_T_set
        VS_scale = 0#(VS_T_set - VS.Return.T)/N_EMA_heat

        VS_Cool = (VS_Err + 3 < 0) *(KB.Err < 1)

        #EM.Pipe_VoCW_HS_in_Acu4_Bottom_0.kV = kV

        #EM.VS_secondary_bypass.Reg.S_set = VS_Cool

class EMA_regulator(BC.Node):
    def construct_Node(self, EMA, source=None, KB=None, VS_EMA_num=None, KB_offset=None, KB_step=None, UK_offset=None, UK_step=None, UK=None, VS=None, cond_dT=5, VS_far=False):



        self.source = source
        self.EMA = EMA



        self.Variables = [
            #{'name': 'N_on', 'unit': '1', 'type': 'state', 'val': 0.05},
            {'name': 'N_comp_circ', 'unit': '1', 'type': 'state', 'val': EMA.N_comp_circuit},
            {'name': 'N_on_act', 'unit': '1', 'type': 'state', 'val': 0.05},
            {'name': 'N_on_UK', 'unit': '1', 'type': 'param', 'val': 0},
            {'name': 'N_on_VS', 'unit': '1', 'type': 'param', 'val': 0},
            {'name': 'N_on_KB', 'unit': '1', 'type': 'param', 'val': 0},
            {'name': 'Sub_int_err', 'unit': '1', 'type': 'state', 'val': 0},
            {'name': 'int_evap_err', 'unit': '1', 'type': 'state', 'val': 0},
            {'name': 'evap_kI', 'unit': '1', 'type': 'param', 'val':  0.00001},
            {'name': 'int_cond_err', 'unit': '1', 'type': 'state', 'val': 0},
            {'name': 'cond_kI', 'unit': '1', 'type': 'param', 'val': 0.001},
            {'name': 'cond_dT', 'unit': '1', 'type': 'param', 'val': cond_dT},
            {'name': 'VS_primer', 'unit': '1', 'type': 'state', 'val': 0.3},
            {'name': 'KB_primer', 'unit': '1', 'type': 'state', 'val': 0.3},
            {'name': 'kI_N_on', 'unit': '1', 'type': 'state', 'val': 1/(60*2)},

            #{'name': 'VS_control', 'unit': '1', 'type': 'param', 'val': 1},
        ]
        self.calc_funcs = []

        if EMA.has_subcooler:
            self.UK = UK
            self.Variables.append({'name': 'UK_offset', 'unit': '1', 'type': 'param', 'val': UK_offset})
            self.Variables.append({'name': 'UK_step', 'unit': '1', 'type': 'param', 'val': UK_step})
            self.calc_funcs.append(self.regulate_subcooler)

        if VS_EMA_num:
            #self.VS = VS
            self.Variables.append({'name': 'VS_EMA_num', 'unit': '1', 'type': 'param', 'val': VS_EMA_num})

            if VS_far:
                self.calc_funcs.append(self.regulate_VS_far)
            else:
                self.calc_funcs.append(self.regulate_VS)
        #else:
        #    self.Variables.append({'name': 'VS_primer', 'unit': '1', 'type': 'state', 'val': 0})

        if KB:
            self.KB = KB
            self.Variables.append({'name': 'KB_offset', 'unit': '1', 'type': 'param', 'val': KB_offset})
            self.Variables.append({'name': 'KB_step', 'unit': '1', 'type': 'param', 'val': KB_step})

            self.calc_funcs.append(self.regulate_KB)

        self.calc_funcs.append(self.regulate)
        #self.calc_funcs.append(self.comp_single_regulate)
        if self.EMA.dual_circuit:
            self.calc_funcs.append(self.comp_dual_regulate)
        else:
            self.calc_funcs.append(self.comp_single_regulate)



    def regulate_subcooler(self):
        #N_on_UK = (UK.Err_T_Sub - UK_offset) / UK_step

        #N_on_UK = N_on_UK *(N_on_UK<=1)+ (N_on_UK>1)
        # Subcooling pump regulation

        VS_Sub_dump = (N_on_VS < 0) * (EMA.pipe_cond_out.T_pipe > UK.T_Sub_Set)
        VS_Sub_dump = (VS_Sub_dump > 0) * VS_Sub_dump
        # Regulation of EMA subcooler pump
        Sub_err = EMA.Subcooler.m_dot_F2.T_s2 - UK.T_Sub_Set + VS_Sub_dump
        #Sub_err = EMA.Subcooler.F2_9.T + 8 - max(EMA.Condenser.F1A_0.T, EMA.Condenser.F1B_0.T,0) + VS_Sub_dump

        Sub_int_err_dot = Sub_err * ((Sub_int_err > 0) * (Sub_err < 0) + (Sub_err > 0))
        kI_Sub = 0.0001
        EMA.LCW_Sub_in.Set_Speed = max(Sub_int_err * kI_Sub, N_on_UK,.2)

        EMA.bp_sub.Reg.S_set = UK.Err_T_Sub * (EMA.pipe_cond_out.T_pipe > UK.T_Sub_Set) + (VS_Sub_dump > 0)


    def regulate_VS(self):
        T_set_VS = min(source.VS_offset + source.VS_scale* VS_EMA_num, 1000, source.VS_T_set)
        #T_set_VS = T_set_VS*(source.VS_T_set>T_set_VS) + source.VS_T_set*(T_set_VS>=source.VS_T_set)
        N_on_VS = (T_set_VS  - EMA.pipe_cond_out.T_pipe)*source.T_scale * (source.mode<=0.5)

    def regulate_VS_far(self):
        T_set_VS = min(source.VS_offset + source.VS_scale* VS_EMA_num, 1000, source.VS_T_set)
        #T_set_VS = T_set_VS*(source.VS_T_set>T_set_VS) + source.VS_T_set*(T_set_VS>=source.VS_T_set)
        N_on_VS = (T_set_VS  - source.VS.Supply.T)*source.T_scale * (source.mode<=0.5)


    def regulate_KB(self):
        N_on_KB = (-source.KB_Err * KB_step - KB_offset) * (source.mode>=0.5)

    def regulate(self):
        #Compressor Regulation

        #
        N_on_in = max(0, N_on_VS, N_on_KB)
        N_on_act_dot = (N_on_in - N_on_act)*kI_N_on

        On_safe1 = (EMA.Compressor1.p_out < 3800)


        EMA.Compressor1.State1 = (N_on_act >= 1) * On_safe1
        EMA.Compressor1.State2 = (N_on_act >= 2) * On_safe1 *(N_comp_circ>1)

        corr = source.KB.T_set - EMA.Evaporator.F2_9.T

        int_evap_err_dot = corr * ((int_evap_err * evap_kI > KB_primer - 0.5) * (corr < 0) + (corr > 0) * (int_evap_err * evap_kI <= .2))

        bias = 0.5



        cond_corr = EMA.pipe_cond_out.T_pipe - (EMA.LCW_Cond_in.T + cond_dT)
        int_cond_err_dot = cond_corr * ((int_cond_err * cond_kI > VS_primer - 0.5) * (cond_corr < 0) + (cond_corr > 0) * (int_cond_err * cond_kI <= .5))

        EMA.LCW_Cond_in.Set_Speed = 0.5 + int_cond_err * cond_kI
        #EMA.LCW_Cond_in.Set_Speed = 0.33 * EMA.Compressor1.state + 0.3 Used for EM1

    def comp_single_regulate(self):
        EMA.LCW_Evap_in.Set_Speed = max(0, (0.5 + int_evap_err * evap_kI) * (N_on_act >= 1), KB_primer * (EMA.Compressor1.state> 1e-12))

    def comp_dual_regulate(self):
        EMA.LCW_Evap_in.Set_Speed = max(0, (0.5 + int_evap_err * evap_kI) * (N_on_act >= 1), KB_primer * (EMA.Compressor1.state + EMA.Compressor2.state > 1e-12))
        On_safe2 = (EMA.Compressor2.p_out < 3800)
        #EMA.Compressor1.State1 = (N_on_act >= 1)*On_safe1
        EMA.Compressor2.State1 = (N_on_act >= 2)*On_safe2
        #EMA.Compressor1.State2 = (N_on_act >= 3)*On_safe1
        EMA.Compressor2.State2 = (N_on_act >= 4)*On_safe2*(N_comp_circ>1)




class EMB_regulator(BC.Node):
    def construct_Node(self, source, EMB, T_emb_comp1_on=25, VS=None, cond1_VS=True):
        self.source = source
        self.EMB = EMB
        self.VS = VS

        self.Variables = [
            {'name': 'T_emb_comp1_on', 'unit': '1', 'type': 'param', 'val': T_emb_comp1_on, },



        ]

        self.calc_funcs = [self.regulate_circ1, ]

        if cond1_VS:
            self.calc_funcs.append(self.reg_cond1_VS)

        if self.EMB.dual_circuit:
            self.calc_funcs.append(self.regulate_circ2)
            if self.EMB.subcooler:
                self.calc_funcs.append(self.regulate_sub_circ1)
                self.calc_funcs.append(self.regulate_sub_circ1_2)
            else:
                self.calc_funcs.append(self.regulate_no_sub_circ1)

        elif self.EMB.subcooler:
            self.calc_funcs.append(self.regulate_sub_circ1)
        else:
            self.calc_funcs.append(self.regulate_no_sub_circ1)


    def regulate_circ1(self):
        #Compressor Regulation
        #c1_start = (source.T_sub1>10)*(source.Err_T_VV_buffer-1 >0) + (source.VS.Err > -3)*(source.T_sub1>VS.T_set-15)
        #c1_keep =  (source.T_sub1>10)*(source.Err_T_VV_buffer+1 >0)+(source.VS.Err > -4)*(source.T_sub1>VS.T_set-20)

        P_circ1_VS =  EMB.Compressor1.Power
        P_circ1_VV = EMB.Compressor1.Power

        On_safe1 = (EMB.Evaporator1.F2_3.T >= -10) * (EMB.Condenser1.F2_3.T <= 90)
        EMB.Compressor1.State1 = (c1_start + c1_keep*(EMB.Compressor1.State1>0))*(On_safe1>0)

        EMB.LCW_Evap1_in.Set_Speed = max(EMB.Compressor1.state*1,0.4*(EMB.Compressor1.state>1e-12),0)
        EMB.LCW_Cond1_out.Set_Speed = EMB.LCW_Evap1_in.Set_Speed

    def reg_cond1_VS(self):
        EMB.cond1_Bypass.Reg.S_set = (source.Err_T_VV_buffer-1 > 0) + (source.Err_T_VV_buffer +1 > 0)*(EMB.cond1_Bypass.Reg.S_set > 0)

    def regulate_no_sub_circ1(self):
        c1_start = (source.Err_T_VV_buffer - 1 > 0) + (source.VS_Err > 0.5)
        c1_keep = (source.Err_T_VV_buffer + 1 > 0) + (source.VS_Err > -0.5)

    def regulate_sub_circ1(self):
        c1_start = (source.T_sub1 > 15) * (source.Err_T_VV_buffer - 1 > 0) + (source.VS_Err > 0.5) * (source.T_sub1 > T_emb_comp1_on)
        c1_keep = (source.T_sub1 > 10) * (source.Err_T_VV_buffer + 1 > 0) + (source.VS_Err > -0.5) * (source.T_sub1 > 20)

        EMB.LCW_Sub_in.Set_Speed = EMB.Compressor1.state+0.35*(EMB.Compressor1.state>1e-12)

    def regulate_circ2(self):
        On_safe2 = (EMB.Evaporator2.F2_3.T >= -10) * (EMB.Condenser2.F2_3.T <= 90)
        #c2_start =(source.VS_Err > -4) * (source.T_sub2 > VS.T_set-15)
        #c2_keep = (source.VS_Err > -5) * (source.T_sub2 > VS.T_set-20)

        c2_start = (source.VS_Err > 0.5) * (source.T_sub2 > 20)
        c2_keep = (source.VS_Err > -0.5) * (source.T_sub2 > 15)

        EMB.Compressor2.State1 = (c2_start + c2_keep * (EMB.Compressor2.State1 > 0))*(On_safe2>0)

        EMB.LCW_Evap2_in.Set_Speed = max(EMB.Compressor2.state*0.6, 0.4*(EMB.Compressor2.state>1e-12), 0)
        EMB.LCW_Cond2_out.Set_Speed = EMB.LCW_Evap2_in.Set_Speed

    def regulate_sub_circ1_2(self):
        EMB.LCW_Sub_in.Set_Speed = EMB.Compressor1.state + EMB.Compressor2.state + 0.35*(EMB.Compressor1.state + EMB.Compressor2.state > 1e-12)

class CO2_regulator(BC.Node):
    def construct_Node(self, source, KVP_CO2):
        #self.source = source
        self.KVP_CO2 = KVP_CO2
        self.Variables = []
        self.calc_funcs = [self.regulate]
        if KVP_CO2.VS_conn:
            self.calc_funcs.append(self.regulate_VS)
        self.source =source
    def regulate(self):
        #source.EM.VV_Cold_Pipe.m_dot = source.EM.VV.F_VV

        #source.EM.P_VVC.Set_Speed = 1  # kg/s
        #source.EM.VV_Cold_Pipe.m_dot = source.EM.VV.F_VV

        #VV_Err = source.EM.VV.T_set +1 - source.EM.VV_ST.CW_5.T
        VV_Top_Err = source.EM.EMHW.VV.T_set + 5 - source.EM.VV_ST.Top.T


        c1_start = VV_Top_Err > 5
        c1_keep = VV_Top_Err > 0

        #prod_on = (source.EM.VV_ST.CW_0.T < 70) * (KVP_CO2.Compressor1.State1 > 0) + (source.EM.VV_ST.CW_0.T < 60)
        p_opt = (KVP_CO2.Condenser1.F1A_0.T - 30) * 250 + 7500
        #P_p_opt = (p_opt - source.EM.EMB.Compressor1.p_out)*0.0001

                                     #+ P_p_opt*(P_p_opt>0)



            #0.35 * (KVP_CO2.Compressor1.state > 1e-12) + 0.01 * KVP_CO2.Compressor1.state

        #circ_flow = KVP_CO2.Compressor1.State1*(KVP_CO2.Condenser1.F2_0.T > source.EM.VV_ST.Bottom.T) * (KVP_CO2.Compressor1.State1>=0.4)
        #circ_flow = circ_flow*((circ_flow<0.5)*(circ_flow>0) +0.5*(circ_flow>=0.5))
            #((VV_Err>0)*(circ_flow<=0) + (circ_flow>0)*(VV_Err>-3))
        KVP_CO2.Compressor1.State1 = (c1_start + c1_keep * (KVP_CO2.Compressor1.State1 > 0) > 0)*VV_Top_Err*0.25
                                     #+ (circ_flow>0)

        #circ_flow_m_dot =  circ_flow

        #Flow_1 = (KVP_CO2.Condenser1.F1A_7.T - KVP_CO2.Condenser1.F2_0.T)*0.02
        #KVP_CO2.LCW_Cond1_out.Set_Speed = (Flow_1*(Flow_1>0) + 0.1)*(KVP_CO2.Compressor1.State1 > 0)
        KVP_CO2.LCW_Cond1_out.Set_Speed = KVP_CO2.Compressor1.State1 * 2

        #Flow_Low = (KVP_CO2.Condenser_Low.F1A_7.T - KVP_CO2.Condenser_Low.F2_0.T)*0.02
        #KVP_CO2.LCW_Cond_Low_out.Set_Speed =  (Flow_Low * (Flow_Low>0) + 0.1)*(KVP_CO2.Compressor1.State1 > 0)
        KVP_CO2.LCW_Cond_Low_out.Set_Speed = KVP_CO2.Compressor1.State1 * 2

        KVP_CO2.LCW_Evap1_in.Set_Speed = min(10,max(KVP_CO2.Compressor1.state*15, KVP_CO2.Compressor1.State1*15,0),10)

    def regulate_VS(self):
        dT_cond_VS_err = (KVP_CO2.LCW_Cond_VS_out.T - KVP_CO2.pipe_cond1_In.T_pipe-2)
        KVP_CO2.LCW_Cond_VS_out.Set_Speed =  ((dT_cond_VS_err*(dT_cond_VS_err>0)+0.3*(source.VS.T_set - source.VS.Supply.T > 0))*(KVP_CO2.pipe_cond_1_VS.T_pipe-1>source.EM.EMB_Cond1_in.T))*(source.VS.T_set>35)
                                             #*(source.EM.VV_ST.Top.T>source.VV.T_set)

class EMHW_CO2_regulator(BC.Node):
    def construct_Node(self, EMHW, EM):

        self.EMHW = EMHW
        self.EM = EM


        self.Variables = [{'name': 'Err_int', 'unit': '1', 'type': 'state', 'val': 0, },]
        self.calc_funcs = [self.regulate]



    def regulate(self):
        # EMHW regulation

        EMHW.VV_Cold_Pipe.m_dot = EMHW.VV.F_VV

        EMHW.P1_1_Prim.Set_Speed = 0.35*(EM.SCC.ST1.Top.T - EMHW.HX1_1.F1A_0.T)



        EMHW.bp_VS.Reg.S_set = 1

        EMHW.P_VVC.Set_Speed = 1  # kg/s

        EMHW.P1_Prim.Set_Speed = EMHW.HX1.F2_0.T +10  - EMHW.P1_Prim.T  #EM.VV_Cold_ST.CW_2.T - (EMHW.P1_Prim.T-3)
        #EMHW.P1_Prim.Set_Speed = (EM.VV_Cold_ST.Bottom.T + 1  - EMHW.P1_Prim.T)*0.5  # EM.VV_Cold_ST.CW_2.T - (EMHW.P1_Prim.T-3)
        EMHW.P2_Prim.Set_Speed = EMHW.HX2.F2_0.T +3  - EMHW.P2_Prim.T
        #EMHW.P2_Prim.Set_Speed = (EM.VV_Intermediate_ST.Bottom.T + 1  - EMHW.P2_Prim.T)*0.5
        #EMHW.P3_Prim.Set_Speed = (EMHW.HX3.F2_0.T +1  - EMHW.P3_Prim.T)*2
        EMHW.P3_Prim.Set_Speed = EMHW.VV.Err *4
        EMHW.P3_Prim.Set_Speed = EMHW.P3_Prim.Set_Speed*(EMHW.P3_Prim.Set_Speed<4)+ 4* (EMHW.P3_Prim.Set_Speed>=4)

class EMHW_regulator(BC.Node):
    def construct_Node(self, EMHW, EM):

        self.EMHW = EMHW
        self.EM = EM


        self.Variables = []
        self.calc_funcs = [self.regulate]

        if EMHW.has_subcooler:
            self.calc_funcs.append(self.regulate_subcooler)

        if EMHW.has_step2_pump:
            self.calc_funcs.append(self.regulate_step2)

    def regulate(self):
        # EMHW regulation

        EMHW.VV_Cold_Pipe.m_dot = EMHW.VV.F_VV

        VV_Err = EMHW.VV.T_set - EMHW.VV_Supply_Pipe.T_pipe

        EMHW.P3_Prim.Set_Speed = VV_Err

        EMHW.bp_VS.Reg.S_set = VV_Err

        EMHW.P_VVC.Set_Speed = 1  # kg/s

    def regulate_subcooler(self):
        EMHW.P1_Prim.Set_Speed = VV_Err * (EM.SCC.ST3.CW_0.T > EMHW.VV.Cold.T)

    def regulate_step2(self):
        EMHW.P2_Prim.Set_Speed = VV_Err * (EM.SCC.ST1.CW_0.T > EMHW.VV.Cold.T)


class BHS_regulator(BC.Subsystem):
    def construct_Subsystem(self, source, EP_Reg, BHS, offset, **conf):
        self.source = source
        self.BHS = BHS
        self.EP_Reg = EP_Reg
        #Regulate pump to achieve temperature setpoint?

        self.Variables = [
            {'name': 'offset', 'unit': '1', 'type': 'param', 'val': offset, },
            ]

        self.calc_funcs = [self.regulate]

    def regulate(self):
        #Set valves
        VS_Err = BHS.HX.F2_2.T-BHS.HX_Supply.T-2 - offset

        VS_Mode = EP_Reg.VS_Cool

        KB_Err = source.KB.T_set - source.ES.Supply_Short.T
        #VS_HP_Err = abs(source.ES.KB_Supply.T - source.KB.T_set)

        BHS.Pump_HX.Set_Speed = VS_Err * (VS_Mode>0) * (BHS.Return_Valve.S_act > 0.999)

        BHS.Pump.Set_Speed = VS_Mode * (VS_Mode>0) * (BHS.Return_Valve.S_act > 0.999) + (abs(KB_Err)+0.35)*(VS_Mode<=0)*(BHS.In_Valve.S_act > 0.999)


        BHS.In_Valve.S_set = (VS_Mode <= 0)*((KB_Err < 0)*(source.ES.KB_Supply.T > BHS.BHS.T_brine_out) + (KB_Err > 2)*(source.ES.KB_Supply.T < BHS.BHS.T_brine_out))
        BHS.Out_Valve.S_set = BHS.In_Valve.S_set
        BHS.Return_Valve.S_set = (BHS.In_Valve.S_set<=0)

        #valve_set = (source.VS_switch - offset > 0)
        #BHS.valve_in.Reg.S_set_in = valve_set
        #BHS.valve_out.Reg.S_set_in = valve_set

        #set pump speed
        #BHS.Pump.Set_Speed = (valve_set>0)*source.VS_Speed + (valve_set<=0)*source.KB_Speed

class Energy_system_w_BHS_regulator(BC.Subsystem):
    def construct_Subsystem(self, EP_Reg=None, **conf):

        self.ES = conf['ES']
        self.EP = conf['EP']
        #self.VV = conf['VV']
        self.VS = conf['VS']
        self.KB = conf['KB']
        self.EP_Reg = EP_Reg


        self.BHSs = [conf['BHS']]

        if 'BHS2' in conf:
            self.BHSs.append(conf['BHS2'])

        #Create regulators
        for i, BHS in enumerate(self.BHSs):
            offset = i
            self.add('BHS_Regulator_' + str(i + 1), BHS_regulator, self, EP_Reg, BHS, offset)

        self.Variables = [
            {'name': 'kP_VS_switch', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'kP_VS_speed', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'kP_KB_speed', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'VS_Speed', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'KB_Speed', 'unit': '1', 'type': 'param', 'val': 1, },
        ]

        self.calc_funcs = [self.regulate]

    def regulate(self):

        ES.Bypass.Reg.S_set = (ES.EM_BHS.P_ewma > 0) + (EP_Reg.VS_Cool > 0)
        ES.Bypass_KB.Reg.S_set = -KB.Err + 0.5
        ES.Pump_KB.Set_Speed = -KB.Err + 0.5


# class EP_Regulator_w_EP(BC.Subsystem):
#
#
#     def construct_Subsystem(self, **conf):
#         import sim_components.thermodynamics.Fluid_Flow as FF
#         self.VV = conf['VV']
#         self.VS = conf['VS']
#         self.KB = conf['KB']
#
#         self.pipe_VS = self.add('pipe_VS', FF.Pipe_w_Power, kV=5, P=0, m_dot=20, side1=self.VS.Return, side2=self.VS.Supply)
#         self.pipe_KB = self.add('pipe_KB', FF.Pipe_w_Power, kV=5, P=0, m_dot=20, side1=self.KB.Return, side2=self.KB.Supply)
#         self.pipe_VVC = self.add('pipe_VVC', FF.Pipe_w_Power, kV=5, P=0, m_dot=1, side1=self.VV.Return, side2=self.VV.Supply)
#         self.pipe_VV = self.add('pipe_VV', FF.Pipe_Check, kV=1, inlet=self.VV.Cold, outlet=self.VV.Supply)
#
#
#
#
#         self.Variables = [
#             {'name': 'kP_VS_switch', 'unit': '1', 'type': 'param', 'val': 1, },
#             {'name': 'kP_VS', 'unit': '1', 'type': 'param', 'val': 1e6, },
#             {'name': 'kP_KB', 'unit': '1', 'type': 'param', 'val': 1e6, },
#             {'name': 'kP_VV', 'unit': '1', 'type': 'param', 'val': 1e6, },
#             {'name': 'VS_Speed', 'unit': '1', 'type': 'param', 'val': 1, },
#             {'name': 'KB_Speed', 'unit': '1', 'type': 'param', 'val': 1, },
#             #{'name': 'P_VVC', 'unit': '1', 'type': 'param', 'val': conf['P_VVC'], },
#             #{'name': 'P', 'unit': '1', 'type': 'param', 'val': conf['P']},
#         ]
#
#         self.calc_funcs = [self.regulate]
#
#     def regulate(self):
#         pipe_KB.P = -VS.Err*(VS.Err > 0) * kP_VS*1.2
#         #KB.Err * (KB.Err < 0) * kP_KB
#         pipe_VS.P = VS.Err*(VS.Err >0 ) * kP_VS
#         VV_P = VV.Err * (VV.Err > 0) * kP_VV
#         VV.Supply.H_dot = VV_P
#
#
#     def output_(self, sys_dict):
#
#         sys_dict[self.gp('Energy_Usage')] = sys_dict[self.EP.gp('Energy_Usage')]+sys_dict[self.ES.gp('Energy_Usage')]