import sim_components.generic.items as B
import numpy as np

class Prosumer(B.Node):
    def construct_Node(self,P=0):

        self.add_var('P_Elec', unit='kW', desc='The power produced by prosumer. Negative denotes consumption.')

    def output(self, sys_dict):
        #print('Power of ', self.gp(''), ' is: ', sys_dict[self.gp('P')], ' kW')
        pass

class Battery(Prosumer):
    def construct_Node(self, E_cap=10, Rel_Charge_Min=10, **c):
        super().construct_Node(P=0)

        self.add_var('E_cap', unit='kWh', val=E_cap, desc='Capacity')
        self.add_var('P_cap', unit='W', val=5*E_cap*1000, desc='Capacity')
        self.add_var('Rel_Charge', unit='%', vartype='state', desc='Charging state')
        self.add_var('Rel_Charge_Min', val=Rel_Charge_Min, unit='%', desc='Min charge state')
        self.add_var('P_set', val=0, unit='kW', desc='Discharging rate requested')
        self.add_var('P_max', val=E_cap*5*1000, unit='kW', desc='Maximum discharging rate')
        self.add_var('J_kWh', val=2.7777778e-10*1e3)


        self.calc_funcs.append(self.diff)

    def diff(self):
        P_max_charge = positive(P_cap *(100 - Rel_Charge)/100)
        P_max_discharge = positive(P_cap * Rel_Charge/100*(Rel_Charge>Rel_Charge_Min))
        P_Elec = min2(max2(P_set, -P_max_charge), P_max_discharge)
        #min2(P_set, P_max) * (Rel_Charge > 0)*(P_set >0) - (P_set < 0)* (Rel_Charge < 100) * min(-P_set, P_max)
        Rel_Charge_dot = -P_Elec * J_kWh / E_cap * 100

    def output(self, sys_dict):
        super().output(sys_dict)
        #print('P setpoint: ', sys_dict[self.gp('P_set')])
        #print('Charge: ', sys_dict[self.gp('Rel_Charge')],' %')


class Controller(B.Subsystem):
    def construct_Subsystem(self, prosumers, min_load_discharge=0, grid_charge_capacity=0, grid_capacity=1000):

        self.add_var('P_balance_wo_battery', val=0, unit='kW', desc='Balance of product/consumption in non-battery prosumers')
        self.add_var('P_balance', val=0, unit='kW', desc='Balance of product/consumption in all prosumers')
        self.add_var('E_balance', val=0, unit='kW', vartype='state', desc='Balance of product/consumption in all prosumers')
        self.add_var('E_negative', val=0, unit='kW', vartype='state', desc='Balance of product/consumption in all prosumers')
        self.add_var('E_positive', val=0, unit='kW', vartype='state', desc='Balance of product/consumption in all prosumers')
        self.add_var('J_MWh', val=2.7777778e-10)
        self.add_var('min_load_discharge', val=min_load_discharge*1000)
        self.add_var('grid_charge_capacity', val=grid_charge_capacity)
        self.add_var('grid_capacity', val=grid_capacity*1000)
        #self.add_var('Rel_Charge_Min', val=rel_charge_min, unit='%', desc='Min charge state')
        # Calculate the energy balance of the system and add/remove power as needed by the grid as an infinite ressource
        self.prosumers = prosumers

        non_battery_prosumers = []
        non_battery_prosumers_p_strs = []
        batteries = []
        for p in self.prosumers:
            if not isinstance(p, Battery):
               non_battery_prosumers.append(p)
               non_battery_prosumers_p_strs.append(p.gp('P_Elec'))
            else:
                batteries.append(p)

        assert len(batteries) == 1, 'There most be one and only one battery in the system, seems there is: ' + str(
            len(batteries)) + ' in this system!'

        self.battery = batteries[0]


        self.add_calc_func_str('P_balance_wo_battery','P_balance_wo_battery = ' + '+'.join(non_battery_prosumers_p_strs))

        self.add_calc_func_str('P_balance' ,'P_balance = ' + '+'.join([p.gp('P_Elec') for p in self.prosumers]))

        self.calc_funcs.append(self.diff)

    def diff(self):
        #Charge is negative -> it is a consumption
        #The charge order can come from either surplus production (positive energy balance
        P_charge = -max2(grid_capacity + P_balance_wo_battery, 0)*(battery.Rel_Charge < grid_charge_capacity)


        #Discharge is positive contribution -> its a production
        #In order to discharge we must have a negative balance even when the min_load_cischarge is added
        #We need to negate the discharge - since a negative required discharge must lead to a positive production from battery
        P_discharge = -min2(negative(P_balance_wo_battery) + min_load_discharge,0)

        battery.P_set = P_discharge + P_charge*(P_discharge<=0)
        E_balance_dot = P_balance*J_MWh
        E_negative_dot = negative(E_balance_dot)
        E_positive_dot = positive(E_balance_dot)

    def output(self, sys_dict):
        pass