import sim_components.generic.items as BC

class Simple_Heatpump(BC.Node):
    def construct_Node(self,

                            cold_side,
                            hot_side,
                            subcooler_side,
                            **c):



        self.calc_funcs = [self.diff]

        self.Variables = [
            {'name': 'T_evaporator', 'unit': '', 'type': 'state', 'val': 0},
            {'name': 'T_condenser', 'unit': '', 'type': 'state', 'val': 40},
            {'name': 'T_subcooler', 'unit': '', 'type': 'state', 'val': 30},
            {'name': 'dT_Super', 'unit': 'K', 'type': 'param', 'val': 6},
            {'name': 'state', 'unit': '', 'type': 'state', 'val': 0},
            {'name': 'Energy', 'unit': 'MJ', 'type': 'state', 'val': 0},
            {'name': 'Cp_evaporator', 'unit': 'J/K', 'type': 'param', 'val': 1000*500},
            {'name': 'Cp_condenser', 'unit': 'J/K', 'type': 'param', 'val': 1000*500},
            {'name': 'Cp_subcooler', 'unit': 'J/K', 'type': 'param', 'val': 1000*500},
            {'name': 'cold_side_flow', 'unit': 'kg/s', 'type': 'param', 'val': 0},
            {'name': 'hot_side_flow', 'unit': 'kg/s', 'type': 'param', 'val': 0},
            {'name': 'subcooler_side_flow', 'unit': 'kg/s', 'type': 'param', 'val': 0},

        ]

        self.m_dot_poly = np.array(c['polynom_m_dot'], dtype=np.float64)
        self.power_poly = np.array(c['polynom_power'], dtype=np.float64)

    def diff(self):

        m_dot = calc_poly2x3(m_dot_poly, T_Evap, T_Cond) * state / 3600

        P_evap = m_dot * dH_evap

        P_cond = P_evap

        P_super = m_dot * dT_super * Cp_RF

        P = calc_poly2x3(power_poly, T_Evap, T_Cond) * state

        Energy_dot = P

        P_comp_heat = P * 0.93

        P_cooling = cold_side_flow * (cold_side_in.T - T_evapotor) * cold_side_in.Cp_liq

        T_evaporator_dot = (P_cooling - P_evap - P_super) / Cp_evaporator

        P_heating = hot_side_flow  * (T_condenser - hot_side.T) * hot_side_in.Cp_liq

        P_subcool_cond = (T_condenser - hot_side_in.T) * Cp_RF * m_dot

        T_condenser_dot = (P_cond + P_subcool_cond - P_heating) / Cp_condenser

        P_subcooling = subcooler_side_flow * (T_subcooler - subcooler_side_in.T) * subcooler_side_in.Cp_liq

        P_subcool_sub = P_comp_heat - P_subcool_cond
        #TODO what if subcooler hotter than condenser??

        T_subcooler_dot = (P_subcooling - P_subcool_sub) / Cp_subcooler

        cold_H_dot = cold_side_in.h * cold_side_flow
        hot_H_dot = hot_side_in.h * hot_side_flow
        sub_H_dot = subcooler_side_in.h * subcooler_side_flow

        cold_side_in.H_dot = -cold_H_dot
        hot_side_in.H_dot = -hot_H_dot
        subcooler_side_in.H_dot = -sub_H_dot

        cold_side_out.H_dot = cold_H_dot-P_cooling
        hot_side_out.H_dot = hot_H_dot+ P_heating
        subcooler_side_out.H_dot = sub_H_dot + P_subcooling

class Buffer(BC.Node):
    def construct_Node(self, T0, V, **c):
        m = V * 1000
        Cp = 4189*V*1000
        H = T0*Cp

        self.Variables = [
            {'name': 'H', 'unit': '', 'type': 'state', 'val': H},
            {'name': 'Cp', 'unit': 'kJ/K', 'type': 'param', 'val': Cp},
            {'name': 'm', 'unit': 'kg', 'type': 'calc', 'val': m},
            {'name': 'T', 'unit': 'C', 'type': 'calc', 'val': T0},
            {'name': 'h', 'unit': 'J/kg', 'type': 'calc', 'val': H/m},
            {'name': 'Cp_liq', 'unit': 'J/kg/K', 'type': 'calc', 'val': 4189},

        ]

        self.calc_funcs = [self.diff]

    def diff(self):
        T = H/Cp
        h = H/m

class Pipe(BC.Link):
    def construct_Link(self, inlet, outlet, **c):
        self.inlet = inlet
        self.outlet = outlet

        self.Variables = [
            {'name': 'flow', 'unit': 'kg/s', 'type': 'param', 'val': 0},
        ]

        self.calc_funcs = [self.diff]

    def diff(self):

        H_dot = flow * ((flow>0) * inlet.h + (flow<=0) * outlet.h)

        outlet.H_dot = H_dot
        inlet.H_dot = -H_dot

class EM_System(BC.Subsystem):
    def construct_Subsystem(self, **c):
        #make Subcooler buffer

        # SCC
        self.SCC = self.add('SCC', Buffer, 30, 3)

        # VV ST
        self.VV_ST = self.add('VV_ST', Buffer, 60, 2)

        # VS
        self.VS = self.add('VS', Buffer, 40, 1)

        # KB
        self.KB = self.add('KB', Buffer, 10, 1)

        # EMA
        self.EMA = self.add('EMA', Simple_Heatpump, cold_side_in = self.KB, cold_side_out = self.KB, hot_side_in=, hot_side_out=, subcooler_side_in=self.SCC, subcooler_side_out=self.SCC)

        # EMB
        self.EMB = self.add('EMB', Simple_Heatpump, cold_side_in=self.SCC, cold_side_out=self.SCC, hot_side_in=self.VV_ST, hot_side_out=self.VV_ST, subcooler_side_in=self.VS, subcooler_side_out=self.VS)






class BTES_Control

    def diff(self):

        if heating:
            flow_BTES = flow_HP_cold - flow_KB
            BTES.flow = flow_BTES
            pipe_BTES_HP_cold_in.flow = flow_BTES
            pipe_HP_cold_out_BTES.flow = flow_BTES
            KB.flow = flow_KB
            pipe_KB_return_HP_cold_in.flow = flow_KB
            pipe_HP_cold_out_KB_supply.flow = flow_KB

        if free_cooling:
            BTES.flow = flow_KB
            pipe_KB_return_BTES_in.flow = flow_KB
            pipe_BTES_out_KB_supply.flow = flow_KB

        if active_cooling:
            BTES.flow = flow_HP_hot
            pipe_KB_return_HP_cold_in.flow = flow_KB
            pipe_HP_cold_out_KB_supply.flow = flow_KB
            pipe_BTES_out_HP_hot_in.flow = flow_HP_hot
            pipe_HP_hot_out_BTES_in.flow = flow_HP_hot






        flow_EM_cold =
        flow_HP_hot =





