import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
#import Liquid
import sim_components.machines.SCC_v2 as SCC
import sim_components.machines.EMHW_v2 as EMHW
import sim_components.machines.EMA_v2 as EMA
import sim_components.machines.EMB as EMB
#import sim_tool_EM.RefpropFluid as Fluid
import sim_components.thermodynamics.ST_v2 as ST


#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class EM_System(BC.Subsystem):
    def construct_Subsystem(self, RF=None, CW=None, **inputs):

        #####Basic assignments

        kV = 3
        V=0.1

        CW_Evap = CW_Cond = CW_Sub = CW
        T_Evap_ini = 10
        T_Cond_ini = 20
        T_Sub_ini = 30
        T0_VS=40
        #### Create connecting volumes

        # Create Volumes for VS line
        VS_line_volume_names = ['VoCW_Cond2_EMB_out', 'VoCW_Cond1_EMB_in', 'VoCW_Cond1_EMB_out', 'VoCW_EMB_In_Sub', 'VoCW_Cond2_EMB_in',
                           'VoCW_EMB_Out_Sub', 'VoCW_HS_In', 'VoCW_HS_Out', 'VoCW_Short_Return', 'VoCW_Short_Supply', 'VS_Sec_Check']#, 'VoCW_VS_Primary_in','VoCW_VS_Primary_out', 'VoCW_VS_Secondary_in', 'VoCW_VS_Secondary_out']

        VS_line_volumes = self.add_many(item_class=FF.Volume, item_names=VS_line_volume_names, **{'Fluid': CW_Cond, 'T0': T0_VS, 'V': V})

        kV_VS =8

        FF.make_network(self, inputs['VS_network'], Fluid=CW, kV=kV_VS, T0=T0_VS, V=V)

        FF.make_network(self, inputs['KB_network'], Fluid=CW, kV=kV_VS, T0=5, V=0.2)

        FF.make_network(self, inputs['UK_network'], Fluid=CW, kV=kV, T0=30, V=V)

        #SCC
        self.SCC=self.add('SCC', SCC.SCC, CW=CW)
        
        #VV ST
        self.VV_ST=self.add('VV_ST', ST.ST, CW=CW, T0=60)

        self.EMHWs = []
        self.N_EMHW = len(inputs['EMHW_list'])
        for i, EMHW_i in enumerate(inputs['EMHW_list']):
            EMHW_conf = {'Config': EMHW_i['type']}
            EMHW_conf.update({'F1': CW, 'F2': CW, 'T_F1': 15, 'T_F2': 30, 'q': 0, 'kpipe': 10, 'L_Pipe': 1,
                              'D_Pipe': 0.05, 'Pump_Step1_Speed': 0, 'Pump_Step2_Speed': 0, 'Pump_Step3_Speed': 0,

                              'Step1_Prim_In': self.SCC.ST3.Top,
                              'Step1_Prim_Out': self.SCC.ST3.Bottom,
                              'Step2_Prim_In': self.SCC.ST1.Top,
                              'Step2_Prim_Out': self.SCC.ST1.Bottom,
                              'Step3_Prim_In': self.VV_ST.Top,
                              'Step3_Prim_Out': self.VV_ST.Bottom,
                              'Cold': EMHW_i['VV'].Cold,
                              'Hot_Water_Return': EMHW_i['VV'].Return,
                              'Supply': EMHW_i['VV'].Supply,
                              'VV': EMHW_i['VV']

                              })  # EMHW




            # EMHW
            if i>0:
                EMHW_name = 'EMHW'+str(i+1)
            else:
                EMHW_name = 'EMHW'

            EMHW_c = self.add(EMHW_name, EMHW.EMHW, **EMHW_conf)

            self.EMHWs.append(EMHW_c)

            #Add consumer pipes





        self.EMAs=[]
        self.N_EMA = len(inputs['EMA_list'])



        for i, EMA_i in enumerate(inputs['EMA_list']):
            if i>0:
                EMA_name = 'EMA'+str(i+1)
            else:
                EMA_name = 'EMA'





            #Create EMA
            EMA_conf= {'Config': EMA_i['type'],
                'RF': RF,
                'Compressor_states': [0, 0, 0, 0],
                'Pump_Evap_Speed': 1,
                'Pump_Cond_Speed': 1,
                'Pump_Sub_Speed': 1,
                '3W_Subcooler_Bypass': 0,
                'In_Evaporator': self.get_item_name(EMA_i['KB_Return']),
                'Out_Evaporator': self.get_item_name(EMA_i['KB_Supply']),
                'In_Condenser': self.get_item_name(EMA_i['VS_Return']),
                'Out_Condenser': self.get_item_name(EMA_i['VS_Supply']),

            }

            if EMA_i['Subcooler']:
                EMA_conf.update({
                    'In_Subcooler': self.get_item_name(EMA_i['UK_Return']),
                    'Out_Subcooler': self.get_item_name(EMA_i['UK_Supply'])
                })

            print(EMA_name)
            self.EMAs.append(self.add(EMA_name, EMA.EMA, CW_Evap, CW_Cond, CW_Sub, T_Evap_ini, T_Cond_ini, T_Sub_ini, subcooler=EMA_i['Subcooler'], **EMA_conf))

        #Make EMBs
        self.EMBs = []
        self.N_EMB = len(inputs['EMB_list'])
        for i, EMB_i in enumerate(inputs['EMB_list']):

            EMB_conf = {'Config': EMB_i['type'],
                'Fix_Pump_Flow': False,
                'Compressor_states': [0, 0],
                'Pump_Evap1_Speed': 1,
                'Pump_Cond1_Speed': 1,
                'Pump_Evap2_Speed': 1,
                'Pump_Cond2_Speed': 1,
                'Pump_Sub_Speed': 1,
                '3W_Space_Hot': 0,
                'In_Evaporator1': self.SCC.ST2.Top,
                'Out_Evaporator1': self.SCC.ST2.Bottom,
                'In_Condenser1_1': self.VV_ST.Bottom,
                'Out_Condenser1_1': VS_line_volumes['VoCW_Cond1_EMB_out'],
                'In_Condenser1_2': VS_line_volumes['VoCW_Cond1_EMB_in'],
                'Out_Condenser1_2': self.VV_ST.Top,
                'In_Evaporator2': self.SCC.ST3.Top,
                'Out_Evaporator2': self.SCC.ST3.Bottom,
                'In_Condenser2': VS_line_volumes['VoCW_Cond2_EMB_in'],
                'Out_Condenser2': VS_line_volumes['VoCW_Cond2_EMB_out'],
                'In_Subcooler': VS_line_volumes['VoCW_EMB_In_Sub'],
                'Out_Subcooler': VS_line_volumes['VoCW_EMB_Out_Sub']
            }

            if i>0:
                EMB_name = 'EMB'+str(i+1)
            else:
                EMB_name = 'EMB'


            self.EMBs.append(self.add(EMB_name, EMB.EMB, CW_Evap, CW_Cond, CW_Sub, T_Evap_ini, T_Cond_ini, T_Sub_ini, **EMB_conf))

        #Make connecting pipes for VS

        pipe_lines = [
            [VS_line_volumes['VoCW_HS_In'], VS_line_volumes['VoCW_Short_Return'], VS_line_volumes['VoCW_EMB_In_Sub'], VS_line_volumes['VoCW_EMB_Out_Sub'], self.get_item_name('VS_Sec_In')],### VS Return
            [self.get_item_name('VS_Prim_Out'), VS_line_volumes['VoCW_Short_Supply'], VS_line_volumes['VoCW_Cond2_EMB_in'], VS_line_volumes['VoCW_Cond1_EMB_in'], VS_line_volumes['VoCW_Cond2_EMB_out'], VS_line_volumes['VoCW_Cond1_EMB_out'], VS_line_volumes['VoCW_HS_Out']],#, VS_line_volumes['VoCW_HS_In']],### VS Flow
        ]

        self.VS_Return_Valve = self.add('VS_Return_Valve', FF.Valve_Regulated, kV=kV_VS, S_set_in=0, side1=self.VoCW_Short_Supply,
                                  side2=self.VoCW_Short_Return)

        FF.make_pipe_lines(self, pipe_lines,kV=kV_VS)



        self.add('Pipe_EMA_Out_EMA2_Out_Main', FF.Pipe_Check, kV=kV_VS,
                 inlet=self.EMA_Out,
                 outlet=self.EMA2_Out_Main)

        self.add('Pipe_EMA2_Out_Main_EMA3_Out', FF.Pipe_Check, kV=kV_VS,
                 inlet=self.EMA2_Out_Main,
                 outlet=self.EMA3_Out)

        self.add('Pipe_VS_Sec_Out_VS_Sec_Check', FF.Pipe_Check, kV=kV_VS,
                 inlet=self.VS_Sec_Out,
                 outlet=self.VS_Sec_Check)

        self.add('Pipe_VS_Sec_In_EMA4_Out', FF.Pipe_Check, kV=kV_VS,
                 inlet=self.VS_Sec_In,
                 outlet=self.EMA4_Out)






        #add secondary VS three way valve:
        self.add('VS_secondary_bypass', FF.ThreeWayValve_Regulated, CW_Evap, kV_VS, .1, T0_VS,
                                 0,
                                A=self.get_item_name('VS_Sec_Check'),
                                B=self.get_item_name('VS_Sec_In'),
                                C=self.get_item_name('VS_Prim_In'))



        #UK
        self.add('Pipe_UK_Prim_Out_SCC_ST1_Top', FF.Pipe, kV=kV,
                 side1=self.get_item_name('UK_Prim_Out'), side2=self.SCC.ST1.Top)

        self.add('Pipe_SCC_ST3_Bottom_Prim_In', FF.Pipe, kV=kV,
                 side1=self.SCC.ST3.Bottom, side2=self.get_item_name('UK_Prim_In'))

        for i, VS_consumer in enumerate(inputs['VS_Consumers']):
            #Make pipes for heating system
            self.add('Pipe_VS'+str(i+1)+'_In', FF.Pipe, kV=kV_VS,
                                   side1=VS_consumer['Consumer'].Return, side2=VS_line_volumes['VoCW_HS_In'])

            self.add('Pipe_VS'+str(i+1)+'_Out', FF.Pipe, kV=kV_VS,
                                    side1=VS_line_volumes['VoCW_HS_Out'], side2=VS_consumer['Consumer'].Supply)

        for i, KB_consumer in enumerate(inputs['KB_Consumers']):
            #Make pipes for heating system
            self.add('Pipe_KB'+str(i+1)+'_Return', FF.Pipe, kV=kV_VS,
                                   side1=KB_consumer['Consumer_Return'], side2=self.get_item_name(KB_consumer['Return']))

            self.add('Pipe_KB'+str(i+1)+'_Supply', FF.Pipe, kV=kV_VS,
                                    side1=self.get_item_name(KB_consumer['Supply']), side2=KB_consumer['Consumer_Supply'])

        for i, Custom_consumer in enumerate(inputs['Custom_Consumers']):
            self.add('Pipe_UK' + str(i + 1) + '_In', FF.Pipe, kV=kV,
                     side1=Custom_consumer['Consumer_Supply'], side2=self.get_item_name(Custom_consumer['Supply']))

            self.add('Pipe_UK' + str(i + 1) + '_Out', FF.Pipe, kV=kV,
                     side1=self.get_item_name(Custom_consumer['Return']), side2=Custom_consumer['Consumer_Return'])
        
    def output_(self, sys_dict):

        #Space Heating Power:
        Power_space_heating = 0
        EMA_Comp_Power = 0
        EMB_Comp_Power = 0
        Cooling_Power = 0
        Energy_Consumption = 0

        for EMA in self.EMAs:
            Power_space_heating += sys_dict[EMA.gp('Power_Heating')]
            EMA_Comp_Power += sys_dict[EMA.gp('Power_Usage')]
            Cooling_Power += -sys_dict[EMA.gp('Power_Evaporator')]
            Energy_Consumption += sys_dict[EMA.gp('Energy_Usage')]

        for EMB in self.EMBs:
            Power_space_heating += sys_dict[EMB.gp('Power_Heating')]
            EMB_Comp_Power += sys_dict[EMB.gp('Power_Usage')]
            Energy_Consumption += sys_dict[EMB.gp('Energy_Usage')]

        sys_dict[self.gp('EMA_Comp_Power')] = EMA_Comp_Power
        sys_dict[self.gp('EMB_Comp_Power')] = EMB_Comp_Power
        sys_dict[self.gp('Space_Heating_Power')] = Power_space_heating
        sys_dict[self.gp('Cooling_Power')] = Cooling_Power
        # 'Power Consumption':
        sys_dict[self.gp('Power_Consumption')] = EMA_Comp_Power + EMB_Comp_Power

        sys_dict[self.gp('Energy_Consumption')] = Energy_Consumption

        #'Total COP':
        sys_dict[self.gp('Total_COP')] = (Power_space_heating + Cooling_Power)/ (EMB_Comp_Power+ EMA_Comp_Power)
    
    def print_output(self,t, sys_dict):
        pass
        #self.Rosendal.print_output(t, sys_dict)

