import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF


class Heat_Exchanger(BC.Subsystem):
    
    def construct_Subsystem(self, N_nodes, N_Plates, F1, F2, T_F2, T_F1, q=0, q2=0, F2_1=False, **c):
        c['N_Plates']=N_Plates
        c['A']=c['A_Plate']*N_Plates
        self.type=c['dual']
        if isinstance(F1, FF.Liquid_Props):
            f1=30
            f2=30
        else:
            f1=30
            f2=30


        V1=c['V1_Plate']*N_Plates*f1
        V2=c['V2_Plate']*N_Plates*f2

        #if c['dual']=='dual':
        
        #    #Adding RF side 2 volume
        #    F1B_In=self.add('F1B_In',FF.Volume,F1,c['V1_Plate']*N_Plates/2,q,T_F1)
        #    F1B_Out=self.add('F1B_Out',FF.Volume,F1,c['V1_Plate']*N_Plates/2,q,T_F1)
        if F2_1:
            kV1_plate = c['kV2_plate']
            kV1_Port = c['kV2_Port']
        else:
            kV1_plate = c['kV2_plate']
            kV1_Port = c['kV1_Port']

        kV2_plate=c['kV2_plate']
        kV2_Port=c['kV2_Port']

        self.N_nodes=N_nodes
        m_HX =c['A']*7700*0.001

        m_node = m_HX/(self.N_nodes+2)

        #self.kV_F1=kV1_Port/np.sqrt((kV1_plate*N_Plates)**2+kV1_Port**2/(kV1_plate*N_Plates)**2)
        #self.kV_F2=kV2_Port/np.sqrt((kV2_plate*N_Plates)**2+kV2_Port**2/(kV2_plate*N_Plates)**2)*1.1

        self.kV_F1=1/(1/(kV1_plate*N_Plates)+1/kV1_Port)
        self.kV_F2=1/(1/(kV2_plate*N_Plates)+1/kV2_Port)
        #print('kV1: ',self.kV_F1 )
        #print('kV2: ', self.kV_F2)
        print()
        print(self.path)
        self.kV_F1 = self.kV_F1 if self.kV_F1 > 0.3 else 0.3
        self.kV_F2 = self.kV_F2 if self.kV_F2 > 0.3 else 0.3
        print('kV1: ', self.kV_F1)
        print('kV2: ', self.kV_F2)
        print('m: ',m_HX)
        self.TC_paths_A=[]
        self.TC_paths_B = []
        
        
        for i in range(0,self.N_nodes+2):
            #Adding CW volume
            self.add('F2_'+str(i),FF.Volume,F2,V2/(self.N_nodes+2),q2,T_F2)
            #Adding RF side A volume
            self.add('F1A_'+str(i),FF.Volume,F1,V1/(self.N_nodes+2),q,T_F1)
            #Adding RF side B volume
            if self.type == 'dual':
                self.add('F1B_'+str(i),FF.Volume,F1,V1/(self.N_nodes+2),q,T_F1)
            
        self.m_dot_F1A=self.add('m_dot_F1A',m_dot_cal,self.kV_F1, side1=self.items['F1A_0'],side2=self.items['F1A_'+str(self.N_nodes-1+2)],**c)
        if self.type == 'dual':
            self.m_dot_F1B=self.add('m_dot_F1B',m_dot_cal,self.kV_F1, side1=self.items['F1B_0'],side2=self.items['F1B_'+str(self.N_nodes-1+2)],**c)

        self.m_dot_F2=self.add('m_dot_F2',m_dot_cal,self.kV_F2, side1=self.items['F2_0'],side2=self.items['F2_'+str(self.N_nodes-1+2)],**c)
        
        for i in range(0,self.N_nodes+2):    
            if i>0:
                #Linking CW volumes to each other
                self.add('L_F2_'+str(i),Pipe_Fix_Flow,side1=self.items['F2_'+str(i-1)],side2=self.items['F2_'+str(i)],flow=self.m_dot_F2)
                #Linking RF side 1 volumes to each other

                #if isinstance(F1, FF.Liquid_Props):
                #    self.add('L_F1A_'+str(i),Pipe_Fix_Flow,side1=self.items['F1A_'+str(i-1)],side2=self.items['F1A_'+str(i)],flow=self.m_dot_F1A)
                #else:
                self.add('L_F1A_' + str(i), FF.Pipe, self.kV_F1, side1=self.items['F1A_' + str(i - 1)],
                             side2=self.items['F1A_' + str(i)])

                if self.type == 'dual':
                    #Linking RF side 2 volumes to each other


                #    if isinstance(F1, FF.Liquid_Props):
                #        self.add('L_F1B_'+str(i),Pipe_Fix_Flow,side1=self.items['F1B_'+str(i-1)],side2=self.items['F1B_'+str(i)],flow=self.m_dot_F1B)
                #    else:
                    self.add('L_F1B_' + str(i), FF.Pipe, self.kV_F1, side1=self.items['F1B_' + str(i - 1)],
                                 side2=self.items['F1B_' + str(i)])

                
        #print(self.items.keys())

        if self.type == 'dual':
            self.h_A = self.add('h_A', h_calc, self.N_nodes,10, pipe1=self.m_dot_F1A, pipe2=self.m_dot_F2, **c)
            self.h_B=self.add('h_B',h_calc,self.N_nodes,10, pipe1=self.m_dot_F1B,pipe2=self.m_dot_F2,**c)
        else:
            self.h_A = self.add('h_A', h_calc, self.N_nodes, 10, pipe1=self.m_dot_F1A, pipe2=self.m_dot_F2, **c)
        
        for i in range(0,self.N_nodes+2):
            #Linking CW with RF side 1 through thermal conductor
            RATC=self.add('LL_F1A_'+str(i),Thermal_Conductor_Linked,side1=self.items['F2_'+str(i)],side2=self.items['F1A_'+str(i)], T0=T_F2, m=m_node, hsource=self.h_A)
            if self.type == 'dual':
                #Linking CW with RF side 2 through thermal conductor
                RBTC=self.add('LL_F1B_'+str(i),Thermal_Conductor_Linked,side1=self.items['F2_'+str(i)],side2=self.items['F1B_'+str(i)], T0=T_F2, m=m_node, hsource=self.h_B)
                #self.TC_paths_A+=[RATC.path]
                self.TC_paths_B +=[RBTC.path]

            self.TC_paths_A += [RATC.path]
            
            
        self.addPort('F2_In',self.items['F2_0'])
        self.F2_In=self.items['F2_0']
        self.addPort('F2_Out',self.items['F2_'+str(self.N_nodes-1+2)])
        self.F2_Out=self.items['F2_'+str(self.N_nodes-1+2)]
        self.addPort('F1A_In',self.items['F1A_'+str(self.N_nodes-1+2)])
        self.F1A_In=self.items['F1A_'+str(self.N_nodes-1+2)]
        self.addPort('F1A_Out',self.items['F1A_0'])
        self.F1A_Out=self.items['F1A_0']
        
        #print(self.F1A_Out.gp('T'))
        
        if c['dual']=='dual':
            
            self.addPort('F1B_In',self.items['F1B_'+str(self.N_nodes-1+2)])
            self.addPort('F1B_Out',self.items['F1B_0'])

    def output_(self, sys_dict):
        #print('here!')
        #print(self.path+'.Q')
        sys_dict[self.path+'.Q_A']=sum([sys_dict[p+'.Q'] for p in self.TC_paths_A])
        sys_dict[self.path+'.Q_B'] = sum([sys_dict[p + '.Q'] for p in self.TC_paths_B])
        sys_dict[self.path + '.Q'] = sys_dict[self.path+'.Q_A']+sys_dict[self.path+'.Q_B']

        sys_dict[self.path+'.Q_A_ewma']=abs(sum([sys_dict[p+'.Q_ewma'] for p in self.TC_paths_A]))
        sys_dict[self.path + '.Q_B_ewma'] =abs(sum([sys_dict[p + '.Q_ewma'] for p in self.TC_paths_B]))
        sys_dict[self.path + '.Q_ewma'] = abs(sys_dict[self.path + '.Q_A_ewma'] + sys_dict[self.path + '.Q_B_ewma'])

        sys_dict[self.path+'.T_F1A_In']=sys_dict[self.ports['F1A_In'].path+'.T']
        sys_dict[self.path+'.T_F1A_Out']=sys_dict[self.ports['F1A_Out'].path+'.T']
        sys_dict[self.path + '.p_F1A_In'] = sys_dict[self.ports['F1A_In'].path + '.p']
        sys_dict[self.path + '.p_F1A_Out'] = sys_dict[self.ports['F1A_Out'].path + '.p']

        sys_dict[self.path+'.T_F2_In']=sys_dict[self.ports['F2_In'].path+'.T']
        sys_dict[self.path+'.T_F2_Out']=sys_dict[self.ports['F2_Out'].path+'.T']
        sys_dict[self.path+'.T_F2_dT']=sys_dict[self.ports['F2_Out'].path+'.T']-sys_dict[self.ports['F2_In'].path+'.T']

        sys_dict[self.path + '.dp'] = sys_dict[self.ports['F2_In'].path + '.p'] - sys_dict[self.ports['F2_Out'].path + '.p']
        sys_dict[self.path + '.dp_1A'] = sys_dict[self.ports['F1A_In'].path + '.p'] - sys_dict[
            self.ports['F1A_Out'].path + '.p']



        if self.type=='dual':
            sys_dict[self.path + '.dp_1B'] = sys_dict[self.ports['F1B_In'].path + '.p'] - sys_dict[
                self.ports['F1B_Out'].path + '.p']

            sys_dict[self.path+'.T_F1B_Out']=sys_dict[self.ports['F1B_Out'].path+'.T']
            sys_dict[self.path+'.T_F1B_In']=sys_dict[self.ports['F1B_In'].path+'.T']
            sys_dict[self.path + '.p_F1B_In'] = sys_dict[self.ports['F1B_In'].path + '.p']
            sys_dict[self.path + '.p_F1B_Out'] = sys_dict[self.ports['F1B_Out'].path + '.p']
            
class h_calc(BC.Link):
    def construct_Link(self,N_nodes,fac, **c):
        self.pipe1=c['pipe1']
        self.pipe2=c['pipe2']
        
        
        self.h_Flow=c['h_data']
        
        self.calc_funcs=[self.h_calc_func]
        
        self.Variables=[
                    {'name': 'N_Plates', 'unit': '1', 'type':'param', 'val':c['N_Plates']},
                    {'name': 'A', 'unit': '', 'type':'param', 'val':c['A']*fac},
                    {'name': 'h', 'unit': '', 'type':'param', 'val':100},
                    {'name': 'N_nodes', 'unit': '', 'type':'param', 'val':N_nodes}
                    ]
                    
    def h_calc_func(self):
        m_dot1=pipe1.m_dot
        m_dot2=pipe2.m_dot
        #print(m_dot1)
        #print(m_dot2)
        h_tot=interp_bilin(h_Flow,ln(abs(pipe1.m_dot+1e-3)/N_Plates),ln(abs(pipe2.m_dot+1e-3)/N_Plates))*A
        #print(h_tot)
        h=h_tot/(N_nodes+2)
        
class Thermal_Conductor_Linked(BC.Link):
    def construct_Link(self, m=10, T0=20, **c):
        self.side1=c['side1']
        self.side2=c['side2']
        self.hsource=c['hsource']
        
        self.calc_funcs=[self.Thermal_Conductor_diff_f]
        self.Variables=[
                    {'name': 'Q', 'unit': 'W', 'type':'param', 'val':0},
                    {'name': 'Q_ewma', 'unit': 'W', 'type':'state', 'val':0},
                    {'name': 'C', 'unit': 'W', 'type':'param', 'val': m*500},
                    {'name': 'T', 'unit': 'W', 'type': 'state', 'val': T0}
                    ]
       
    def Thermal_Conductor_diff_f(self):
        h=hsource.h
        Q1=h*(side1.T-T)
        Q2=h*(side2.T-T)
        Q = Q1
        T_dot = (Q1 + Q2)/C

        Q_ewma_dot=0.01*(Q/1000-Q_ewma)
        side1.H_dot=-Q1
        side2.H_dot=-Q2
        
class Pipe_Fix_Flow(BC.Link):
    def construct_Link(self, **c):
        self.side1=c['side1']
        self.side2=c['side2']
        self.flow=c['flow']
        
        self.calc_funcs=[self.Pipe_diff_f]

        self.Variables=[
                    
                    ]
                    
    def Pipe_diff_f(self):
        
        p_in=side1.p
        p_out=side2.p
        #print(p_in) 
        #print(p_out) 
        H_dot=flow.m_dot*((flow.m_dot>0)*side1.H/side1.m+(flow.m_dot<0)*side2.H/side2.m)
        side1.m_dot=-flow.m_dot
        side2.m_dot=flow.m_dot
        side1.H_dot=-H_dot
        side2.H_dot=H_dot
        #print(kV)
        
class m_dot_cal(BC.Link):
    def construct_Link(self,kV, **c):
        self.side1=c['side1']
        self.side2=c['side2']
        
        self.calc_funcs=[self.m_dot_calc_func]

        self.Variables=[
                    {'name': 'kV', 'unit': 'kg/s/sqrt(kPa)', 'type':'param', 'val':kV},
                    {'name': 'm_dot', 'unit': 'kg/s', 'type':'param', 'val':0},
                    ]
                    
    def m_dot_calc_func(self):
        dp=side1.p-side2.p
        #print(dp)
        m_dot=sign(dp)*sqrt(abs(dp))*kV    
        #print(m_dot)
        T_s1=side1.T
        T_s2=side2.T

       # print(T_s1)
        #print(T_s2)