import sim_components.generic.items as B
       
class Thermal_Conductor(B.Link):
    def construct_Link(self,h, **c):
        self.side1=c['side1']
        self.side2=c['side2']
        
        self.calc_funcs=[self.Thermal_Conductor_diff_f]
        self.Variables=[
                    {'name': 'Q', 'unit': 'W', 'type':'calc', 'val':0},
                    {'name': 'h', 'unit': 'W/K', 'type':'param', 'val':h},
                    {'name': 'Q_ewma', 'unit': 'W', 'type': 'state', 'val': 0}
                    ]
       
    def Thermal_Conductor_diff_f(self):
        Q=h*(side1.T-side2.T)
        side1.H_dot=-Q
        side2.H_dot=Q
        #Q_ewma_dot = 0.01 * (Q / 1000 - Q_ewma)

    
        
class Thermal_Mass(B.Node):
    def construct_Node(self,C, T0=20):
        
        self.calc_funcs=[self.Thermal_Mass_diff_f]
        self.Variables=[
                    {'name': 'H', 'unit': 'J', 'type':'state', 'val':C*(T0+273.15)},
                    {'name': 'T', 'unit': 'K', 'type':'param', 'val':T0},
                    {'name': 'C', 'unit': 'J/K', 'type':'param', 'val':C}
                    ]
        
        
    def Thermal_Mass_diff_f(self):
        #test
        self.T=self.H/self.C-273.15
        self.h = self.H/self.C*4189


class Thermal_Power(B.Node):
    def construct_Node(self,P=150000, T0=20,**c):
        
        self.calc_funcs=[self.Thermal_Power_diff_f]
        
        self.Variables=[
                    
                     {'name': 'P', 'unit': 'J/K', 'type':'param', 'val':P}
                    ]
        self.outlet=c['outlet']
        
    def Thermal_Power_diff_f(self):
        #test
        outlet.H_dot=P


class Thermal_Ground(B.Link):
    def construct_Link(self, h, T_Ground=0, **c):
        self.side1 = c['side1']


        self.calc_funcs = [self.Thermal_Conductor_diff_f]
        self.Variables = [
            {'name': 'Q', 'unit': 'W', 'type': 'calc', 'val': 0},
            {'name': 'h', 'unit': 'W/K', 'type': 'param', 'val': h},
            {'name': 'T_Ground', 'unit': 'oC', 'type': 'param', 'val': T_Ground},
            {'name': 'Q_ewma', 'unit': 'W', 'type': 'state', 'val': 0},
            {'name': 'E_loss', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'W_GWh', 'unit': 'GWh/W', 'type': 'param', 'val': 1.0 / 1e9 / 3600}
        ]

    def Thermal_Conductor_diff_f(self):
        Q = h * (side1.T - T_Ground)
        side1.H_dot = -Q
        #Q_ewma_dot = 0.01 * (Q / 1000 - Q_ewma)
        E_loss_dot = Q*W_GWh