import refprop as rp
import numpy as np
import copy
import math
import matplotlib.pyplot as plt
import pickle

def generate_liquid_properties(fluid_name):
    # Temperature 
    # - t -
    # (oC)	Dynamic Viscosity 
    # - µ -
    # (10-3 Pa s (N s/m2))	Kinematic Viscosity 
    # - ν -
    # (10-6 m2/s)
    # 0	1.787	1.787
    # 5	1.519	1.519
    # 10	1.307	1.307
    # 20	1.002	1.004
    # 30	0.798	0.801
    # 40	0.653	0.658
    # 50	0.547	0.553
    # 60	0.467	0.475
    # 70	0.404	0.413
    # 80	0.355	0.365
    # 90	0.315	0.326
    # 100	0.282	0.294
    if fluid_name == 'Water':
        T=(273.15+np.array([-20,-10,-5,0, 5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100])).tolist()
        v_dyn=[3.0,2.5,2,1.787,1.519,1.307,1.002,0.798,0.653,0.547,0.467,0.404,0.355,0.315,0.282]
        v_kin=[3.0,2.5,2,1.787,1.519,1.307,1.004,0.801,0.658,0.553,0.475,0.413,0.365,0.326,0.294]
        
        Cp=4177
        rho=992
    else:
        raise ValueError('Dont know the liquid: '+fluid_name)
    props={}
    props['rho']=rho
    props['Cp']=Cp
    props['T']=T
    props['v_dyn']=v_dyn
    props['v_kin']=v_kin
    props['liquid']=fluid_name
    
    return props
  

def store_Fluid_Properties(name, props, desc='', comm=''):
    print('Would you like to store as a configuration? Y(es)/N(o)')
    inp=input() 
    if inp=='Y':
        import Simulation_Store_MongoDB as Simulation_Store
        ss=Simulation_Store.Simulation_Store()
        c={'Name': name,'Description': desc,'Comment': comm,
            'Configuration': props}
            
            # 'Configuration': {'Type': HxType, 'h_data': {'h': h.tolist(), 'mflow_1':mdot_CW1_in_h.tolist(),'mflow_2':mdot_CW2_in_h.tolist()},
            # 'kV1_plate': knp1[0]/N_Plates_kV, 'kV1_Port':kp1[0], 'kV2_plate': knp2[0]/N_Plates_kV, 'kV2_Port':kp2[0], 'A_Plate':A_Plate, 'V1_Plate':0.134/1000, 'V2_Plate':0.195/2/1000
        #print(c)
        id=ss.store_Config(c)
        
        c2_obj=ss.get_Config_by_id(id).next()
        
        ss.close()
    else:
        print('Config not saved!')
    

if __name__ == '__main__':
    import BasicComponents as BC, Heat_Transfer as HT, Fluid_Flow as FF
    import EMB as EMB
    import Model_Tools as MT
    import Simulation_Store_MongoDB
    import Data_Regulator
    import Model_Encoder as ME


    
    
    CW='Water'
    print(CW)
    props=generate_liquid_properties(CW)
    store_Fluid_Properties(CW+'_4', props, desc='Properties for pure water')
    