#EMWH
import sim_components.generic.items as BC, sim_components.thermodynamics.Heat_Transfer as HT, sim_components.thermodynamics.Fluid_Flow as FF



#from String_Dual_Heat_Exchanger import String_Dual_Heat_Exchanger
#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class ST(BC.Subsystem):
    def construct_Subsystem(self, T0=20, **d):
        
        #d={'V_CW': 1,'h': 10000,'N_nodes': 3,'L_Pipe':1,'D_Pipe':0.07}
        CW=self.add('Water',FF.Liquid_Props,Config='Water_4')
        self.TC_paths=[]
        
        for i in range(0,d['N_nodes']):
            #Adding CW volume
            self.add('CW_'+str(i),FF.Volume,CW,d['V_CW']/d['N_nodes'],0,T0=T0, p0=100)
            
        for i in range(0,d['N_nodes']):   
            if i>0:
                #Linking nodes through thermal conductor
                self.add('Node_Conductor'+str(i),HT.Thermal_Conductor,d['h'],side1=self.items['CW_'+str(i-1)],side2=self.items['CW_'+str(i)])
                #self.TC_paths+=[CWTC.path+'.Q']
        
        for i in range(0,d['N_nodes']):
            if i>0:
                #Linking nodes through pipes
                self.add('Node_Flow'+str(i),FF.Pipe_Dim,CW,L=d['L_Pipe'], D=d['D_Pipe'],side1=self.items['CW_'+str(i-1)],side2=self.items['CW_'+str(i)])
                
        
        self.addPort('CW_In_1',self.items['CW_0'])   
        self.addPort('CW_Out_1',self.items['CW_'+str(d['N_nodes']-1)])
        
        self.addPort('CW_In_2',self.items['CW_'+str(d['N_nodes']-1)])            
        self.addPort('CW_Out_2',self.items['CW_0'])

        
        
    def output_(self, sys_dict):
        #Prim
        #sys_dict[self.gp('T_In_Prim_Step_1')]
        sys_dict[self.gp('T_CW_Node_0')]=sys_dict[self.gp('CW_0.T')]
        sys_dict[self.gp('T_CW_Node_1')]=sys_dict[self.gp('CW_1.T')]
        sys_dict[self.gp('T_CW_Node_2')]=sys_dict[self.gp('CW_2.T')]
        
        
    def print_output(self, t, sys_dict):
        pass