import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF

class cross_flow_element():

    def construct_(self, C_core):
        self.Variables = [

            {'name': 'H_in', 'unit': 'J', 'type': 'state', 'val': }
            {'name': 'H_out', 'unit': 'J', 'type': 'state', 'val':}
            {'name': 'H_core', 'unit': 'J', 'type': 'state', 'val':}
        ]
        #state H
    def calc(self):

        h_in = H_in/(V_in * rho_in)
        h_out = H_out / (V_out * rho_out)

        T_in = (h_in - x_in * h_we)/(c_pa+x_in * c_pw) - Abs_zero
        T_out = (h_out - x_out * h_we)/(c_pa+x_out * c_pw) - Abs_zero
        T_core = H_core / C_core - Abs_zero
        Q_in = (T_core - T_in)*k
        Q_out = (T_core - T_out)*k
        H_in_dot = (in_before.h - h) * m_dot_in + Q_in
        H_out_dot = (out_before.h - h) * m_dot_out + Q_out
        H_core_dot = -Q_in - Q_out


class cross_flow_heat_exchanger(BC.Subsystem):

    def construct_Subsystem(self, N_nodes_x=50, N_nodes_y=50,
                            in_total_width=1, out_total_width=1.5, stack_height=13, height_out_channel=5,
                            width_out_channel=0.0035, height_in_channel=0.0035, width_in_channel=0.004,
                            wall_thickness=0.003, heat_conductivity=0.21, density = 1.2
                            **c):

        n_in_channels_layer = in_total_width / (width_in_channel + wall_thickness)
        n_out_channels_layer = out_total_width / width_out_channel

        n_layers = stack_height / (height_in_channel + height_out_channel + wall_thickness)

        n_in_channels_total = n_in_channels_layer * n_layers/2
        n_out_channels_total = n_out_channels_layer * n_layers / 2

        d_hydraulic_in_channel = 2 * width_in_channel * height_in_channel / (width_in_channel + height_in_channel)
        d_hydraulic_out_channel = 2 * width_out_channel * height_out_channel / (width_out_channel + height_out_channel)




        for xi in range(N_nodes_x):

            for yi in range(N_nodes_y):
                self.add('in_' + str(xi) +'_' + str(yi), FF.Volume, F2, V2 / (self.N_nodes + 2), 0, T_F2)
                self.add('out_' + str(xi) +'_' + str(yi), FF.Volume, F2, V2 / (self.N_nodes + 2), 0, T_F2)
                self.add('core_' + str(xi) + '_' + str(yi), HT.Thermal_Mass, F2, V2 / (self.N_nodes + 2), 0, T_F2)





