#EMWH
import sim_components.generic.items as BC, sim_components.thermodynamics.LF_Pump_with_Map_P as LF_Pump_with_Map

import sim_components.thermodynamics.Heat_Exchanger_Nodes_Mean_p as MHX


import sim_components.thermodynamics.Fluid_Flow as FF
#from String_Dual_Heat_Exchanger import String_Dual_Heat_Exchanger
#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class EMHW(BC.Subsystem):
    def construct_Subsystem(self, **c):
        #DEFINE HX
        #HX1
        self.HX1=self.add('HX1',MHX.Heat_Exchanger,3, c['Plates_Step1'], c['F1'], c['F2'], c['T_F2'],c['T_F1'],c['q'], Config=c['Conf_Step1'],dual='single')
        
        #HX2
        
        self.HX2=self.add('HX2',MHX.Heat_Exchanger,3, c['Plates_Step2'], c['F1'], c['F2'], c['T_F2'],c['T_F1'],c['q'], Config=c['Conf_Step2'],dual='single')
        
        #HX3
        
        self.HX3=self.add('HX3',MHX.Heat_Exchanger,3, c['Plates_Step3'], c['F1'], c['F2'], 60,60,c['q'], Config=c['Conf_Step3'],dual='single')

        #DEFINE PRIMARY SIDE - EM side of EMHW
            #Step 1 - lowest temp


        f={'inlet': self.HX1.ports['F1A_Out'],'outlet': c['Step1_Prim_Out']}
        f.update({'Pump_Type':c['Pump_Step1_Pri'], 'Set_Speed':c['Pump_Step1_Speed'], 'kP': 0.00001})
        
        self.P1_Prim = self.add('P1_Prim', LF_Pump_with_Map.Pump_with_Map, **f)
                #Inlet will be a port directly to HX1
        self.addPort('Step1_Prim_In',self.HX1.ports['F1A_In'])

            # Step 2 - middle temp



        h={'inlet': self.HX2.ports['F1A_Out'],'outlet':  c['Step2_Prim_Out']}
        h.update({'Pump_Type':c['Pump_Step2_Pri'], 'Set_Speed':c['Pump_Step2_Speed'], 'kP': 0.00001})
        
        self.P2_Prim = self.add('P2_Prim', LF_Pump_with_Map.Pump_with_Map, **h)
            # Inlet will be a port directly to HX2

        self.addPort('Step2_Prim_In', self.HX2.ports['F1A_In'])

            # Step 3 - highest temp


        self.VS_Outlet_Vol=self.add('VS_Outlet_Vol',FF.Volume,c['F1'],.1,60)
        
        j={'inlet': self.HX3.ports['F1A_Out'],'outlet':  self.VS_Outlet_Vol}
        j.update({'Pump_Type':c['Pump_Step3_Pri'], 'Set_Speed':c['Pump_Step3_Speed'], 'kP': 0.00001})
        
        self.P3_Prim = self.add('P3_Prim', LF_Pump_with_Map.Pump_with_Map, **j)
        
        
        self.bp_VS=self.add('VS_Bypass',FF.ThreeWayValve_Regulated,c['F1'],3,.1,60,1,
            A=c['Step3_Prim_In'],
            B=self.VS_Outlet_Vol,
            C=self.HX3.ports['F1A_In'])
        
        self.addPort('Step3_Prim_Out',self.VS_Outlet_Vol)

        self.HW_Final_EM = self.add('Step3_Prim_EM', FF.EnergyMeter, inlet=self.HX3.ports['F1A_Out'], outlet=self.bp_VS.Vol, pipe=self.bp_VS.pipe_C)

        # DEFINE SECONDARY SIDE - Customer side of EMHW
        self.addPort('Step1_Sec_In', self.HX1.ports['F2_In'])

        #self.Pipe_5 = self.add('Pipe_5', FF.Pipe_Dim, c['F1'], L=2, D=0.065,
        self.Pipe_5 = self.add('Pipe_5', FF.Pipe, .25,
                               side1=self.HX1.ports['F2_Out'],
                               side2=self.HX2.ports['F2_In'])

        #self.Pipe_6 = self.add('Pipe_6', FF.Pipe_Dim, c['F1'], L=2, D=0.065,
        self.Pipe_6 = self.add('Pipe_6', FF.Pipe_Check,.25,
                               inlet=self.HX2.ports['F2_Out'],
                               outlet=self.HX3.ports['F2_In'])

        m = {'inlet': c['Hot_Water_Return'], 'outlet': self.HX3.ports['F2_In']}
        m.update({'Pump_Type': 'Grundfos_Magma3_50-60', 'Set_Speed': 1, 'kP': 0.000003})
        self.P_VVC = self.add('P_VVC', LF_Pump_with_Map.Pump_with_Map, simple=True, **m)

        self.addPort('Step3_Sec_Out', self.HX3.ports['F2_Out'])



    def output_(self, sys_dict):
        #Prim
        # sys_dict[self.gp('T_In_Prim_Step_1')]=sys_dict[self.Pipe_1.gp('T_Outlet')]
        sys_dict[self.gp('T_Out_Prim_Step_1')]=sys_dict[self.HX1.gp('T_F1A_Out')]
        
        # sys_dict[self.gp('T_In_Prim_Step_2')]=sys_dict[self.Pipe_2.gp('T_Outlet')]
        sys_dict[self.gp('T_Out_Prim_Step_2')]=sys_dict[self.HX2.gp('T_F1A_Out')]
        
       
        sys_dict[self.gp('T_Out_Prim_Step_3')]=sys_dict[self.HX3.gp('T_F1A_Out')]
        
        #Sec
        # sys_dict[self.gp('T_In_Sec_Step_1')]=sys_dict[self.Pipe_4.gp('T_Outlet')]
        sys_dict[self.gp('T_Out_Sec_Step_1')]=sys_dict[self.HX1.gp('T_F2_Out')]
        
        sys_dict[self.gp('T_In_Sec_Step_2')]=sys_dict[self.HX1.gp('T_F2_Out')]
        sys_dict[self.gp('T_Out_Sec_Step_2')]=sys_dict[self.HX2.gp('T_F2_Out')]
        
        sys_dict[self.gp('T_In_Sec_Step_3')]=sys_dict[self.HX2.gp('T_F2_Out')]
        sys_dict[self.gp('T_Out_Sec_Step_3')]=sys_dict[self.HX3.gp('T_F2_Out')]
        
        #Heat transfer
        sys_dict[self.gp('PowerStep_1')]=sys_dict[self.HX1.gp('Q')]
        sys_dict[self.gp('PowerStep_2')]=sys_dict[self.HX2.gp('Q')]
        sys_dict[self.gp('PowerStep_3')]=sys_dict[self.HX3.gp('Q')]
        
        #Flow
        sys_dict[self.gp('Flow_P1')]=sys_dict[self.P1_Prim.gp('m_dot')]
        sys_dict[self.gp('Flow_P2')]=sys_dict[self.P2_Prim.gp('m_dot')]
        sys_dict[self.gp('Flow_P3')]=sys_dict[self.P3_Prim.gp('m_dot')]
        # sys_dict[self.gp('Flow_P1_Sec')]=sys_dict[self.P1_Sec.gp('m_dot')]
        
        # self.PowerStep_1=sys_dict['EMHW_stub.EMHW.HX1.Q']
        # self.PowerStep_2=sys_dict['EMHW_stub.EMHW.HX2.Q']
        # self.PowerStep_3=sys_dict['EMHW_stub.EMHW.HX3.Q']
        
        
    def print_output(self, t, sys_dict):
        pass