#EMWH
import sim_components.generic.items as BC, sim_components.thermodynamics.LF_Pump_with_Map_P as LF_Pump_with_Map

import sim_components.thermodynamics.Heat_Exchanger_Nodes_Mean_p as MHX


import sim_components.thermodynamics.Fluid_Flow as FF
#from String_Dual_Heat_Exchanger import String_Dual_Heat_Exchanger
#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class EMHW(BC.Subsystem):
    def construct_Subsystem(self, has_Subcooler = True, has_step2_pump=True, simple_pumps=False, step_1_1_pri_in=None,step_1_1_pri_out=None, **c):
        print()
        print('c')
        print(c)
        print()
        #DEFINE HX
        #HX1
        T0 = 60

        self.VV = c['VV']
        self.has_subcooler = has_Subcooler
        self.has_step2_pump = has_step2_pump
        if has_Subcooler:

            self.HX1=self.add('HX1',MHX.Heat_Exchanger,4, c['Plates_Step1'], c['F1'], c['F2'], c['T_F2'],c['T_F1'],c['q'], Config=c['Conf_Step1'],dual='single')

            if step_1_1_pri_in:
                self.HX1_1 = self.add('HX1_1', MHX.Heat_Exchanger, 4, c['Plates_Step1'], c['F1'], c['F2'], c['T_F2'],
                                    c['T_F1'], c['q'], Config=c['Conf_Step1'], dual='single')
        
            #HX2
        
            self.HX2=self.add('HX2',MHX.Heat_Exchanger,4, c['Plates_Step2'], c['F1'], c['F2'], c['T_F2'],c['T_F1'],c['q'], Config=c['Conf_Step2'],dual='single')
        
        #HX3
        
        self.HX3=self.add('HX3',MHX.Heat_Exchanger,4, c['Plates_Step3'], c['F1'], c['F2'], T0,T0,c['q'], Config=c['Conf_Step3'],dual='single')

        #DEFINE PRIMARY SIDE - EM side of EMHW
            #Step 1 - lowest temp

        if has_Subcooler:

            f={'inlet': self.HX1.ports['F1A_Out'],'outlet': c['Step1_Prim_Out']}
            f.update({'Pump_Type':c['Pump_Step1_Pri'], 'Set_Speed':c['Pump_Step1_Speed'], 'kP': 0.00001})

            self.P1_Prim = self.add('P1_Prim', LF_Pump_with_Map.Pump_with_Map, simple=simple_pumps, **f)
                    #Inlet will be a port directly to HX1
            #self.addPort('Step1_Prim_In',self.HX1.ports['F1A_In'])

                # Step 2 - middle temp

            if step_1_1_pri_in:
                f = {'inlet': self.HX1_1.ports['F1A_Out'], 'outlet': step_1_1_pri_out}
                f.update({'Pump_Type': c['Pump_Step1_Pri'], 'Set_Speed': c['Pump_Step1_Speed'], 'kP': 0.00001})

                self.P1_1_Prim = self.add('P1_1_Prim', LF_Pump_with_Map.Pump_with_Map, simple=simple_pumps, **f)


            if has_step2_pump:

                h={'inlet': self.HX2.ports['F1A_Out'],'outlet':  c['Step2_Prim_Out']}
                h.update({'Pump_Type':c['Pump_Step2_Pri'], 'Set_Speed':c['Pump_Step2_Speed'], 'kP': 0.00001})

                self.P2_Prim = self.add('P2_Prim', LF_Pump_with_Map.Pump_with_Map, simple=simple_pumps, **h)
                    # Inlet will be a port directly to HX2
            else:
                self.P2_Prim = self.add('P2_Prim', FF.Pipe, kV=10,
                                       side1 = self.HX2.ports['F1A_Out'],
                                    side2 =  c['Step2_Prim_Out'])

            #.addPort('Step2_Prim_In', self.HX2.ports['F1A_In'])

                # Step 3 - highest temp


        self.VS_Outlet_Vol=self.add('VS_Outlet_Vol',FF.Volume,c['F1'],.1,60)
        
        j={'inlet': self.HX3.ports['F1A_Out'],'outlet':  self.VS_Outlet_Vol}
        j.update({'Pump_Type':c['Pump_Step3_Pri'], 'Set_Speed':c['Pump_Step3_Speed'], 'kP': 0.00001})
        
        self.P3_Prim = self.add('P3_Prim', LF_Pump_with_Map.Pump_with_Map, simple=simple_pumps,**j)


        self.bp_VS=self.add('VS_Bypass',FF.ThreeWayValve_Regulated,c['F1'],3,.1,60,1,
            A=c['Step3_Prim_In'],
            B=self.VS_Outlet_Vol,
            C=self.HX3.ports['F1A_In'])
        
        #self.addPort('Step3_Prim_Out',self.VS_Outlet_Vol)

        self.HW_Final_EM = self.add('Step3_Prim_EM', FF.EnergyMeter, inlet=self.HX3.ports['F1A_Out'], outlet=self.bp_VS.Vol, pipe=self.bp_VS.pipe_C)


        # DEFINE SECONDARY SIDE - Customer side of EMHW

        if has_Subcooler:
            if step_1_1_pri_in:
                self.Pipe_1_1_sec = self.add('Pipe_1_1_sec', FF.Pipe, .25,
                                       side1=self.HX1.ports['F2_Out'],
                                       side2=self.HX1_1.ports['F2_In'])
            #self.Pipe_5 = self.add('Pipe_5', FF.Pipe_Dim, c['F1'], L=2, D=0.065,
            self.Pipe_5 = self.add('Pipe_5', FF.Pipe, .25,
                                   side1=self.HX1_1.ports['F2_Out'] if step_1_1_pri_in else self.HX1.ports['F2_Out'],
                                   side2=self.HX2.ports['F2_In'])

            #self.Pipe_6 = self.add('Pipe_6', FF.Pipe_Dim, c['F1'], L=2, D=0.065,
            self.Pipe_6 = self.add('Pipe_6', FF.Pipe_Check,.25,
                                   inlet=self.HX2.ports['F2_Out'],
                                   outlet=self.HX3.ports['F2_In'])

        m = {'inlet': self.VV.Return, 'outlet': self.HX3.ports['F2_In']}
        m.update({'Pump_Type': 'Grundfos_Magma3_50-60', 'Set_Speed': 1, 'kP': 0.000003})
        self.P_VVC = self.add('P_VVC', LF_Pump_with_Map.Pump_with_Map, simple=True, **m)




        self.add('VV_Supply_Pipe', FF.Pipe, kV=.5, side1=self.HX3.ports['F2_Out'],
                 side2=self.VV.Supply)

        self.VV_Cold_Pipe = self.add('VV_Cold_Pipe', FF.Pipe_Fixed_Massflow, m_dot=0, side1=self.VV.Cold,
                 side2=self.HX1.ports['F2_In'] if has_Subcooler else self.HX3.ports['F2_In'])

        #self.VV_Cold_Pipe

        # Connections SCC - EMHW
        if has_Subcooler:
            self.add('Step2_Prim_Pipe', FF.Pipe, kV=1, side1=c['Step2_Prim_In'],
                     side2=self.HX2.ports['F1A_In'])

            self.add('Step1_Prim_Pipe', FF.Pipe_Check, kV=1, inlet=c['Step1_Prim_In'],
                     outlet=self.HX1.ports['F1A_In'])


            if step_1_1_pri_in:
                self.add('Step1_1_Prim_Pipe', FF.Pipe_Check, kV=1, inlet=step_1_1_pri_in,
                         outlet=self.HX1_1.ports['F1A_In'])

        # Connections EMHW Prim

        self.add('Step3_Prim_Pipe', FF.Pipe, kV=3, side1=self.VS_Outlet_Vol,
                 side2=c['Step3_Prim_Out'])


    #def output_(self, sys_dict):

        #if self.has_Subcooler:
        #Prim
        # sys_dict[self.gp('T_In_Prim_Step_1')]=sys_dict[self.Pipe_1.gp('T_Outlet')]
        #sys_dict[self.gp('T_Out_Prim_Step_1')]=sys_dict[self.HX1.gp('T_F1A_Out')]

        # sys_dict[self.gp('T_In_Prim_Step_2')]=sys_dict[self.Pipe_2.gp('T_Outlet')]
        #sys_dict[self.gp('T_Out_Prim_Step_2')]=sys_dict[self.HX2.gp('T_F1A_Out')]
        
       
        #sys_dict[self.gp('T_Out_Prim_Step_3')]=sys_dict[self.HX3.gp('T_F1A_Out')]
        
        #Sec
        # sys_dict[self.gp('T_In_Sec_Step_1')]=sys_dict[self.Pipe_4.gp('T_Outlet')]
        #sys_dict[self.gp('T_Out_Sec_Step_1')]=sys_dict[self.HX1.gp('T_F2_Out')]
        
        #sys_dict[self.gp('T_In_Sec_Step_2')]=sys_dict[self.HX1.gp('T_F2_Out')]
        #sys_dict[self.gp('T_Out_Sec_Step_2')]=sys_dict[self.HX2.gp('T_F2_Out')]
        
        #sys_dict[self.gp('T_In_Sec_Step_3')]=sys_dict[self.HX2.gp('T_F2_Out')]
        #sys_dict[self.gp('T_Out_Sec_Step_3')]=sys_dict[self.HX3.gp('T_F2_Out')]
        
        #Heat transfer
        #sys_dict[self.gp('PowerStep_1')]=sys_dict[self.HX1.gp('Q')]
        #sys_dict[self.gp('PowerStep_2')]=sys_dict[self.HX2.gp('Q')]
        #sys_dict[self.gp('PowerStep_3')]=sys_dict[self.HX3.gp('Q')]
        
        #Flow
        #sys_dict[self.gp('Flow_P1')]=sys_dict[self.P1_Prim.gp('m_dot')]
        #sys_dict[self.gp('Flow_P2')]=sys_dict[self.P2_Prim.gp('m_dot')]
        #sys_dict[self.gp('Flow_P3')]=sys_dict[self.P3_Prim.gp('m_dot')]
        # sys_dict[self.gp('Flow_P1_Sec')]=sys_dict[self.P1_Sec.gp('m_dot')]
        
        # self.PowerStep_1=sys_dict['EMHW_stub.EMHW.HX1.Q']
        # self.PowerStep_2=sys_dict['EMHW_stub.EMHW.HX2.Q']
        # self.PowerStep_3=sys_dict['EMHW_stub.EMHW.HX3.Q']
        
        
    #def print_output(self, t, sys_dict):
       # pass