import sim_components.generic.items as B
import numpy as np
from scipy.interpolate import interp1d

class Static_Regulator(B.Item):
    def construct_Item(self, static_data, dt=3600, interp_var='t'):


        self.ops=[]
        #print(static_data)
        for group, data in static_data.items():

            t=np.array(data['t'],dtype=np.float64)
            #print('min t: ',min(t),' max t: ',max(t))
            for k, v in data['tags'].items():

                assert len(t)==len(v), "Detected tag data with different length than its interpolator t, len t: "+str(len(t))+ " length tag data: "+str(len(v))
                #print(set([int(i*100) for i in (t[:-2]-t[1:-1])]))
                if not len(set(t[1:]-t[:-1]))==1:
                    print('Warning creating regular grid with dt: ',dt,' s spacing!')
                    v_interp = interp1d(t, v)
                    t_interval = max(t)-min(t)
                    n = int(np.ceil(t_interval/dt))
                    dt = t_interval/n
                    t_int = np.array(range(n+1))*dt
                    v = v_interp(t_int)


                #print('this is used now!')
                #scaled_data=np.concatenate([[len(t), min(t)-1,max(t)-1], t,np.array(v,dtype=np.float64)])
                #print('t', ': max - ', max(t), ' min - ', min(t))
                #print(k,': max - ',max(v), ' min - ',min(v))
                #print()
                    scaled_data = np.concatenate([[len(t_int), min(t_int), max(t_int)], t_int, np.array(v, dtype=np.float64)])
                else:
                    scaled_data = np.concatenate([[len(t), min(t), max(t)], t, np.array(v, dtype=np.float64)])
                #print('tag: ',k,' max: ', max(np.array(v,dtype=np.float64)), ' min: ',min(np.array(v,dtype=np.float64)))


                #scaled_data = np.concatenate([[len(t), min(t) - 1, max(t) - 1], t,v])
                #print(tag[0]+': ',min(np.array(tag[1],dtype=np.float64)),max(np.array(tag[1],dtype=np.float64)))
                op={'path':'abs','source': 'Static_Regulator', 'line': 0, 'target': k, 'func': 'interp_lin', 'args': [scaled_data,interp_var]}
            
                self.ops+=[op]

