import sim_components.generic.items as B
import sim_components.thermodynamics.Fluid_Flow as FF
import numpy as np

class Connector(B.Subsystem):

    def construct_Subsystem(self,**c):
        self.add_var('m_dot', val=0)

        self.add_var('H_dot')
        self.add_var('Cp', c, val=4196)

        self.add_var('h', c, val=0)
        self.add_var('T', c, val=20)

class Volume(B.Node):

    def construct_Node(self, Fluid, V=1, T0=20, rho0=1000):
        m=rho0*V
        H0=(T0+273.15)*m*Fluid.Cp
        self.add_var('T', val=T0)
        self.add_var('V', val=V)
        self.add_var('Cp', val=Fluid.Cp)
        self.add_var('H', vartype='state', val=H0)
        self.add_var('m', val=rho0*V)
        self.add_var('h', val=H0/m)
        self.calc_funcs.append(self.diff)

    def diff(self):
        h = H / m
        T =  h / Cp - 273.15


class Heat_Exchanger(B.Subsystem):

    def construct_Subsystem(self,
                            **c):

        self.pri = c['pri']
        self.sec = c['sec']

        self.add_var('eff',c, val=0.95)
        self.add_var('P', c, val=0)

        self.calc_funcs.append(self.diff)

    def diff(self):
        #T_sec_out = pri.m_dot * pri.Cp / (sec.m_dot * sec.Cp)* eff *(pri.T - sec.T)
        T_pri_out = pri.T - eff * (pri.T - sec.T)

        P = (T_pri_out - pri.T ) * pri.m_dot * pri.Cp * (pri.m_dot>0)*(sec.m_dot>0)


        pri.H_dot = pri.h * pri.m_dot + P


        sec.H_dot = sec.h * sec.m_dot - P


class Consumer(B.Subsystem):

    def construct_Subsystem(self, pri, fluid_sec, P=0, V=0.1, T0=20, **c):
        self.add_var('P',val=P)
        self.add_var('m_dot',c, val=0)
        self.add_var('m_dot_bleed', val=0.1)
        self.fluid_sec = fluid_sec
        self.sec = self.add('sec', Connector, Cp=fluid_sec.Cp)
        self.pri = pri

        self.Supply = self.add('Supply', Volume, fluid_sec, V, T0)
        self.Return = self.add('Return', Volume, fluid_sec, V, T0)

        self.HX = self.add('HX', Heat_Exchanger, pri=self.pri, sec=self.sec)

        self.add_var('dT',c,val=5)
        self.add_var('P', c, val=P)

        self.calc_funcs.append(self.diff)

    def diff(self):
        sec.m_dot = abs(P / fluid_sec.Cp /dT) + m_dot_bleed
        pri.m_dot = m_dot
        sec.Cp = fluid_sec.Cp
        sec.h = Return.h
        sec.T = Return.T

        #first part is from HX second part is consumption
        H_dot = sec.m_dot * (Supply.h - sec.h)

        Return.H_dot = H_dot + P
        Supply.H_dot = sec.H_dot - sec.m_dot * Supply.h

class KB_Hub(B.Subsystem):

    def construct_Subsystem(self, fluid, V=.1, T0=0, Heating=0, **c):

        self.KB = self.add('KB',Connector)
        self.CS = self.add('CS', Connector)
        self.BHS = self.add('BHS', Connector)


        self.Supply = self.add('Supply',Volume,fluid,V,T0)
        self.Return = self.add('Return', Volume, fluid, V, T0)
        self.Return_BHS = self.add('Return_BHS', Volume, fluid, V, T0)

        self.add_var('Heating', val=Heating)

        self.calc_funcs.append(self.diff)

    def diff(self):
        #Heating
        KB.h = Supply.h
        KB.T = Supply.T

        BHS.h = Return_BHS.h
        BHS.T = Return_BHS.T

        CS.h = Return.h
        CS.T = Return.T

        BHS.m_dot =  KB.m_dot * (Heating<1) + CS.m_dot - KB.m_dot * (Heating>0)

        Supply_Return_BHS_m_dot = BHS.m_dot - KB.m_dot

        Return_Supply_m_dot = BHS.m_dot - CS.m_dot + KB.m_dot * (Heating>0)

        Supply_Return_H_dot =  Return_Supply_m_dot * ((Return_Supply_m_dot<0)*Supply.h - (Return_Supply_m_dot>0)*Return.h)

        Return_BHS.H_dot = -BHS.m_dot * Return_BHS.h + KB.H_dot * (Heating < 1) +  Supply_Return_BHS_m_dot * Supply.h
        Return.H_dot = BHS.H_dot - CS.m_dot * Return.h + Supply_Return_H_dot + KB.H_dot * (Heating > 0)
        Supply.H_dot = CS.H_dot  - KB.m_dot * Supply.h  - Supply_Return_H_dot - Supply_Return_BHS_m_dot * Supply.h
        #Heating!

        #m_dot_Supply_Return = CS.m_dot - BHS.m_dot - KB.m_dot
        #H_dot_Supply_Return = m_dot_Supply_Return * ((m_dot_Supply_Return>0)*Supply.h + (m_dot_Supply_Return<0)*Return.h)
        #m_dot_Return_BHS_Return = 0
        #m_dot_Supply_Return_BHS = BHS.m_dot


        #Cooling
        #m_dot_Supply_Return = KB.m_dot - CS.m_dot
        #m_dot_Return_BHS_Return = BHS.m_dot - CS.m_dot + m_dot_Supply_Return
        #m_dot_Supply_Return_BHS = 0

        #Supply.H_dot = CS.H_dot + H_dot_Supply_Return - KB.m_dot*Supply.h
        #Return.H_dot = - CS.m_dot*Return.h - H_dot_Supply_Return + BHS.H_dot

class VS_Hub(B.Subsystem):

    def construct_Subsystem(self, fluid, V=1, T0=0):

        self.VS = self.add('VS',Connector)
        self.HS = self.add('HS', Connector)
        self.BHS = self.add('BHS', Connector)


        self.Supply = self.add('Supply',Volume,fluid,V=V, T0=T0)
        self.Return = self.add('Return', Volume, fluid, V=V, T0=T0)

        self.calc_funcs.append(self.diff)

    def diff(self):
        #Heating
        BHS.m_dot = 1 +0
        #VS.m_dot=1
        VS.h = Supply.h
        VS.T = Supply.T

        BHS.h = Supply.h
        BHS.T = Supply.T

        HS.h = Return.h
        HS.T = Return.T

        Supply_Return_m_dot = -VS.m_dot - BHS.m_dot + HS.m_dot
        Supply_Return_H_dot = ((Supply_Return_m_dot>0)*Supply.h + (Supply_Return_m_dot<0)*Return.h)*Supply_Return_m_dot

        Supply.H_dot =  HS.H_dot - Supply_Return_H_dot - VS.m_dot*Supply.h - BHS.m_dot*Supply.h
        Return.H_dot =  -HS.m_dot*Return.h + VS.H_dot + BHS.H_dot + Supply_Return_H_dot

from sim_components.energy_storage.borehole_storage import BoreholeStorageExchanger_Scaling
class BHS_HX(B.Subsystem):
    def construct_Subsystem(self, fluid, N_boreholes=63, **c):

        self.add_var('H_dot')
        self.add_var('h')
        self.add_var('m_dot', val=0)
        self.add_var('T', val=0)

        self.BHS_HX=self.add('BHS_HX', BoreholeStorageExchanger_Scaling, inlet=self, outlet=self, pump=self, N_boreholes=N_boreholes, L_borehole=250)

        self.calc_funcs.append(self.diff)

    def diff(self):

        H_dot = h * m_dot - BHS_HX.P


class BHS_Hub(B.Subsystem):

    def construct_Subsystem(self, fluid, KB_Connector, VS_Connector, T0=0, V=.1, N_boreholes=63,  **c):
        self.KB = KB_Connector
        self.VS = VS_Connector

        self.add_var('Active_m_dot', c, val=0)

        self.BHS = self.add('BHS', BHS_HX, fluid, N_boreholes=N_boreholes)

        self.Supply = self.add('Supply', Volume, fluid, V, T0)
        self.Return = self.add('Return', Volume, fluid, V, T0)


        self.Active_In = self.add('Active_In', Volume, fluid, V, T0)
        self.Active_Out = self.add('Active_Out', Volume, fluid, V, T0)

        self.BHS_In = self.add('BHS_In', Volume, fluid, V, T0)
        self.BHS_Out = self.add('BHS_Out', Volume, fluid, V, T0)

        self.Active = self.add('Active', Connector)

        self.HX = self.add('HX', Heat_Exchanger, pri=self.Active, sec=self.VS)

        self.calc_funcs.append(self.diff)

    def diff(self):

        #BHS.m_dot = 1 + 0

        Active.m_dot = Active_m_dot
        BHS.m_dot = KB.m_dot + Active.m_dot
        Active.h = Active_In.h
        Active.T = Active_In.T
        BHS.h = BHS_In.h
        BHS.T = BHS_In.T
        #KB.h = Supply.h

        Return_Supply_m_dot = KB.m_dot - BHS.m_dot
        Return_Supply_H_dot = Return_Supply_m_dot * ((Return_Supply_m_dot>0) * Return.h + (Return_Supply_m_dot<0) * Supply.h)
        Active_In_Active_Out_m_dot = BHS.m_dot - Active.m_dot

        KB.H_dot = Supply.h * KB.m_dot

        BHS_In.H_dot = BHS.m_dot * (Active_Out.h - BHS_In.h)
        BHS_Out.H_dot = BHS.H_dot - BHS.m_dot * BHS_Out.h
        Supply.H_dot = BHS.m_dot * BHS_Out.h + Return_Supply_H_dot - KB.H_dot
        Return.H_dot = KB.m_dot*KB.h - BHS.m_dot * Return.h - Return_Supply_H_dot



        Active_In_Out_H_dot = ((Active_In_Active_Out_m_dot > 0)* Active_In_Active_Out_m_dot * Active_In.h + (Active_In_Active_Out_m_dot < 0) * Active_In_Active_Out_m_dot * Active_Out.h)

        Active_In.H_dot = BHS.m_dot * Return.h - Active_In_Out_H_dot - Active.m_dot * Active_In.h
        Active_Out.H_dot = -BHS.m_dot * Active_Out.h + Active_In_Out_H_dot + Active.H_dot

class HP(B.Subsystem):
    def construct_Subsystem(self, Fluid_KB, Fluid_VS, N_comp, KB_Connector, VS_Connector, State1=0, State2=0, dT_Super=6, ** c):

        self.Fluid_KB = Fluid_KB
        self.Fluid_VS = Fluid_VS

        if 'dT_Super' in c:
            dT_Super = c['dT_Super']

        self.calc_funcs.append(self.diff)

        self.Variables = [
            {'name': 'state', 'unit': '', 'type': 'state', 'val': 0},
            {'name': 'dT_Super', 'unit': 'K', 'type': 'param', 'val': dT_Super},
            {'name': 'State1', 'unit': '', 'type': 'param', 'val': State1},
            {'name': 'State2', 'unit': '', 'type': 'param', 'val': State2},
            {'name': 'P_ewma', 'unit': '', 'type': 'state', 'val': 1},
            {'name': 'Energy', 'unit': 'MJ', 'type': 'state', 'val': 0},
            {'name': 'N_comp', 'unit': '1', 'type': 'param', 'val': N_comp},
            {'name': 'dT_condenser_subcool', 'unit': '1', 'type': 'param', 'val': 3},
            {'name': 'm_dot_water', 'unit': '1', 'type': 'param', 'val': 15},
        ]

        self.m_dot_poly = np.array(c['polynom_m_dot'], dtype=np.float32)
        self.power_poly = np.array(c['polynom_power'], dtype=np.float32)
        self.Q_poly = np.array(c['polynom_Q'], dtype=np.float32)

        print(self.Q_poly)


        #self.Evap_Connector = self.add('Evap_Connector', Connector, Cp=Fluid_KB.Cp)
        #self.Cond_Connector = self.add('Cond_Connector', Connector, Cp=Fluid_VS.Cp)

        self.KB = KB_Connector
        self.VS = VS_Connector

    def diff(self):

        T_Evap = KB.T - dT_Super
        T_Cond = VS.T + dT_condenser_subcool

        State1_in = (State1 > 0) * State1 * (State1 <= 1) + (State1 > 1)
        State2_in = (State2 > 0) * State2 * (State2 <= 1) + (State2 > 1)
        state_set = ((State1_in + State2_in) * (State1_in + State2_in <= N_comp) + (State1_in + State2_in > N_comp) * N_comp)*(T_Cond<60)

        state_dot = (state_set  - state)*0.01

        Power_Heat = calc_poly2x3(Q_poly, T_Evap, T_Cond) * state#* (T_Cond<60)

        Power = calc_poly2x3(power_poly, T_Evap, T_Cond) * state #* (T_Cond<60)
        m_dot = calc_poly2x3(m_dot_poly, T_Evap, T_Cond) * state #* (T_Cond<60)
        Power = Power * (Power >= 0)
        P = Power * 0.93
        P_ewma_dot = 0.1 * (Power / 1000 - P_ewma)
        Energy_dot = Power / 1e6

        VS.m_dot = (State1_in+State2_in)*m_dot_water
        VS.H_dot = Power_Heat + P + VS.h * VS.m_dot
        KB.m_dot = (State1_in+State2_in)*m_dot_water
        KB.H_dot = -Power_Heat + KB.h * KB.m_dot


class Energy_System(B.Subsystem):
    def construct_Subsystem(self):
        self.Brine = self.add('Brine', FF.Liquid_Props, Config='Water_4')
        self.Water = self.add('Water', FF.Liquid_Props, Config='Water_4')

        self.KB_hub = self.add('KB_hub', KB_Hub, fluid=self.Brine, V=.1, T0=5, Heating=0)
        self.VS_hub = self.add('VS_hub', VS_Hub, fluid=self.Water, V=.1, T0=20)

        self.BHS = self.add('BHS', BHS_Hub, fluid=self.Brine, V=.1, KB_Connector=self.KB_hub.BHS, VS_Connector=self.VS_hub.BHS, N_boreholes=10)

        self.KB = self.add('KB', Consumer, self.KB_hub.KB, fluid_sec=self.Brine, P=0, dT=5, T0=5, m_dot=0)
        self.VS = self.add('VS', Consumer, self.VS_hub.VS, fluid_sec=self.Water, P=-50000, dT=5, T0=30, m_dot=1)

        self.HP = self.add('HP', HP, self.Brine, self.Water, 1, self.KB_hub.CS, self.VS_hub.HS, State1 = 1, State2 = 0, dT_Super = 6, Config='GSD60235VA_Poly')





