import sim_components.generic.items as BC

import sim_components.machines.EM_System_Parallel as EM_System_Parallel
import sim_components.thermodynamics.Fluid_Flow as FF


#from String_Dual_Heat_Exchanger import String_Dual_Heat_Exchanger
#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class Stub(BC.Subsystem):
    def construct_Subsystem(self, inputs, *Args, **Kwargs):

        CW = self.add('Water', FF.Liquid_Props, Config='Water_4')

        #Make reservoirs for heating system, chilled water and hot water  - pumps are inside EM
        V_HS = 400/2/4.187/2/1000*300
        #self.Re_Heating_system = self.add('Re_Heating_system', FF.Reservoir, CW, T0 = inputs.Heating_System_Temperature - inputs.Heating_System_Return_dT)
        self.Re_Heating_system = self.add('Re_Heating_system', FF.Volume, CW, 10, 0, T0 = inputs.Heating_System_Temperature-inputs.Heating_System_Return_dT)

        self.Re_Chilled_system = self.add('Re_Chilled_system', FF.Reservoir, CW, T0 = inputs.Chilled_System_Temperature)

        #self.Re_Hot_Water_system = self.add('Re_Hot_Water_system', FF.Reservoir, CW, T0 = inputs.Hot_Water_Temperature - inputs.Hot_Water_Return_dT)
        self.Re_Hot_Water_system = self.add('Re_Hot_Water_system',  FF.Volume, CW, 1, 0, T0=inputs.Hot_Water_Temperature)

        self.Re_Cold_Water_supply = self.add('Re_Cold_Water_supply', FF.Reservoir, CW, T0=inputs.Cold_Water_Temperature)

        #Configure EM
        EM_conf={
            'Conf_EMA': inputs.EM.configuration['Conf_EMA'],
            'Conf_EMB': inputs.EM.configuration['Conf_EMB'],
            'Conf_EMHW': inputs.EM.configuration['Conf_EMHW'],
            'N_EMA': inputs.EM.configuration['N_EMA']

                 }

        #Configure connections to EM
        EM_conf.update({
            'CW': CW,
            'Chilled_Water_Inlet': self.Re_Chilled_system,
            'Chilled_Water_Outlet': self.Re_Chilled_system,
            'Heating_System_Inlet': self.Re_Heating_system,
            'Heating_System_Outlet': self.Re_Heating_system,
            'Cold_Water_Inlet': self.Re_Cold_Water_supply,
            'Hot_Water_Return': self.Re_Hot_Water_system,
            'Hot_Water_Outlet': self.Re_Hot_Water_system,
        })

        self.EM=self.add('EM', EM_System_Parallel.EM_System, **EM_conf)
        #1self.EM = self.add('EM', EM_System.EM_System, **EM_conf)

        self.P_HS=inputs.Heating_System_Power
        self.F_HW = inputs.Hot_Water_Flow




        #self.add('EM_Reg', EM_regulator, self, T_HS=inputs.Heating_System_Temperature+273.15)
        self.dT_CS = inputs.Chilled_System_Return_dT
        self.dT_HS = inputs.Heating_System_Return_dT

        regulator_conf={
            'T_HS': inputs.Heating_System_Temperature,
            'T_HW': inputs.Hot_Water_Temperature,
            'P_HS': inputs.Heating_System_Power,
            'F_HW': self.F_HW,
            'dT_HS': self.dT_HS,
            'dT_CS': self.dT_CS,

            'rating': int(inputs.Rating==True)
        }



        self.Reg=self.EM_Reg = self.add('EM_Reg',EM_regulator,inputs.EM.configuration['N_EMA'], self, **regulator_conf)

    def output_(self, sys_dict):
        pass

    def Stop_Func(self):
        #Need to update for real stop condition!
        Stop_Crit = 1e-4 / 3600
        Stop_Value = 1
        Stop_Cond = (Stop_Value <= Stop_Crit)
        print(Stop_Value)

    ##NEED TO FIX
    def set_outputs(self, output_fields, sys_dict, Final=False):
        self.output(sys_dict)


        if not hasattr(self,'cycle_hist'):
            self.len_cycle_hist=0
            self.cycle_hist={'Power': {'search': True, 'avg': True, 'data': []}, 'Energy': {'search': False, 'avg': False, 'data': []}, 'Energy_HS':{'search': False, 'avg': False, 'data': []}, 'Energy_HW':{'search': False, 'avg': False, 'data': []}}

        if not hasattr(self,'last_t'):
            self.last_t=-1
            self.avg={'Energy_HS':0, 'Energy_HW':0, 'Energy':1}

        if not sys_dict['t'] == self.last_t:
            self.len_cycle_hist+=1
            #self.cycle_hist['COP']+=[sys_dict[self.gp('COP')]]
            self.cycle_hist['Power']['data'] += [sys_dict[self.gp('EM.Power_Consumption')]]
            self.cycle_hist['Energy']['data'] += [sys_dict[self.gp('EM.Energy_Consumption')]]
            self.cycle_hist['Energy_HS']['data'] += [sys_dict[self.Reg.gp('Energy_HS')]]
            self.cycle_hist['Energy_HW']['data'] += [sys_dict[self.Reg.gp('Energy_HW')]]

            import sim_components.generic.utils.analysis_utils as au

            cycle=au.search_cycle(self.cycle_hist, 18*60, 3, 10,self.len_cycle_hist)

            self.avg=cycle['averages']
            #print(cycle)
            #print(self.avg['Energy_HS']*1000.0/60.0)

        self.last_t=sys_dict['t']

        out = {'t': sys_dict['t'],
               'COP': (self.avg['Energy_HS']+self.avg['Energy_HW'])/self.avg['Energy'],

               'Power Consumption': self.avg['Energy']*1000.0/60.0,
               'Power Space Heating': self.avg['Energy_HS']*1000.0/60.0,
               'Power Hot Water': self.avg['Energy_HW']*1000.0/60.0,
               'Power Cooling': 0

               }

        outputs = []
        for o in output_fields:
            outputs += [float(out[o])]

        return outputs

    def set_results(self, output_fields, sys_dict, Final=False):

        return self.set_outputs(output_fields, sys_dict, Final=True)


    ##NEED to fix end


class EM_regulator(BC.Node):
    def construct_Node(self, N_EMA, Stub, **c):
        self.Stub=Stub
        self.EM = Stub.EM

        self.Variables = [
            {'name': 'P_HS', 'unit': 'kW', 'type': 'param', 'val': c['P_HS']},

            {'name': 'F_HW', 'unit': 'kg/s', 'type': 'param', 'val': c['F_HW']},

            {'name': 'T_On_EMB_Comp_1', 'unit': 'K', 'type':'param', 'val':   30},
            {'name': 'T_Off_EMB_Comp_1', 'unit': 'K', 'type': 'param', 'val': 25},
            {'name': 'T_On_EMB_Comp_2', 'unit': 'K', 'type': 'param', 'val':  20},
            {'name': 'T_Off_EMB_Comp_2', 'unit': 'K', 'type': 'param', 'val': 15},
            {'name': 'T_HS', 'unit': 'oC', 'type': 'param', 'val': c['T_HS']},
            {'name': 'T_HW', 'unit': 'oC', 'type': 'param', 'val': c['T_HW']},
            {'name': 'dT_On_EMA', 'unit': 'K', 'type': 'param', 'val': 0.5},
            {'name': 'T_HS_Err_Acc', 'unit': 'C', 'type': 'state', 'val': 0},
            {'name': 'Sub_int_err', 'unit': 'K', 'type': 'state', 'val': 0},
            {'name': 'Sub2_int_err', 'unit': 'K', 'type': 'state', 'val': 0},
            {'name': 'Sub3_int_err', 'unit': 'K', 'type': 'state', 'val': 0},
            {'name': 'dT_Rating', 'unit': 'K', 'type': 'param', 'val': 2},
            {'name': 'Rating', 'unit': '1', 'type': 'param', 'val': c['rating']},
            {'name': 'P_err_int', 'unit': '1', 'type': 'state', 'val': 0},
            {'name': 'P_on', 'unit': '1', 'type': 'param', 'val': 0},
            {'name': 'dT_HS', 'unit': '1', 'type': 'param', 'val': c['dT_HS']},
            {'name': 'dT_CS', 'unit': '1', 'type': 'param', 'val':  c['dT_CS']},
            {'name': 'Energy_HS', 'unit': 'MJ', 'type': 'state', 'val': 0},
            {'name': 'Energy_HW', 'unit': 'MJ', 'type': 'state', 'val': 0},
            {'name': 'tim', 'unit': 's', 'type': 'state', 'val': 0},
            {'name': 'timd', 'unit': '1/s', 'type': 'state', 'val': 1},
            {'name': 'Err_Evap_In', 'unit': 'K*s', 'type': 'state', 'val': 0},
            {'name': 'Energy_Add_HS', 'unit': 'MJ', 'type': 'state', 'val': 0},
            {'name': 'Energy_Add_HW', 'unit': 'MJ', 'type': 'state', 'val': 0},
            {'name': 'P_HW_act', 'unit': 'kW', 'type': 'param', 'val': 0}
        ]

        self.calc_funcs = [self.Regulate]
        if N_EMA == 1:
            self.calc_funcs+=[self.Regulate_1_EMA]
        elif N_EMA == 2:
            self.calc_funcs += [self.Regulate_2_EMA]
        else:
            self.calc_funcs += [self.Regulate_3_EMA]

    def Regulate(self):

        # Regulation of EMB Hot Water Production
        HW_On = 0# ((EM.VV_ST.CW_1.T < T_HW + 4.5) * (EM.EMB.bp_cond1.Reg.S_set <= 0) + (EM.VV_ST.CW_1.T < T_HW+5.5) * (EM.EMB.bp_cond1.Reg.S_set > 0))#*(F_HW>0)
        EM.EMB.bp_cond1.Reg.S_set = HW_On

        T_HS_Err_Acc_dot = T_HS - Stub.Re_Heating_system.T
        Err=100*(Rating>0)+(Rating<=0)*(T_HS - Stub.EM.Pipe_HS_Out.T_pipe)*2
        P_err =-(T_HS - dT_HS - Stub.Re_Heating_system.T)
        P_err_int_dot = ((P_err_int>0)*(P_err<0)+(P_err>=0))*P_err

        P_on=(P_on<=0)*(Stub.EM.Pipe_HS_Out.T_pipe>T_HS)+(P_on>0)

        P_HS_act_reg = P_err_int*.01 + .1*P_err * P_HS
        P_HS_act = P_HS_act_reg*(P_HS_act_reg>0)*(Rating>0)+(Rating<=0)*P_HS *P_on
        Energy_HS_dot = P_HS_act / 1.0e3

        #P_Add_HS = (Err > 5) * Err * P_HS_act
        P_Add_HS = (Err > 3) * (Err-3) * 4.187 * Stub.EM.Pipe_HS_Out.m_dot*(Rating<=0)*P_on
        Energy_Add_HS_dot = P_Add_HS / 1.0e3

        # Heating system load
        Stub.Re_Heating_system.H_dot = (-P_HS_act+P_Add_HS*P_on)*1000
        Flow_HS = P_HS_act / dT_HS / 4.187
        Flow_HS = Flow_HS*(Flow_HS>1)+(Flow_HS<=1)
        EM.Pipe_HS_Out.m_dot = Flow_HS
        EM.Pipe_HS_In.m_dot = Flow_HS

        Err_HW_ST = T_On_EMB_Comp_1 + 3 - EM.SCC.ST2.CW_1.T

        # Regulation of EMB Compressors
        EM.EMB.Compressor1.State1 = (((EM.EMB.Compressor1.State1 > 0) * (EM.SCC.ST2.CW_1.T >= T_Off_EMB_Comp_1)*(Err>0.25) + (EM.EMB.Compressor1.State1 <= 0) * (EM.SCC.ST2.CW_1.T >= T_On_EMB_Comp_1)*(Err>0.5))*(HW_On<=0)+(HW_On>0))*(EM.SCC.ST3.CW_1.T > 0)
        EM.EMB.Compressor2.State1 = ((EM.EMB.Compressor2.State1 > 0) * (EM.SCC.ST3.CW_1.T >= T_Off_EMB_Comp_2)*(Err>0) + (EM.EMB.Compressor2.State1 <= 0) * (EM.SCC.ST3.CW_1.T >= T_On_EMB_Comp_2)*(Err>0.25))*(EM.SCC.ST3.CW_1.T > 0)

        EM.EMB.LCW_Evap1_in.Set_Speed = EM.EMB.Compressor1.state_set*0.75
        EM.EMB.LCW_Cond1_out.Set_Speed = EM.EMB.Compressor1.state_set*0.75

        EM.EMB.LCW_Evap2_in.Set_Speed = EM.EMB.Compressor2.state_set*0.75
        EM.EMB.LCW_Cond2_out.Set_Speed = EM.EMB.Compressor2.state_set+1

        EM.EMB.LCW_Sub_in.Set_Speed  = (EM.EMB.Compressor1.state_set + EM.EMB.Compressor2.state_set)/2

        #Hot water load
        F_HW = P_HW_act *0.8/((Stub.Re_Hot_Water_system.T - Stub.Re_Cold_Water_supply.T) * 4.187)
        Energy_HW_dot = P_HW_act / 1.0e3

        Err_HW = (T_HW - EM.Pipe_8.T_pipe)
        P_Add_HW = (Err_HW > 3) * (T_HW-3-EM.Pipe_8.T_pipe)*4.187*EM.Pipe_8.m_dot

        Energy_Add_HW_dot = P_Add_HW / 1.0e3

        Stub.Re_Hot_Water_system.H_dot = - F_HW * Stub.Re_Hot_Water_system.h - P_HW_act *0.2 + P_Add_HW*1e3
        Stub.Re_Hot_Water_system.m_dot = - F_HW

        EM.Cold_Water_Pipe.m_dot = F_HW


        EM.EMHW.P1_Prim.Set_Speed = Err_HW *(Stub.EM.SCC.ST3.CW_0.T>Stub.Re_Cold_Water_supply.T_Set)
        EM.EMHW.P2_Prim.Set_Speed = Err_HW *(Stub.EM.SCC.ST1.CW_0.T>Stub.Re_Cold_Water_supply.T_Set)
        EM.EMHW.P3_Prim.Set_Speed = Err_HW

        EM.EMHW.bp_VS.Reg.S_set = Err_HW

        EM.EMHW.P_VVC.Set_Speed = 1 #kg/s
        tim_dot = timd

    def Regulate_1_EMA(self):
        # Regulation of EMA
        EM.EMA.Compressor1.State1 = (Err > .75) * (EM.EMA.Compressor1.State1 <= 0) + (Err > 0.5) * (EM.EMA.Compressor1.State1 > 0)
        EM.EMA.Compressor2.State1 = (Err > 1) * (EM.EMA.Compressor2.State1 <= 0) + (Err > 0.75) * (EM.EMA.Compressor2.State1 > 0)
        EM.EMA.Compressor1.State2 = (Err > 1.25) * (EM.EMA.Compressor1.State2 <= 0) + (Err > 1) * (EM.EMA.Compressor1.State2 > 0)
        EM.EMA.Compressor2.State2 = (Err > 1.5) * (EM.EMA.Compressor2.State2 <= 0) + (Err > 1.25) * (EM.EMA.Compressor2.State2 > 0)

        EM.EMA.LCW_Evap_in.Set_Speed = (EM.EMA.Compressor1.state_set + EM.EMA.Compressor2.state_set) * 0.125 + 0.25

        EM.EMA.LCW_Cond_in.Set_Speed = (EM.EMA.Compressor1.state_set + EM.EMA.Compressor2.state_set) * 0.125 + 0.25

        # Regulation of EMA subcooler pump
        Sub_err = (T_On_EMB_Comp_1+5) - EM.EMA.Subcooler.m_dot_F2.T_s2
        Sub_int_err_dot = Sub_err * ((Sub_int_err > 0) * (Sub_err < 0) + (Sub_err > 0))
        kI_Sub = 0.00001 * 10
        EM.EMA.LCW_Sub_in.Set_Speed = Sub_int_err * kI_Sub + Err_HW_ST * 0 + 1

        EM.EMA.bp_sub.Reg.S_set = Err_HW_ST * HW_On

    def Regulate_2_EMA(self):
        # Regulation of EMA
        EM.EMA.Compressor1.State1 = (2*Err > .75) * (EM.EMA.Compressor1.State1 <= 0) + (2*Err > 0.5) * (EM.EMA.Compressor1.State1 > 0)+(EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On
        EM.EMA2.Compressor1.State1 = (2*Err > 1) * (EM.EMA2.Compressor1.State1 <= 0) + (2*Err > 0.75) * (EM.EMA2.Compressor1.State1 > 0)
        EM.EMA.Compressor2.State1 = (2*Err > 1.25) * (EM.EMA.Compressor2.State1 <= 0) + (2*Err > 1) * (EM.EMA.Compressor2.State1 > 0)
        EM.EMA2.Compressor2.State1 = (2*Err > 1.5) * (EM.EMA2.Compressor2.State1 <= 0) + (2*Err > 1.25) * (EM.EMA2.Compressor2.State1 > 0)
        EM.EMA.Compressor1.State2 = (2*Err > 1.75) * (EM.EMA.Compressor1.State2 <= 0) + (2*Err > 1.5) * (EM.EMA.Compressor1.State2 > 0)
        EM.EMA2.Compressor1.State2 = (2*Err > 2) * (EM.EMA2.Compressor1.State2 <= 0) + (2*Err > 1.75) * (EM.EMA2.Compressor1.State2 > 0)
        EM.EMA.Compressor2.State2 = (2*Err > 2.25) * (EM.EMA.Compressor2.State2 <= 0) + (2*Err > 2) * (EM.EMA.Compressor2.State2 > 0)
        EM.EMA2.Compressor2.State2 = (2*Err > 2.5) * (EM.EMA2.Compressor2.State2 <= 0) + (2*Err > 2.25) * (EM.EMA2.Compressor2.State2 > 0)

        EM.EMA.LCW_Evap_in.Set_Speed = (EM.EMA.Compressor1.state_set + EM.EMA.Compressor2.state_set) * 0.125 + 0.25
        EM.EMA2.LCW_Evap_in.Set_Speed = (EM.EMA2.Compressor1.state_set + EM.EMA2.Compressor2.state_set) * 0.125 + 0.25

        EM.EMA.LCW_Cond_in.Set_Speed = (EM.EMA.Compressor1.state_set + EM.EMA.Compressor2.state_set) * 0.125 + 0.25
        EM.EMA2.LCW_Cond_in.Set_Speed = (EM.EMA2.Compressor1.state_set + EM.EMA2.Compressor2.state_set) * 0.125 + 0.25

        kI_Sub = 0.00001 * 10
        # Regulation of EMA subcooler pump
        Sub_err = (T_On_EMB_Comp_1+5) - EM.EMA.Subcooler.m_dot_F2.T_s2
        Sub_int_err_dot = Sub_err * ((Sub_int_err > 0) * (Sub_err < 0) + (Sub_err > 0))
        EM.EMA.LCW_Sub_in.Set_Speed = Sub_int_err * kI_Sub +1#+ Err_HW_ST * 0 + 1
        EM.EMA.bp_sub.Reg.S_set = (EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On

        Sub2_err = (T_On_EMB_Comp_1+5) - EM.EMA2.Subcooler.m_dot_F2.T_s2
        Sub2_int_err_dot = Sub2_err * ((Sub2_int_err > 0) * (Sub2_err < 0) + (Sub2_err > 0))
        EM.EMA2.LCW_Sub_in.Set_Speed = Sub2_int_err * kI_Sub+1# + Err_HW_ST * 0 + 1
        #EM.EMA2.bp_sub.Reg.S_set = Err_HW_ST * HW_On

    def Regulate_3_EMA(self):
        # Regulation of EMA
        EM.EMA.Compressor1.State1 = (3*Err > .75) * (EM.EMA.Compressor1.State1 <= 0) + (3*Err > 0.5) * (EM.EMA.Compressor1.State1 > 0)+(EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On
        EM.EMA2.Compressor1.State1 = (3*Err > 1) * (EM.EMA2.Compressor1.State1 <= 0) + (3*Err > 0.75) * (EM.EMA2.Compressor1.State1 > 0)+(EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On
        EM.EMA3.Compressor1.State1 = (3*Err > 1.25) * (EM.EMA3.Compressor1.State1 <= 0) + (3*Err > 1) * (EM.EMA3.Compressor1.State1 > 0) + (EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On

        EM.EMA.Compressor2.State1 = (3*Err > 1.5) * (EM.EMA.Compressor2.State1 <= 0) + (3*Err > 1.25) * (EM.EMA.Compressor2.State1 > 0)
        EM.EMA2.Compressor2.State1 = (3*Err > 1.75) * (EM.EMA2.Compressor2.State1 <= 0) + (3*Err > 1.5) * (EM.EMA2.Compressor2.State1 > 0)
        EM.EMA3.Compressor2.State1 = (3*Err > 2) * (EM.EMA3.Compressor2.State1 <= 0) + (3*Err > 1.75) * (EM.EMA3.Compressor2.State1 > 0)

        EM.EMA.Compressor1.State2 = (3*Err > 2.25) * (EM.EMA.Compressor1.State2 <= 0) + (3*Err > 2) * (EM.EMA.Compressor1.State2 > 0)
        EM.EMA2.Compressor1.State2 = (3*Err > 2.5) * (EM.EMA2.Compressor1.State2 <= 0) + (3*Err > 2.25) * (EM.EMA2.Compressor1.State2 > 0)
        EM.EMA3.Compressor1.State2 = (3*Err > 2.75) * (EM.EMA3.Compressor1.State2 <= 0) + (3*Err > 2.5) * (EM.EMA3.Compressor1.State2 > 0)

        EM.EMA.Compressor2.State2 = (3*Err > 3) * (EM.EMA.Compressor2.State2 <= 0) + (3*Err > 2.75) * (EM.EMA.Compressor2.State2 > 0)
        EM.EMA2.Compressor2.State2 = (3*Err > 3.25) * (EM.EMA2.Compressor2.State2 <= 0) + (3*Err > 3) * (EM.EMA2.Compressor2.State2 > 0)
        EM.EMA3.Compressor2.State2 = (3*Err > 3.5) * (EM.EMA3.Compressor2.State2 <= 0) + (3*Err > 3.25) * (EM.EMA3.Compressor2.State2 > 0)

        EM.EMA.LCW_Evap_in.Set_Speed = (EM.EMA.Compressor1.state_set + EM.EMA.Compressor2.state_set) * 0.125 + 0.25
        EM.EMA2.LCW_Evap_in.Set_Speed = (EM.EMA2.Compressor1.state_set + EM.EMA2.Compressor2.state_set) * 0.125 + 0.25
        EM.EMA3.LCW_Evap_in.Set_Speed = (EM.EMA3.Compressor1.state_set + EM.EMA3.Compressor2.state_set) * 0.125 + 0.25

        EM.EMA.LCW_Cond_in.Set_Speed = (EM.EMA.Compressor1.state_set + EM.EMA.Compressor2.state_set) * 0.125 + 0.25
        EM.EMA2.LCW_Cond_in.Set_Speed = (EM.EMA2.Compressor1.state_set + EM.EMA2.Compressor2.state_set) * 0.125 + 0.25
        EM.EMA3.LCW_Cond_in.Set_Speed = (EM.EMA3.Compressor1.state_set + EM.EMA3.Compressor2.state_set) * 0.125 + 0.25

        kI_Sub = 0.00001 * 10
        # Regulation of EMA subcooler pump
        Sub_err = (T_On_EMB_Comp_1+5) - EM.EMA.Subcooler.m_dot_F2.T_s2
        Sub_int_err_dot = Sub_err * ((Sub_int_err > 0) * (Sub_err < 0) + (Sub_err > 0))
        EM.EMA.LCW_Sub_in.Set_Speed = Sub_int_err * kI_Sub +1#+ Err_HW_ST * 0 + 1
        EM.EMA.bp_sub.Reg.S_set = (EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On

        Sub2_err = (T_On_EMB_Comp_1+5) - EM.EMA2.Subcooler.m_dot_F2.T_s2
        Sub2_int_err_dot = Sub2_err * ((Sub2_int_err > 0) * (Sub2_err < 0) + (Sub2_err > 0))
        EM.EMA2.LCW_Sub_in.Set_Speed = Sub2_int_err * kI_Sub+1# + Err_HW_ST * 0 + 1
        EM.EMA2.bp_sub.Reg.S_set = (EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On
        #EM.EMA2.bp_sub.Reg.S_set = Err_HW_ST * HW_On

        Sub3_err = (T_On_EMB_Comp_1 + 5) - EM.EMA3.Subcooler.m_dot_F2.T_s2
        Sub3_int_err_dot = Sub2_err * ((Sub3_int_err > 0) * (Sub3_err < 0) + (Sub3_err > 0))
        EM.EMA3.LCW_Sub_in.Set_Speed = Sub3_int_err * kI_Sub + 1  # + Err_HW_ST * 0 + 1
        EM.EMA3.bp_sub.Reg.S_set = (EM.SCC.ST2.CW_1.T <= T_Off_EMB_Comp_1) * HW_On

if __name__ == '__main__':
    from sim_tool_EM.Sim_Store.models_mongoengine import *
    import sim_tool_EM.Sim_Store.Project_Manager as PM

    pt = ['Stub.Re_Chilled_system.T', 'Stub.EM.EMA.Evaporator.T_F2_Out', 'Stub.EM.EMA2.Evaporator.T_F2_Out', 'Stub.EM.EMA3.Evaporator.T_F2_Out', 'Stub.EM.EMA.Condenser.T_F2_Out', 'Stub.EM.EMA.Pre_Cond.T', 'Stub.EM.EMA.Pump_CW_In_Sub.m_dot', 'Stub.EM.EMA.Compressor2.P_ewma', 'Stub.EM.EMHW.HX1.T_F1A_Out', 'Stub.EM.Pipe_4.T_pipe', 'Stub.EM.EMHW.HX2.T_F1A_Out', 'Stub.EM.Pipe_2.T_pipe', 'Stub.EM.EMHW.VS_Bypass.pipe_C.m_dot', 'Stub.EM.EMHW.HX1.T_F2_Out', 'Stub.EM.EMHW.HX2.T_F2_Out', 'Stub.EM.EMHW.HX3.T_F2_Out', 'Stub.EM.EMB.Evap1_Bypass.Vol.T', 'Stub.EM.EMB.Evaporator1.F2_2.T', 'Stub.EM.EMB.Evap2_Bypass.Vol.T', 'Stub.EM.EMB.Evaporator2.T_F2_Out', 'text6045', 'Stub.EM.EMB.Condenser2.T_F2_Out', 'Stub.EM.EMB.cond1_Bypass.Vol.T', 'Stub.EM.EMB.Pump_CW_In_Sub.m_dot', 'Stub.EM.VoCW_EMB_In_Sub.T', 'Stub.Re_Heating_system.T', 'Stub.EM.EMB.Power_Usage', 'Stub.EM.EMB.COP', 'Stub.EM.EMA.Power_Usage', 'Stub.EM.EMA.COP_ewma', 'Stub.EM.EMA.Compressor1.P_ewma', 'Stub.EM.EMB.Compressor2.P_ewma', 'Stub.EM.EMB.Compressor1.P_ewma', 'Stub.EM.EMA.Pump_CW_In_Evap.m_dot', 'Stub.EM.EMA.Pump_CW_In_Cond.m_dot', 'Stub.EM.EMA.Sub_middle.T', 'Stub.EM.EMA.Power_Heating', 'Stub.EM.EMA.pipe_sub_in.T_pipe', 'Stub.EM.EMA.Compressor2.T_Evap', 'Stub.EM.EMA.Compressor1.T_Evap', 'Stub.EM.EMA.Compressor2.T_Cond', 'Stub.EM.EMA.Compressor1.T_Cond', 'Stub.EM.EMB.Power_Heating', 'Stub.EM.EMB.Pump_CW_Out_Cond1.m_dot', 'Stub.EM.EMB.pipe_cond2_In.m_dot', 'Stub.EM.EMB.Pump_CW_In_Evap1.Act_Speed', 'Stub.EM.EMB.Pump_CW_In_Evap2.Act_Speed', 'Stub.EM.EMA.Compressor2.T_Discharge', 'Stub.EM.EMA.Compressor1.T_Discharge', 'Stub.EM.EMB.Compressor1.T_Discharge', 'Stub.EM.EMB.Compressor2.T_Discharge', 'Stub.EM.EMB.Compressor1.T_Evap', 'Stub.EM.EMB.Compressor2.T_Evap', 'Stub.EM.EMB.Compressor1.T_Cond', 'Stub.EM.EMB.Subcooler.T_F2_Out', 'Stub.EM.EMB.Compressor2.State1', 'Stub.EM.EMB.Compressor1.State1', 'Stub.EM.EMA.Compressor2.State1', 'Stub.EM.EMA.Compressor2.State2', 'Stub.EM.EMA.Compressor1.State1', 'Stub.EM.EMA.Compressor1.State2', 'Stub.EM.EMB.Condenser1.T_F2_Out', 'Stub.EM.EMB.Compressor2.T_Cond', 'Stub.EM.EMA.Subcool_Bypass.Reg.S_act', 'Stub.EM.EMB.cond1_Bypass.Reg.S_act', 'Stub.EM.EMB.Evap1_Bypass.Reg.S_act', 'Stub.EM.EMB.Evap2_Bypass.Reg.S_act', 'Stub.EM.SCC.ST1.CW_1.T', 'Stub.EM.SCC.ST2.CW_1.T', 'Stub.EM.SCC.ST3.CW_1.T', 'Stub.EM.VV_ST.CW_1.T', 'Stub.EM.Pipe_Cond1_EMB_out_HS_Out.T_pipe', 'Stub.EM.EMA.pipe_cond_out.m_dot', 'Stub.EM.EMA.pipe_sub_in.m_dot', 'Stub.EM.VoCW_Cond1_EMB_in.T', 'Stub.EM.VoCW_Cond2_EMB_out.T', 'Stub.EM.EMB.cond1_Bypass.pipe_B.m_dot', 'Stub.EM.EMB.pipe_cond1_Out2.m_dot', 'Stub.EM.Pipe_EMB_cond2_in_out.m_dot', 'Stub.EM.Pipe_EMB_cond1_cond2.m_dot', 'Stub.EM.Pipe_EMB_cond1_in_out.m_dot', 'Stub.EM.EMB.cond1_Bypass.pipe_A.m_dot', 'Stub.EM.EMB.pipe_cond1_Out1.m_dot', 'Stub.EM.EMB.Evap1_Bypass.pipe_A.m_dot', 'Stub.EM.EMB.Evap2_Bypass.pipe_A.m_dot', 'Stub.EM.EMB.pipe_evap1_Out.m_dot', 'Stub.EM.EMB.pipe_evap2_Out.m_dot', 'Stub.EM.EMB.Power_Cooling', 'Stub.EM.EMA.Power_Cooling', 'Stub.EM.EMA.Power_Evaporator', 'Stub.EM.EMA.Power_Condenser', 'Stub.EM.EMB.Evaporator1.Q_ewma', 'Stub.EM.EMB.Condenser1.Q_ewma', 'Stub.EM.EMB.Condenser2.Q_ewma', 'Stub.EM.EMB.Evaporator2.Q_ewma', 'Stub.EM.SCC.ST1.CW_0.T', 'Stub.EM.SCC.ST1.CW_2.T', 'Stub.EM.SCC.ST2.CW_0.T', 'Stub.EM.SCC.ST2.CW_2.T', 'Stub.EM.SCC.ST3.CW_0.T', 'Stub.EM.SCC.ST3.CW_2.T', 'Stub.EM.EMA.Subcooler.Q_B_ewma', 'Stub.EM.EMB.Subcooler.Q_B_ewma', 'Stub.EM.VV_ST.CW_0.T', 'Stub.EM.VV_ST.CW_2.T', 'Stub.Real_EMA_Sub_In_T', 'Stub.Real_EMA_Sub_Out_T', 'Stub.Real_EMA_Cond_In_T', 'Stub.Real_EMA_Cond_Out_T', 'Stub.Real_EMA_Evap_Out_T', 'Stub.Real_Step1_Prim_Out_T', 'Stub.Real_Step1_Prim_In_T', 'Stub.Real_Step2_Prim_Out_T', 'Stub.Real_Step2_Prim_In_T', 'Stub.Real_Step3_Prim_Out_T', 'Stub.Real_Step3_Prim_In_Flow', 'Stub.Real_VS_ST_T', 'Stub.Real_SCC_ST1_T', 'Stub.Real_SCC_ST2_T', 'Stub.Real_SCC_ST3_T', 'Stub.Real_EMB_Evap1_Out_T', 'Stub.Real_EMB_Evap1_In_T', 'Stub.Real_EMB_Cond1_Out_T', 'Stub.Real_EMB_Cond2_In_T', 'Stub.Real_EMB_Cond1_In_T', 'Stub.Real_EMB_Cond2_Out_T', 'Stub.Real_EMB_Sub_In_T', 'Stub.Real_EMB_Sub_Out_T', 'Stub.Real_HS_Out_T', 'Stub.Real_Step1_Sec_Out_T', 'Stub.Real_Step2_Sec_Out_T', 'Stub.EM.Pipe_HS_In.m_dot', 'Stub.Real_HS_Out_mdot', 'Stub.EM.EMB.pipe_Sub_Out.m_dot', 'Stub.EM.EMB.Pump_CW_In_Evap2.Set_Speed', 'Stub.EM.EMB.Pump_CW_In_Evap1.Set_Speed', 'Stub.EM.Pump_HS_Out.Act_Speed', 'Stub.EM.Pump_HS_Out.Set_Speed', 'Stub.EM.EMA.Pump_CW_In_Cond.Act_Speed', 'Stub.EM.EMA.Pump_CW_In_Cond.Set_Speed', 'Stub.EM.EMA.Pump_CW_In_Evap.Act_Speed', 'Stub.EM.EMA.Pump_CW_In_Evap.Set_Speed', 'Stub.EM.EMA.Pump_CW_In_Sub.Act_Speed', 'Stub.EM.EMA.Pump_CW_In_Sub.Set_Speed', 'Stub.EM.EMHW.P1_Prim.Act_Speed', 'Stub.EM.EMHW.P1_Prim.Set_Speed', 'Stub.EM.EMHW.P2_Prim.Act_Speed', 'Stub.EM.EMHW.P2_Prim.Set_Speed', 'Stub.EM.EMHW.P3_Prim.Act_Speed', 'Stub.EM.EMHW.P3_Prim.Set_Speed', 'Stub.EM.EMHW.VS_Bypass.Reg.S_act', 'Stub.Real_HW_Out_T', 'Stub.EM.Cold_Water_Pipe.m_dot', 'Stub.EM.EMB.Pump_CW_Out_Cond1.Act_Speed', 'Stub.EM.EMB.Pump_CW_Out_Cond1.Set_Speed', 'Stub.EM.EMB.Pump_CW_Out_Cond2.Act_Speed', 'Stub.EM.EMB.Pump_CW_Out_Cond2.Set_Speed', 'Stub.Real_EMB_Evap2_In_T', 'Stub.Real_EMB_Evap2_Out_T', 'Stub.EM.EMHW.P_VVC.Act_Speed', 'Stub.EM.EMHW.P_VVC.Set_Speed', 'Stub.EM.EMB.Pump_CW_Out_Cond2.m_dot', 'Stub.Re_Heating_system.T_Set', 'Stub.EM.EMHW.VS_Bypass.pipe_A.m_dot', 'Stub.EM.Pipe_7.m_dot', 'Stub.EM.EMHW.VS_Bypass.pipe_B.m_dot', 'Stub.EM.EMHW.Pipe_5.m_dot', 'Stub.EM.EMHW.Pipe_6.m_dot', 'Stub.EM.EMHW.P_VVC.m_dot', 'Stub.EM.Pipe_8.m_dot', 'Stub.EM.EMHW.VS_Bypass.pipe_C.T_pipe', 'Stub.EM.EMHW.HX3.T_F1A_Out', 'Stub.EM.Pipe_4.m_dot', 'Stub.EM.EMHW.P1_Prim.m_dot', 'Stub.EM.EMHW.P2_Prim.m_dot', 'Stub.EM.Pipe_2.m_dot', 'Stub.EM.SCC.Pipe_1.m_dot', 'Stub.EM.SCC.Pipe_2.m_dot', 'Stub.EM.EMB.Evap1_Bypass.pipe_B.m_dot', 'Stub.EM.EMB.Evap2_Bypass.pipe_B.m_dot', 'Stub.EM.EMB.Pump_CW_In_Evap1.m_dot', 'Stub.EM.EMB.Pump_CW_In_Evap2.m_dot', 'Stub.EM.EMB.cond1_Bypass.pipe_C.m_dot', 'Stub.EM.Pipe_HS_Out.m_dot', 'Stub.EM.Pipe_EMB_sub_in_out.m_dot', 'Stub.EM.EMA.pipe_Sub_Out_Pre_Cond.m_dot', 'Stub.EM.EMB.Pump_CW_In_Sub.Act_Speed', 'Stub.EM.EMB.Pump_CW_In_Sub.Set_Speed', 'Stub.EM.EMA.Subcool_Bypass.pipe_A.m_dot', 'Stub.EM.EMA.Subcool_Bypass.pipe_B.m_dot', 'Stub.EM.EMA.pipe_cond_in.m_dot', 'Stub.EM.EMHW.P3_Prim.m_dot', 'Stub.Real_Step3_Prim_In_T', 'Stub.Re_Cold_Water_supply.T_Set', 'Stub.Real_Power_Usage_EMA', 'Stub.Real_Power_Space_Heating', 'Stub.Real_HW_Out_P', 'Stub.EM.EMHW.Step3_Prim_EM.P_ewma', 'Stub.Real_CW_In_P', 'Stub.EM.HW_Initial_EM.P_ewma', 'Stub.EM.HS_EM.P_ewma', 'Stub.Real_Power_Usage_EMB', 'Stub.EM.Pipe_ReCW_Sub_in.T_pipe', 'Stub.Real_EM_HS_Sub_In_T', 'Stub.Real_EM_HS_In_T', 'Stub.Real_EM_HS_Out_T', 'Stub.EM.Pipe_HS_Out.T_pipe', 'Stub.EM.Pipe_HS_In_HS_Out.m_dot', 't', 'Stub.Real_EMA_Comp1_Discharge_T', 'Stub.Real_EMA_Comp2_Discharge_T', 'Stub.EM.EMB.Subcooler.Q_A_ewma', 'Stub.EM.EMA.Subcooler.Q_A_ewma', 'Stub.Real_EMB_Comp1_Discharge_T', 'Stub.Real_EMB_Comp2_Discharge_T', 'Stub.Re_Chilled_system.T2', 'Stub.EM.EMA2.Evaporator.F2_5.T', 'Stub.EM.EMA2.Condenser.T_F2_Out', 'Stub.EM.EMA2.Pre_Cond.T', 'Stub.EM.EMA2.Pump_CW_In_Sub.m_dot', 'Stub.EM.EMA2.Compressor2.P_ewma', 'Stub.EM.EMA2.Compressor1.P_ewma', 'Stub.EM.EMA2.Pump_CW_In_Evap.m_dot', 'Stub.EM.EMA2.Pump_CW_In_Cond.m_dot', 'Stub.EM.EMA.Sub_middle.T-2', 'Stub.EM.EMA2.pipe_sub_in.T_pipe', 'Stub.EM.EMA2.Compressor2.T_Evap', 'Stub.EM.EMA2.Compressor1.T_Evap', 'Stub.EM.EMA2.Compressor2.T_Cond', 'Stub.EM.EMA2.Compressor1.T_Cond', 'Stub.EM.EMA2.Compressor2.T_Discharge', 'Stub.EM.EMA2.Compressor1.T_Discharge', 'Stub.EM.EMA2.Compressor2.State1', 'Stub.EM.EMA2.Compressor2.State2', 'Stub.EM.EMA2.Compressor1.State1', 'Stub.EM.EMA2.Compressor1.State2', 'Stub.EM.EMA2.Subcool_Bypass.Reg.S_act', 'Stub.EM.EMA2.pipe_cond_out.m_dot', 'Stub.EM.EMA2.pipe_sub_in.m_dot', 'Stub.EM.EMA2.Power_Evaporator', 'Stub.EM.EMA2.Power_Condenser', 'Stub.EM.EMA2.Subcooler.Q_B_ewma', 'Stub.Real_EMA_Sub_In_T-1', 'Stub.Real_EMA_Sub_Out_T-3', 'Stub.Real_EMA_Cond_In_T-2', 'Stub.Real_EMA_Cond_Out_T-1', 'Stub.Real_EMA2_Evap_Out_T', 'Stub.EM.EMA2.Pump_CW_In_Cond.Act_Speed', 'Stub.EM.EMA2.Pump_CW_In_Cond.Set_Speed', 'Stub.EM.EMA2.Pump_CW_In_Evap.Act_Speed', 'Stub.EM.EMA2.Pump_CW_In_Evap.Set_Speed', 'Stub.EM.EMA2.Pump_CW_In_Sub.Act_Speed', 'Stub.EM.EMA2.Pump_CW_In_Sub.Set_Speed', 'Stub.EM.EMA2.pipe_Sub_Out_Pre_Cond.m_dot', 'Stub.EM.EMA2.Subcool_Bypass.pipe_A.m_dot', 'Stub.EM.EMA2.Subcool_Bypass.pipe_B.m_dot', 'Stub.EM.EMA2.pipe_cond_in.m_dot', 'Stub.Real_EMA2_Comp1_Discharge_T', 'Stub.Real_EMA2_Comp2_Discharge_T', 'Stub.EM.EMA2.Subcooler.Q_A_ewma', 'Stub.EM.EMA2.Power_Usage', 'Stub.EM.EMA2.COP_ewma', 'Stub.EM.EMA2.Power_Heating', 'Stub.EM.EMA2.Power_Cooling', 'Stub.Real_Power_Usage_EMA-6', 'Stub.EM.Power_Consumption', 'Stub.EM.Space_Heating_COP', 'Stub.EM.Space_Heating_Power', 'Stub.EM.Total_COP', 'Stub.Real_Power_Usage', 'Stub.Real_COP', 'Stub.EM.Pipe_EMA_2.m_dot', 'Stub.EM.VoCW_Cond_EMA.T', 'Stub.EM.VoCW_Cond_EMA2.T', 'Stub.EM_Reg.P_HW_act', 'Stub.EM_Reg.P_HS_act', 'Stub.EM_Reg.P_Add_HW', 'Stub.EM_Reg.P_Add_HS', 'Stub.EM_Reg.P_HS', 'Stub.EM.Energy_Consumption', 'Stub.EM_Reg.Energy_HS', 'Stub.EM_Reg.Energy_HW', 'Stub.EM_Reg.Energy_Add_HS', 'Stub.EM_Reg.Energy_Add_HW', 'Stub.EM_Reg.T_HS', 'Stub.Re_Chilled_system.T_Set', 'Stub.EM_Reg.T_HW', 'Stub.Re_Hot_Water_system.T', 'Stub.EM.TW_HS_HW_in.Reg.S_set', ]


    print('Enter project title:')
    project_title = input()

    machine = input("Enter machine: ")

    if machine == '':
        machine=project_title

    print('Rating (1) or SCOP (2):')
    inp = input()
    if inp == '1':


        print(project_title)

        g_name='Seasonal COP'

        Power_design=1600


        u = User.objects.get(first_name='Lasse')

        proj = PM.create_Project(project_title, owner=u, tags=['test', 'EM', 'SCOP'])

        ######################
        gr=proj.groups.create(name='Rating')
        fields = ['t', 'COP', 'Power Consumption', 'Power Space Heating', 'Power Hot Water', 'Power Cooling']


        sr=gr.scenarios.create(name='Rating', visualization='EM12', persistant_tags=pt)

        sr.inputs.append(Solver_Inputs(name='solver', t_Start=0, t_Step=60, t_End=24*3600).hide_fields(
        #sr.inputs.append(Solver_Inputs(name='solver', t_Start=0, t_Step=60, t_End=5*3600).hide_fields(
                                  ['t_Start', 't_Step', 't_End']))

        sr.inputs.append(Task_Inputs(name='task', sim_module='sim_tool_EM.EM_SCOP_Project').hide_fields(
                                  ['sim_module']))

        sr.outputs.append(Outputs(fields=fields))
        sr.results.append(Outputs(fields=fields))
        T_out=-10
        T_HS=50
        Power = 10/26*(16-T_out)/10*Power_design

        scop_bin = EM_Static_COP(name='model',
                                Chilled_System_Temperature=4,
                                Chilled_System_Return_dT=4,
                                Heating_System_Temperature=T_HS,
                                Heating_System_Return_dT=10,
                                Hot_Water_Temperature=55,
                                Cold_Water_Temperature=10,
                                Heating_System_Power=Power,
                                Hot_Water_Flow=0,
                                EM=Config.objects.get(name=machine),
                                Rating=True).hide_fields(['EM','Rating'])


        sr.inputs.append(scop_bin)

        # PM.append_Scenario_Inputs(proj,'Spring','EMA3',EMA3)

        cop_bars = [
            Data_View_Field(name='COP', text_rep='{}: {}', scaling=60, decimal_spaces=2),
            Data_View_Field(name='Power Consumption', text_rep='{}: {} kW', scaling=.1, decimal_spaces=1),
            Data_View_Field(name='Power Space Heating', text_rep='{}: {} kW', scaling=.1, decimal_spaces=1),
            Data_View_Field(name='Power Hot Water', text_rep='{}: {} kW', scaling=.1, decimal_spaces=1),
            Data_View_Field(name='Power Cooling', text_rep='{}: {} kW', scaling=.1, decimal_spaces=1),

        ]

        PM.create_Scenario_ResultView(proj, gr.uuid, sr.uuid, cop_bars)

        sr.graphs.append(Graph(title='COP', x_title='time (s)', y_title='COP',
                              type='Scatter', x='t',
                              y=['COP'],
                              y_modes=['line']))

        gr.outputs.append(Outputs(fields=fields))
        gr.results.append(Outputs(fields=fields))

        EM = EM_Static_COP(name='model',
                           Chilled_System_Temperature=4,
                           Chilled_System_Return_dT=4,
                           Heating_System_Temperature=50,
                           Heating_System_Return_dT=8,
                           Hot_Water_Temperature=55,
                           Cold_Water_Temperature=10,
                           Heating_System_Power=Power,
                           Hot_Water_Flow=0,
                           EM=Config.objects.get(name=machine),
                           Rating=True
                           ).hide_fields(
            ['Chilled_System_Temperature', 'Heating_System_Temperature', 'Hot_Water_Temperature','Cold_Water_Temperature',
             'Heating_System_Power', 'Hot_Water_Flow', 'Cooling_Power','Chilled_System_Return_dT','Heating_System_Return_dT'])
        gr.inputs.append(EM)

        PM.save(proj)

        #print(PM.run_Scenario_Uuid(proj,gr.uuid,sr.uuid,local=True, multi_proc=False, force=True))

        print('Delete '+ proj.title+'? - Enter DEL or press enter...')
        title=proj.title
        inp = input()
        if inp == 'DEL':

            PM.delete_Project_title(proj.title)
            print('Project '+title + ' deleted!')
        else:
            print('Project kept!')

    if inp == '2':

        print(project_title)
        u = User.objects.get(first_name='Lasse')
        proj=PM.get_create_project(project_title, owner=u, tags=['test', 'EM', 'SCOP'])



        print('Enter climate region - Cold/Helsinki (1), Average/Strassbourg (2), Warmer/Athens (3):')
        climate = input()

        print('Enter Application - Low Temperature/Floor Heating (1), Medium Temperature/Radiator Heating (2)')
        application_temp=input()

        print('Enter design power in kW:')
        Power_design = float(input())
        if application_temp == '1':
            application_str = 'Low Temp/Floor Heat'
        if application_temp == '2':
            application_str = 'Medium Temp/Radiator'

        if climate == '1':
            climate_str = 'Colder/Helsinki'
            T_design = -22

            if application_temp == '1':
                Tmax=35
                dT_HS=5

            if application_temp == '2':
                Tmax=55
                dT_HS=8

        elif climate == '2':
            climate_str = 'Average/Strassbourg'
            T_design = -10

            if application_temp == '1':
                Tmax=35
                dT_HS=5

            if application_temp == '2':
                Tmax=55
                dT_HS=8

        elif climate == '3':
            climate_str = 'Warmer/Athens'
            T_design = -2

        else:
            print('Not a known climate zone')

        g_name = 'Seasonal COP for ' + climate_str + ' ' + application_str
        print(g_name)
        gr = proj.groups.create(name=g_name)
        fields = ['t', 'COP', 'Power Consumption', 'Power Space Heating', 'Power Hot Water', 'Power Cooling']

        for T in range(T_design,16):


            sr = gr.scenarios.create(name='Bin '+str(T)+'\N{DEGREE SIGN}C', visualization='EM12', persistant_tags=pt)
            Power = Power_design * (T - 16) / (T_design - 16)
            T_HS = (Tmax - 22.5) / (16 - T_design) * (T_design - T) + Tmax



            V_HS = 400 / 2 / 4.187 / 2 / 1000 * 300
            t_solve = 24*3600#V_HS/Power*2*4.187*1000 * 6 + 3*3600

            # s.inputs.append(Solver_Inputs(name='solver', t_Start=0, t_Step=60, t_End=24*3600*30).hide_fields(
            sr.inputs.append(Solver_Inputs(name='solver', t_Start=0, t_Step=60, t_End=t_solve).hide_fields(
                ['t_Start', 't_Step', 't_End']))

            print(t_solve)
            sr.inputs.append(Task_Inputs(name='task', sim_module='sim_tool_EM.EM_SCOP_Project').hide_fields(
                ['sim_module']))

            sr.outputs.append(Outputs(fields=fields))
            sr.results.append(Outputs(fields=fields))



            scop_bin = EM_Static_COP(name='model',
                                     Chilled_System_Temperature=0,
                                     Chilled_System_Return_dT=3,
                                     Heating_System_Temperature=T_HS,
                                     Heating_System_Return_dT=dT_HS,
                                     Hot_Water_Temperature=55,
                                     Cold_Water_Temperature=10,
                                     Heating_System_Power=Power,
                                     Hot_Water_Flow=0,
                                     EM=Config.objects.get(name=machine),
                                     Rating=False).hide_fields(['EM', 'Rating'])

            sr.inputs.append(scop_bin)

            # PM.append_Scenario_Inputs(proj,'Spring','EMA3',EMA3)

            cop_bars = [
                Data_View_Field(name='COP', text_rep='{}: {}', scaling=40, decimal_spaces=2),
                Data_View_Field(name='Power Consumption', text_rep='{}: {} kW', scaling=.5, decimal_spaces=1),
                Data_View_Field(name='Power Space Heating', text_rep='{}: {} kW', scaling=.5, decimal_spaces=1),
                Data_View_Field(name='Power Hot Water', text_rep='{}: {} kW', scaling=.5, decimal_spaces=1),
                Data_View_Field(name='Power Cooling', text_rep='{}: {} kW', scaling=.5, decimal_spaces=1),

            ]

            PM.create_Scenario_ResultView(proj, gr.uuid, sr.uuid, cop_bars)

            sr.graphs.append(Graph(title='COP', x_title='time (s)', y_title='COP',
                                   type='Scatter', x='t',
                                   y=['COP'],
                                   y_modes=['line']))

        gr.outputs.append(Outputs(fields=fields))
        gr.results.append(Outputs(fields=fields))

        EM = EM_Static_COP(name='model',
                           Chilled_System_Temperature=0,
                           Chilled_System_Return_dT=3,
                           Heating_System_Temperature=50,
                           Heating_System_Return_dT=8,
                           Hot_Water_Temperature=55,
                           Cold_Water_Temperature=10,
                           Heating_System_Power=Power,
                           Hot_Water_Flow=0,
                           EM=Config.objects.get(name=machine),
                           Rating=False
                           ).hide_fields(
            ['Chilled_System_Temperature', 'Heating_System_Temperature', 'Hot_Water_Temperature', 'Cold_Water_Temperature',
             'Heating_System_Power', 'Hot_Water_Flow', 'Cooling_Power', 'Chilled_System_Return_dT',
             'Heating_System_Return_dT'])
        gr.inputs.append(EM)



        PM.save(proj)
        print(PM.run_Scenario_Uuid(proj, gr.uuid, sr.uuid, local=True, multi_proc=False, force=True))

        # for s in g.scenarios:

        #   pass

        # import webbrowser
        # new = 2 # open in a new tab, if possible

        # open a public URL, in this case, the webbrowser docs
        # url = "http://127.0.0.1:8001/sim_app/projects/"+project_title
        # webbrowser.open(url,new=2)

        print('Delete ' + proj.title + '? - Enter DEL or press enter...')
        title = proj.title
        inp = input()
        if inp == 'DEL':

            PM.delete_Project_title(proj.title)
            print('Project ' + title + ' deleted!')
        else:
            print('Project kept!')