import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
#import Liquid
#import sim_components.machines.SCC_v2 as SCC
import sim_components.machines.EMHW_v2 as EMHW
import sim_components.machines.EMA_v2 as EMA
import sim_components.machines.EMB_single_no_sub_v2 as EMB
import sim_components.machines.CO2_KVP as CO2_KVP
#import sim_tool_EM.RefpropFluid as Fluid
import sim_components.thermodynamics.ST_v2 as ST


#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class EM_System(BC.Subsystem):
    def construct_Subsystem(self, CW, EMA_defs, EMB_defs, EMHW_defs, VV_list, VS_list=None,  UK_list=None, KB_list=None, Custom_list=None,  EMA_sec_defs=None, Condenser_Dump=False, KVP_HW_type = 'EMB',
                            T0_VS = 40,
                            T0_KB = 10,
                            T0_UK=25,
                            T0_VV = 60,
                            kV_VS=15,
                            kV_KB = 10,
                            kV_UK=3,
                            V_VS=0.1,
                            V_UK=0.1,
                            V_KB = 0.1,
                            EMA_Parallel = True,
                            **c):
        self.KVP_HW_type = KVP_HW_type
        self.KVP_HW = EMB.EMB if KVP_HW_type == 'EMB' else CO2_KVP.KVP
        #### Basic assignments
        self.Condenser_Dump = Condenser_Dump

        CW_KB= CW_VS = CW_UK=CW

        self.has_subcooling = True
        self.has_scc = False

        if UK_list:
            UK_network = [['UK_in'], ['UK_out']]
            FF.make_network(self, UK_network, Fluid=CW_UK, kV=kV_UK, T0=T0_UK, V=V_UK)

            for i, UK in enumerate(UK_list):
                #Create pipe supply, Create pipe return
                self.add('Pipe_UK_return_'+str(i), FF.Pipe, kV=kV_KB,
                         side1=UK.Return_Pri, side2=self.UK_in)
                self.add('Pipe_UK_supply_' + str(i), FF.Pipe, kV=kV_UK,
                         side1=self.UK_out, side2=UK.Supply_Pri)



        #### Create connecting volumes

        VS_network = [
                [('VS_return', {'V': 1}), 'VS_Short_return', 'VS_Sec_in', 'BHS_In'], ['VS_Sec_check'], ['VS_Pri_in'], ['BHS_Out'],
                ['VS_Pri_out', 'VS_Short_supply', 'EMB_Cond1_in', 'EMB_Cond1_out', ('VS_supply', {'V': 1})]
        ]



        KB_network = [[('KB_return', {'V': 1})], [('KB_supply', {'V': 1})]]

        FF.make_network(self, VS_network, Fluid=CW_VS, kV=kV_VS, T0=T0_VS, V=V_VS)

        FF.make_network(self, KB_network, Fluid=CW_KB, kV=kV_KB, T0=T0_KB, V=V_KB)

        FF.make_pipe_check_lines(self, [[self.BHS_Out, self.VS_Sec_check]], kV_VS)

        self.VS_Cooling_EM = self.add('VS_Cooling_EM', FF.EnergyMeter, inlet=self.BHS_In, outlet=self.BHS_Out, pipe=self.Pipe_Check_BHS_Out_VS_Sec_check)


        #VV ST
        self.VV_ST=self.add('VV_ST', ST.ST, CW=CW_VS, T0=T0_VV)

        # Connect EMHW in parallel
        self.EMHWs = []
        self.N_EMHW = len(EMHW_defs)
        for i, EMHW_i in enumerate(EMHW_defs):
            EMHW_conf = {'Config': EMHW_i}
            EMHW_conf.update({'F1': CW, 'F2': CW, 'T_F1': 15, 'T_F2': 30, 'q': 0, 'kpipe': 10, 'L_Pipe': 1,
                              'D_Pipe': 0.05, #'Pump_Step1_Speed': 0, 'Pump_Step2_Speed': 0,
                              'has_Subcooler': False,
                              'Pump_Step3_Speed': 0,

                              #'Step1_Prim_In': self.SCC.ST3.Top,
                              #'Step1_Prim_Out': self.SCC.ST3.Bottom,
                              #'Step2_Prim_In': self.SCC.ST1.Top,
                              #'Step2_Prim_Out': self.SCC.ST1.Bottom,
                              'Step3_Prim_In': self.VV_ST.Top,
                              'Step3_Prim_Out': self.VV_ST.Bottom,
                              'VV': VV_list[i],

                              })  # EMHW

            # EMHW
            if i > 0:
                EMHW_name = 'EMHW' + str(i + 1)
            else:
                EMHW_name = 'EMHW'

            EMHW_c = self.add(EMHW_name, EMHW.EMHW, **EMHW_conf)

            self.EMHWs.append(EMHW_c)

            # Add consumer pipes


        #Connect EMAs in series
        self.EMAs=[]
        self.N_EMA = len(EMA_defs)
        self.N_EMB = len(EMB_defs)


        self.N_EMA_sec = len(EMA_sec_defs) if EMA_sec_defs else 0

        ema_VS_inlet = self.VS_Pri_in


        ema_KB_inlets = [self.KB_return]
        ema_KB_outlets = [self.KB_supply]

        if UK_list:
            ema_UK_inlets = [self.UK_in]
            ema_UK_outlets = [self.UK_out]

        ema_VS_inlets = [self.VS_Pri_in]

        subcounter=0

        self.parallel = EMA_Parallel

        for i in range(1, self.N_EMA+self.N_EMB):
            ema_KB_inlets.append(self.add('EMA_KB_in_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))
            ema_KB_outlets.append(self.add('EMA_KB_out_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))

        if self.parallel:
            ema_VS_outlets = [self.VS_Pri_out]
            for i in range(1, self.N_EMA):
                ema_VS_inlets.append(self.add('EMA_VS_in_' + str(i), FF.Volume, Fluid=CW, T0=T0_VS, V=0.1))

                #ema_VS_inlets.append(ema_VS_outlets[i - 1])
                #ema_VS_outlets.insert(i - 1, ema_VS_inlets[i])
                ema_VS_outlets.append(self.add('EMA_VS_out_' + str(i), FF.Volume, Fluid=CW, T0=T0_VS, V=0.1))

                if UK_list:
                    ema_UK_inlets.append(self.add('EMA_UK_in_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))
                    ema_UK_outlets.append(self.add('EMA_UK_out_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))

            FF.make_pipe_lines(self, [ema_VS_inlets, reversed(ema_VS_outlets)], kV_VS)
        else:
            ema_VS_outlets = []

            for i in range(self.N_EMA):
                if i > 0:
                    ema_KB_inlets.append(self.add('EMA_KB_in_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))
                    ema_KB_outlets.append(self.add('EMA_KB_out_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))


                    # ema_VS_inlets.append()

                    ema_VS_inlets.append(ema_VS_outlets[i - 1])

                    if UK_list:
                        ema_UK_inlets.append(self.add('EMA_UK_in_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))
                        ema_UK_outlets.append(self.add('EMA_UK_out_' + str(i), FF.Volume, Fluid=CW, T0=T0_KB, V=0.1))

                # ema_VS_outlets.insert(i-1, ema_VS_inlets[i])
                if i < self.N_EMA - 1:
                    ema_VS_outlets.append(self.add('EMA_VS_in_' + str(i + 1), FF.Volume, Fluid=CW, T0=T0_VS, V=0.1))
                else:
                    ema_VS_outlets.append(self.VS_Pri_out)

            FF.make_pipe_check_lines(self, [ema_VS_outlets], kV_VS)

        FF.make_pipe_lines(self, [ema_KB_inlets, reversed(ema_KB_outlets)], kV_KB)

        subcounter = -1
        for i, EMA_i in enumerate(EMA_defs):


            EMA_name = 'EMA'+str(i+1) if i>0 else 'EMA'



            #Create EMA
            EMA_conf= {'Config': EMA_i,
                #'RF': RF,
                'Compressor_states': [0, 0, 0, 0],
                'Pump_Evap_Speed': 1,
                'Pump_Cond_Speed': 1,
                'Pump_Sub_Speed': 1,
                '3W_Subcooler_Bypass': 0,
                'In_Evaporator': ema_KB_inlets[i],
                'Out_Evaporator': ema_KB_outlets[i],
                'In_Condenser': ema_VS_inlets[i],
                'Out_Condenser': ema_VS_outlets[i],
                'In_Subcooler': ema_UK_inlets[i] if UK_list else None,
                'Out_Subcooler': ema_UK_outlets[i] if UK_list else None

            }

            print(EMA_name)
            #self.EMAs.append(
            self.EMAs.append(self.add(EMA_name, EMA.EMA, CW_Evap=CW_KB, CW_Cond=CW_VS, CW_Sub=CW_UK, T_Evap_ini=T0_KB,
                             T_Cond_ini=T0_VS, subcooler=True if UK_list else False, **EMA_conf))
            #self.EMAs.append(self.add(EMA_name, EMA.EMA, CW_KB, CW_VS, T0_KB, T0_VS, subcooler=False, **EMA_conf))


        #What should go instead of EMB
        #Make EMBs
        self.EMBs = []
        for i, EMB_i in enumerate(EMB_defs):

            EMB_conf = {'Config': EMB_i,
                'Dual_Circuit': False,
                'has_subcooler': False,
                'Fix_Pump_Flow': False,
                'Compressor_states': [0],
                'Pump_Evap1_Speed': 1,
                'Pump_Cond1_Speed': 1,
                #'Pump_Evap2_Speed': 1,
                #'Pump_Cond2_Speed': 1,
                #'Pump_Sub_Speed': 1,
                '3W_Space_Hot': 0,
                'In_Evaporator1': ema_KB_inlets[self.N_EMA+i],
                'Out_Evaporator1': ema_KB_outlets[self.N_EMA+i],
                'In_Condenser1_2': self.EMB_Cond1_in,
                'Out_Condenser1_2': self.EMB_Cond1_out,
                'In_Condenser1_1': self.VV_ST.Bottom,
                'Out_Condenser1_1': self.VV_ST.Top,
                #'In_Evaporator2': self.SCC.ST3.Top,
                #'Out_Evaporator2': self.SCC.ST3.Bottom,
                #'In_Condenser2': self.EMB_Cond2_in,
                #'Out_Condenser2': self.EMB_Cond2_out,
                #'In_Subcooler': self.EMB_Sub_in,
                #'Out_Subcooler': self.EMB_Sub_out,
            }

            if i>0:
                EMB_name = 'EMB'+str(i+1)
            else:
                EMB_name = 'EMB'


            self.EMBs.append(self.add(EMB_name, self.KVP_HW, CW_Evap=CW_KB, CW_Cond=CW_VS, T_Evap_ini=T0_KB, T_Cond_ini=T0_VS, **EMB_conf))

        #Make connecting pipes for VS


        self.VS_Return_Valve = self.add('VS_Return_Valve', FF.Valve_Regulated, kV=kV_VS, S_set_in=0, side1=self.VS_Short_supply,
                                  side2=self.VS_Short_return)

        self.add('VS_secondary_bypass', FF.ThreeWayValve_Regulated, CW_VS, kV_VS, V_VS, T0_VS,
                 0,
                 A=self.get_item_name('VS_Sec_check'),
                 B=self.get_item_name('VS_Sec_in'),
                 C=self.get_item_name('VS_Pri_in'))

        if VS_list:
            for i, VS in enumerate(VS_list):
                self.add('Bypass_VS'+str(i+1), FF.ThreeWayValve_Regulated, CW, 2*kV_VS, 0.1, T0_VS,
                         1,
                         A=VS.Return_Pri,
                         B=self.VS_supply,
                         C=self.VS_return
                         )

                #Create pipe supply, Create pipe return
                #self.add('Pipe_VS_return_'+str(i), FF.Pipe, kV=kV_VS,
                 #        side1=VS.Return_Pri, side2=self.VS_return)
                self.add('Pipe_VS_supply_' + str(i+1), FF.Pipe, kV=kV_VS,
                         side1=self.VS_supply, side2=VS.Supply_Pri)

        if KB_list:
            for i, KB in enumerate(KB_list):
                self.add('Bypass_KB' + str(i + 1), FF.ThreeWayValve_Regulated, CW, 2*kV_KB, 0.1, T0_KB,
                         1,
                         A=KB.Return_Pri,
                         B=self.KB_supply,
                         C=self.KB_return
                         )

                #Create pipe supply, Create pipe return
                #self.add('Pipe_KB_return_'+str(i), FF.Pipe, kV=kV_KB,
                #         side1=KB.Return_Pri_Pri, side2=self.KB_return)
                self.add('Pipe_KB_supply_' + str(i), FF.Pipe, kV=kV_KB,
                         side1=self.KB_supply, side2=KB.Supply_Pri)

        if Custom_list:
            for i, cc in enumerate(Custom_list):
                self.add('Pipe_C' + str(i + 1) + '_In', FF.Pipe, kV=cc['kV'],
                         side1=cc['Consumer_Supply'], side2=self.get_item_name(cc['Supply']))

                self.add('Pipe_C' + str(i + 1) + '_Out', FF.Pipe, kV=cc['kV'],
                         side1=self.get_item_name(cc['Return']), side2=cc['Consumer_Return'])


    def output_(self, sys_dict):

        #Space Heating Power:
        Power_space_heating = 0
        EMA_Comp_Power = 0
        EMB_Comp_Power = 0
        Cooling_Power = 0
        Energy_Consumption = 0
        Energy_Consumption_Compressors = 0

        for EMA in self.EMAs:
            Power_space_heating += sys_dict[EMA.gp('Power_Heating')]
            EMA_Comp_Power += sys_dict[EMA.gp('Power_Usage')]
            Cooling_Power += -sys_dict[EMA.gp('Power_Evaporator')]
            Energy_Consumption += sys_dict[EMA.gp('Energy_Usage')]
            Energy_Consumption_Compressors += sys_dict[EMA.gp('Energy_Usage_Compressor')]

        for EMB in self.EMBs:
            Power_space_heating += sys_dict[EMB.gp('Power_Heating')]
            EMB_Comp_Power += sys_dict[EMB.gp('Power_Usage')]
            Energy_Consumption += sys_dict[EMB.gp('Energy_Usage')]
            Energy_Consumption_Compressors += sys_dict[EMB.gp('Energy_Usage_Compressor')]


        sys_dict[self.gp('EMA_Comp_Power')] = EMA_Comp_Power
        sys_dict[self.gp('EMB_Comp_Power')] = EMB_Comp_Power
        sys_dict[self.gp('Space_Heating_Power')] = Power_space_heating
        sys_dict[self.gp('Cooling_Power')] = Cooling_Power
        # 'Power Consumption':
        sys_dict[self.gp('Power_Consumption')] = EMA_Comp_Power + EMB_Comp_Power

        sys_dict[self.gp('Energy_Consumption')] = Energy_Consumption/3600
        sys_dict[self.gp('Energy_Consumption_Compressors')] = Energy_Consumption_Compressors/3600
        sys_dict[self.gp('Energy_Consumption_Evap_Pumps')] = sum([sys_dict[EMA.gp('Energy_Usage_Evap_Pump')] / 3600 for EMA in self.EMAs])



        #'Total COP':
        sys_dict[self.gp('Total_COP')] = (Power_space_heating + Cooling_Power)/ (EMB_Comp_Power+ EMA_Comp_Power)
    
    def print_output(self,t, sys_dict):
        pass
        #self.Rosendal.print_output(t, sys_dict)

