import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
#import Liquid
import sim_components.machines.SCC as SCC
import sim_components.machines.EMHW as EMHW
import sim_components.machines.EMA as EMA
import sim_components.machines.EMB as EMB
#import sim_tool_EM.RefpropFluid as Fluid
import sim_components.thermodynamics.ST as ST


#LinK: m=kg/s, H=J/s, p=kPa, T=K
#Node: m=kg, H=J, p=kPa, T=K

class EM_System(BC.Subsystem):
    def construct_Subsystem(self, **inputs):


        #Insert Buffer Tanks
        # SCC
        self.SCC = self.add('SCC', SCC.SCC, **{'CW': CW, 'L_Pipe': 1, 'D_Pipe': 0.05})

        #VV ST
        self.VV_ST = self.add('VV_ST', ST.ST, 60, **{'V_CW': 3, 'h': 10000, 'N_nodes': 3})


        #Insert Machines
        for EMA in inputs['EMA_list']:
            EMA_conf = {'Config': inputs['Conf_EMA']}
            EMA_conf.update({
                'Compressor_states': [0, 0, 0, 0],
                'Pump_Evap_Speed': 1,
                'Pump_Cond_Speed': 1,
                'Pump_Sub_Speed': 1,
                '3W_Subcooler_Bypass': 0,
                'In_Evaporator': inputs['KB'].Return,
                'Out_Evaporator': inputs['KB'].Supply,
                'In_Condenser': EMA_VoCW[0],
                'Out_Condenser': EMA_VoCW[1],
                'In_Subcooler': self.SCC.ports['Out_ST3_Prim'],
                'Out_Subcooler': self.SCC.ports['In_ST1_Prim']
            })
            if i > 1:
                EMA_name = 'EMA' + str(i)
            else:
                EMA_name = 'EMA'

            self.EMAs += [
                self.add(EMA_name, EMA.EMA, CW_Evap, CW_Cond, CW_Sub, T_Evap_ini, T_Cond_ini, T_Sub_ini, **EMA_conf)]

        for EMB in inputs['EMB_list']:

        for EMHW in inputs['EMB_list']:

        #Make connecting pipes