from sim_components.generic.items import *
import sim_components.thermodynamics.Fluid_Flow as FF
import sim_components.thermodynamics.Heat_Exchanger_Nodes_Mean_p as MHX

class Consumer(Subsystem):
    def construct_Subsystem(self, peak_producer = None, Reservoir=None, var_load=None, CW=None, kV=10, V=1, P=0, peak_sign=1, T_set=20, dT=5, PL=None, *args, **kwargs):

        self.calc_funcs = [self.consume]
        print('var load: ', var_load)
        print('reservoir: ', Reservoir)
        if var_load:
            self.calc_funcs.append(self.consume_power)

        self.HX = self.add('HX', MHX.Heat_Exchanger, 6, 761*3, CW, CW, T_set,
                           T_set, 0, F2_1=True, Config='B649H_2', dual='single')

        self.Reservoir = Reservoir
        if Reservoir:
            self.Supply = self.add('Supply', FF.ThermalReservoir, CW, V, T0=T_set)

            self.Return = self.add('Return', FF.ThermalReservoir, CW, V, T0=T_set + Reservoir)
            print('adding reservoir')
            F_min = 20

        else:
            print('adding volume')
            self.Supply = self.add('Supply', FF.Volume, CW, V, 0,
                                   T0=T_set)

            self.Return = self.add('Return', FF.Volume, CW, V, 0,
                                   T0=T_set)

            F_min = 0.1

        self.Pipe_Supply = self.add('Pipe_Supply', FF.Pipe, kV, side1=self.HX.ports['F1A_Out'], side2=self.Supply)
        self.Pipe_Return = self.add('Pipe_Return', FF.Pipe, kV, side1=self.Return, side2=self.HX.ports['F1A_In'])

        self.Pipe = self.add('Pipe', FF.Pipe_Fixed_Massflow, m_dot=0,
                             side1=self.Supply, side2=self.Return)

        self.Supply_Pri = self.HX.ports['F2_In']
        self.Return_Pri = self.HX.ports['F2_Out']

        if peak_producer:
            self.Peak = self.add('Peak', PeakProducer, parent=self, peak_sign=peak_sign, **peak_producer)

        self.Variables = [
            {'name': 'P', 'unit': 'kW', 'type': 'param', 'val': P * 1000},
            {'name': 'T_set', 'unit': 'C', 'type': 'param', 'val': T_set + (7 if var_load else 0)},
            {'name': 'dT_extra', 'unit': 'C', 'type': 'param', 'val': 7 if var_load else 0},
            {'name': 'int_err', 'unit': 'C', 'type': 'state', 'val': 0},
            {'name': 'kI', 'unit': '', 'type': 'param', 'val': 0.01},
            {'name': 'Err', 'unit': 'C', 'type': 'param', 'val': 0},
            {'name': 'dT', 'unit': 'C', 'type': 'param', 'val': dT},
            {'name': 'E', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'F_min', 'unit': 'kg/s', 'type': 'param', 'val': F_min},
            {'name': 'W_MWh', 'unit': 'MWh/W', 'type': 'param', 'val': 1.0 / 1e6 / 3600},
        ]

    def consume(self):
        F = max(F_min, abs(P / (dT * 4187)), 0.1)
        Pipe.m_dot = F

        Err = T_set - Supply.T

        Return.H_dot = - P

        E_dot = P*W_MWh

        E_Balance = E

    def consume_power(self):
        Err_consume = Err - dT_extra
        int_err_dot = Err_consume

        P = -(int_err * kI + Err_consume*100)*1000

class PeakProducer(Node):
    def construct_Node(self, parent=None, kP=1, bias=1, peak_sign=0, *Args, **Kwargs):
        #print(parent.name)
        self.parent = parent
        if not self.parent.Reservoir:
            self.calc_funcs = [self.peak]
            E_state = True
            #print('sdfsfd')
        else:
            #print('df')
            E_state = False

        self.Variables = [
            {'name': 'bias', 'unit': 'K', 'type': 'param', 'val': bias},
            #{'name': 'kP', 'unit': 'K', 'type': 'param', 'val': kP*1e3},
            {'name': 'peak_sign', 'unit': '1', 'type': 'param', 'val': peak_sign},
            {'name': 'kP', 'unit': '1', 'type': 'param', 'val': kP},
            {'name': 'E', 'unit': 'MWh', 'type': 'state' if E_state else 'param', 'val': 0},
            {'name': 'P', 'unit': 'MWh', 'type': 'param', 'val': 0},
            {'name': 'W_MWh', 'unit': 'MWh/W', 'type': 'param', 'val': 1.0 / 1e6 / 3600}
        ]

    def peak(self):
        P_peak_interim = parent.F * (parent.F>0) * (parent.Err - bias) * 4187
        #parent.Pipe.m_dot *
            #(parent.Err - bias) * kP
        P = (((parent.Err - bias) * peak_sign) > 0)*P_peak_interim*0
        #* peak_sign
        E_dot = P*W_MWh
        parent.Return.H_dot = P

    def output(self, sys_dict):
        #print('asdsfsfd',self.parent.name)
        if self.parent.Reservoir:
           #print('herer')
           sys_dict[self.gp('P')] = -sys_dict[self.parent.gp('Supply.H_dot')]
           sys_dict[self.gp('E')] = -sys_dict[self.parent.gp('Supply.H')]*sys_dict[self.parent.gp('W_MWh')]