from sim_components.generic.items import *
import sim_components.thermodynamics.Fluid_Flow as FF
import sim_components.thermodynamics.Heat_Exchanger_Nodes_Mean_p as MHX

class Consumer_(Subsystem):
    def construct_Subsystem(self, peak_producer = None, fix_flow=None, Reservoir=None, Fix_Err=None, var_load=None, var_flow=5, CW=None, kV=10, V=1, P=0, P_demand=None, peak_sign=1, T_set=20, return_pipe_kV=None, T_return=None,*Args, **Kwargs):
        dT = var_flow
        self.Reservoir = Reservoir

        self.calc_funcs = [self.reservoir_energy]
        if Reservoir:

            self.Supply = self.add('Supply', FF.ThermalReservoir, CW, V, T0=T_set)

            self.Return = self.add('Return', FF.ThermalReservoir, CW, V, T0=T_set+Reservoir)
            dT=Reservoir


        else:
            self.calc_funcs.append(self.consume)
            self.Supply = self.add('Supply', FF.Volume, CW, V, 0,
                                   T0=T_set)

            #self.Middle = self.add('Middle', FF.Volume, CW, V, 0,
            #                       T0=T_set)

            self.Return = self.add('Return', FF.Volume, CW, V, 0,
                                          T0=T_set)

        self.Supply_Pri = self.Supply
        self.Return_Pri = self.Return



        if fix_flow:
            self.Pipe = self.add('Pipe', FF.Pipe_Fixed_Massflow, m_dot=fix_flow,
                                 side1=self.Supply, side2=self.Return)

        else:

            self.Pipe = self.add('Pipe', FF.Pipe, kV, side1=self.Supply, side2=self.Return)


        if return_pipe_kV:
            assert fix_flow or var_flow, "Cannot have return pipe without var or fixed flow"
            self.Pipe_Loop = self.add('Pipe_Loop', FF.Pipe, return_pipe_kV, side1=self.Supply, side2=self.Return)

        if peak_producer:
            self.Peak = self.add('Peak', PeakProducer, parent=self, peak_sign=peak_sign, **peak_producer)

        if Fix_Err:
            assert Reservoir, "Can only use fixed err with reservoir"

        if var_load:
            self.calc_funcs.append(self.consume_power)

        if T_return:
            self.calc_funcs.append(self.set_return_T)

        #print('P dem ',P_demand)
        if not P_demand == None:
            print('add')
            print(self.path)
            print()
            #print('Adding P demand to ', self.name)

            self.calc_funcs.append(self.consume_demand)
        extra_dT = 5
        self.Variables = [
            {'name': 'P', 'unit': 'kW', 'type': 'param', 'val': P*1000},
            {'name': 'T_set', 'unit': 'C', 'type': 'param', 'val': T_set + peak_sign*extra_dT  if var_load else T_set},
            {'name': 'T_return', 'unit': 'C', 'type': 'param', 'val': T_return},
            {'name': 'extra_dT', 'unit': 'C', 'type': 'param', 'val': extra_dT},

            {'name': 'int_err', 'unit': 'C', 'type': 'state', 'val': 0},
            {'name': 'Err', 'unit': 'C', 'type': 'param', 'val': Fix_Err if Fix_Err else 0},
            {'name': 'dT', 'unit': 'C', 'type': 'param', 'val': dT},
            {'name': 'E', 'unit': 'MWh', 'type': 'state', 'val': 0},

            {'name': 'E_demand_err', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'E_demand', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'P_demand', 'unit': 'kW', 'type': 'param', 'val': P_demand * 1000 if P_demand else 0},
            {'name': 'T_set_demand', 'unit': 'kW', 'type': 'param', 'val': T_set},
            {'name': 'kI_demand', 'unit': '1/s', 'type': 'param', 'val': 1/3600},
            #{'name': 'frac_demand_derate', 'unit': '1/K', 'type': 'param', 'val': 0.05*peak_sign},
            {'name': 'k_decay', 'unit': '1/K', 'type': 'param', 'val': 0.1/(24*3600)},

            {'name': 'W_MWh', 'unit': 'MWh/W', 'type': 'param', 'val': 1.0/1e6/3600},
            {'name': 'F_min', 'unit': 'kg/s', 'type': 'param', 'val': 1},
            {'name': 'active_flow', 'unit': '1', 'type': 'param', 'val': 0},
            {'name': 'T_in', 'unit': '1', 'type': 'param', 'val': 20},
            {'name': 'max_dT', 'unit': '1', 'type': 'param', 'val': 5},
            {'name': 'max_E_demand_err', 'unit': 'MWh', 'type': 'param', 'val': 3},
            {'name': 'prod_sign', 'unit': '1', 'type': 'param', 'val': peak_sign},
            {'name': 'T_set_idle', 'unit': '1', 'type': 'param', 'val': 25},

            #0.5 if fix_flow or var_flow else 1 if Fix_Err==0 else 0},


        ]

    def set_return_T(self):
        dT = T_set - T_return

    def consume_demand(self):
        P_catch_up = E_demand_err*kI_demand/W_MWh

        dT_ = T_set_demand - T_in

        dT_corr = dT_*(abs(dT_) > .1) + (abs(dT_) <= .1)

        P_set = P_demand + P_catch_up
        h_est = P_demand/dT_corr * (abs(P_demand)>0) + (abs(P_demand)<=0)
        P = (Supply.T - T_in) * h_est
        P = (prod_sign*P <= prod_sign*P_set)*P + P_set*(prod_sign*P> prod_sign*P_set)
        #T_set = T_set_demand
        T_set_add = P_catch_up / h_est * (abs(dT_)>1) * (abs(P_demand)>0)
        T_set_add = T_set_add * (abs(T_set_add) < max_dT) + (abs(T_set_add) >= max_dT) * sign(T_set_add) * max_dT

        T_set = (T_set_add + T_set_demand)*(P*prod_sign > 0) + (P*prod_sign <= 0)*T_set_idle
        E_demand_dot = P_demand*W_MWh
        E_demand_err_dot = (P_demand-P)*W_MWh * (abs(E_demand_err)<=max_E_demand_err) - E_demand_err*k_decay

    def consume(self):
        #Err=T_set-(Return.T+dT)
        Err = T_set - Supply.T

        #Return.H_dot = (Middle.h - Return.h) * F - P
        #Middle.H_dot = (Return.h - Middle.h) * F


        Return.H_dot = (Supply.h - Return.h) * F - P
        Supply.H_dot = (Return.h - Supply.h) * F


        #E_dot = P*W_MWh

    def consume_power(self):
        int_err_dot = Err-prod_sign*extra_dT
        kI = 1
        P = -(int_err * kI + Err*1000)*1000

    def reservoir_energy(self):
        F = abs(P / (dT * 4187))
        Supply.T_set = T_set
        Return.T_set = T_set - dT

        E_dot =  -P*W_MWh

        E_Balance = -E + (Supply.H +Return.H)*W_MWh

    def err(self):
        Err = E_Balance*1000

    #def pump_control(self):
    #    Pipe.m_dot = max(0, abs(P)/4187/dT, F_min)

    def output_(self, sys_dict):
        sys_dict[self.gp('P_Balance')] = (sys_dict[self.gp('P')] + sys_dict[self.gp('Supply.H_dot')]  + sys_dict[self.gp('Return.H_dot')])/1000

class Consumer(Subsystem):
    def construct_Subsystem(self, peak_producer = None, fix_flow=None, Reservoir=None, Fix_Err=None, var_load=None, var_flow=5, CW=None, kV=10, V=1, P=0, P_demand=None, peak_sign=1, T_set=20, return_pipe_kV=None, T_return=None,*Args, **Kwargs):

        self.HX = self.add('HX', MHX.Heat_Exchanger, 6, 761*3, CW, CW, T_set,
                           T_set, 0, F2_1=True, Config='B649H_2', dual='single')

        self.Reservoir = Reservoir
        dT = var_flow
        self.calc_funcs = [self.reservoir_energy]
        if Reservoir:
            dT = Reservoir

            self.Supply = self.add('Supply', FF.ThermalReservoir, CW, V, T0=T_set)

            self.Return = self.add('Return', FF.ThermalReservoir, CW, V, T0=T_set+Reservoir)


        else:
            self.calc_funcs.append(self.consume)
            self.Supply = self.add('Supply', FF.Volume, CW, V, 0,
                                   T0=T_set)

            #self.Middle = self.add('Middle', FF.Volume, CW, V, 0,
            #                       T0=T_set)

            self.Return = self.add('Return', FF.Volume, CW, V, 0,
                                          T0=T_set)

        self.Pipe = self.add('Pipe', FF.Pipe_Fixed_Massflow, m_dot=0,
                             side1=self.Supply, side2=self.Return)



        #if fix_flow:


        #else:

        #    self.Pipe = self.add('Pipe', FF.Pipe, kV, side1=self.Supply, side2=self.Return)

        self.Pipe_Supply = self.add('Pipe_Supply', FF.Pipe, kV, side1=self.HX.ports['F1A_Out'], side2=self.Supply)
        self.Pipe_Return = self.add('Pipe_Return', FF.Pipe, kV, side1=self.Return, side2=self.HX.ports['F1A_In'])

        self.Supply_Pri = self.HX.ports['F2_In']
        self.Return_Pri = self.HX.ports['F2_Out']

        #if return_pipe_kV:
        #    assert fix_flow or var_flow, "Cannot have return pipe without var or fixed flow"
        #    self.Pipe_Loop = self.add('Pipe_Loop', FF.Pipe, return_pipe_kV, side1=self.Supply, side2=self.Return)

        if peak_producer:
            self.Peak = self.add('Peak', PeakProducer, parent=self, peak_sign=peak_sign, **peak_producer)

        if Fix_Err:
            assert Reservoir, "Can only use fixed err with reservoir"

        if var_load:
            print('adding consume power to: ', self.path)
            self.calc_funcs.append(self.consume_power)

        if T_return:
            self.calc_funcs.append(self.set_return_T)
        #print('P dem ',P_demand)
        if not P_demand == None:
            #print('Adding P demand to ', self.name)

            self.calc_funcs.append(self.consume_demand)
        extra_dT = 7
        self.Variables = [
            {'name': 'P', 'unit': 'kW', 'type': 'param', 'val': P*1000},
            {'name': 'T_set', 'unit': 'C', 'type': 'param', 'val': T_set + peak_sign*extra_dT  if var_load else T_set},
            {'name': 'T_return', 'unit': 'C', 'type': 'param', 'val': T_return},

            {'name': 'extra_dT', 'unit': 'C', 'type': 'param', 'val': extra_dT},

            {'name': 'int_err', 'unit': 'C', 'type': 'state', 'val': 0},
            {'name': 'Err', 'unit': 'C', 'type': 'param', 'val': Fix_Err if Fix_Err else 0},
            {'name': 'dT', 'unit': 'C', 'type': 'param', 'val': dT},
            {'name': 'E', 'unit': 'MWh', 'type': 'state', 'val': 0},

            {'name': 'E_demand_err', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'E_demand', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'P_demand', 'unit': 'kW', 'type': 'param', 'val': P_demand * 1000 if P_demand else 0},
            {'name': 'T_set_demand', 'unit': 'kW', 'type': 'param', 'val': T_set},
            {'name': 'kI_demand', 'unit': '1/s', 'type': 'param', 'val': 1/3600},
            #{'name': 'frac_demand_derate', 'unit': '1/K', 'type': 'param', 'val': 0.05*peak_sign},
            {'name': 'k_decay', 'unit': '1/K', 'type': 'param', 'val': 0.1/(24*3600)},

            {'name': 'W_MWh', 'unit': 'MWh/W', 'type': 'param', 'val': 1.0/1e6/3600},
            {'name': 'F_min', 'unit': 'kg/s', 'type': 'param', 'val': 1},
            {'name': 'active_flow', 'unit': '1', 'type': 'param', 'val': 0},
            {'name': 'T_in', 'unit': '1', 'type': 'param', 'val': 20},
            {'name': 'max_dT', 'unit': '1', 'type': 'param', 'val': 5},
            {'name': 'max_E_demand_err', 'unit': 'MWh', 'type': 'param', 'val': 3},
            {'name': 'prod_sign', 'unit': '1', 'type': 'param', 'val': peak_sign},
            {'name': 'T_set_idle', 'unit': '1', 'type': 'param', 'val': 25},

            #0.5 if fix_flow or var_flow else 1 if Fix_Err==0 else 0},


        ]
        print(self.path)
        print(self.Variables[1])

    def set_return_T(self):
        dT = T_set - T_return

    def consume_demand(self):
        P_catch_up = E_demand_err*kI_demand/W_MWh

        dT_ = T_set_demand - T_in

        dT_corr = dT_*(abs(dT_) > .1) + (abs(dT_) <= .1)

        P_set = P_demand + P_catch_up
        h_est = P_demand/dT_corr * (abs(P_demand)>0) + (abs(P_demand)<=0)
        P = (Supply.T - T_in) * h_est
        P = (prod_sign*P <= prod_sign*P_set)*P + P_set*(prod_sign*P> prod_sign*P_set)
        #T_set = T_set_demand
        T_set_add = P_catch_up / h_est * (abs(dT_)>1) * (abs(P_demand)>0)
        T_set_add = T_set_add * (abs(T_set_add) < max_dT) + (abs(T_set_add) >= max_dT) * sign(T_set_add) * max_dT

        T_set = (T_set_add + T_set_demand)*(P*prod_sign > 0) + (P*prod_sign <= 0)*T_set_idle
        E_demand_dot = P_demand*W_MWh
        E_demand_err_dot = (P_demand-P)*W_MWh * (abs(E_demand_err)<=max_E_demand_err) - E_demand_err*k_decay

    def consume(self):
        #Err=T_set-(Return.T+dT)
        Err = T_set - Supply.T

        #Return.H_dot = (Middle.h - Return.h) * F - P
        #Middle.H_dot = (Return.h - Middle.h) * F

        Pipe.m_dot = F
        #Return.H_dot = (Supply.h - Return.h) * F - P
        Return.H_dot = - P
        #Supply.H_dot = (Return.h - Supply.h) * F



        #E_dot = P*W_MWh

    def consume_power(self):
        int_err_dot = Err-prod_sign*extra_dT
        kI = .1
        P = -(int_err * kI + Err*100)*1000

    def reservoir_energy(self):
        F = abs(P / (dT * 4187))
        Pipe.m_dot = F
        E_dot =  -P*W_MWh
        Supply.T_set = T_set
        Return.T_set = T_set - dT

        E_Balance = -E + (Supply.H +Return.H)*W_MWh

    def err(self):
        Err = E_Balance*1000

    #def pump_control(self):
    #    Pipe.m_dot = max(0, abs(P)/4187/dT, F_min)

    def output_(self, sys_dict):
        sys_dict[self.gp('P_Balance')] = (sys_dict[self.gp('P')] + sys_dict[self.gp('Supply.H_dot')]  + sys_dict[self.gp('Return.H_dot')])/1000



class Consumer_VV(Subsystem):
    def construct_Subsystem(self, peak_producer = None, CW=None, kV=10, V=0.1, T_Cold= 0, P=100, P_VVC=10, T_set=20, *Args, **Kwargs):
        self.Reservoir=None

        self.Supply = self.add('Supply', FF.Volume, CW, V, 0,
                               T0=T_set)
        self.Return = self.add('Return', FF.Volume, CW, V, 0,
                               T0=T_set)

        self.Pipe = self.add('Pipe', FF.Pipe, kV, side1=self.Supply, side2=self.Return)

        self.Cold = self.add('Cold', FF.Reservoir, CW, T0=T_Cold)

        if peak_producer:
            self.Peak = self.add('Peak', PeakProducer, parent=self, **peak_producer)

        self.calc_funcs = [self.consume]

        self.Variables = [
            {'name': 'P', 'unit': 'kW', 'type': 'param', 'val': P*1000},
            {'name': 'P_VVC', 'unit': 'kW', 'type': 'param', 'val': P_VVC*1000},
            {'name': 'T_set', 'unit': 'C', 'type': 'param', 'val': T_set},
            {'name': 'Err', 'unit': 'C', 'type': 'param', 'val': 0},
            {'name': 'F_VV', 'unit': 'kg/s', 'type': 'param', 'val': 0},
            {'name': 'E', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'E_VVC', 'unit': 'MWh', 'type': 'state', 'val': 0},
            {'name': 'W_MWh', 'unit': 'MWh/W', 'type': 'param', 'val': 1.0 / 1e6 / 3600}
        ]

    def consume(self):
        Err=T_set-Supply.T
        F_VV = P / ((Supply.T - Cold.T) * 4187)
        F_VV = F_VV*(F_VV>0)
        F = Pipe.m_dot


        Supply.H_dot = - F_VV * Supply.h
        Supply.m_dot = - F_VV

        E_dot = P * W_MWh
        E_VVC_dot = P_VVC * W_MWh


        Return.H_dot = - P_VVC


class PeakProducer(Node):
    def construct_Node(self, parent=None, kP=1, bias=1, peak_sign=0, *Args, **Kwargs):
        #print(parent.name)
        self.parent = parent
        if not self.parent.Reservoir:
            self.calc_funcs = [self.peak]
            E_state = True
            #print('sdfsfd')
        else:
            #print('df')
            E_state = False

        self.Variables = [
            {'name': 'bias', 'unit': 'K', 'type': 'param', 'val': bias},
            #{'name': 'kP', 'unit': 'K', 'type': 'param', 'val': kP*1e3},
            {'name': 'peak_sign', 'unit': '1', 'type': 'param', 'val': peak_sign},
            {'name': 'kP', 'unit': '1', 'type': 'param', 'val': kP},
            {'name': 'E', 'unit': 'MWh', 'type': 'state' if E_state else 'param', 'val': 0},
            {'name': 'P', 'unit': 'MWh', 'type': 'param', 'val': 0},
            {'name': 'W_MWh', 'unit': 'MWh/W', 'type': 'param', 'val': 1.0 / 1e6 / 3600}
        ]

    def peak(self):
        P_peak_interim = parent.F * (parent.F>0) * (parent.Err - bias) * 4187
        #parent.Pipe.m_dot *
            #(parent.Err - bias) * kP
        P = (((parent.Err - bias) * peak_sign) > 0)*P_peak_interim
        #* peak_sign
        E_dot = P*W_MWh
        parent.Return.H_dot = P

    def output(self, sys_dict):
        #print('asdsfsfd',self.parent.name)
        if self.parent.Reservoir:
           #print('herer')
           sys_dict[self.gp('P')] = -sys_dict[self.parent.gp('Supply.H_dot')]
           sys_dict[self.gp('E')] = -sys_dict[self.parent.gp('Supply.H')]*sys_dict[self.parent.gp('W_MWh')]








if __name__ == '__main__':
    energy_system = {
        #'item_class': 'sim_components.generic.items.SubsystemPrescribed',
        'specification':{
            'items': {
                'CW': {'item_class': 'sim_components.thermodynamics.Fluid_Flow.Liquid_Props', 'Config': 'Water_4'},
                'KB': {'item_class': 'sim_components.systems.energy_system_integration.Consumer_w_hookup', 'CW': '@CW', 'kV': 10, 'V': 0.1},
                'VS': {'item_class': 'sim_components.systems.energy_system_integration.Consumer_w_hookup', 'CW': '@CW', 'kV': 10, 'V': 0.1,
                       'peak_producer': {'kP': 1, 'bias': 0, 'peak_sign': 0}},
                'BHS1': {'item_class': 'sim_components.energy_storage.borehole_storage.BoreholeStorage_KB_VS', 'CW': '@CW', 'KB': '@KB', 'VS': '@VS', 'pump_type': 'Grundfos NBE_65_125-137'},
                'BHS2': {'item_class': 'sim_components.energy_storage.borehole_storage.BoreholeStorage_KB_VS', 'CW': '@CW', 'KB': '@KB', 'VS': '@VS', 'pump_type': 'Grundfos NBE_65_125-137'},

                'VV': {'item_class': 'sim_components.systems.energy_system_integration.Consumer_VV', 'CW': '@CW', 'kV': 10, 'V': 0.1, 'T_Cold': 0, },
                #'EP': {'item_class': 'sim_components.systems.EM_System_Standard_Interface.EM_System',
                #       'CW': '@CW', 'KB': '@KB', 'VS': '@VS', 'VV': '@VV',
                #        'Conf_EMA': 'EMA-1',
                #        'Conf_EMB': 'EMB-1',
                #        'Conf_EMHW': 'EMHW-2',
                #        'N_EMA': 2
                #       },

                #'EP_Reg': {'item_class': 'sim_components.regulators.EM_Regulator.EM_Regulator',
                #           'EM': '@EP',  'KB': '@KB', 'VS': '@VS', 'VV': '@VV'
                #        },

                'EP_Reg': {'item_class': 'sim_components.regulators.EM_Regulator.EP_Regulator_w_EP',
                                        'KB': '@KB', 'VS': '@VS', 'VV': '@VV'
                                   },
                'ES_Reg': {'item_class': 'sim_components.regulators.EM_Regulator.Energy_system_w_BHS_regulator', 'KB': '@KB', 'VS': '@VS', 'BHS': '@BHS1', 'BHS2': '@BHS2'}
            },
        }
    }
    #import sim_components.systems.EM_System_Standard_Interface
    from sim_tools.store.simulation_store_mongodb import Item_Factory
    item_fact = Item_Factory('')
    stub = item_fact.get_Item('Stub', '', SubsystemPrescribed, **energy_system)

