import sim_components.generic.items as B
import numpy as np

import sim_tools.assemble_solve.model_solver as ME
import pickle
import math

from pprint import pprint


class Fluid_Props(B.Item):
    def construct_Item(self, **c):
        self.props = pickle.load( open('thermodynamics/Interp/'+c['file'], "rb" ))
        print(c['file'])
       #self.props = pickle.load(
        #    open('/opt/shared_folders/EM_simulations/Development/EMA_v2 - Manual testing/dependencies/R410A_333_6_file.dat',
         #        "rb"))
        # print(c)

        # print(self.props['lim'])

        def sa(s, k, v, t):
            setattr(s, k + '_' + t, v[t])

        for k, v in self.props['data'].items():
            sa(self, k, v, 'T')
            sa(self, k, v, 'p')
            sa(self, k, v, 'h')
            sa(self, k, v, 's')
            sa(self, k, v, 'q')
            sa(self, k, v, 'rho')
            sa(self, k, v, 'mu')
            sa(self, k, v, 'cp')
            sa(self, k, v, 'k')
            sa(self, k, v, 'sigma')

        self.MW = self.props['w_g']  # g/mol
        self.p_critical = self.props['p_crit']  # kPa


class Liquid_Props(B.Item):
    def construct_Item(self, **c):
        print(c)
        self.rho = c['rho']
        self.Cp = c['Cp']
        self.T = c['T']
        self.v_dyn = c['v_dyn']
        self.v_kin = c['v_kin']
        self.liq_name = c['liquid']

        # From coolprop to see if it works
        self.mu = 0.001518172849562
        self.k = 0.558183414077752
        self.Pr = self.Cp * self.mu / self.k
        self.v_dyn_lin = np.concatenate([[len(self.T), min(self.T), max(self.T)], self.T, self.v_dyn])
        # self.v_kin_lin=np.concatenate([[len(self.T),min(self.T),max(self.T)],self.T,self.v_kin])

        self.add_var('Cp', val=self.Cp)


class Volume(B.Node):
    def construct_Node(self, Fluid=None, V=0.1, q0=0, T0=20, p0=0):

        self.Fluid = Fluid

        # asdasd=dfsdf
        if isinstance(Fluid, Fluid_Props):

            self.rh_p = self.Fluid.rh_p
            self.rh_T = self.Fluid.rh_T
            self.rh_q = self.Fluid.rh_q
            self.pq_T = self.Fluid.pq_T
            self.Tp_q = self.Fluid.Tp_q

            self.pq_rho = self.Fluid.pq_rho
            self.pq_cp = self.Fluid.pq_cp
            self.pq_k = self.Fluid.pq_k
            self.pq_sigma = self.Fluid.pq_sigma
            self.pq_mu = self.Fluid.pq_mu
            self.pq_h = self.Fluid.pq_h
            # [rho, h, p]=self.Fluid.calc_props('Tq',[T0,q0],'rhp')

            rho = ME.bilinear_interpolation(0, T0, q0, [0], self.Fluid.Tq_rho)
            p = ME.bilinear_interpolation(0, T0, q0, [0], self.Fluid.Tq_p)
            h = ME.bilinear_interpolation(0, T0, q0, [0], self.Fluid.Tq_h)
            q_Tp = ME.bilinear_interpolation(0, T0, np.log(p), [0], self.Fluid.Tp_q)
            q_rh = ME.bilinear_interpolation(0, np.log(rho), h, [0], self.Fluid.rh_q)

            self.p = p

            # back up - properties - if calculation does not converge, uses the sat properties of the initial condition
            sigmaL0 = ME.bilinear_interpolation(0, T0, 0, [0], self.Fluid.Tq_sigma) * 1e-3
            kV0 = ME.bilinear_interpolation(0, T0, 1, [0], self.Fluid.Tq_k) * 1e-3
            kL0 = ME.bilinear_interpolation(0, T0, 0, [0], self.Fluid.Tq_k) * 1e-3
            muV0 = ME.bilinear_interpolation(0, T0, 1, [0], self.Fluid.Tq_mu) * 1e-6
            muL0 = ME.bilinear_interpolation(0, T0, 0, [0], self.Fluid.Tq_mu) * 1e-6
            cpV0 = ME.bilinear_interpolation(0, T0, 1, [0], self.Fluid.Tq_cp)
            cpL0 = ME.bilinear_interpolation(0, T0, 0, [0], self.Fluid.Tq_cp)
            rhoV0 = ME.bilinear_interpolation(0, T0, 1, [0], self.Fluid.Tq_rho)
            rhoL0 = ME.bilinear_interpolation(0, T0, 0, [0], self.Fluid.Tq_rho)

            hV0 = ME.bilinear_interpolation(0, T0, 1, [0], self.Fluid.Tq_h)
            hL0 = ME.bilinear_interpolation(0, T0, 0, [0], self.Fluid.Tq_h)
            hLat0 = hV0 - hL0

            rho0_0 = rhoL0
            mu0 = muL0
            k0 = kL0
            Cp0 = cpL0

            m = rho * V
            H = h * m
            # print(self.name)
            # print('p: ', p)
            # print('rho: ', rho)
            # print('m: ', m)
            # print('h: ', h)
            # print('q_Tp: ', q_Tp)
            # print('q_rh: ', q_rh)

            kP = 0.1  # 0.1

            self.MW = self.Fluid.MW  # g/mol
            self.p_critical = self.Fluid.p_critical  # kPa

            self.calc_funcs = [self.F2P_Volume_diff_f]

            self.Variables = [
                {'name': 'm', 'unit': 'kg', 'type': 'state', 'val': m},
                {'name': 'H', 'unit': 'J', 'type': 'state', 'val': H},
                {'name': 'h', 'unit': 'J/kg', 'type': 'param', 'val': h},
                {'name': 'p', 'unit': 'kPa', 'type': 'state', 'val': p},
                {'name': 'T', 'unit': 'K', 'type': 'state', 'val': T0},
                {'name': 'V', 'unit': 'm3', 'type': 'param', 'val': V},
                {'name': 'kP', 'unit': 'Hz', 'type': 'param', 'val': kP},
                {'name': 'rhoV0', 'unit': 'kg/m3', 'type': 'param', 'val': rhoV0},
                {'name': 'rhoL0', 'unit': 'kg/m3', 'type': 'param', 'val': rhoL0},
                {'name': 'muV0', 'unit': 'kg/m3', 'type': 'param', 'val': muV0},
                {'name': 'muL0', 'unit': 'kg/m3', 'type': 'param', 'val': muL0},
                {'name': 'mu0', 'unit': 'kg/m3', 'type': 'param', 'val': mu0},
                {'name': 'kV0', 'unit': 'kg/m3', 'type': 'param', 'val': kV0},
                {'name': 'k0', 'unit': 'kg/m3', 'type': 'param', 'val': k0},
                {'name': 'Cp0', 'unit': 'kg/m3', 'type': 'param', 'val': Cp0},
                {'name': 'rho0_0', 'unit': 'kg/m3', 'type': 'param', 'val': rho0_0},
                {'name': 'kL0', 'unit': 'kg/m3', 'type': 'param', 'val': kL0},
                {'name': 'cpV0', 'unit': 'kg/m3', 'type': 'param', 'val': cpV0},
                {'name': 'cpL0', 'unit': 'kg/m3', 'type': 'param', 'val': cpL0},
                {'name': 'sigmaL0', 'unit': 'kg/m3', 'type': 'param', 'val': sigmaL0},
                {'name': 'hLat0', 'unit': 'J/kg', 'type': 'param', 'val': hLat0},
                {'name': 'hL0', 'unit': 'J/kg', 'type': 'param', 'val': hL0},
            ]


        elif isinstance(Fluid, Liquid_Props):

            self.calc_funcs = [self.Liquid_Volume_diff_f]

            self.Liquid = Fluid

            m0 = self.Fluid.rho * V * 1.1

            self.Variables = [
                {'name': 'm', 'unit': 'kg', 'type': 'state', 'val': m0},
                {'name': 'H', 'unit': 'J', 'type': 'state', 'val': self.Fluid.Cp * (T0 + 273.15) * m0},
                {'name': 'h', 'unit': 'J', 'type': 'param', 'val': self.Fluid.Cp * (T0 + 273.15)},
                {'name': 'q', 'unit': '1', 'type': 'param', 'val': 1},
                {'name': 'p', 'unit': 'kPa', 'type': 'state', 'val': 1e3},
                {'name': 'T', 'unit': 'K', 'type': 'state', 'val': T0},
                {'name': 'V', 'unit': 'm3', 'type': 'param', 'val': V},
                {'name': 'Cp', 'unit': 'J/K', 'type': 'param', 'val': self.Fluid.Cp},
                {'name': 'rho0', 'unit': 'kg/m3', 'type': 'param', 'val': self.Fluid.rho},
                {'name': 'mu', 'unit': 'Pa*s', 'type': 'param', 'val': self.Fluid.mu},
                {'name': 'k', 'unit': 'W/(m2*K)', 'type': 'param', 'val': self.Fluid.k},
                {'name': 'Cp0', 'unit': 'J/K', 'type': 'param', 'val': self.Fluid.Cp},
                {'name': 'rho0_0', 'unit': 'kg/m3', 'type': 'param', 'val': self.Fluid.rho},
                {'name': 'mu0', 'unit': 'Pa*s', 'type': 'param', 'val': self.Fluid.mu},
                {'name': 'k0', 'unit': 'W/(m2*K)', 'type': 'param', 'val': self.Fluid.k},
                {'name': 'Pr', 'unit': '', 'type': 'param', 'val': self.Fluid.Pr},
                {'name': 'kP', 'unit': 'Hz', 'type': 'param', 'val': .1}
            ]
        else:
            print(Fluid)
            raise ValueError('The medium class not recognized!')

    def F2P_Volume_diff_f(self):
        # rp=exp(interp_bilin(rh_p, m/V, H/m))
        rho = m / V
        rho2 = rho
        # rho2=ln(abs(rho))
        h = H / m

        q = interp_bilin(rh_q, rho2, H / m)
        rp = interp_bilin(rh_p, rho2, H / m)
        rT = interp_bilin(rh_T, rho2, H / m)

        p_dot = (rp - p) * kP
        T_dot = (rT - T) * kP

        H_dot = V * (rp - p) * kP * 1000

        T_DP = interp_bilin(pq_T, ln(p), 1)
        T_BP = interp_bilin(pq_T, ln(p), 0)

        # Saturation properties:
        kL = interp_bilin(pq_k, ln(p), 0) * 1e-3  # W/mK
        kV = interp_bilin(pq_k, ln(p), 1) * 1e-3  # W/mK
        muL = interp_bilin(pq_mu, ln(p), 0) * 1e-6  # Pa*sec
        muV = interp_bilin(pq_mu, ln(p), 1) * 1e-6  # Pa*sec
        rhoL = interp_bilin(pq_rho, ln(p), 0)  # kg/m3
        rhoV = interp_bilin(pq_rho, ln(p), 1)  # kg/m3
        sigma = interp_bilin(pq_sigma, ln(p), 0) * 1e-3  # N/m
        cpL = interp_bilin(pq_cp, ln(p), 0)  # J/kgK
        cpV = interp_bilin(pq_cp, ln(p), 1)  # J/kgK

        hL = interp_bilin(pq_h, ln(p), 0)
        hV = interp_bilin(pq_h, ln(p), 1)
        h_lat = hV - hL

        alpha = q

        # to have the same variables name of water when liquid single-phase:
        mu = muL
        rho0 = rhoL
        Cp = cpL
        k = kL

        # alpha = (1+(rhoV/rhoL)*((1-q)/q)*(0.4 + 0.6*sqrt((rhoL/rhoV + 0.4* ((1-q)/q))/(1+0.4*((1-q)/q)) )) )**(-1)
        MW = MW
        p_critical = p_critical

    def Liquid_Volume_diff_f(self):
        rT = H / Cp / m - 273.15
        h = H / m

        d_rho = (m / V - rho0) / rho0
        rp = d_rho * 1e4 + 1e3

        p_dot = (rp - p) * kP
        T_dot = (rT - T) * kP
        H_dot = V * (rp - p) * kP * 1000


class Reservoir(B.Node):
    def construct_Node(self, Fluid, q0=1, T0=20, dT_Super=0, p0=500):

        self.Fluid = Fluid

        if isinstance(Fluid, Fluid_Props):
            # print()
            # print(self.name)

            p = ME.bilinear_interpolation(0, T0, q0, [0], self.Fluid.Tq_p)
            h = ME.bilinear_interpolation(0, T0 + dT_Super, q0, [0], self.Fluid.Tq_h)
            rho = ME.bilinear_interpolation(0, T0 + dT_Super, q0, [0], self.Fluid.Tq_rho)

            self.ph_T = self.Fluid.ph_T
            self.ph_q = self.Fluid.ph_q
            self.ph_rho = self.Fluid.ph_rho

            self.calc_funcs = [self.Refrigerant_reservoir_update]

            # h=ME.bilinear_interpolation(0, T0+dT_Super, np.log(p), [0], self.Fluid.Tp_h)
            # rho=ME.bilinear_interpolation(0, T0+dT_Super, np.log(p), [0], self.Fluid.Tp_rho)
            self.Variables = [
                {'name': 'm', 'unit': 'kg', 'type': 'reservoir', 'val': rho},
                {'name': 'rho', 'unit': 'kg/m3', 'type': 'reservoir', 'val': rho},
                {'name': 'H', 'unit': 'J', 'type': 'reservoir', 'val': h * rho},
                {'name': 'h', 'unit': 'J/kg', 'type': 'reservoir', 'val': h},
                {'name': 'p', 'unit': 'kPa', 'type': 'reservoir', 'val': p},
                {'name': 'T', 'unit': 'K', 'type': 'reservoir', 'val': T0},
                {'name': 'V', 'unit': 'm3', 'type': 'param', 'val': .1},
                {'name': 'h_Set', 'unit': 'J/kg', 'type': 'param', 'val': h},
                {'name': 'p_Set', 'unit': 'kPa', 'type': 'reservoir', 'val': p},

            ]

            print('p: ', p)
            print('rho: ', rho)
            print('h: ', h)

        elif isinstance(Fluid, Liquid_Props):

            m0 = self.Fluid.rho

            self.calc_funcs = [self.Liquid_reservoir_update]

            self.Variables = [
                {'name': 'm', 'unit': 'kg', 'type': 'reservoir', 'val': m0},
                {'name': 'H', 'unit': 'J', 'type': 'reservoir', 'val': self.Fluid.Cp * (T0 + 273.15) * m0},
                {'name': 'h', 'unit': 'J', 'type': 'reservoir', 'val': self.Fluid.Cp * (T0 + 273.15)},
                {'name': 'p', 'unit': 'kPa', 'type': 'reservoir', 'val': p0},
                {'name': 'T', 'unit': 'K', 'type': 'reservoir', 'val': T0},
                {'name': 'V', 'unit': 'm3', 'type': 'param', 'val': 1},
                {'name': 'C', 'unit': 'J/K', 'type': 'param', 'val': m0 * self.Fluid.Cp},
                {'name': 'Cp', 'unit': 'J/K', 'type': 'param', 'val': self.Fluid.Cp},
                {'name': 'T_Set', 'unit': 'K', 'type': 'param', 'val': T0}
            ]
        else:
            raise ValueError('The medium class not recognized!')

    def Liquid_reservoir_update(self):
        T = T_Set
        H = (T_Set + 273.15) * C
        h = (T_Set + 273.15) * Cp

    def Refrigerant_reservoir_update(self):
        p = p_Set
        h = h_Set

        q = interp_bilin(ph_q, ln(p), h)
        T = interp_bilin(ph_T, ln(p), h)
        rho = interp_bilin(ph_rho, ln(p), h)
        H = h * rho


class Var_Nozzle(B.Link):
    def construct_Link(self, m_dot=0, **c):
        self.side1 = c['side1']
        self.side2 = c['side2']

        self.calc_funcs = [self.Var_Nozzle_diff_f]

        self.Variables = [
            {'name': 'flow', 'unit': 'kg/s', 'type': 'param', 'val': m_dot}
        ]

    def Var_Nozzle_diff_f(self):
        # H_dot=flow*((flow>0)*side1.H/side1.m)
        # flow_act = flow * (flow > 0)
        flow_act = flow
        H_dot = flow_act * side1.h
        side1.m_dot = -flow_act
        side2.m_dot = flow_act

        side1.H_dot = -H_dot
        side2.H_dot = H_dot

        inlet_h = side1.h
        outlet_h = side2.h
        Hdot = H_dot


class Dual_Compressor(B.Link):
    def construct_Link(self, Fluid, N_comp, State1=0, State2=0, dT_Super=6, **c):
        self.Fluid = Fluid

        if 'dT_Super' in c:
            dT_Super = c['dT_Super']

        # dT_Super=10

        self.inlet = c['inlet']
        self.outlet = c['outlet']
        self.nozzle = c['nozzle']

        self.calc_funcs = [self.Compressor_diff_f]

        self.Variables = [
            {'name': 'state', 'unit': '', 'type': 'state', 'val': 0},
            {'name': 'dT_Super', 'unit': 'K', 'type': 'param', 'val': dT_Super},
            {'name': 'State1', 'unit': '', 'type': 'param', 'val': State1},
            {'name': 'State2', 'unit': '', 'type': 'param', 'val': State2},
            {'name': 'P_ewma', 'unit': '', 'type': 'state', 'val': 1},
            {'name': 'P_ewma_2', 'unit': '', 'type': 'state', 'val': 1},
            {'name': 'Energy', 'unit': 'MJ', 'type': 'state', 'val': 0},
            {'name': 'N_comp', 'unit': '1', 'type': 'param', 'val': N_comp},
        ]

        self.m_dot_poly = np.array(c['polynom_m_dot'], dtype=np.float32)
        self.power_poly = np.array(c['polynom_power'], dtype=np.float32)

    def Compressor_diff_f(self):
        inlet_h = inlet.H / inlet.m

        T_Evap = interp_bilin(Fluid.pq_T, ln(inlet.p), 0)
        T_Cond = interp_bilin(Fluid.pq_T, ln(outlet.p), 1)

        dT_Super_Act = inlet.T - T_Evap
        print(dT_Super_Act)

        # Ensure minimum superheating even when CoM Inputs gives 0
        dT_Super_set = dT_Super * (dT_Super > 0) + 2.5 * (dT_Super <= 0)
        dT_Super_Err = dT_Super_Act - dT_Super_set

        S_in = interp_bilin(Fluid.ph_s, ln(inlet.p), inlet_h)
        rho_in = interp_bilin(Fluid.ph_rho, ln(inlet.p), inlet_h)
        #
        State1_in = (State1 > 0) * State1 * (State1 <= 1) + (State1 > 1)
        State2_in = (State2 > 0) * State2 * (State2 <= 1) + (State2 > 1)
        state_set = (State1_in + State2_in) * (State1_in + State2_in <= N_comp) + (
                    State1_in + State2_in > N_comp) * N_comp
        # state_set=State_set*(T_Evap>-10)
        state_dot = (state_set - state) * 0.1
        #
        p_in = inlet.p
        t_in = interp_bilin(Fluid.ph_T, ln(inlet.p), inlet_h)
        #
        m_dot = calc_poly2x3(m_dot_poly, T_Evap, T_Cond) * state / 3600 * 1
        m_dot = m_dot * (m_dot >= 0)
        #
        nozzle.flow = m_dot * (1.0 + dT_Super_Err * .05)
        #
        h_out_ideal = interp_bilin(Fluid.ps_h, ln(outlet.p), S_in)

        Power = calc_poly2x3(power_poly, T_Evap, T_Cond) * state
        Power = Power * (Power >= 0)
        P = Power * 0.93
        P_ewma_dot = 0.1 * (Power / 1000 - P_ewma)
        P_ewma_2_dot = 0.1 * (P / 1000 - P_ewma_2)

        Energy_dot = Power / 1e6
        #
        inlet.m_dot = -m_dot
        outlet.m_dot = m_dot

        outlet_h = inlet_h + P / (m_dot + (m_dot == 0))
        outlet.H_dot = outlet_h * m_dot
        inlet.H_dot = -inlet_h * m_dot

        # eff_isentropic = (h_out_ideal-inlet_h)/(outlet_h-inlet_h)

        T_Discharge = interp_bilin(Fluid.ph_T, ln(outlet.p), outlet_h)
        print(T_Discharge)
        print(m_dot)
        #
        #
        p_out = outlet.p


class ThreeWayValve(B.Link):
    def construct_Link(self, kV, AC=0, **c):
        self.A = c['A']
        self.B = c['B']
        self.C = c['C']

        self.Variables = [
            {'name': 'kV', 'unit': '', 'type': 'param', 'val': kV},
            {'name': 'AC', 'unit': 'min^-1', 'type': 'param', 'val': AC}
        ]
        self.calc_funcs = [self.ThreeWay_diff_f]

    def ThreeWay_diff_f(self):
        dp = A.p * (AC > 0) + B.p * (AC <= 0) - C.p
        m_dot = sign(dp) * sqrt(abs(dp)) * kV
        # H_dot=m_dot*((m_dot>0)*(A.H/A.m*(AC>0.1)+B.H/B.m*(AC<=0.1))+(m_dot<0)*C.H/C.m)
        H_dot = m_dot * ((m_dot > 0) * (A.h * (AC > 0.1) + B.h * (AC <= 0.1)) + (m_dot < 0) * C.h)

        A.m_dot = -m_dot * (AC > 0.1)
        A.H_dot = -H_dot * (AC > 0.1)
        B.m_dot = -m_dot * (AC <= 0.1)
        B.H_dot = -H_dot * (AC <= 0.1)
        C.m_dot = m_dot
        C.H_dot = H_dot


class Simple_Valve_Regulator(B.Node):
    def construct_Node(self, kP=0.1, kV=1, ini=0, **c):
        self.Variables = [
            {'name': 'S_act', 'unit': '1', 'type': 'state', 'val': ini},
            {'name': 'S_set', 'unit': '1', 'type': 'param', 'val': ini},
            {'name': 'kP', 'unit': 'Hz', 'type': 'param', 'val': kP},
            {'name': 'kV', 'unit': '', 'type': 'param', 'val': kV},
        ]

        self.input1 = c['input1']
        self.input2 = c['input2']

        self.calc_funcs = [self.Diff_f]

    def Diff_f(self):
        S_set_in = (S_set > 0) * S_set * (S_set <= 1) + (S_set > 1)
        S_act_dot = (S_set_in - S_act) * kP

        input1.kV = kV * S_act
        input2.kV = kV * (1 - S_act)


class Valve_Regulated(B.Subsystem):
    def construct_Subsystem(self, kV=5, S_set_in=0, kP=0.1, **c):
        self.pipe = self.add('pipe', Pipe, kV * S_set_in,
                             side1=c['side1'],
                             side2=c['side2'])

        self.Variables = [
            {'name': 'S_set_in', 'unit': '', 'type': 'param', 'val': S_set_in},
            {'name': 'S_set', 'unit': '', 'type': 'param', 'val': S_set_in},
            {'name': 'S_act', 'unit': '', 'type': 'state', 'val': S_set_in},
            {'name': 'kV', 'unit': '', 'type': 'param', 'val': kV},
            {'name': 'kP', 'unit': '', 'type': 'param', 'val': kP}

        ]
        self.calc_funcs = [self.valve_calc]

    def valve_calc(self):
        S_set_in = (S_set > 0) * S_set * (S_set <= 1) + (S_set > 1)
        S_act_dot = (S_set_in - S_act) * kP

        pipe.kV = kV * S_act


class Pipe_Check(B.Link):
    def construct_Link(self, kV, reverse=False, **c):
        if reverse:
            self.outlet = c['inlet'] if 'inlet' in c else c['side1']
            self.inlet = c['outlet'] if 'outlet' in c else c['side2']
        else:
            self.inlet = c['inlet'] if 'inlet' in c else c['side1']
            self.outlet = c['outlet'] if 'outlet' in c else c['side2']

            # self.parameters={self.gp('kV'): kV}

        self.Variables = [
            {'name': 'kV', 'unit': '', 'type': 'param', 'val': kV}
        ]
        self.calc_funcs = [self.Pipe_Check_diff_f]

    def Pipe_Check_diff_f(self):
        T_pipe = inlet.T
        dp = (inlet.p - outlet.p)  # -10)
        ip = inlet.p
        print(ip)
        op = outlet.p
        print(op)
        m_dot = sqrt(abs(dp)) * kV * (dp > 0)

        # H_dot=m_dot*inlet.H/inlet.m
        H_dot = m_dot * inlet.h
        print(m_dot)
        inlet.m_dot = -m_dot
        inlet.H_dot = -H_dot

        outlet.m_dot = m_dot
        outlet.H_dot = H_dot


class Pipe_Fixed_Massflow(B.Link):
    def construct_Link(self, m_dot, **c):
        self.side1 = c['side1']
        self.side2 = c['side2']

        self.calc_funcs = [self.Pipe_diff_f]

        self.Variables = [
            {'name': 'm_dot', 'unit': 'kg/s', 'type': 'param', 'val': m_dot},
        ]

    def Pipe_diff_f(self):
        T_pipe = ((m_dot > 0) * side1.T + (m_dot <= 0) * side2.T)
        # H_dot=m_dot*((m_dot>0)*side1.H/side1.m+(m_dot<0)*side2.H/side2.m)
        H_dot = m_dot * ((m_dot > 0) * side1.h + (m_dot < 0) * side2.h)
        side1.m_dot = -m_dot
        side2.m_dot = m_dot
        side1.H_dot = -H_dot
        side2.H_dot = H_dot


class Pipe_kV(B.Link):
    def construct_Link(self, kV=1, **c):
        self.side1 = c['side1']
        self.side2 = c['side2']

        self.calc_funcs = [self.Pipe_diff_f]

        self.Variables = [

            {'name': 'kV', 'unit': 'kg/s/sqrt(kPa)', 'type': 'param', 'val': kV},
            {'name': 'm_dot_max', 'unit': 'kg/s', 'type': 'param', 'val': 100},
            {'name': 'm_dot', 'unit': 'kg/s', 'type': 'param', 'val': 0.1}, ]

    def Pipe_diff_f(self):
        T_pipe = ((m_dot > 0) * side1.T + (m_dot <= 0) * side2.T)
        dp = side1.p - side2.p
        m_dot_raw = sign(dp) * sqrt(abs(dp)) * kV
        m_dot = m_dot_raw * (abs(m_dot_raw) <= m_dot_max) + m_dot_max * (abs(m_dot_raw) > m_dot_max) * sign(m_dot_raw)

        H_dot = m_dot * ((m_dot > 0) * side1.H / side1.m + (m_dot < 0) * side2.H / side2.m)
        # H_dot = m_dot * ((m_dot > 0) * side1.h + (m_dot < 0) * side2.h)

        side1.m_dot = -m_dot
        side2.m_dot = m_dot
        side1.H_dot = -H_dot
        side2.H_dot = H_dot


class Pipe(B.Link):
    def construct_Link(self, **c):
        # type flow='2ph-eva', '2ph-cond', '1ph'

        self.side1 = c['side1']
        self.side2 = c['side2']
        self.flow = c['flow']

        self.calc_funcs = []
        self.calc_funcs.append(self.Pipe_diff_f)

        self.Variables = [
            {'name': 'm_dot_max', 'unit': 'kg/s', 'type': 'param', 'val': 100},
            {'name': 'm_dot', 'unit': 'kg/s', 'type': 'param', 'val': 0.1}, ]

    def Pipe_diff_f(self):
        kV = flow.kV_CV

        T_pipe = ((m_dot > 0) * side1.T + (m_dot <= 0) * side2.T)

        dp = side1.p - side2.p
        dp_max = min2(abs(dp), 20)

        m_dot_raw = sign(dp) * sqrt(abs(dp_max)) * kV
        m_dot = m_dot_raw * (abs(m_dot_raw) <= m_dot_max) + m_dot_max * (abs(m_dot_raw) > m_dot_max) * sign(m_dot_raw)

        H_dot = m_dot * ((m_dot > 0) * side1.H / side1.m + (m_dot < 0) * side2.H / side2.m)

        # H_dot = m_dot * ((m_dot > 0) * (side1.H / side1.m - side2.H/side2.m) + (m_dot < 0) * (side2.H / side2.m- side1.H/side1.m))

        side1.m_dot = -m_dot
        side2.m_dot = m_dot
        side1.H_dot = -H_dot
        side2.H_dot = H_dot


class ThreeWayValve_Regulated(B.Subsystem):
    def construct_Subsystem(self, fluid, kV=0.2, kP=0.1, T_ini=20, AC=0, V=0.1,
                            pipe_types=[(Pipe_kV, {}), (Pipe_kV, {}), (Pipe_kV, {})], **c):
        self.Vol = self.add('Vol', Volume, fluid, V, 0, T_ini)

        pipeA = self.add('pipe_A', pipe_types[0][0], kV,
                         side1=c['A'],
                         side2=self.Vol,
                         **pipe_types[0][1]
                         )

        pipeB = self.add('pipe_B', pipe_types[1][0], kV,
                         side1=c['B'],
                         side2=self.Vol,
                         **pipe_types[1][1]
                         )

        self.add('pipe_C', pipe_types[2][0], kV,
                 side1=self.Vol,
                 side2=c['C'],
                 **pipe_types[2][1])

        self.Reg = self.add('Reg', Simple_Valve_Regulator, kP, kV, AC,
                            input1=pipeA, input2=pipeB)


class Mass_Flow_Source(B.Link):
    def construct_Link(self, Fluid, m_dot, T, q, **c):
        self.Fluid = Fluid
        self.outlet = c['outlet']
        # self.parameters={self.gp('m_dot'): m_dot, self.gp('T'): T}

        if isinstance(Fluid, Fluid_Props):

            self.calc_funcs = [self.F2P_Mass_Flow_Source_diff_f]

            # [h]=self.Fluid.calc_props('Tq',[T,q],'h')
            h = ME.bilinear_interpolation(0, T, q, [0], self.Fluid.Tq_h)

            self.Variables = [
                {'name': 'm_dot', 'unit': 'kg/s', 'type': 'param', 'val': m_dot},
                {'name': 'h', 'unit': 'J/kg', 'type': 'param', 'val': h}
            ]

        elif isinstance(Fluid, Liquid_Props):

            self.calc_funcs = [self.Liquid_Mass_Flow_Source_diff_f]

            self.Variables = [
                {'name': 'm_dot', 'unit': 'kg/s', 'type': 'param', 'val': m_dot},
                {'name': 'H_dot', 'unit': 'J/kg', 'type': 'param', 'val': Fluid.Cp * (T + 273.15) * m_dot}
            ]
        else:
            print(Fluid)
            raise ValueError('The medium class not recognized!')

    def F2P_Mass_Flow_Source_diff_f(self):

        outlet.m_dot = m_dot
        outlet.H_dot = m_dot * h

    def Liquid_Mass_Flow_Source_diff_f(self):

        outlet.m_dot = m_dot
        outlet.H_dot = H_dot