import numpy as np
import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow_new as FF2
from pprint import pprint


class Heat_Exchanger(BC.Subsystem):

    def construct_Subsystem(self, N_nodes, N_Plates, F1, F2, T_F2=0, T_F1=0, q=0, q2=0, F2_1=True, fac=10, f1=30, f2=30,
                            hex_type=None, **c):

        c['N_Plates'] = N_Plates
        N_channels = N_Plates - 1
        c['A'] = c['A_Plate'] * N_Plates
        Total_Length = c['Length']
        Total_Width = c['Width']
        b = c['b']
        Lambda = c['Lambda']
        theta = c['theta']

        self.N_nodes = N_nodes

        # b = 0.0025
        # Lambda = 0.009
        # theta = 30
        # Geometry calculations

        X = 3.14159 * b / Lambda
        phi = 1 / 6 * (1 + np.sqrt(1 + X ** 2) + 4 * np.sqrt(1 + X ** 2 / 2))
        Dh = 2 * b / phi
        De = 2 * b
        Dp_CW = 0.09

        Nch_RF = N_channels / 2  # if np.mod(N_channels,2)==0 else ((N_channels-1)/2)
        Nch_CW = N_channels - Nch_RF

        deltaL = Total_Length / self.N_nodes
        A_ht = 2 * phi * (Total_Width * Total_Length) * Nch_RF

        self.deltaL = deltaL

        no_hx = False

        if 'no_hx' in c.keys():
            no_hx = c['no_hx']

        self.type = c['dual']
        # c['dual'] = dual
        # self.type = dual

        V1 = c['V1_Plate'] * N_Plates * f1 * N_nodes / 8
        V2 = c['V2_Plate'] * N_Plates * f2 * N_nodes / 8

        kV1_plate = c['kV2_plate']
        kV1_Port = c['kV1_Port']
        kV2_plate = c['kV2_plate']
        kV2_Port = c['kV2_Port']

        self.kV_F1 = kV1_Port / np.sqrt((kV1_plate * N_Plates) ** 2 + kV1_Port ** 2 / (kV1_plate * N_Plates) ** 2)
        self.kV_F2 = kV2_Port / np.sqrt((kV2_plate * N_Plates) ** 2 + kV2_Port ** 2 / (kV2_plate * N_Plates) ** 2) * 1.1

        print()
        print(self.path)

        if c['dual'] == 'dual':  # Adding RF side 2 volume
            F1B_In = self.add('F1B_In', FF2.Volume, F1, c['V1_Plate'] * N_Plates / 2, q, T_F1)
            F1B_Out = self.add('F1B_Out', FF2.Volume, F1, c['V1_Plate'] * N_Plates / 2, q, T_F1)
            A0_Ref = b * Total_Width * Nch_RF / 2
            A0_CW = b * Total_Width * Nch_CW
            A_ht_A = A_ht / 2
            A_ht_B = A_ht / 2
            deltaA_ht_A = A_ht_A / self.N_nodes
            deltaA_ht_B = A_ht_B / self.N_nodes
        else:
            A0_Ref = b * Total_Width * Nch_RF
            A0_CW = b * Total_Width * Nch_CW
            A_ht_A = A_ht
            deltaA_ht_A = A_ht_A / self.N_nodes

        self.N_nodes = N_nodes
        # m_HX =c['m_no_plates']+N_Plates*c['m_plate']
        m_HX = c['A'] * 7700 * 0.001

        m_node = m_HX / (self.N_nodes + 2)

        # print('m: ', m_HX)
        # print()
        # print(self.path)

        self.TC_paths_A = []
        self.TC_paths_B = []

        self.F2_vol_paths = []
        self.F1A_vol_paths = []
        self.F1B_vol_paths = []

        for i in range(0, self.N_nodes + 2):
            # Adding CW volume

            F2_vol = self.add('F2_' + str(i), FF2.Volume, F2, V2 / (self.N_nodes + 2), q2, T_F2)
            # Adding RF side A volume
            F1A_vol = self.add('F1A_' + str(i), FF2.Volume, F1, V1 / (self.N_nodes + 2), q, T_F1)

            self.F2_vol_paths += [F2_vol.path]
            self.F1A_vol_paths += [F1A_vol.path]

            # Adding RF side B volume
            if self.type == 'dual':
                F1B_vol = self.add('F1B_' + str(i), FF2.Volume, F1, V1 / (self.N_nodes + 2), q, T_F1)
                self.F1B_vol_paths += [F1B_vol.path]

        self.m_dot_F1A = self.add('m_dot_F1A', m_dot_cal,
                                  A0=A0_Ref,
                                  deltaL=self.deltaL,
                                  Dh=Dh, De=De,
                                  A_ht=A_ht_A,
                                  phi=phi,
                                  type_flow=hex_type,
                                  kV_SWEP=self.kV_F1,
                                  side1=self.items['F1A_0'],
                                  side2=self.items['F1A_' + str(self.N_nodes - 1 + 2)], **c)

        self.m_dot_F1A_path = self.m_dot_F1A.path

        if self.type == 'dual':
            self.m_dot_F1B = self.add('m_dot_F1B',
                                      m_dot_cal,
                                      A0=A0_Ref,
                                      deltaL=self.deltaL,
                                      A_ht=A_ht_B,
                                      phi=phi, Dh=Dh, De=De,
                                      kV_SWEP=self.kV_F1,
                                      type_flow=hex_type, side1=self.items['F1B_0'],
                                      side2=self.items['F1B_' + str(self.N_nodes - 1 + 2)], **c)

        self.m_dot_F2 = self.add('m_dot_F2', m_dot_cal,
                                 A0=A0_CW,
                                 deltaL=self.deltaL,
                                 phi=phi, A_ht=A_ht_B + A_ht_A,
                                 Dh=Dh, De=De, Dp=Dp_CW,
                                 type_flow='1ph',
                                 kV_SWEP=self.kV_F2,
                                 side1=self.items['F2_0'],
                                 side2=self.items['F2_' + str(self.N_nodes - 1 + 2)], **c)

        for i in range(0, self.N_nodes + 2):
            if i > 0:
                self.add('L_F2_' + str(i), FF2.Pipe, side1=self.items['F2_' + str(i - 1)],
                         side2=self.items['F2_' + str(i)], flow=self.m_dot_F2)

                # Linking RF side 1 volumes to each other
                self.add('L_F1A_' + str(i), FF2.Pipe,
                         side1=self.items['F1A_' + str(i - 1)],
                         side2=self.items['F1A_' + str(i)], flow=self.m_dot_F1A)

                if self.type == 'dual':
                    # Linking RF side 2 volumes to each other
                    self.add('L_F1B_' + str(i), FF2.Pipe,
                             side1=self.items['F1B_' + str(i - 1)],
                             side2=self.items['F1B_' + str(i)],
                             flow=self.m_dot_F1B)

        # for i in range(1, self.N_nodes + 1):
        for i in range(0, self.N_nodes + 2):
            # Linking CW with RF side 1 through thermal conductor

            if no_hx:
                RATC = self.add('LL_F1A_' + str(i), Thermal_Insulator_Linked, side1=self.items['F2_' + str(i)],
                                side2=self.items['F1A_' + str(i)], T0=T_F2, m=m_node, hsource=self.h_A)
            else:

                RATC = self.add('LL_F1A_' + str(i), Thermal_Conductor_Linked,
                                deltaA_ht=deltaA_ht_A,
                                side1=self.items['F2_' + str(i)],
                                side2=self.items['F1A_' + str(i)],
                                T0=T_F2, m=m_node, type_flow=hex_type,
                                FlowRef=self.m_dot_F1A,
                                FlowCW=self.m_dot_F2)

            if self.type == 'dual':
                RBTC = self.add('LL_F1B_' + str(i), Thermal_Conductor_Linked,
                                deltaA_ht=deltaA_ht_B,
                                side1=self.items['F2_' + str(i)],
                                side2=self.items['F1B_' + str(i)],
                                T0=T_F2, m=m_node, type_flow=hex_type,
                                FlowRef=self.m_dot_F1B,
                                FlowCW=self.m_dot_F2)

                self.TC_paths_B += [RBTC.path]

            self.TC_paths_A += [RATC.path]

        self.addPort('F2_In', self.items['F2_0'])
        self.F2_In = self.items['F2_0']
        self.addPort('F2_Out', self.items['F2_' + str(self.N_nodes + 1)])
        self.F2_Out = self.items['F2_' + str(self.N_nodes + 1)]
        self.addPort('F1A_In', self.items['F1A_' + str(self.N_nodes + 1)])
        self.F1A_In = self.items['F1A_' + str(self.N_nodes + 1)]
        self.addPort('F1A_Out', self.items['F1A_0'])
        self.F1A_Out = self.items['F1A_0']

        # print(self.F1A_Out.gp('T'))

        if c['dual'] == 'dual':
            self.addPort('F1B_In', self.items['F1B_' + str(self.N_nodes - 1 + 2)])
            self.addPort('F1B_Out', self.items['F1B_0'])

    def output_(self, sys_dict):
        sys_dict[self.gp('m_dot_A_overall')] = sys_dict[self.m_dot_F1A.gp('m_dot')]
        sys_dict[self.gp('m_dot_B_overall')] = sys_dict[self.m_dot_F1B.gp('m_dot')]

        sys_dict[self.path + '.Q_A'] = sum([sys_dict[p + '.Q'] for p in self.TC_paths_A])
        sys_dict[self.path + '.Q_B'] = sum([sys_dict[p + '.Q'] for p in self.TC_paths_B])

        sys_dict[self.path + '.Q'] = sys_dict[self.path + '.Q_A'] + sys_dict[self.path + '.Q_B']

        sys_dict[self.path + '.Q_A_ewma'] = abs(sum([sys_dict[p + '.Q_ewma'] for p in self.TC_paths_A]))
        sys_dict[self.path + '.Q_B_ewma'] = abs(sum([sys_dict[p + '.Q_ewma'] for p in self.TC_paths_B]))
        sys_dict[self.path + '.Q_ewma'] = abs(sys_dict[self.path + '.Q_A_ewma'] + sys_dict[self.path + '.Q_B_ewma'])

        sys_dict[self.path + '.T_F1A_In'] = sys_dict[self.ports['F1A_In'].path + '.T']
        sys_dict[self.path + '.T_F1A_Out'] = sys_dict[self.ports['F1A_Out'].path + '.T']
        # sys_dict[self.path+'.Flow_F1A_In']=sys_dict[self.ports['F1A_In'].path+'.flow']
        # sys_dict[self.path+'.Flow_F1A_Out']=sys_dict[self.ports['F1A_Out'].path+'.flow']
        sys_dict[self.path + '.p_F1A_In'] = sys_dict[self.ports['F1A_In'].path + '.p']
        sys_dict[self.path + '.p_F1A_Out'] = sys_dict[self.ports['F1A_Out'].path + '.p']
        sys_dict[self.path + '.h_F1A_In'] = sys_dict[self.ports['F1A_In'].path + '.h']
        sys_dict[self.path + '.h_F1A_Out'] = sys_dict[self.ports['F1A_Out'].path + '.h']
        sys_dict[self.path + '.rho_F1A_In'] = sys_dict[self.ports['F1A_In'].path + '.rho']
        sys_dict[self.path + '.rho_F1A_Out'] = sys_dict[self.ports['F1A_Out'].path + '.rho']
        sys_dict[self.path + '.tot_mass_F1A'] = 0
        sys_dict[self.path + '.tot_mass_F1B'] = 0
        for i in range(0, self.N_nodes + 2):
            # save the temperature in each control volume - to get the temperature profile
            p = self.F2_vol_paths[i]
            sys_dict[self.path + '.T_F2_' + str(i)] = sys_dict[p + '.T']
            sys_dict[self.path + '.p_F2_' + str(i)] = sys_dict[p + '.p']
            p = self.F1A_vol_paths[i]
            sys_dict[self.path + '.T_F1A_' + str(i)] = sys_dict[p + '.T']
            sys_dict[self.path + '.p_F1A_' + str(i)] = sys_dict[p + '.p']
            sys_dict[self.path + '.q_F1A_' + str(i)] = sys_dict[p + '.q']
            sys_dict[self.path + '.rho_F1A_' + str(i)] = sys_dict[p + '.rho']
            sys_dict[self.path + '.mass_F1A_' + str(i)] = sys_dict[p + '.m']
            sys_dict[self.path + '.tot_mass_F1A'] += sys_dict[p + '.m']
            sys_dict[self.path + '.enthalpy_F1A_' + str(i)] = sys_dict[p + '.h']
            sys_dict[self.path + '.V_F1A_' + str(i)] = sys_dict[p + '.V']

            if self.type == 'dual':
                p = self.F1B_vol_paths[i]
                sys_dict[self.path + '.T_F1B_' + str(i)] = sys_dict[p + '.T']
                sys_dict[self.path + '.p_F1B_' + str(i)] = sys_dict[p + '.p']
                sys_dict[self.path + '.q_F1B_' + str(i)] = sys_dict[p + '.q']
                sys_dict[self.path + '.rho_F1B_' + str(i)] = sys_dict[p + '.rho']
                sys_dict[self.path + '.mass_F1B_' + str(i)] = sys_dict[p + '.m']
                sys_dict[self.path + '.tot_mass_F1B'] += sys_dict[p + '.m']
                sys_dict[self.path + '.enthalpy_F1B_' + str(i)] = sys_dict[p + '.h']
                sys_dict[self.path + '.V_F1B_' + str(i)] = sys_dict[p + '.V']

        for i in range(0, self.N_nodes + 2):
            p = self.TC_paths_A[i]
            sys_dict[self.path + '.Qdot_a_' + str(i + 1)] = sys_dict[p + '.Q_ewma']
            sys_dict[self.path + '.htcRef_a_' + str(i + 1)] = sys_dict[p + '.htc2']
            sys_dict[self.path + '.htcCW_a_' + str(i + 1)] = sys_dict[p + '.htc1']
            if self.type == 'dual':
                p = self.TC_paths_B[i]
                sys_dict[self.path + '.Qdot_b_' + str(i + 1)] = sys_dict[p + '.Q_ewma']
                sys_dict[self.path + '.htcRef_b_' + str(i + 1)] = sys_dict[p + '.htc2']
                sys_dict[self.path + '.htcCW_b_' + str(i + 1)] = sys_dict[p + '.htc1']

        sys_dict[self.path + '.T_F2_In'] = sys_dict[self.ports['F2_In'].path + '.T']
        sys_dict[self.path + '.T_F2_Out'] = sys_dict[self.ports['F2_Out'].path + '.T']

        sys_dict[self.path + '.T_F2_dT'] = sys_dict[self.ports['F2_Out'].path + '.T'] - sys_dict[
            self.ports['F2_In'].path + '.T']

        sys_dict[self.path + '.dp'] = sys_dict[self.ports['F2_In'].path + '.p'] - sys_dict[
            self.ports['F2_Out'].path + '.p']
        sys_dict[self.path + '.dp_1A'] = sys_dict[self.ports['F1A_In'].path + '.p'] - sys_dict[
            self.ports['F1A_Out'].path + '.p']

        if self.type == 'dual':
            sys_dict[self.path + '.dp_1B'] = sys_dict[self.ports['F1B_In'].path + '.p'] - sys_dict[
                self.ports['F1B_Out'].path + '.p']

            sys_dict[self.path + '.T_F1B_Out'] = sys_dict[self.ports['F1B_Out'].path + '.T']
            sys_dict[self.path + '.T_F1B_In'] = sys_dict[self.ports['F1B_In'].path + '.T']
            sys_dict[self.path + '.p_F1B_In'] = sys_dict[self.ports['F1B_In'].path + '.p']
            sys_dict[self.path + '.p_F1B_Out'] = sys_dict[self.ports['F1B_Out'].path + '.p']
            sys_dict[self.path + '.h_F1B_In'] = sys_dict[self.ports['F1B_In'].path + '.h']
            sys_dict[self.path + '.h_F1B_Out'] = sys_dict[self.ports['F1B_Out'].path + '.h']
            sys_dict[self.path + '.rho_F1B_In'] = sys_dict[self.ports['F1B_In'].path + '.rho']
            sys_dict[self.path + '.rho_F1B_Out'] = sys_dict[self.ports['F1B_Out'].path + '.rho']


class Dummy():
    def __init__(self):
        self.path = None


class Thermal_Insulator_Linked(BC.Link):
    def construct_Link(self, m=10, T0=20, **c):
        self.side1 = c['side1']
        self.side2 = c['side2']
        self.hsource = c['hsource']

        self.calc_funcs = [self.Thermal_Conductor_diff_f]
        self.Variables = [
            {'name': 'Q', 'unit': 'W', 'type': 'param', 'val': 0},
            {'name': 'Q_ewma', 'unit': 'W', 'type': 'state', 'val': 0},
            {'name': 'C', 'unit': 'W', 'type': 'param', 'val': m * 500},
            {'name': 'T', 'unit': 'W', 'type': 'state', 'val': T0}
        ]

    def Thermal_Conductor_diff_f(self):
        h = hsource.h
        Q1 = 0
        Q2 = 0
        Q = Q1
        T_dot = (Q1 + Q2) / C

        Q_ewma_dot = 0.01 * (Q / 1000 - Q_ewma)
        side1.H_dot = -Q1
        side2.H_dot = -Q2


class m_dot_cal(BC.Link):
    def construct_Link(self, A0=0.5, deltaL=0.05, theta=30, Lambda=0.009,
                       Dh=0.0034, De=0.0034, A_ht=1, phi=1, type_flow='1ph', Dp=0.09,
                       kV_SWEP=1, **c):

        self.side1 = c['side1']
        self.side2 = c['side2']

        self.calc_funcs = []

        if type_flow == '1ph':
            self.calc_funcs.append(self.f_1ph)
        elif type_flow == '2ph-eva':
            self.calc_funcs.append(self.f_2ph_eva)
        elif type_flow == '2ph-cond':
            self.calc_funcs.append(self.f_2ph_cond)

        self.calc_funcs.append(self.m_dot_calc_func)

        self.Variables = [
            {'name': 'kV', 'unit': 'kg/s/sqrt(kPa)', 'type': 'param', 'val': 1},
            {'name': 'kV_CV', 'unit': 'kg/s/sqrt(kPa)', 'type': 'param', 'val': 1},
            {'name': 'kV_SWEP', 'unit': 'kg/s/sqrt(kPa)', 'type': 'param', 'val': kV_SWEP},
            {'name': 'm_dot', 'unit': 'kg/s', 'type': 'param', 'val': 0.1},
            {'name': 'f_Fanning_overall', 'unit': '', 'type': 'param', 'val': 0.1},
            {'name': 'theta', 'unit': '', 'type': 'param', 'val': theta},
            {'name': 'phi', 'unit': '', 'type': 'param', 'val': phi},
            {'name': 'L', 'unit': 'm', 'type': 'param', 'val': c['Length']},
            {'name': 'deltaL', 'unit': 'm', 'type': 'param', 'val': deltaL},
            {'name': 'Dh', 'unit': 'm1', 'type': 'param', 'val': Dh},
            {'name': 'De', 'unit': 'm1', 'type': 'param', 'val': De},
            {'name': 'A0', 'unit': 'm2', 'type': 'param', 'val': A0},
            {'name': 'We_m', 'unit': '', 'type': 'param', 'val': 5},
            {'name': 'Bd', 'unit': '', 'type': 'param', 'val': 40},
            {'name': 'Bo', 'unit': '', 'type': 'param', 'val': 0.0001},
            {'name': 'G_flux', 'unit': '', 'type': 'param', 'val': 20},
            {'name': 'm_dot_', 'unit': 'kg/s', 'type': 'param', 'val': 0.1},
            {'name': 'A_ht', 'unit': 'm2', 'type': 'param', 'val': A_ht},
            {'name': 'Dp', 'unit': 'm', 'type': 'param', 'val': Dp},
            {'name': 'Lambda', 'unit': 'm', 'type': 'param', 'val': Lambda},

        ]

    def f_1ph(self):
        mu = side1.mu * (side1.mu > 0) + side1.mu0 * (side1.mu <= 0)
        rho_m = side1.rho0 * (side1.rho0 > 0) + side1.rho0_0 * (side1.rho0 <= 0)
        rhoL = rho_m
        cp = side1.Cp * (side1.Cp > 0) + side1.Cp0 * (side1.Cp <= 0)
        k = side1.k * (side1.k > 0) + side1.k0 * (side1.k <= 0)

        Pr = cp * mu / k
        mdot = m_dot_ * (m_dot_ < 50) + 50 * (m_dot_ >= 50)
        G_flux = abs(mdot / A0)
        Re = G_flux * Dh / mu

        theta_radiant = theta * 3.14159 / 180

        log10_Re = ln(Re) / ln(10)
        sin_theta = sin(theta_radiant)
        sin_2theta = sin(2 * theta_radiant)
        cos_theta = sqrt(1 - sin_theta ** 2)
        tan_theta = sin_theta / cos_theta

        f0 = 64 / Re * (Re < 2000) + (1.8 * log10_Re - 1.5) ** (-2) * (Re >= 2000)
        f1 = (597 / Re + 3.85) * (Re < 2000) + (9 / Re ** (0.289)) * (Re >= 2000)

        A = cos_theta / ((0.18 * tan_theta + 0.36 * sin_theta + f0 / cos_theta) ** (1 / 2)) + (1 - cos_theta) / (
            sqrt(3.8 * f1))

        f = 1 / (A ** 2)
        f_Fanning_1 = f / 8
        # f_Fanning_overall = min2(f_Fanning_1,5)
        f_Fanning_ = min2(f_Fanning_1, 2)
        f_Fanning_overall = max2(f_Fanning_, 0.05)

        kV = A0 * sqrt(Dh / (2 * f_Fanning_overall * L)) * sqrt(rho_m)
        # A0 * sqrt(Dh / (2 * f_Fanning_overall * L)) * sqrt(rho_m)

        dp_gr = 0  # rho_m*9.81*L

        A0_port = 3.14159 * Dp ** 2 / 4
        G_port = abs(m_dot_ / A0_port)
        dp_port = 0  # 2*0.75*G_port**2/(2*rho_m)
        dp_gr = 0

        Nu = 0.122 * Pr ** (1 / 3) * (f * Re ** 2 * sin_2theta) ** 0.374
        htc = Nu * k / Dh

    def f_2ph_eva(self):
        cpL = side1.cpL * (side1.cpL > 0) + (side1.cpL <= 0) * side1.cpL0
        cpV = side1.cpV * (side1.cpV > 0) + (side1.cpV <= 0) * side1.cpV0
        muL = side1.muL * (side1.muL > 0) + (side1.muL <= 0) * side1.muL0
        muV = side1.muV * (side1.muV > 0) + (side1.muV <= 0) * side1.muV0
        kL = side1.kL * (side1.kL > 0) + (side1.kL <= 0) * side1.kL0
        kV_cond = side1.kV * (side1.kV > 0) + (side1.kV <= 0) * side1.kV0
        sigma = side1.sigma * (side1.sigma > 0) + side1.sigmaL0 * (side1.sigma <= 0)
        rhoL = side1.rhoL * (side1.rhoL > 0) + side1.rhoL0 * (side1.rhoL <= 0)
        rhoV = side1.rhoV * (side1.rhoV > 0) + side1.rhoV0 * (side1.rhoV <= 0)
        q = 0.2
        h_lat = side1.h_lat * (side1.h_lat > 0) + side1.hLat0 * (side1.h_lat <= 0)

        p = side1.p
        mdot = m_dot_ * (m_dot_ < 50) + 50 * (m_dot_ >= 50)
        G_flux = abs(mdot / A0)

        rho_m = ((q / rhoV + (1 - q) / rhoL) ** (-1))

        We_m = (G_flux ** 2) * Dh / (sigma * rho_m)

        Bd = (9.81 * (Dh ** 2) * (rhoL - rhoV) / sigma)

        theta_star = theta / 70
        C = 2.125 * (theta_star ** 9.993) + 0.955

        Re_V = G_flux * q * Dh / muV
        Re_LO = G_flux * Dh / muL

        f_Fanning_Amalfi = C * 15.698 * (abs(We_m)) ** (-0.475) * (abs(Bd) ** (0.255)) * ((rhoL / rhoV) ** (-0.571))

        Ge3 = 64710 * (Lambda / Dh) ** (-5.27) * ((theta) * 3.14159 / 180) ** (-3.03)
        Ge4 = -1.314 * (Lambda / Dh) ** (-0.62) * ((theta) * 3.14159 / 180) ** (-0.47)
        G_eq = G_flux * (1 - q + q * abs(rhoL / rhoV) ** (1 / 2))
        Re_eq = G_eq * Dh / muL
        f_Han = Ge3 * (Re_eq ** Ge4)
        f_Fanning_overall_ = f_Han / 2 * rho_m / rhoL * G_eq ** 2 / G_flux ** 2

        Re_VO = G_flux * Dh / muV
        theta_star_2 = theta / 60
        n = 2.99 * (Re_VO <= 8000) + 3.15 * (Re_VO > 8000) * (Re_VO <= 16000) + 2.99 * (Re_VO > 16000)
        m = 0.137 * (Re_VO <= 4000) + 0.172 * (Re_VO > 4000) * (Re_VO <= 8000) + 0.161 * (Re_VO > 8000) * (
                    Re_VO <= 16000) + 0.195 * (Re_VO > 16000)
        f_Fanning_1 = (n / (Re_VO ** m)) * (-1.89 + 6.56 * theta_star_2 - 3.69 * theta_star_2 ** 2)

        # f_Fanning_overall=  min2(f_Fanning_Amalfi, 5)

        theta_radiant = theta * 3.14159 / 180

        log10_Re = ln(Re_LO) / ln(10)
        sin_theta = sin(theta_radiant)
        sin_2theta = sin(2 * theta_radiant)
        cos_theta = sqrt(1 - sin_theta ** 2)
        tan_theta = sin_theta / cos_theta

        f0 = 64 / Re_LO * (Re_LO < 2000) + (1.8 * log10_Re - 1.5) ** (-2) * (Re_LO >= 2000)
        f1 = (597 / Re_LO + 3.85) * (Re_LO < 2000) + (9 / Re_LO ** (0.289)) * (Re_LO >= 2000)

        A = cos_theta / ((0.18 * tan_theta + 0.36 * sin_theta + f0 / cos_theta) ** (1 / 2)) + (1 - cos_theta) / (
            sqrt(3.8 * f1))

        f = 1 / (A ** 2)
        f_Fanning_SP = f / 8
        f_Fanning_overall = min2(f_Fanning_SP, 2)
        kV = A0 * sqrt(Dh / (2 * f_Fanning_overall * L)) * sqrt(rho_m)

        dp_port = 0
        dp_gr = 0

    def f_2ph_cond(self):
        # Tao and Infante Ferrera correlation - 2019- valid for condensation - only for pressure drop
        sigma = side1.sigma * (side1.sigma > 0) + side1.sigmaL0 * (side1.sigma <= 0)
        cpL = side1.cpL * (side1.cpL > 0) + (side1.cpL <= 0) * side1.cpL0
        cpV = side1.cpV * (side1.cpV > 0) + (side1.cpV <= 0) * side1.cpV0
        rhoL = side1.rhoL * (side1.rhoL > 0) + side1.rhoL0 * (side1.rhoL <= 0)
        muL = side1.muL * (side1.muL > 0) + (side1.muL <= 0) * side1.muL0
        muV = side1.muV * (side1.muV > 0) + (side1.muV <= 0) * side1.muV0
        kL = side1.kL * (side1.kL > 0) + (side1.kL <= 0) * side1.kL0
        rhoV = side1.rhoV * (side1.rhoV > 0) + side1.rhoV0 * (side1.rhoV <= 0)
        kV_cond = side1.kV * (side1.kV > 0) + (side1.kV <= 0) * side1.kV0
        q = 0.5
        h_lat = side1.h_lat * (side1.h_lat > 0) + side1.hLat0 * (side1.h_lat <= 0)
        hL_sat = side1.hL * (side1.hL > 0) + side1.hL0 * (side1.hL <= 0)

        p = side1.p
        p_crit = side1.p_critical

        rho_m = (q / rhoV + (1 - q) / rhoL) ** (-1)

        mdot = m_dot_ * (m_dot_ < 5) + 2 * (m_dot_ >= 5)
        G_flux = abs(mdot / A0)

        G_flux_Re = G_flux
        G_eq = G_flux_Re * (1 - q + q * abs(rhoL / rhoV) ** (1 / 2))
        Re_eq = G_eq * Dh / muL
        Re_LO = G_flux_Re * Dh / muL

        ratio_p = no_zero_div(p, p_crit, 1)

        kV = A0 * sqrt(Dh / (2 * f_Fanning_overall * L)) * sqrt(rho_m)

        # Han correlations

        theta_radiant = theta * 3.14159 / 180
        Ge3 = 3521.1 * (Lambda / Dh) ** (4.17) * (theta_radiant) ** (-7.75)
        Ge4 = -1.024 * (Lambda / Dh) ** (0.0925) * (theta_radiant) ** (-1.3)
        f_Han = Ge3 * Re_eq ** (Ge4)
        f_Fanning_overall_Han = f_Han / 2 * rho_m / rhoL * G_eq ** 2 / G_flux ** 2

        # Yan Lin correlation
        HeatFlux = h_lat * G_flux * A0 / A_ht
        Bo_1 = no_zero_div(abs(HeatFlux), (h_lat * G_flux), 0.01)
        Bo = Bo_1 * (Bo_1 > 0) + 0.0008 * (Bo_1 <= 0)
        f_Fanning_overall_YanLin = 94.75 * Re_eq ** (-0.0467) * Re_LO ** (-0.4) * Bo ** 0.5 * (ratio_p) ** (0.8)

        f_Fanning_overall_ = f_Fanning_overall_YanLin * (G_flux > 40) + f_Fanning_overall_Han * (G_flux <= 40)
        f_Fanning_1 = f_Fanning_overall_
        f_Fanning_ = min2(f_Fanning_1, 2)
        f_Fanning_overall = max2(f_Fanning_, 0.05)

        dp_gr = 0
        dp_port = 0

    def m_dot_calc_func(self):
        dp = side1.p - side2.p
        dp_fr = dp - dp_gr - dp_port

        m_dot_raw = sign(dp) * sqrt(abs(dp_fr)) * kV
        m_dot = m_dot_raw * (abs(m_dot_raw) > 0) + 0.1 * (m_dot_raw == 0)

        kV_CV_ = A0 * sqrt(Dh / (2 * f_Fanning_overall * deltaL)) * sqrt(rho_m)
        kV_CV1 = min2(kV_CV_, 10)
        kV_CV = max2(kV_CV1, 0.3)
        # kV = kV_SWEP#*sqrt(rho_m)/sqrt(rhoL)
        # kV_CV = kV_SWEP*sqrt(L/deltaL)#*sqrt(rho_m)/sqrt(rhoL)

        T_s1 = side1.T
        T_s2 = side2.T

    def output(self, sys_dict):
        sys_dict[self.gp('m_dot_')] = sys_dict[self.gp('m_dot')]


class Thermal_Conductor_Linked(BC.Link):
    def construct_Link(self, deltaA_ht=0.1, m=10, T0=20, type_flow=None, **c):
        self.side1 = c['side1']
        self.side2 = c['side2']

        self.Ref = c['FlowRef']
        self.CW = c['FlowCW']

        self.calc_funcs = []
        self.calc_funcs.append(self.Thermal_Conductor_diff_f)

        if type_flow == '1ph':
            self.calc_funcs.append(self.htc_1ph)
        elif type_flow == '2ph-eva':
            self.calc_funcs.append(self.htc_2ph_eva)
        elif type_flow == '2ph-cond':
            self.calc_funcs.append(self.htc_2ph_cond)

        self.Variables = [
            {'name': 'Q', 'unit': 'W', 'type': 'param', 'val': 0},
            {'name': 'Q1', 'unit': 'W', 'type': 'param', 'val': 0},
            {'name': 'Q2', 'unit': 'W', 'type': 'param', 'val': 0},
            {'name': 'Q_ewma', 'unit': 'W', 'type': 'state', 'val': 0},
            {'name': 'Q_ewma_1', 'unit': 'W', 'type': 'state', 'val': 0},
            {'name': 'Q_ewma_2', 'unit': 'W', 'type': 'state', 'val': 0},
            {'name': 'C', 'unit': 'W', 'type': 'param', 'val': m * 500},
            {'name': 'T', 'unit': 'W', 'type': 'state', 'val': T0},
            {'name': 'deltaA_ht', 'unit': 'm2', 'type': 'param', 'val': deltaA_ht},
            {'name': 'htc1', 'unit': 'W/m2K', 'type': 'param', 'val': 1000},
            {'name': 'htc2', 'unit': 'W/m2K', 'type': 'param', 'val': 1000},
            {'name': 'heat_flux_', 'unit': 'W/m2', 'type': 'param', 'val': 10000},
            {'name': 'heat_flux', 'unit': 'W/m2', 'type': 'param', 'val': 10000},
        ]

    def htc_1ph(self):
        htc_Ref_ = Ref.htc

    def htc_2ph_eva(self):
        q = side2.q
        G = Ref.G_flux
        rhoV = Ref.rhoV
        rhoL = Ref.rhoL
        muV = Ref.muV
        kL = Ref.kL

        h_lat = Ref.h_lat
        We_m = Ref.We_m
        Bd = Ref.Bd
        theta_star = Ref.theta_star

        Bo_1 = no_zero_div(abs(heat_flux_), (h_lat * G), 0.01)
        Bo = Bo_1 * (Bo_1 > 0) + 0.0008 * (Bo_1 <= 0)

        Re_V = (G * q * Ref.Dh / muV) * (q > 0) * (q < 1) + (G * Ref.Dh / muV) * ((q >= 1) + (q <= 0))
        Re_LO = Ref.Re_LO

        Nu1 = 982 * (theta_star ** 1.101) * (We_m ** (0.315)) * (Bo ** (0.32)) * (rhoL / rhoV) ** (-0.224)
        Nu2 = 18.495 * (theta_star ** 0.248) * (Re_V ** 0.135) * (Re_LO ** 0.351) * (Bd ** 0.235) * (Bo ** 0.198) * (
                    rhoL / rhoV) ** (-0.223)

        Nu = Nu1 * (Bd < 4) + Nu2 * (Bd >= 4)
        htc_Ref_ = Nu * kL / Ref.Dh

    def htc_2ph_cond(self):
        q = side2.q
        G = Ref.G_flux_Re
        G_eq = (G * (1 - q + q * abs(Ref.rhoL / Ref.rhoV) ** (1 / 2))) * (q > 0) * (q < 1) + G * ((q >= 1) + (q <= 0))
        Re_eq = (G_eq * Ref.Dh / Ref.muL)

        Pr_L = Ref.cpL * Ref.muL / Ref.kL
        Pr_V = Ref.cpV * Ref.muV / Ref.kV_cond
        htc_Ref_V = 4.118 * (Ref.kV_cond / Ref.Dh) * Re_eq ** 0.4 * Pr_V ** (1 / 3)
        htc_Ref_L = 4.118 * (Ref.kL / Ref.Dh) * Re_eq ** 0.4 * Pr_L ** (1 / 3)

        htc_Ref_ = htc_Ref_L * (q > 0) * (q < 1) + (
                    htc_Ref_L * (side2.h < Ref.hL_sat) + htc_Ref_V * (side2.h >= Ref.hL_sat)) * ((q >= 1) + (q <= 0))

    def Thermal_Conductor_diff_f(self):
        htc_Ref = htc_Ref_ * 1
        htc_CW = CW.htc * 1
        htc2_1 = max2(100, htc_Ref)
        htc1_1 = max2(100, htc_CW)
        htc1 = min2(htc1_1, 30000)
        htc2 = min2(htc2_1, 30000)

        R_ref = 1 / htc2
        R_CW = 1 / htc1

        U = (R_ref + R_CW) ** (-1)

        Q = U * deltaA_ht * (side1.T - side2.T)
        UA = U * deltaA_ht

        Q1 = htc1 * deltaA_ht * (-side1.T + T)
        Q2 = htc2 * deltaA_ht * (-side2.T + T)

        T_dot = (-Q1 - Q2) / C

        Q_ewma_dot = 0.01 * (Q / 1000 - Q_ewma)
        Q_ewma_2_dot = 0.01 * (Q2 / 1000 - Q_ewma_2)
        Q_ewma_1_dot = 0.01 * (Q1 / 1000 - Q_ewma_1)

        #side1.H_dot = -Q
        #side2.H_dot = Q
        side1.H_dot = Q1
        side2.H_dot = Q2

        heat_flux = abs(Q2) / deltaA_ht

    def output(self, sys_dict):
        sys_dict[self.gp('heat_flux_')] = sys_dict[self.gp('heat_flux')]