import sim_components.generic.utils.DataMap2D as DataMap2D
import sim_components.generic.items as BC
import os
class Pump_with_Map(BC.Link):
    def construct_Link(self,simple=False,scaling=1,**c):
       
        self.Pump_Type=c['Pump_Type']
        #print(self.Pump_Type)
       
        self.inlet=c['inlet']
        self.outlet=c['outlet']
        data= DataMap2D.import_CSV_Data('Pumps/' + self.Pump_Type + '.csv')
        print('Type: ', self.Pump_Type)
        print('path: ',os.getcwd())
        #self.QH_DC=DataMap2D.make_2DMap(data,['Q','H','DC'])
        #self.QP_DC=DataMap2D.make_2DMap(data,['Q','P','DC']).coeffs
        XYZ=['P','H','DC']
        self.PH_DC= DataMap2D.make_interpolation_grid(data, XYZ, 100, 100, 0, max(data[XYZ[0]]), min(data[XYZ[1]]), max(data[XYZ[1]]))
        
        XYZ=['P','H','Q']
        self.PH_Q= DataMap2D.make_interpolation_grid(data, XYZ, 100, 100, 0, max(data[XYZ[0]]), min(data[XYZ[1]]), max(data[XYZ[1]]))
        if simple:
            self.calc_funcs=[self.Mass_source_diff_f]
        else:    
            self.calc_funcs=[self.Pump_Fixed_Displacement_diff_f]
        print('P_max', data['Pmax'][0])
        self.Variables=[
                    {'name': 'Set_Speed', 'unit': '1', 'type':'param', 'val':c['Set_Speed']},
                    {'name': 'Pmax', 'unit': 'kPa', 'type':'param', 'val': data['Pmax'][0]},
                    {'name': 'DCmin', 'unit': '%', 'type': 'param', 'val': data['Dcmin'][0]/100},
                    {'name': 'kP', 'unit': '', 'type':'param', 'val':c['kP']},
                    #{'name': 'Q', 'unit': '', 'type':'state', 'val':0},
                    {'name': 'P', 'unit': '', 'type':'state', 'val':0},
                    #{'name': 'int_err', 'unit': '', 'type':'state', 'val':0},
                    {'name': 'P_ewma', 'unit': '', 'type': 'state', 'val': 0},
                    {'name': 'Energy', 'unit': 'MJ', 'type': 'state', 'val': 0},
                    {'name': 'scaling', 'unit': '1', 'type': 'param', 'val': scaling},
                    {'name': 'int_resistance', 'unit': 'kPa', 'type': 'param', 'val': 10},
                    ]

    def Pump_Fixed_Displacement_diff_f(self):
        On = (Set_Speed >= DCmin)
        #dp=max((outlet.p-inlet.p)/4, int_resistance, 0)
        dp=(outlet.p - inlet.p) / 4
        Set_Speed_in = (Set_Speed >= 0) * Set_Speed * (Set_Speed <= 1) + (Set_Speed > 1)

        Act_Speed=interp_bilin(PH_DC,P,dp)/100

        err=(Set_Speed_in-Act_Speed)

        P_dot=err*0.1*Pmax*((P>0)*(err<0)+(err>0)*(P<Pmax))


        Q = interp_bilin(PH_Q,P,dp)/1000
        rho=inlet.m/inlet.V
        m_dot=On*Q*rho * (Q>0)*scaling

        

        H_dot=m_dot*inlet.H/inlet.m
        inlet.m_dot=-m_dot
        inlet.H_dot=-H_dot
        T = inlet.T

        outlet.m_dot=m_dot

        p_in=inlet.p
        power=P*On*scaling
        outlet.H_dot = H_dot+ power

        P_ewma_dot = 0.1 * (power / 1000 - P_ewma)
        Energy_dot = power / 1e6

    
    def Mass_source_diff_f(self):
        dp=outlet.p-inlet.p
        Set_Speed_in=(Set_Speed>0)*Set_Speed
        #*(Set_Speed<10)+(Set_Speed>10)*10
        Act_Speed=Set_Speed_in
        m_dot=Set_Speed_in
        H_dot=m_dot*inlet.h
        inlet.m_dot=-m_dot
        inlet.H_dot=-H_dot
        T = inlet.T
        outlet.m_dot=m_dot
        outlet.H_dot=H_dot
        print(m_dot)
        power=100*m_dot
        P_ewma_dot = 0.1 * (power / 1000 - P_ewma)
        Energy_dot = power / 1e6

if __name__ == '__main__':
    
    import Simulation_Store_MongoDB as Simulation_Store
    
    item_fact=Simulation_Store.Item_Factory('')
    pump=item_fact.get_Item('Test','',Pump_with_Map, inlet=1, outlet=1,Pump_Type='Grundfos NBE_65_125-127',kP=1,Set_Speed=1)
    
    