import sim_components.generic.items as BC, sim_components.thermodynamics.Heat_Transfer as HT, sim_components.thermodynamics.Fluid_Flow as FF

class ST(BC.Subsystem):
    def construct_Subsystem(self, CW, T0=20, V=1, N_nodes=3, h=10, V_Top=0.1, V_Bottom=0.1, kV=5):
        self.Top = self.add('Top', FF.Volume, CW, V_Top, 0, T0=T0)#, p0=100)
        self.Bottom = self.add('Bottom', FF.Volume, CW, V_Bottom, 0, T0=T0)#, p0=100)

        for i in range(N_nodes):

            cur_node=self.add('CW_'+str(i),FF.Volume,CW,V/N_nodes,0,T0=T0)#, p0=100)




            if i== 0:
                self.add('Pipe_connect_top', FF.Pipe, CW=CW, kV=kV, side1=self.Top, side2=cur_node)
            if i==N_nodes-1:
                self.add('Pipe_connect_bottom', FF.Pipe, CW=CW, kV=kV, side1=cur_node, side2=self.Bottom)
            if i>0:
                #Linking nodes through thermal conductor
                self.add('Node_Conductor'+str(i),HT.Thermal_Conductor,h,side1=self.items['CW_'+str(i-1)],side2=self.items['CW_'+str(i)])

                #Linking nodes through pipes
                self.add('Node_Flow'+str(i),FF.Pipe,kV=3,side1=self.items['CW_'+str(i-1)],side2=self.items['CW_'+str(i)])




        #self.addPort('CW_In_1',self.items['CW_0'])
        #self.addPort('CW_Out_1',self.items['CW_'+str(N_nodes-1)])
        
        #self.addPort('CW_In_2',self.items['CW_'+str(N_nodes-1)])
        #self.addPort('CW_Out_2',self.items['CW_0'])
