import sim_components.generic.items as BC, sim_components.thermodynamics.Fluid_Flow as FF
import sim_components.thermodynamics.Heat_Transfer as HT

class Volume_String(BC.Subsystem):
    
    def construct_Subsystem(self, N_nodes, Strings, Links=[], **c):
        self.Strings = Strings
        self.N_nodes=N_nodes
        self.volumes=[]
        m_dot_cals=[]

        #Create volumes and connecting pipes
        for j, s in enumerate(Strings):
            self.volumes.append([])
            for i in range(0, self.N_nodes):
                self.volumes[-1].append(self.add('F'+str(j)+'_' + str(i), FF.Volume, s['Fluid'], s['Volume'] / (self.N_nodes), 0, s['T_ini']))

            #m_dot_cals.append(self.add('m_dot_F'+str(j), m_dot_cal, s['kV'], side1=self.volumes[-1][0],
            #                          side2=self.volumes[-1][self.N_nodes - 1]))

            for i in range(0, self.N_nodes):
                if i>0:
                    self.add('L_F'+str(j)+'_' + str(i), FF.Pipe, kV=3, side1=self.volumes[-1][i-1],
                         side2=self.volumes[-1][i])
                    #self.add('L_F' + str(j) + '_' + str(i), Pipe_Fix_Flow, side1=self.volumes[-1][i - 1],
                    #     side2=self.volumes[-1][i], flow=m_dot_cals[-1])

        self.Q=[[] for s in Strings]

        #Create heat conductor links
        for j, l in enumerate(Links):
            for i in range(0, self.N_nodes):
                q = self.add('LL_F'+str(j)+'_' + str(i), HT.Thermal_Conductor, l['h'],
                                side1=self.volumes[l['strings'][0]][i],
                                side2=self.volumes[l['strings'][1]][i]
                                )
                self.Q[l['strings'][0]] += [(q.path, 1)]
                self.Q[l['strings'][1]] += [(q.path, -1)]






class Pipe_Fix_Flow(BC.Link):
    def construct_Link(self, **c):
        self.side1=c['side1']
        self.side2=c['side2']
        self.flow=c['flow']
        
        self.calc_funcs=[self.Pipe_diff_f]

        self.Variables=[
                    
                    ]
                    
    def Pipe_diff_f(self):

        H_dot=flow.m_dot*((flow.m_dot>0)*side1.H/side1.m+(flow.m_dot<0)*side2.H/side2.m)
        side1.m_dot=-flow.m_dot
        side2.m_dot=flow.m_dot
        side1.H_dot=-H_dot
        side2.H_dot=H_dot
        #print(kV)
        
class m_dot_cal(BC.Link):
    def construct_Link(self,kV, **c):
        self.side1=c['side1']
        self.side2=c['side2']
        
        self.calc_funcs=[self.m_dot_calc_func]

        self.Variables=[
                    {'name': 'kV', 'unit': 'kg/s/sqrt(kPa)', 'type':'param', 'val':kV},
                    {'name': 'm_dot', 'unit': 'kg/s', 'type':'param', 'val':0},
                    {'name': 'dp', 'unit': 'kPa', 'type': 'calc', 'val': 0},
                    ]
                    
    def m_dot_calc_func(self):
        dp=side1.p-side2.p

        m_dot=sign(dp)*sqrt(abs(dp))*kV    
