import sim_tools.store.simulation_store_mongodb as Simulation_Store

if __name__ == '__main__':

    configs = [
        {'Name': 'GSD80421VA_Poly', 'Description': 'Bitzer Orbit GSD80421VA Scroll Compressor',
         'Comment': 'Polynomial at 6K superheat', 'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0.0001, 'Cp': 1750,
                                                                    'polynom_power': [11539.40017, 274.4988737,
                                                                                      90.85296381, 7.566775628,
                                                                                      -11.25189155, 3.574981467,
                                                                                      0.080662746, -0.149143911,
                                                                                      0.107348712, 0.031826712
                                                                                      ],
                                                                    'polynom_m_dot': [2020.233663, 63.7395367,
                                                                                      1.932303955, 0.948985398,
                                                                                      0.286009113, -0.041428282,
                                                                                      0.007191029, -0.00045653,
                                                                                      -0.004622149, -0.000737299
                                                                                      ],
                                                                    'polynom_Q': [
                                                                        130498.6019, 4406.228227, -729.9404388,
                                                                        66.67729035, -13.81443554, -4.567807723,
                                                                        0.363746787, -0.474644823, -0.320891372,
                                                                        -0.027316811

                                                                    ]

                                                                    }},

        {'Name': 'GSD80295VA_Poly', 'Description': 'Bitzer Orbit GSD80295VA Scroll Compressor',
         'Comment': 'Polynomial at 6K superheat', 'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0.0001, 'Cp': 1750,
                                                                    'polynom_power': [5623.309251, 74.13554554,
                                                                                      278.5889449, 2.16850245,
                                                                                      -2.282959232, -2.96804187,
                                                                                      0.033750589, -0.03310399,
                                                                                      0.012504041, 0.067147379],
                                                                    'polynom_m_dot': [1479.858342, 46.99068286,
                                                                                      -0.22755353, 0.695373317,
                                                                                      0.13183607, -0.012173471,
                                                                                      0.005316732, -0.000487581,
                                                                                      -0.002506305, -0.000507698],
                                                                    'polynom_Q': [93714.94627, 3115.246937,
                                                                                  -715.0951297, 47.02423103,
                                                                                  -12.70024821, 0.947435328, 0.2525737,
                                                                                  -0.35058187, -0.201139181,
                                                                                  -0.050259901]

                                                                    }},
        {'Name': 'GSD80485VA_Poly', 'Description': 'Bitzer Orbit GSD80295VA Scroll Compressor',
         'Comment': 'Polynomial at 6K superheat', 'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0.0001, 'Cp': 1750,
                                                                    'polynom_power': [12377.06377, 305.3184812,
                                                                                      158.9912123, 7.820869194,
                                                                                      -12.11422011, 2.747987202,
                                                                                      0.071610844, -0.153582861,
                                                                                      0.117113975, 0.04395762],
                                                                    'polynom_m_dot': [2246.902063, 70.49933348,
                                                                                      3.198171733, 1.005099654,
                                                                                      0.248461128, -0.085730197,
                                                                                      0.007212687, -0.001194453,
                                                                                      -0.004337268, -0.000358918],
                                                                    'polynom_Q': [147456.488, 4874.67108, -953.6517536,
                                                                                  72.1443773, -17.31640436,
                                                                                  -2.201385848, 0.379542796,
                                                                                  -0.552540724, -0.348563937,
                                                                                  -0.057082045]
                                                                    }},
        {'Name': 'GSD80385VA_Poly', 'Description': 'Bitzer Orbit GSD80295VA Scroll Compressor',
         'Comment': 'Polynomial at 6K superheat',
         'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0.0001, 'T_cond_max': 58, 'Cp': 1750,
                           'polynom_power': [10500.50414, 202.0760326,
                                             112.9582122, 5.456033165,
                                             -7.992593091, 3.008131514,
                                             0.050851048, -0.109920204,
                                             0.078371116, 0.026403691],
                           'polynom_m_dot': [1897.057142, 59.83137139,
                                             0.51348484, 0.876200006,
                                             0.178840113, -0.018002677,
                                             0.006587283, -0.000670046,
                                             -0.003186345, -0.000563196],
                           'polynom_Q': [121239.2773, 3997.094288,
                                         -904.2596947, 60.0120198,
                                         -15.36591553, 1.811820971,
                                         0.319314544, -0.448691693,
                                         -0.265236097, -0.072263883]
                           }},
        {'Name': 'GSU80385VL_Poly_R454B', 'Description': 'Bitzer Orbit+ GSU80385VL Scroll Compressor',
         'Comment': 'Polynomial at 6K superheat',
         'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1750,
                           'polynom_power': [9578.35326, 204.7826829,
                                             106.0761156, 5.558788122,
                                             -8.197943726, 2.106517324,
                                             0.048326292, -0.111874966,
                                             0.081304682, 0.034463136
                                             ],
                           'polynom_m_dot': [1535.129599, 48.90486925,
                                             -1.899919725, 0.662240984,
                                             -0.025727861, 0.042614644,
                                             0.004787395, -0.00050104,
                                             0.000229548, -0.000698495
                                             ]
                           }},
        {'Name': 'GSD60235VA_Poly', 'Description': 'Bitzer Orbit GSD60235VA Scroll Compressor',
         'Comment': 'Polynomial at 6K superheat',
         'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1750,
                           'polynom_power': [6322.636149, 103.335324,
                                             116.4696866, 4.618382331,
                                             -2.023994863, 0.04501001,
                                             0.097622635, -0.050568899,
                                             0.008850639, 0.027446474],
                           'polynom_m_dot': [1073.86334, 34.31863957,
                                             2.79320893, 0.468902097,
                                             0.114804972, -0.061255793,
                                             0.003850519, 0.000219798,
                                             -0.001391373, 0.000172603],
                           'polynom_Q': [69230.87354, 2277.90935, -423.6074146,
                                         32.63799126, -6.714477976,
                                         -0.539597839, 0.184270409,
                                         -0.221821584, -0.159897577,
                                         -0.03107228]}},

        {'Name': '4NES-20Y_Poly', 'Description': 'Bitzer 4NES-20Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [2517.792877, -154.5023946,
                                             146.1820425, -5.937473213,
                                             7.500599015, -0.21065783,
                                             -0.05182653, 0.083330586,
                                             -0.024753904, -0.006490231],
                           'polynom_m_dot': [805.7623897, 28.69881934,
                                             -3.91660403, 0.355438641,
                                             -0.010505262, 0.03079358,
                                             0.002571211, 0.000913861,
                                             -0.000436821, -0.000397783],
                           'polynom_Q': [46644.56365, 1897.472271,
                                         -456.400655, 27.99119015,
                                         -14.32793408, 0.355639243,
                                         0.153091089, -0.161715246,
                                         -0.009763546, -0.001265122]

                           }},
        {'Name': '4NES-20Y_Poly_R1234ZE', 'Description': 'Bitzer 4NES-20Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 5, 'kP': 0.05, 'kI': 0, 'T_cond_max': 90, 'Cp': 1300,
                           'polynom_power': [2562.719818, -113.1165294, 85.65467701, -4.650028071, 5.774644386,
                                             0.112652204, -0.042305682, 0.067960738, -0.020648677, -0.005377759],
                           'polynom_m_dot': [679.0428882, 25.47435908, -3.15506158, 0.331158809, -0.032552181,
                                             0.01657259, 0.002481127, 0.000156346, -0.000273756, -0.000219085],
                           'polynom_Q': [35480.41842, 1488.644551, -361.9733017, 22.85927154, -11.68673257, 0.316564415,
                                         0.131814467, -0.142699857, -0.004201762, 0.000809076]

                           }},

        {'Name': '4NES-20Y_Poly_R1234YF', 'Description': 'Bitzer 4NES-20Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat and 0 K subcooling',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 85, 'Cp': 2000,
                           'polynom_power': [2472.542036, -153.1714236, 150.6549283, -5.431482762, 6.901067175,
                                             -0.270693258, -0.044037892, 0.070816507, -0.020996646, -0.005482236],
                           'polynom_m_dot': [978.9789371, 32.81770491, -4.083173853, 0.378212236, -0.012686535,
                                             0.025440295, 0.002620124, 0.001030312, -0.00037043, -0.000368581],
                           'polynom_Q': [46186.76075, 1784.493318, -498.8037299, 26.4565814, -13.29226077, 0.831576243,
                                         0.146230474, -0.17015126, -0.029957722, -0.005446308]

                           }},
        {'Name': '4TES-12Y_Poly', 'Description': 'Bitzer 4TES-12Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           #'polynom_power': [1709.196621, -94.65141052,
                           #                  115.4595665, -3.481589713,
                           #                  4.86978828, -0.371900576,
                           #                  -00.059498136, 0.042152607,
                           #                 -0.011735826, -0.002128889],
                           #'polynom_m_dot': [585.0921531, 20.69211529,
                           #                  -2.508168083, 0.255397451,
                           #                  0.005856941, 0.015945005,
                           #                  0.001894012, 0.000767651,
                           #                  -0.000436084, -0.000257841]
                           #Update 27/10/2020 Roberta
                           'polynom_m_dot': [589.8589677, 21.0395719,
                                             -2.795893579,
                                             0.265756459,
                                             -0.004777956,
                                             0.020758515,
                                             0.001798549,
                                             0.000598457,
                                             -0.000344258,
                                             -0.000281314],
                           'polynom_power': [1721.349292,	-102.1215905,
                                             113.4653817,	-3.792841125,
                                             5.155027674,	-0.303757852,
                                             -0.039458708,	0.047767216,
                                             -0.014447382,	-0.00273206],
                           'polynom_Q': [33517.14988,	1351.460929,
                                         -338.3103937,	19.97010288,
                                         -9.673701556,	0.583315814,
                                         0.110071433,	-0.111447604,
                                         -0.014596684,	-0.003902878,]
                           }},

        {'Name': '4GE-30Y_Poly', 'Description': 'Bitzer 4GE-30Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [4032.948454, -69.60760488,
                                             232.1472183, -4.069534566,
                                             5.044102115, -0.988913829,
                                             -0.023757958, 0.043863354,
                                             0.012993466, -0.001305145],
                           'polynom_m_dot': [1174.473011, 45.84313206,
                                             -2.83466989, 0.633421646,
                                             -0.123058439, 0.008779753,
                                             0.00345374, -0.001721896,
                                             0.000424567, -0.000392219],
                           'polynom_Q': [68335.47595, 2881.619715,
                                         -538.4234828, 43.67258806,
                                         -22.3004915, -1.12217938,
                                         0.211305041, -0.307219116,
                                         -0.001061927, 0.003693439]
                           }},
        # {'Name': '6FE-50Y_Poly', 'Description': 'Bitzer 6FE-50Y Semi-hermetic recip Compressor',
        # 'Comment': 'Polynomial at 10K superheat', 'Configuration': {'dT_Super': 8, 'kP': .03, 'kI': 0,
        #                                                            'polynom_power': [5705.931955,	-247.4594538,	498.4139575,	-6.47003065,	15.93041088,	-2.568033227,	-0.061017135,	0.065574972,	-0.057203977,	-0.004034721],
        #                                                            'polynom_m_dot': [2050.769151,	76.97675045,	-4.314328812,	1.095638569,	-0.076576206,	-0.013441208,	0.006053548,	-0.002564967,	-0.001164663,	-0.000512623]
        #                                                           }},
        {'Name': '6FE-50Y_Poly_R513A', 'Description': 'Bitzer 6FE-50Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 8, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [6026.329143, -263.9198478,
                                             523.8562776, -6.727746221,
                                             16.42235354, -2.691023985,
                                             -0.06280835, 0.062447399,
                                             -0.05821557, -0.004294773
                                             ],
                           'polynom_m_dot': [2403.075861, 87.60440914,
                                             -3.88727296, 1.229124813,
                                             -0.085060366, -0.037653531,
                                             0.006988595, -0.003293975,
                                             -0.001429644, -0.000466414
                                             ]
                           }},

        {'Name': '6FE-50Y_Poly_R134A', 'Description': 'Bitzer Semi_Hermectic Reciprocating Compressor 6FE-50Y',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0.0001, 'Cp': 1750,
                           'polynom_power': [5705.931955, -247.4594538,
                                             498.4139575, -6.47003065,
                                             15.93041088, -2.568033227,
                                             -0.061017135, 0.065574972,
                                             -0.057203977, -0.004034721],
                           'polynom_m_dot': [2050.769151, 76.97675045,
                                             -4.314328812, 1.095638569,
                                             -0.076576206, -0.013441208,
                                             0.006053548, -0.002564967,
                                             -0.001164663, -0.000512623],
                           'polynom_Q': [120195.7891, 4958.757193,
                                         -970.8449788, 76.92480617,
                                         -36.35596297, -2.178220692,
                                         0.373381869, -0.544075214,
                                         -0.040799718, 0.01008808]
                           }},
        {'Name': '6GE-30Y_Poly_R134A', 'Description': 'Bitzer Semi_Hermectic Reciprocating Compressor 6GE-30Y',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0.0001, 'Cp': 1750,
                           'polynom_power': [3949.759441,
                                             -253.871857,
                                             440.280766,
                                             -7.036305677,
                                             14.91502169,
                                             -2.12147382,
                                             -0.04937765,
                                             0.097322709,
                                             -0.051133345,
                                             -0.001515312],
                           'polynom_m_dot': [1644.114579,
                                             69.22688127,
                                             -1.872758655,
                                             1.142003402,
                                             -0.11878764,
                                             -0.049265802,
                                             0.007722703,
                                             -0.002153196,
                                             -0.000493476,
                                             0.000108787],
                           'polynom_Q': [99090.96158,
                                         4015.71704,
                                         -754.9346042,
                                         59.02090514,
                                         -31.79641006,
                                         -2.216372874,
                                         0.29596065,
                                         -0.399028619,
                                         -0.003923909,
                                         0.01512524]
                           }},
        {'Name': '6FE-50Y_Poly_R1234ZE', 'Description': 'Bitzer 6FE-50Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 5K superheat',
         'Configuration': {'dT_Super': 5, 'kP': 0.05, 'kI': 0, 'T_cond_max': 90, 'Cp': 1300,
                           'polynom_power': [4362.649099, -255.6615334,
                                             369.6292726, -5.993023694,
                                             13.64666631, -1.68481949,
                                             -0.048973658, 0.073985537,
                                             -0.045925135, -0.003643216
                                             ],
                           'polynom_m_dot': [1682.99067, 65.60572201,
                                             -1.477237061, 0.982536925,
                                             -0.071705694, -0.050411824,
                                             0.005908687, -0.002509643,
                                             -0.000561677, -0.000114718
                                             ],
                           'polynom_Q': [89262.63301, 3811.843672,
                                         -670.6877723, 62.4652363,
                                         -27.83900193, -3.254633674,
                                         0.3314769, -0.435416586,
                                         -0.02661422, 0.02031437]
                           }},

        {'Name': '6FE-50Y_Poly_R1234YF', 'Description': 'Bitzer 6FE-50Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 5K superheat and 3K subcooling',
         'Configuration': {'dT_Super': 5, 'kP': 0.05, 'kI': 0, 'T_cond_max': 85, 'Cp': 2000,
                           'polynom_power': [6136.749, -242.5610446, 490.021307086223, -6.608256973, 14.54793145,
                                             -2.502489156, -0.051437571, 0.068884484,
                                             -0.048674843, -0.00268273],
                           'polynom_m_dot': [2554.964054, 92.00540711, -3.159681523, 1.26029008, -0.131004051,
                                             -0.06754114, 0.006639125,
                                             -0.003710463, -0.000972835, -0.000214907
                                             ],
                           'polynom_Q': [121988.2256, 4863.31177, -1068.544868, 72.69162378, -39.69275396, -3.56802016,
                                         0.360371532, -0.532345345,
                                         -0.041361545, 0.023245703]
                           }},

        {'Name': '6GE-40Y_Poly', 'Description': 'Bitzer 6GE-40Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [4288.270518, -265.8837127,
                                             422.1028624, -8.760491748,
                                             14.38619993, -2.144127164,
                                             -0.078639657, 0.110182354,
                                             -0.042305726, -0.000957593],
                           'polynom_m_dot': [1553.398436, 55.42789972,
                                             3.500496924, 0.741262865,
                                             0.181128262, -0.109625088,
                                             0.005064367, 0.001378262,
                                             -0.002133971, 0.000144884]
                           }},
        {'Name': '8FE-70Y_Poly', 'Description': 'Bitzer 8FE-70Y Semi-hermetic recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [9035.337645, -483.2024585,
                                             843.8762276, -20.27561051,
                                             29.26880549, -8.150919687,
                                             -0.240559107, 0.298280209,
                                             -0.122528193, 0.028006636
                                             ],
                           'polynom_m_dot': [2822.44524, 102.68225,
                                             -3.200262698, 1.431738422,
                                             -0.090273935, -0.099690824,
                                             0.009131806, -0.003582096,
                                             -0.000396384, -7.74748E-05
                                             ],
                           'polynom_Q': [163200.9485, 6436.23868,
                                         -1242.479725, 97.13610676,
                                         -43.99324113, -6.070782084,
                                         0.541339244, -0.665755688,
                                         -0.061169308, 0.038733817
                                         ],
                           }},
        {'Name': 'CSH7583-80Y_Poly_R1234ze', 'Description': 'Bitzer CSH7583-80Y Compact Screw Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1300,
                           'polynom_power': [4909.15252, 205.5744106,
                                             941.0345927, 14.93509546,
                                             -2.6963189, -13.38362032,
                                             -0.078823848, -0.271941734,
                                             0.078869791, 0.149962994

                                             ],
                           'polynom_m_dot': [3592.654029, 116.4857423,
                                             -34.3601648, 1.429053456,
                                             -0.164500878, 0.941526903,
                                             0.009768741, 0.002315047,
                                             0.002048406, -0.009671231

                                             ]
                           }},
        {'Name': 'CSH7583-80Y_Poly_R134a', 'Description': 'Bitzer CSH7583-80Y Compact Screw Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [1488.066688, 331.4851313,
                                             1648.276369, 22.96633441,
                                             1.281230501, -29.18555425,
                                             -0.052002734, -0.403523313,
                                             -0.026082501, 0.300579884

                                             ],
                           'polynom_m_dot': [3065.8873, 94.95840626,
                                             52.98173984, 1.159039546,
                                             2.169311978, -1.095338024,
                                             0.006003332, 0.018173467,
                                             -0.023894758, 0.005088209

                                             ]
                           }},
        {'Name': '8GE-50Y_Poly_R134a', 'Description': 'Bitzer 8GE-50Y Recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [6379.872947, -398.3921738,
                                             806.5949482, -17.5283481,
                                             24.65760112, -9.240579107,
                                             -0.213626548, 0.269917863,
                                             -0.098220474, 0.042967502

                                             ],
                           'polynom_m_dot': [2375.578441, 87.28778509,
                                             -1.396583736, 1.21782281,
                                             -0.048977334, -0.115730467,
                                             0.007767049, -0.002140644,
                                             -0.00043025, 0.000211429
                                             ]
                           }},
        {'Name': '8FE-70Y_Poly_R134a', 'Description': 'Bitzer 8FE-70Y Recip Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 6, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [9035.337645, -483.2024585,
                                             843.8762276, -20.27561051,
                                             29.26880549, -8.150919687,
                                             -0.240559107, 0.298280209,
                                             -0.122528193, 0.028006636

                                             ],
                           'polynom_m_dot': [2822.44524, 102.68225,
                                             -3.200262698, 1.431738422,
                                             -0.090273935, -0.099690824,
                                             0.009131806, -0.003582096,
                                             -0.000396384, -7.74748E-05

                                             ],
                           'polynom_Q': [163200.9485, 6436.23868, -1242.479725, 97.13610676, -43.99324113, -6.070782084,
                                         0.541339244, -0.665755688, -0.061169308, 0.038733817
                                         ],

                           }},
        {'Name': 'CSH6593-60Y_Poly_R1234ze', 'Description': 'Bitzer CSH6593-60Y Compact Screw Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1300,
                           'polynom_power': [19094.79407, 297.5963391,
                                             229.2407355, 8.236801299,
                                             -2.698176963, 2.233790272,
                                             0.071327013, -0.12467373,
                                             0.030300364, 0.053090111

                                             ],
                           'polynom_m_dot': [3008.931123, 101.0599766,
                                             26.47654342, 1.44752019,
                                             1.325367847, -0.615881164,
                                             0.008698273, 0.0066758,
                                             -0.017523151, 0.002505969

                                             ]
                           }},
        {'Name': 'CSH6563-40Y_Poly_R1234ze', 'Description': 'Bitzer CSH6593-60Y Compact Screw Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1300,
                           'polynom_power': [8328.843639, 140.6851758,
                                             268.2137153, 5.90915946,
                                             -1.95850192, -3.172252499,
                                             0.030487541, -0.084299085,
                                             0.026809594, 0.061037401

                                             ],
                           'polynom_m_dot': [2098.159, 71.61035, -19.1757,
                                             0.893646, -0.31144, 0.437621,
                                             0.005168, -0.00177, 0.002733,
                                             -0.00431

                                             ]
                           }},
        {'Name': 'CSH7573-70Y_Poly_R1234ze', 'Description': 'Bitzer CSH7573-70Y Compact Screw Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 5, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1300,
                           'polynom_power': [17357.79, 217.8559, -30.1436,
                                             6.522827, -4.89619, 7.095727,
                                             0.077939, -0.07966, 0.090919,
                                             -0.00572

                                             ],
                           'polynom_m_dot': [3300.374, 107.0422, -33.9581,
                                             1.210133, -0.05489, 0.777281,
                                             0.008054, 0.004706, -0.00142,
                                             -0.00776

                                             ]
                           }},
        {'Name': 'CSH7573-70Y_Poly_R1234ze_2K_dT_super', 'Description': 'Bitzer CSH7573-70Y Compact Screw Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 6, 'kP': .05, 'kI': 0.000, 'T_cond_max': 58, 'Cp': 1300,
                           'polynom_power': [17357.79, 217.8559, -30.1436,
                                             6.522827, -4.89619, 7.095727,
                                             0.077939, -0.07966, 0.090919,
                                             -0.00572

                                             ],
                           'polynom_m_dot': [3300.374, 107.0422, -33.9581,
                                             1.210133, -0.05489, 0.777281,
                                             0.008054, 0.004706, -0.00142,
                                             -0.00776

                                             ]
                           }},
        {'Name': '6CTE-50K', 'Description': 'Bitzer 6CTE-50K Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 10, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [-22440.9, -687.096, 1115.743,
                                             -5.93802, 2.155842, -4.50079,
                                             0.015129, -0.08371, 0.056859,
                                             0.007917
                                             ],
                           'polynom_m_dot': [3493.123, 101.2347, -7.29894,
                                             1.311031, -0.00598, -0.00668,
                                             0.012734, 0.00239, -0.0004,
                                             -2.4E-09
                                             ]
                           }},
        {'Name': '6DTE-50K', 'Description': 'Bitzer 6DTE-50K Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 30, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [-17622, -539.55, 876.15, -4.6629,
                                             1.6929, -3.5343, 0.01188,
                                             -0.065736, 0.044649, 0.0062172

                                             ],
                           'polynom_m_dot': [2781.806082, 80.61992975,
                                             -5.81262902, 1.044060807,
                                             -0.004764101, -0.005315849,
                                             0.010141282, 0.001903529,
                                             -0.000321855, -1.92359E-09

                                             ]
                           }},
        {'Name': '4FTC-30K', 'Description': 'Bitzer 4FTC-30K Compressor',
         'Comment': 'Polynomial at 10K superheat',
         'Configuration': {'dT_Super': 5, 'kP': 0.05, 'kI': 0, 'T_cond_max': 58, 'Cp': 1420,
                           'polynom_power': [-13835.84393, -690.2656296,
                                             628.8259977, -8.941778737,
                                             9.45465698, -3.277604326,
                                             -0.034832731, 0.022193892,
                                             -0.014859208, 0.007460004

                                             ],
                           'polynom_m_dot': [1783.166143, 58.24046074,
                                             -5.080695883, 1.021153123,
                                             -0.082712245, 0.000435892,
                                             0.014409139, -0.000879502,
                                             -5.21084E-05, 2.82918E-05]
                           }},

        {'Name': 'EMA-025', 'Description': 'EMA-025', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': False,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'GSD60235VA_Poly',
             'Conf_Evap': 'B200T_1',
             'Plates_Evap': 166,
             'Conf_Cond': 'B120T_2',
             'Plates_Cond': 84,
             'Conf_Sub': 'B25T_2',
             'Plates_Sub': 70,
             'Pump_Evap': 'Grundfos Magma3_65-150',
             'Pump_Cond': 'Grundfos Magma3_65-150',
             'Pump_Sub': 'Grundfos Magma3_25-40',
             'Refrigerant': 'R410A_333_6_No_NaN',
             'Nominal_Power': 25,
             'T_cond_max': 58,
         }},
        {'Name': 'EMA-1', 'Description': 'EMA-1', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'GSD80295VA_Poly',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 222,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 210,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 94,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_50_125-121',
             'Pump_Sub': 'Grundfos Magma3_25-60',
             'Refrigerant': 'R410A_333_6_No_NaN',
             'Nominal_Power': 100,
             'T_cond_max': 58,
             # 'Refrigerant': 'R410A_20181126'

         }},
        {'Name': 'EMA-1-R134a-6GE-30Y', 'Description': 'EMA-1', 'Comment': '',
         'Tags': ['EMA'],
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': '6GE-30Y_Poly_R134A',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 222,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 210,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 94,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_50_125-121',
             'Pump_Sub': 'Grundfos Magma3_25-60',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 100,
             'T_cond_max': 85,
             # 'Refrigerant': 'R410A_20181126'

         }},
        {'Name': 'EMA-1-EP', 'Description': 'EMA-1', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'GSD80295VA_Poly',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 222,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 210,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 94,
             'Pump_Evap': 'Grundfos NBE_50_125-121',
             'Pump_Cond': 'Grundfos NBE_50_125-121',
             'Pump_Sub': 'Grundfos Magma3_25-60',
             'Refrigerant': 'R410A_333_6_No_NaN',
             'Nominal_Power': 100,
             'T_cond_max': 58,
             # 'Refrigerant': 'R410A_20181126'

         }},
        {'Name': 'EMA-2', 'Description': 'EMA-2', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'GSD80385VA_Poly',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 290,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 266,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 146,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_125-100',
             'Refrigerant': 'R410A_333_6_No_NaN',
             'Nominal_Power': 200,
             'T_cond_max': 58,
         }},
        {'Name': 'EMA-3', 'Description': 'EMA-3', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'GSD80485VA_Poly',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Length_Evap': 0.546,
             'Width_Evap': 0.302 ,
             'b_Evap': 0.0031,
             'Lambda_Evap': 0.0098,
             'theta_Evap': 30,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Length_Cond': 0.449,
             'Width_Cond': 0.243,
             'b_Cond': 0.0055,
             'Lambda_Cond': 0.0055,
             'theta_Cond': 30,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Length_Sub': 0.449,
             'Width_Sub': 0.243,
             'b_Sub': 0.0055,
             'Lambda_Sub': 0.0055,
             'theta_Sub': 30,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R410A_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 58,
         }},
        {'Name': 'EMA-3s', 'Description': 'EMA-3', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'GSD80485VA_Poly',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 330,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R410A_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 58,
         }},
        {'Name': 'EMA-05', 'Description': 'EMA-05', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': 'GSD80421VA_Poly',
             'Conf_Evap': 'B250AS_2',
             'Plates_Evap': 180,
             'Conf_Cond': 'B250AS_2',
             'Plates_Cond': 160,
             'Conf_Sub': 'B25T_2',
             'Plates_Sub': 80,
             # 'Pump_Evap': 'Grundfos_Magma3_125-100',
             # 'Pump_Cond': 'Grundfos_Magma3_125-100',
             'Pump_Evap': 'Grundfos NBE_65_125-120',
             'Pump_Cond': 'Grundfos NBE_50_125-144',

             'Pump_Sub': 'Grundfos Magma3_25-40',
             'Refrigerant': 'R410A_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 58,
         }},
        {'Name': 'EMA-3B', 'Description': 'EMA-3 with Reciprocating Compressors', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': '8FE-70Y_Poly',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 70,
         }},
        # {'Name': 'EMA-3B-lowGWP', 'Description': 'EMA-3 with Reciprocating Compressors', 'Comment': '',
        #   'Configuration': {
        #       'Dual_Circuit': True,
        #       'Compressors_Circuit': 2,
        #       'Conf_Compressor': '6FE-50Y_Poly_R1234ZE',
        #       'Conf_Evap': 'DB700_2',
        #       'Plates_Evap': 366,
        #       'Conf_Cond': 'DB300_2',
        #       'Plates_Cond': 330,
        #       'Conf_Sub': 'DB300_2',
        #       'Plates_Sub': 178,
        #       'Pump_Evap': 'Grundfos NBE_65_125-137',
        #       'Pump_Cond': 'Grundfos NBE_65_125-127',
        #       'Pump_Sub': 'Grundfos_Magma3_25-100',
        #       'Refrigerant': 'R1234ze_333_6_No_NaN_2',
        #       'Nominal_Power': 300,
        #       'T_cond_max': 90,
        #   }},
        {'Name': 'EMA-3-R1234ze-6FE50Y', 'Description': 'EMA-3 with Reciprocating Compressors', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': '6FE-50Y_Poly_R1234ZE',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R1234ze_333_6_No_NaN_2',
             'Nominal_Power': 300,
             'T_cond_max': 90,
         }},
        {'Name': 'EMA-3-R1234yf-6FE50Y', 'Description': 'EMA-3 with Reciprocating Compressors', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': '6FE-50Y_Poly_R1234YF',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R1234yf_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 85,

         }},
        {'Name': 'EMA-3-R134a-6FE50Y', 'Description': 'EMA-3 with Reciprocating Compressors', 'Comment': '',
         'Tags': ['EMA'],
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': '6FE-50Y_Poly_R134A',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 85,
         }},
        {'Name': 'EMA-3B_screw_R134a', 'Description': 'EMA-3 with Screw Compressors', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'CSH7583-80Y_Poly_R134a',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 70,
         }},
        {'Name': 'EMA-3B_screw_R1234ze', 'Description': 'EMA-3 with Screw Compressors', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'CSH7583-80Y_Poly_R1234ze',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos_Magma3_25-100',
             'Refrigerant': 'R1234ze_333_6_No_NaN_2',
             'Nominal_Power': 300,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-025', 'Description': 'EMB-025', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': False,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '4TES-12Y_Poly',
             'Conf_Evap': 'B120T_2',
             'Plates_Evap': 60,
             'Conf_Cond': 'B120T_2',
             'Plates_Cond': 60,
             'Conf_Sub': 'B10T_2',
             'Plates_Sub': 30,
             'Pump_Evap1': 'Grundfos Magma3_40-80',
             'Pump_Cond1': 'Grundfos Magma3_40-80',
             'Pump_Sub': 'Grundfos Magma3_25-40',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 25,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-1', 'Description': 'EMB-1', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '4NES-20Y_Poly',
             'Conf_Evap': 'B200T_1',
             'Plates_Evap': 82,
             'Conf_Cond': 'B200T_1',
             'Plates_Cond': 82,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 26,
             'Pump_Evap1': 'Grundfos_Magma3_50-100',
             'Pump_Cond1': 'Grundfos_Magma3_50-100',
             'Pump_Evap2': 'Grundfos_Magma3_50-60',
             'Pump_Cond2': 'Grundfos_Magma3_50-60',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 100,
             'T_cond_max': 70,
             # 'Refrigerant': 'R134A_20181125'

         }},
        # {'Name': 'EMB-1-R1234ZE', 'Description': 'EMB-1', 'Comment': '',
        #  'Configuration': {
        #      'Dual_Circuit': True,
        #      'Compressors_Circuit': 1,
        #      'Conf_Compressor': '4NES-20Y_Poly_R1234ZE',
        #      'Conf_Evap': 'B200T_1',
        #      'Plates_Evap': 82,
        #      'Conf_Cond': 'B200T_1',
        #      'Plates_Cond': 82,
        #      'Conf_Sub': 'DB200_1',
        #      'Plates_Sub': 26,
        #      'Pump_Evap1': 'Grundfos_Magma3_50-100',
        #      'Pump_Cond1': 'Grundfos_Magma3_50-100',
        #      'Pump_Evap2': 'Grundfos_Magma3_50-60',
        #      'Pump_Cond2': 'Grundfos_Magma3_50-60',
        #      'Pump_Sub': 'Grundfos Magma3_32-120',
        #      'Refrigerant': 'R1234ZE_333_6_No_NaN',
        #      'Nominal_Power': 100,
        #      'T_cond_max': 70,
        #      # 'Refrigerant': 'R134A_20181125'
        #  }},

        {'Name': 'EMB-1-R1234ZE-4NES20Y', 'Description': 'EMB-1', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '4NES-20Y_Poly_R1234ZE',
             'Conf_Evap': 'B200T_1',
             'Plates_Evap': 82,
             'Conf_Cond': 'B200T_1',
             'Plates_Cond': 82,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 26,
             'Pump_Evap1': 'Grundfos_Magma3_50-100',
             'Pump_Cond1': 'Grundfos_Magma3_50-100',
             'Pump_Evap2': 'Grundfos_Magma3_50-60',
             'Pump_Cond2': 'Grundfos_Magma3_50-60',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R1234ze_333_6_No_NaN_2',
             'Nominal_Power': 100,
             'T_cond_max': 70,
             # 'Refrigerant': 'R134A_20181125'
         }},
        {'Name': 'EMB-1-R1234YF-4NES20Y', 'Description': 'EMB-1', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '4NES-20Y_Poly_R1234YF',
             'Conf_Evap': 'B200T_1',
             'Plates_Evap': 82,
             'Conf_Cond': 'B200T_1',
             'Plates_Cond': 82,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 26,
             'Pump_Evap1': 'Grundfos_Magma3_50-100',
             'Pump_Cond1': 'Grundfos_Magma3_50-100',
             'Pump_Evap2': 'Grundfos_Magma3_50-60',
             'Pump_Cond2': 'Grundfos_Magma3_50-60',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R1234yf_333_6_No_NaN',
             'Nominal_Power': 100,
             'T_cond_max': 70,
             # 'Refrigerant': 'R134A_20181125'
         }},

        {'Name': 'EMB-2', 'Description': 'EMB-2', 'Comment': '',
         'Configuration': {
             'Dual_Circuit':
                 True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '4GE-30Y_Poly',
             'Conf_Evap': 'B400T_1',
             'Plates_Evap': 76,
             'Conf_Cond': 'B400T_1',
             'Plates_Cond': 76,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 34,
             'Pump_Evap1': 'Grundfos_Magma3_50-150',
             'Pump_Cond1': 'Grundfos_Magma3_50-150',
             'Pump_Evap2': 'Grundfos_Magma3_50-60',
             'Pump_Cond2': 'Grundfos_Magma3_50-60',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 150,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-3_screw_R1234ze', 'Description': 'EMB-3', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '6FE-50Y_Poly',
             'Conf_Evap': 'B400T_1',
             'Plates_Evap': 120,
             'Conf_Cond': 'B400T_1',
             'Plates_Cond': 126,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 58,
             'Pump_Evap1': 'Grundfos Magma3_65-150',
             'Pump_Cond1': 'Grundfos Magma3_65-150',
             'Pump_Evap2': 'Grundfos_Magma3_50-100',
             'Pump_Cond2': 'Grundfos_Magma3_50-100',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R1234ze_333_6_No_NaN_2',
             'Nominal_Power': 200,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-3', 'Description': 'EMB-3', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '6FE-50Y_Poly_R134A',
             'Conf_Evap': 'B400T_1',
             'Plates_Evap': 120,
             'Conf_Cond': 'B400T_1',
             'Plates_Cond': 126,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 58,
             'Pump_Evap1': 'Grundfos Magma3_65-150',
             'Pump_Cond1': 'Grundfos Magma3_65-150',
             'Pump_Evap2': 'Grundfos_Magma3_50-100',
             'Pump_Cond2': 'Grundfos_Magma3_50-100',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 200,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-4', 'Description': 'EMB-4', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '8FE-70Y_Poly',
             'Conf_Evap': 'B400T_1',
             'Plates_Evap': 166,
             'Conf_Cond': 'B400T_1',
             'Plates_Cond': 170,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 78,
             'Pump_Evap1': 'Grundfos Magma3_65-150',
             'Pump_Cond1': 'Grundfos Magma3_65-150',
             'Pump_Evap2': 'Grundfos Magma3_65-150',
             'Pump_Cond2': 'Grundfos Magma3_65-150',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 300,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-1s', 'Description': 'EMB-1', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': False,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '4NES-20Y_Poly',
             'Conf_Evap': 'B200T_1',
             'Plates_Evap': 82,
             'Conf_Cond': 'B200T_1',
             'Plates_Cond': 82,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 26,
             'Pump_Evap1': 'Grundfos_Magma3_50-100',
             'Pump_Cond1': 'Grundfos_Magma3_50-100',
             'Pump_Evap2': 'Grundfos_Magma3_50-60',
             'Pump_Cond2': 'Grundfos_Magma3_50-60',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 100,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-2s', 'Description': 'EMB-2', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': False,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '4GE-30Y_Poly',
             'Conf_Evap': 'B400T_1',
             'Plates_Evap': 76,
             'Conf_Cond': 'B400T_1',
             'Plates_Cond': 76,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 34,
             'Pump_Evap1': 'Grundfos_Magma3_50-150',
             'Pump_Cond1': 'Grundfos_Magma3_50-150',
             'Pump_Evap2': 'Grundfos_Magma3_50-60',
             'Pump_Cond2': 'Grundfos_Magma3_50-60',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 150,
             'T_cond_max': 70,
         }},
        {'Name': 'EMB-3s', 'Description': 'EMB-3', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': False,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '6FE-50Y_Poly_R134A',
             'Conf_Evap': 'B400T_1',
             'Plates_Evap': 120,
             'Conf_Cond': 'B400T_1',
             'Plates_Cond': 126,
             'Conf_Sub': 'DB200_1',
             'Plates_Sub': 58,
             'Pump_Evap1': 'Grundfos Magma3_65-150',
             'Pump_Cond1': 'Grundfos Magma3_65-150',
             'Pump_Evap2': 'Grundfos_Magma3_50-100',
             'Pump_Cond2': 'Grundfos_Magma3_50-100',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'R134A_333_6_No_NaN',
             'Nominal_Power': 200,
             'T_cond_max': 70,
         }},
        {'Name': 'EMAB-1', 'Description': 'EMAB-1', 'Comment': '',
         'Configuration': {
             'EMA': 'EMA-025',
             'EMB': 'EMB-025',
         }},
        {'Name': 'EMHW-1', 'Description': 'EMHW-1', 'Comment': '',
         'Configuration': {
             'Conf_Step1': 'B400T_1',
             'Plates_Step1': 93,
             'Conf_Step2': 'B400T_1',
             'Plates_Step2': 93,
             'Conf_Step3': 'B400T_1',
             'Plates_Step3': 105,
             'Pump_Step1_Pri': 'Grundfos Magma3_32-120',
             'Pump_Step2_Pri': 'Grundfos Magma3_32-120',
             'Pump_Step3_Pri': 'Grundfos_Magma3_50-150',
         }},
        {'Name': 'EMHW-2', 'Description': 'EMHW-2', 'Comment': '',
         'Configuration': {
             'Conf_Step1': 'B120T_1',
             'Plates_Step1': 57,
             'Conf_Step2': 'B120T_1',
             'Plates_Step2': 57,
             'Conf_Step3': 'B120T_1',
             'Plates_Step3': 65,
             'Pump_Step1_Pri': 'Grundfos Magma3_25-60',
             'Pump_Step2_Pri': 'Grundfos Magma3_25-60',
             'Pump_Step3_Pri': 'Grundfos_Magma3_50-150',
         }},
        {'Name': 'EMHW-3', 'Description': 'EMHW-3', 'Comment': '',
         'Configuration': {
             'Conf_Step1': 'B400T_1',
             'Plates_Step1': 93,
             'Conf_Step2': 'B400T_1',
             'Plates_Step2': 93,
             'Conf_Step3': 'B400T_1',
             'Plates_Step3': 105,
             'Pump_Step1_Pri': 'Grundfos Magma3_32-120',
             'Pump_Step2_Pri': 'Grundfos Magma3_32-120',
             'Pump_Step3_Pri': 'Grundfos_Magma3_50-150',
         }},
        {'Name': 'EMHW-3_1', 'Description': 'EMHW-3', 'Comment': '',
         'Configuration': {
             'Conf_Step1': 'B400T_1',
             'Plates_Step1': 93,
             'Conf_Step2': 'B400T_1',
             'Plates_Step2': 93,
             'Conf_Step3': 'B400T_1',
             'Plates_Step3': 200,
             'Pump_Step1_Pri': 'Grundfos Magma3_32-120',
             'Pump_Step2_Pri': 'Grundfos Magma3_32-120',
             'Pump_Step3_Pri': 'Grundfos Magma3_65-150',
         }},

        {'Name': 'EMA-3-50-100', 'Description': 'EMA-3 with Magma3 50-100 SC pump', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': True,
             'Compressors_Circuit': 2,
             'Conf_Compressor': 'GSD80485VA_Poly',
             'Conf_Evap': 'DB700_2',
             'Plates_Evap': 366,
             'Conf_Cond': 'DB300_2',
             'Plates_Cond': 330,
             'Conf_Sub': 'DB300_2',
             'Plates_Sub': 178,
             'Pump_Evap': 'Grundfos NBE_65_125-137',
             'Pump_Cond': 'Grundfos NBE_65_125-127',
             'Pump_Sub': 'Grundfos NBE_65_125-137',
             'Refrigerant': 'R410A_333_6_No_NaN'
         }},
        {'Name': 'CO2_KVP-1', 'Description': 'CO2 KVP', 'Comment': '',
         'Configuration': {
             'Dual_Circuit': False,
             'Compressors_Circuit': 1,
             'Conf_Compressor': '6CTE-50K',
             'Conf_Evap': 'B185_2',
             'Plates_Evap': 100,
             'Conf_Cond': 'B185_2',
             'Plates_Cond': 100,
             'Conf_Suc': 'B185_2',
             'Plates_Suc': 20,
             'Pump_Evap1': 'Grundfos Magma3_65-150',
             'Pump_Cond1': 'Grundfos Magma3_65-150',
             'Pump_Sub': 'Grundfos Magma3_32-120',
             'Refrigerant': 'CO2_20181129_2'
         }},

    ]

    # configs=[
    #        {'Name': 'Single_Liquid_HX_001','Description':'Example of single liquid heat exchanger','Comment':'Not fitted','Configuration': {'V_CW1': 0.08,'V_CW2': 0.08, 'h':10000, 'N_nodes':5, 'kpipe_CW1':10, 'kpipe_CW2':10}}]
    ss = Simulation_Store.Simulation_Store()
    for c in configs:
        print(ss.store_Config(c, True))
