import sim_components.generic.items as BC


class EM_Regulator(BC.Subsystem):
    def construct_Subsystem(self,  **conf):
        
        self.bind_keys(conf, ['EM', 'VS', 'KB', 'VV'])

        self.EMA_reg_params = conf['EMA_reg_params'] if 'EMA_reg_params' in conf else {}
        self.EMB_reg_params = conf['EMB_reg_params'] if 'EMB_reg_params' in conf else {}
        self.EMHW_reg_params = conf['EMHW_reg_params'] if 'EMHW_reg_params' in conf else {}

        self.calc_funcs = [self.regulate, self.regulate_EMA, self.regulate_EMB, self.regulate_VS_dump]

        self.generate_EMA_regulation()
        self.generate_EMB_regulation()
        self.generate_EMHW_regulation()

        self.add_var('EMA_SCC_ST2_Top_T_SP_open',conf, val=20)
        self.add_var('EMA_SCC_ST2_Top_T_SP_close', conf, val=25)

        self.add_var('VS_err_int', conf, vartype='state')
        self.add_var('KB_err_int', conf, vartype='state')

        self.add_var('kI_VS_err', conf, val=0.001, desc='I-constant for condenser pump SP based on VS err')
        self.add_var('kI_KB_err', conf, val=0.001, desc='I-constant for evaporator pump SP based on KB err')
        self.add_var('EMA_VS_SP_Offset', conf, val=1, desc='Offset of EMA VS setpoint from system VS setpoint ')
        self.add_var('N_EMA', val=self.EM.N_EMA, desc='Number of EMAs in system')

        self.add_var('EMB_T_SP_VV_Buffer_Offset', conf, unit='oC', val=5, desc='')

        self.add_var('EMB_T_SP_VV_Buffer_C1_Start_Offset', conf, unit='oC', val=-2, desc='')
        self.add_var('EMB_T_SP_VV_Buffer_C1_Keep_Offset', conf, unit='oC', val=2, desc='')

        self.add_var('T_SP_Subcool_VV_C1_start', conf, unit='oC', val=15, desc='')
        self.add_var('T_SP_Subcool_VV_C1_keep', conf, unit='oC', val=10, desc='')

        self.add_var('EMB_T_SP_VS_C1', conf, unit='oC', val=35, desc='')


        self.add_var('EMB_T_SP_Subcool_VS_C1_start', conf, unit='oC', val=25, desc='')
        self.add_var('EMB_T_SP_Subcool_VS_C1_keep', conf, unit='oC', val=20, desc='')

        self.add_var('EMB_T_SP_VS_C2', conf, unit='oC', val=35, desc='')


        self.add_var('EMB_T_SP_Subcool_VS_C2_start', conf, unit='oC', val=20, desc='')
        self.add_var('EMB_T_SP_Subcool_VS_C2_keep', conf, unit='oC', val=15, desc='')

        self.add_var('T_min_VS_SP', conf, unit='oC', val=35, desc='')

        self.add_var('VS_Cool_Err_int', unit='1', vartype='state', val=0, desc='')
        self.add_var('T_VS_Cool_Offset', conf, val=3, desc='')
        self.add_var('T_VS_Cool_Start', conf, val=30, desc='')

        self.add_var('kP_VS_Cool', conf, val=0.25, desc='')
        self.add_var('kI_VS_Cool', conf, val=0.1, desc='')




    def regulate(self):

        #Calculation of VV SP and Error
        T_SP_VV_buffer = VV.T_set + EMB_T_SP_VV_Buffer_Offset

        T_err_VV_buffer = T_SP_VV_buffer - EM.VV_ST.Top.T

        # Calculation of VS SP and Error
        T_VS_SP = max(0, VS.T_set, T_min_VS_SP)

        VS_err = T_VS_SP - EM.VS_supply.T
        VS_err_int_dot = VS_err

        #TODO: fix this"!
        #VS_Cool = (VS_err + 3 < 0) * (KB.Err < 1)

        #Added by without Viktor
    def regulate_VS_dump(self):
        VS_Cool_Err = EM.VS_Pri_in.T - max(25, T_VS_SP + T_VS_Cool_Offset, 0) * kP_VS_Cool

        VS_Cool_Err_int_dot = (VS_Cool_Err - VS_Cool_Err_int) * kI_VS_Cool

        VS_Cool_start = (max(T_VS_Cool_Start, T_VS_SP + T_VS_Cool_Offset, 0) < EM.VS_Pri_in.T)
        VS_Cool_keep = (T_VS_SP < EM.VS_Pri_in.T)

        VS_Cool_SP = (VS_Cool_start > 0) +  (VS_Cool_SP > 0) * (VS_Cool_keep > 0)

        EM.VS_secondary_bypass.Reg.S_set = VS_Cool_SP * VS_Cool_Err_int


    def regulate_EMA(self):

        #EMA related
        #subcooler valve regulation
        subcooler_valve_open = (EM.SCC.ST2.Top.T <= EMA_SCC_ST2_Top_T_SP_open)
        subcooler_valve_keep = (EM.SCC.ST2.Top.T <= EMA_SCC_ST2_Top_T_SP_close)
        EMA_subcooler_valve_SP = (EMA_subcooler_valve_SP > 0)* subcooler_valve_keep + subcooler_valve_open #hysteris regulator

        # secondary speed setting for condenser pump
        EMA_cond_pump_ext_SP = (VS_err_int>0)*VS_err_int * kI_VS_err

        #TODO look at adding bypass/return pipe on VS

        # secondary speed setting for evaporator pump

        KB_err = KB.Supply.T - KB.T_set
        KB_err_int_dot = KB_err

        EMA_evap_pump_ext_SP = (KB_err_int>0)*KB_err_int * kI_KB_err


        #Temperature setpoints for EMA power
        EMA_VS_T_set = VS.T_set

        EMA_KB_T_set = KB.T_set

        #Common params for EMA temperature setpoint
        EMA_T_offset = EM.VS_supply.T + EMA_VS_SP_Offset
        EMA_T_scale =  (EMA_VS_T_set - EM.VS_supply.T)/N_EMA

    def generate_EMA_regulation(self):
        # VS Setpoint for each specific EMA
        ema_regulators = []
        for i, ema in enumerate(self.EM.EMAs):
            # Add an ema regulator to each EMA:
            # TODO: add regulator
            ema_regulators.append(self.add('EMA_Regulator_' + str(i + 1), EMA_Regulator, EMA=ema, **self.EMA_reg_params))

            self.add_calc_func_str('EMA_VS_T_Set_' + ema.name,
                                   "{}.T_hot_out_SP = EMA_T_offset + ({} + 1) * EMA_T_scale".format(
                                       ema_regulators[-1].name, i))
            self.add_calc_func_str('EMA_KB_T_Set_' + ema.name,
                                   "{}.T_cold_out_SP = EMA_KB_T_set".format(ema_regulators[-1].name))

        self.add_simple_forward_map(ema_regulators, {'EMA_cond_pump_ext_SP': 'cond_pump_ext_SP',
                                                     'EMA_evap_pump_ext_SP': 'evap_pump_ext_SP'})

    def regulate_EMB(self):

        #Circuit 1

        EMB_C1_VV_start = (T_err_VV_buffer + EMB_T_SP_VV_Buffer_C1_Start_Offset> 0) * (EM.SCC.ST2.Top.T >= T_SP_Subcool_VV_C1_start)

        EMB_C1_VV_keep = (T_err_VV_buffer + EMB_T_SP_VV_Buffer_C1_Keep_Offset > 0) * (EM.SCC.ST2.Top.T >= T_SP_Subcool_VV_C1_keep)

        EMB_C1_VS_start = (T_VS_SP < EMB_T_SP_VS_C1)  * (EM.SCC.ST2.Top.T >= EMB_T_SP_Subcool_VS_C1_start)

        EMB_C1_VS_keep = (T_VS_SP < EMB_T_SP_VS_C1) * (EM.SCC.ST2.Top.T >= EMB_T_SP_Subcool_VS_C1_keep)

        #Circuit 2

        EMB_C2_VS_start = (T_VS_SP < EMB_T_SP_VS_C2) * (EM.SCC.ST3.Top.T >= EMB_T_SP_Subcool_VS_C2_start)

        EMB_C2_VS_keep = (T_VS_SP < EMB_T_SP_VS_C2) * (EM.SCC.ST3.Top.T >= EMB_T_SP_Subcool_VS_C2_keep)

    def generate_EMB_regulation(self):

        # VS Setpoint for each specific EMA
        emb_regulators = []
        for i, emb in enumerate(self.EM.EMBs):
            #Add an ema regulator to each EMB:
            emb_regulators.append(self.add('EMB_Regulator_' + str(i + 1), EMB_Regulator, EMB=emb, **self.EMB_reg_params))

        self.add_simple_forward_map(emb_regulators,
                                    {'EMB_C1_VV_start': 'C1_VV_start',
                                     'EMB_C1_VV_keep': 'C1_VV_keep',
                                     'EMB_C1_VS_start': 'C1_VS_start',
                                     'EMB_C1_VS_keep': 'C1_VS_keep',
                                     'EMB_C2_VS_start': 'C2_VS_start',
                                     'EMB_C2_VS_keep': 'C2_VS_keep'})



    def generate_EMHW_regulation(self):
        emhw_regulators = []
        for i, emhw in enumerate(self.EM.EMHWs):
            # Add an ema regulator to each EMB:
            # TODO: add regulator
            emhw_regulators.append(self.add('EMHW_Regulator_' + str(i + 1), EMHW_Regulator, EMHW=emhw, **self.EMHW_reg_params))

        self.add_simple_forward_map(emhw_regulators,
                                    {
                                     'EM.SCC.ST3.Top.T': 'T_in_prim_1',
                                     'EM.SCC.ST1.Top.T': 'T_in_prim_2',
                                    })


class EMA_Regulator(BC.Subsystem):
    def construct_Subsystem(self, **conf):
        self.EMA = conf['EMA']



        self.add_var('T_hot_out_SP', conf, unit='oC', val=40)
        self.add_var('kP_comp_hot', conf, val=4)

        self.add_var('T_cold_out_SP', conf, unit='oC', val=0)
        self.add_var('kP_comp_cold', conf, val=4)

        self.add_var('kP_cond_set_scale', conf, val=0.15)
        self.add_var('kP_cond_set_offset', conf, val=0.15)

        self.add_var('kP_evap_set_scale', conf, val=0.15)
        self.add_var('kP_evap_set_offset', conf, val=0.15)

        self.add_var('kP_sub_set_scale', conf, val=0.15)
        self.add_var('kP_sub_set_offset', conf, val=0.15)

        self.add_var('kP_sub_speed_on_bypass', conf, val=1)

        self.add_var('sub_bypass_SP', conf, val=0)

        self.add_var('cond_pump_ext_SP', conf, val=0)
        self.add_var('evap_pump_ext_SP', conf, val=0)

        self.add_var('p_max', conf, val=3800)

        self.add_var('cond_pump_ext_timer', conf, vartype='state')
        self.add_var('cond_pump_ext_timeout', conf, val=0)
        self.add_var('evap_pump_ext_timer', conf, vartype='state')
        self.add_var('evap_pump_ext_timeout', conf, val=0)



        self.calc_funcs = [self.regulate]

    def regulate(self):
        # Regulate number of compressors based on setpoint temperature on hot side
        T_hot_out = EMA.pipe_cond_out_pre_cond.T_pipe
        # Calculate hot side temperature error
        T_hot_out_err = T_hot_out_SP - T_hot_out
        # Calculate number of compressors to turn on for hot side error
        N_comp_on_hot = T_hot_out_err * kP_comp_hot

        # Regulate number of compressors based on setpoint temperature on cold side
        T_cold_out = EMA.pipe_evap_out.T_pipe
        # Calculate cold temperature error
        T_cold_out_err = T_cold_out - T_cold_out_SP
        # Calculate number of compressors to turn on for cold side error
        N_comp_on_cold = T_cold_out_err * kP_comp_cold

        # Regulate the subcooler valve
        EMA.bp_sub.Reg.S_set = sub_bypass_SP

        # Setting compressor states
        On_safe1 = EMA.Compressor1.p_out < p_max
        N_on_act = max(0, N_comp_on_hot, N_comp_on_cold) * On_safe1

        # Op_Mode = (N_comp_on_hot - N_comp_on_cold)

        # Regulate pump speed for subcooler
        EMA.LCW_Sub_in.Set_Speed = max(0, N_on_act * kP_sub_set_scale + kP_sub_set_offset, EMA.bp_sub.Reg.S_set * kP_sub_speed_on_bypass)

        # Regulate pump speed for condenser - try to decouple in steps
        # secondary regulator for pump speed for evaporator based on heating system
        cond_pump_ext_timer_dot = (N_on_act > 0)  # Make the timer work!
        EMA.LCW_Cond_in.Set_Speed = N_on_act * kP_cond_set_scale + kP_cond_set_offset + cond_pump_ext_SP * (cond_pump_ext_timer >= cond_pump_ext_timeout)

        # Regulate pump speed for evaporator
        # secondary regulator for pump speed for evaporator based on chilled system
        evap_pump_ext_timer_dot = (N_on_act > 0)  # TODO: Make the timer work!
        EMA.LCW_Evap_in.Set_Speed = N_on_act * kP_evap_set_scale + kP_evap_set_offset + evap_pump_ext_SP * (evap_pump_ext_timer >= evap_pump_ext_timeout)

        # Safety switch - only allow compressors to turn on if pressure is < max pressure
        EMA.Compressor1.State1 = (N_on_act >= 1)
        EMA.Compressor2.State1 = (N_on_act >= 2)
        EMA.Compressor1.State2 = (N_on_act >= 3)
        EMA.Compressor2.State2 = (N_on_act >= 4)

class EMB_Regulator(BC.Subsystem):
    def construct_Subsystem(self, **conf):

        self.EMB = conf['EMB']

        self.add_var('C1_VV_start', conf, val=0)
        self.add_var('C1_VV_keep', conf, val=0)
        self.add_var('C1_VS_start', conf, val=0)
        self.add_var('C1_VS_keep', conf, val=0)

        self.add_var('LCW_Evap1_in_Speed_SP', conf, val=0.7)
        self.add_var('LCW_Cond1_in_Speed_SP', conf, val=0.7)


        self.add_var('LCW_Evap2_in_Speed_SP', conf, val=0.7)
        self.add_var('LCW_Cond2_in_Speed_SP', conf, val=0.7)

        self.add_var('LCW_Sub_Comp1_Speed_SP', conf, val=0.4)
        self.add_var('LCW_Sub_Comp2_Speed_SP', conf, val=0.4)

        self.add_var('Comp1_SP_VV', conf, vartype='state')
        self.add_var('Comp1_SP_VS', conf, vartype='state')



        self.calc_funcs = [self.regulate]

    def regulate(self):
        #Criteria for start-stop of compressors

        Comp1_SP_VV = C1_VV_start + C1_VV_keep*(Comp1_SP_VV > 0)
        Comp1_SP_VS = C1_VS_start + C1_VS_keep*(Comp1_SP_VS > 0)



        EMB.Compressor1.State1 =  Comp1_SP_VV + Comp1_SP_VS
        EMB.cond1_Bypass.Reg.S_set = (Comp1_SP_VV > 0)

        EMB.Compressor2.State1 = C2_VS_start + C2_VS_keep * (EMB.Compressor2.state >0)

        #Setting speed of pumps
        #Circuit 1
        EMB.LCW_Evap1_in.Set_Speed = max(EMB.Compressor1.state * LCW_Evap1_in_Speed_SP, 0.4 * (EMB.Compressor1.state > 1e-12), 0) #Pump need to keep running after the compressor has been switched off and is still winding down.
        EMB.LCW_Cond1_out.Set_Speed = max(EMB.Compressor1.state * LCW_Cond1_in_Speed_SP, 0.4 * (EMB.Compressor1.state > 1e-12), 0)

        #Circuit 2
        EMB.LCW_Evap2_in.Set_Speed = max(EMB.Compressor2.state * LCW_Evap2_in_Speed_SP, 0.4 * (EMB.Compressor2.state > 1e-12), 0)
        EMB.LCW_Cond2_out.Set_Speed = max(EMB.Compressor2.state * LCW_Cond2_in_Speed_SP, 0.4 * (EMB.Compressor2.state > 1e-12), 0)

        #Subcooler Pump speed setting
        #TODO: flash gas?

        EMB.LCW_Sub_in.Set_Speed = EMB.Compressor1.state * LCW_Sub_Comp1_Speed_SP + EMB.Compressor2.state * LCW_Sub_Comp2_Speed_SP + 0.35 * (EMB.Compressor1.state > 1e-12)


class EMHW_Regulator(BC.Subsystem):
    def construct_Subsystem(self, **conf):
        self.EMHW = conf['EMHW']

        self.add_var('prim1_Set_Speed_kP', conf, val=1)
        self.add_var('prim2_Set_Speed_kP', conf, val=1)
        self.add_var('prim3_Set_Speed_kP', conf, val=1)
        self.add_var('bypass_valve_kP', conf, val=1)
        self.add_var('bypass_valve_T_offset', conf, val=1)
        self.add_var('Flow_VVC', conf, val=1)
        self.add_var('T_in_prim_1', conf, val=0)
        self.add_var('T_in_prim_2', conf, val=0)

        self.calc_funcs = [self.regulate]

        if self.EMHW.has_subcooler:
            self.calc_funcs.append(self.regulate_subcooler)

        if self.EMHW.has_step2_pump:
            self.calc_funcs.append(self.regulate_step2)

    def regulate(self):
        # EMHW regulation

        #Need to make water flow in cold pipe as it is mass flow controlled pipe
        EMHW.VV_Cold_Pipe.m_dot = EMHW.VV.F_VV

        #Calculate VV error
        VV_Err = EMHW.VV.T_set - EMHW.VV_Supply_Pipe.T_pipe


        EMHW.P3_Prim.Set_Speed = prim3_Set_Speed_kP * VV_Err

        EMHW.bp_VS.Reg.S_set = bypass_valve_kP * (VV_Err + bypass_valve_T_offset) #TODO: Check! This should only close to avoid too hot temperature

        EMHW.P_VVC.Set_Speed = Flow_VVC  # kg/s

    def regulate_subcooler(self):
        EMHW.P1_Prim.Set_Speed = prim1_Set_Speed_kP * ( T_in_prim_1 > EMHW.VV.Cold.T) #TODO: Add controls of the pump to reduce speed under certain circumstances

    def regulate_step2(self):
        EMHW.P2_Prim.Set_Speed = prim2_Set_Speed_kP * (T_in_prim_2 > EMHW.Pipe_5.T_pipe) #TODO: Add controls of the pump to reduce speed under certain circumstances


#TODO: Rewrite with Viktor
class BHS_regulator(BC.Subsystem):
    def construct_Subsystem(self, source, EP_Reg, BHS, offset, **conf):
        self.source = source
        self.BHS = BHS
        self.EP_Reg = EP_Reg
        #Regulate pump to achieve temperature setpoint?

        self.Variables = [
            {'name': 'offset', 'unit': '1', 'type': 'param', 'val': offset, },
            ]

        self.calc_funcs = [self.regulate]

    def regulate(self):
        #Set valves
        VS_Err = BHS.HX.F2_2.T-BHS.HX_Supply.T-2 - offset

        VS_Mode = EP_Reg.VS_Cool_SP

        KB_Err = source.KB.T_set - source.ES.Supply_Short.T
        #VS_HP_Err = abs(source.ES.KB_Supply.T - source.KB.T_set)

        BHS.Pump_HX.Set_Speed = VS_Err * (VS_Mode>0) * (BHS.Return_Valve.S_act > 0.999)

        BHS.Pump.Set_Speed = VS_Mode * (VS_Mode>0) * (BHS.Return_Valve.S_act > 0.999) + (abs(KB_Err)+0.35)*(VS_Mode<=0)*(BHS.In_Valve.S_act > 0.999)


        BHS.In_Valve.S_set = (VS_Mode <= 0)*((KB_Err < 0)*(source.ES.KB_Supply.T > BHS.BHS.T_brine_out) + (KB_Err > 2)*(source.ES.KB_Supply.T < BHS.BHS.T_brine_out))
        BHS.Out_Valve.S_set = BHS.In_Valve.S_set
        BHS.Return_Valve.S_set = (BHS.In_Valve.S_set<=0)

        #valve_set = (source.VS_switch - offset > 0)
        #BHS.valve_in.Reg.S_set_in = valve_set
        #BHS.valve_out.Reg.S_set_in = valve_set

        #set pump speed
        #BHS.Pump.Set_Speed = (valve_set>0)*source.VS_Speed + (valve_set<=0)*source.KB_Speed

#TODO: Rewrite with Viktor
class Energy_system_w_BHS_regulator(BC.Subsystem):
    def construct_Subsystem(self, EP_Reg=None, **conf):

        self.ES = conf['ES']
        self.EP = conf['EP']
        #self.VV = conf['VV']
        self.VS = conf['VS']
        self.KB = conf['KB']
        self.EP_Reg = EP_Reg


        self.BHSs = [conf['BHS']]

        if 'BHS2' in conf:
            self.BHSs.append(conf['BHS2'])

        #Create regulators
        for i, BHS in enumerate(self.BHSs):
            offset = i
            self.add('BHS_Regulator_' + str(i + 1), BHS_regulator, self, EP_Reg, BHS, offset)

        self.Variables = [
            {'name': 'kP_VS_switch', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'kP_VS_speed', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'kP_KB_speed', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'VS_Speed', 'unit': '1', 'type': 'param', 'val': 1, },
            {'name': 'KB_Speed', 'unit': '1', 'type': 'param', 'val': 1, },
        ]

        #TODO: Check if we have a bypass and make it a parameter
        self.calc_funcs = [self.regulate]

    """The bypass valve should be open to make sure KB consumer heat is going directly to EMA evaporators when:
                1. Boreholes are used to take condenser reject heat - Active cooling
                2. If heat is extracted from boreholes for use in EMA evaporators during "winter"  (When pumps are in operation for free cooling)

                Timers needed to delay shift between
            """
    def regulate(self):

        #Need to make the EM regulate the secondary pump speed
        #If the pumps in EMA are speeding up

        ES.Bypass.Reg.S_set = (ES.EM_BHS.P_ewma > 0) + (EP_Reg.VS_Cool_SP > 0)
        ES.Bypass_KB.Reg.S_set = -KB.Err + 0.5
        ES.Pump_KB.Set_Speed = -KB.Err + 0.5