def make_Items_Graph(system, ops, sys_dict):
    assigns=preprocess_assigns(ops, system)
    out_items = []
    out_vars = [{'name': 't', 'val': 0, 'path': 't'}]
    #Generate all variables
    sys_dict_copy = dict(sys_dict)
    pop_list=[]
    for k,v in sys_dict_copy.items():
        k_item, k_var=get_item_var(k)
        #print(k_var[:3])
        if k_var[:3]=="tmp":
            pop_list+=[k]

    for p in pop_list:
        sys_dict_copy.pop(p)


    process_item(system, out_items, out_vars, assigns, sys_dict_copy, level=0, x_pos=0)


    #process_assigns(assigns, out_items)

    # x_pos = 0
    # for i in items:
    #
    #     process_item(i, out_items, out_vars, level=0, x_pos=x_pos, )
    #     x_pos+=out_items[-1]['width']
    # print('second run')
    #process_assigns(assigns, out_items)

    max_level=0
    min_level=99999
    for i in out_items:
        set_levels(assigns, i)

        if i['level']>max_level:
            max_level=i['level']

        if i['level']<min_level:
            min_level=i['level']

    for v in out_vars:
        v['level']=max_level+1



    #print(graph_items)
    return {'items': out_items, 'variables': out_vars, 'assigns': assigns, 'levels': max_level}

def post_process_assigns(ops, items):
    for op in ops:
        #print(op)
        target_list = op['target_item'].split('.')
        from_list = op['from_item'].split('.')

        i=0
        done=False

        while i < min((len(target_list),len(from_list))) and not done:

            op['level'] = i-1
            if target_list[i] != from_list[i]:

                done=True

            i+=1

        target_found = False
        from_found = False

        for i in items:

            if i['path'] == op['target_item']:
                for v in i['variables']:
                    if v['name'] == op['target_var']:
                        #print(v)
                        op['target_x_pos']=v['x_pos']
                        target_found=True
                        break

            if i['path'] == op['from_item']:
                for v in i['variables']:
                    if v['name'] == op['from_var']:
                        op['from_x_pos']=v['x_pos']
                        from_found=True
                        break

            if from_found and target_found:
                pass#break


def process_assigns(ops, items):
    for op in ops:
        #print(op)
        target_list = op['target'].split('.')
        op['target_var'] = target_list[-1]
        op['target_item'] = '.'.join(map(str,target_list[:-1]))

        from_list = op['left'].split('.')
        op['from_var'] = from_list[-1]
        op['from_item'] = '.'.join(map(str,from_list[:-1]))

        op_found_target=False
        op_found_from=False



        for i in items:
            #print(i['path'])
            #print(i['name'])
            if i['path'] == op['target_item']:
                #print('found target')
                #print(i['path'])
                #print(op['target_item'])
                op_found_target=True
                found = False
                for v in i['variables']:
                    if v['name'] == op['target_var']:
                        found=True
                        #break

                if not found:
                    i['variables']+=[{'name': op['target_var']}]

            if i['path'] == op['from_item']:
                #print('found from')
                #print(i['path'])
                #print(i.path)
                #print(op['from_item'])
                op_found_from=True
                found = False
                for v in i['variables']:
                    if v['name'] == op['from_var']:
                        found = True
                        #break

                if not found:
                    i['variables'] += [{'name': op['from_var']}]

        if not op_found_target:
            print('Warning: did not find {} from {}'.format(op['target_item'],op['target']))

        if not op_found_from:
            print('Warning: did not find {} from {}'.format(op['from_item'],op['left']))


def preprocess_assigns(ops, system):
    assigns = []
    for op in ops:
        #print(op)
        if 'op' in op:
            if op['op'] == 'assign' or op['op'] == 'negate':

                if op['left'][:3]!='tmp':

                    target_list = op['target'].split('.')
                    op['target_var'] = target_list[-1]
                    op['target_item'] = '.'.join(map(str, target_list[:-1]))

                    from_list = op['left'].split('.')
                    op['from_var'] = from_list[-1]
                    op['from_item'] = '.'.join(map(str, from_list[:-1]))

                    op['level']=9999999

                    check_assign_exist(op, system)

                    assigns += [op]


    return assigns

def check_assign_exist(a, item):
    #check if item is target
    if a['target_item'] == item.path:
        if find(item.Variables,'name',a['target_var'])==-1:
            item.Variables.append({'name': a['target_var']})

    if a['from_item'] == item.path:
        # check if item has from var

        if find(item.Variables,'name',a['from_var'])==-1:
            item.Variables.append({'name': a['from_var']})

    if hasattr(item, 'children'):

        for i in item.children:
            check_assign_exist(a,i)

def set_levels(assigns, i):
    for a in assigns:
        if a['level'] == i['level']:
            a['sublevel'] = i['sublevels']
            i['sublevels']+=1


def find(lst, key, value):
    for i, dic in enumerate(lst):
        if dic[key] == value:
            return i

    return -1

def process_item(item, out_items, out_vars, assigns, sys_dict, level, x_pos):
        pop_list=[]
        for k,v in sys_dict.items():
            k_item, k_var=get_item_var(k)
            if k_item == item.path:



                k_index=find(item.Variables,'name',k_var)

                if k_index == -1:
                    k_index = item.Variables.append({'name': k_var, 'val':sys_dict[k]})
                else:

                    item.Variables[k_index]['val']=sys_dict[k]

                pop_list+=[k]

        for p in pop_list:
            sys_dict.pop(p)


        width_v = 1
        width_a = 1

        x_pos_start = x_pos
        graph_item={'name': item.name, 'path': item.path, 'variables': item.Variables, 'sub_items':0, 'width': width_v, 'x_pos': x_pos, 'level': level, 'sublevels': 0}
        #print(graph_item['path'])
        if len(item.Variables)>0:
            graph_item['width']=0



            for i, v in enumerate(item.Variables):


                if i>0:
                    x_pos+=.1
                v['x_pos'] = x_pos
                v['path']=item.path+'.'+v['name']



                out_vars+= [v]
                x_pos_start_v=x_pos
                for a in assigns:
                    if a['target_item']==item.path and a['target_var']==v['name']:

                        x_pos += width_a/2
                        a['target_x_pos'] = x_pos


                        if level < a['level']:
                            a['level']=level
                        #break

                    if a['from_item']==item.path and a['from_var']==v['name']:

                        x_pos += width_a/2
                        a['from_x_pos'] = x_pos


                        if level < a['level']:
                            a['level']=level
                        #break

                x_pos += width_a / 2
                v['width'] = x_pos-x_pos_start_v

                if v['width']==0:
                    v['width']=10
                    x_pos+=10







        if hasattr(item, 'children'):



            for n,i in enumerate(item.children):
                if n>0:
                    x_pos += 1.1*(4-level+.2)**2
                x_pos=process_item(i, out_items, out_vars, assigns, sys_dict, level +1, x_pos)

                graph_item['sub_items']+=out_items[-1]['sub_items']+1
                #x_pos += out_items[-1]['width']

        graph_item['width']=x_pos-x_pos_start
        if graph_item['width'] == 0:
            graph_item['width'] = 10
            x_pos+=10


        out_items+=[graph_item]



        return x_pos

def get_item_var(path):
    path_list = path.split('.')
    return  '.'.join(map(str, path_list[:-1])), path_list[-1]
